/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.internal.scene.control.skin;

import com.sun.javafx.scene.control.skin.SkinBase;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.geometry.HPos;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import jfxtras.labs.internal.scene.control.behavior.GridViewBehavior;
import jfxtras.labs.scene.control.grid.GridCell;
import jfxtras.labs.scene.control.grid.GridView;
import jfxtras.labs.scene.control.grid.cell.DefaultGridCell;

public class GridViewSkin<T>
extends SkinBase<GridView<T>, GridViewBehavior<T>> {
    private ListChangeListener<T> itemsListener;
    private ChangeListener<Number> layoutListener = new ChangeListener<Number>(){

        public void changed(ObservableValue<? extends Number> arg0, Number arg1, Number arg2) {
            GridViewSkin.this.requestLayout();
        }
    };
    private ChangeListener<ObservableList<T>> itemListChangedListener;

    public GridViewSkin(GridView<T> control) {
        super(control, new GridViewBehavior<T>(control));
        this.itemsListener = new ListChangeListener<T>(){

            public void onChanged(ListChangeListener.Change<? extends T> change) {
                while (change.next()) {
                    int i;
                    int start = change.getFrom();
                    int end = change.getTo();
                    if (change.wasReplaced() || change.wasAdded() || change.wasPermutated() || change.wasUpdated()) {
                        for (i = start; i < end; ++i) {
                            if (change.wasReplaced()) {
                                GridViewSkin.this.replaceCell(i);
                                continue;
                            }
                            if (change.wasAdded()) {
                                GridViewSkin.this.addCell(i);
                                continue;
                            }
                            if (change.wasPermutated()) {
                                GridViewSkin.this.updateAllCells();
                                continue;
                            }
                            if (change.wasRemoved()) {
                                GridViewSkin.this.removeCell(i);
                                continue;
                            }
                            if (!change.wasUpdated()) continue;
                            GridViewSkin.this.updateCell(i);
                        }
                        continue;
                    }
                    if (!change.wasRemoved()) continue;
                    for (i = start; i <= end; ++i) {
                        GridViewSkin.this.removeCell(i);
                    }
                }
            }
        };
        this.itemListChangedListener = new ChangeListener<ObservableList<T>>(){

            public void changed(ObservableValue<? extends ObservableList<T>> arg0, ObservableList<T> oldList, ObservableList<T> newList) {
                if (oldList != null) {
                    oldList.removeListener(GridViewSkin.this.itemsListener);
                }
                if (newList != null) {
                    newList.addListener(GridViewSkin.this.itemsListener);
                }
                GridViewSkin.this.updateAllCells();
            }
        };
        ((GridView)this.getSkinnable()).itemsProperty().addListener(this.itemListChangedListener);
        ObservableList currentList = (ObservableList)((GridView)this.getSkinnable()).itemsProperty().get();
        if (currentList != null) {
            currentList.addListener(this.itemsListener);
        }
        ((GridView)this.getSkinnable()).cellHeightProperty().addListener(this.layoutListener);
        ((GridView)this.getSkinnable()).cellWidthProperty().addListener(this.layoutListener);
        ((GridView)this.getSkinnable()).verticalCellSpacingProperty().addListener(this.layoutListener);
        ((GridView)this.getSkinnable()).horizontalCellSpacingProperty().addListener(this.layoutListener);
        this.updateAllCells();
    }

    public void updateAllCells() {
        this.getChildren().clear();
        ObservableList items = ((GridView)this.getSkinnable()).getItems();
        if (items != null) {
            for (int index = 0; index < items.size(); ++index) {
                Object item = items.get(index);
                GridCell<T> cell = this.createCell();
                cell.setItem(item);
                cell.updateIndex(index);
                this.getChildren().add(cell);
            }
        }
        this.requestLayout();
    }

    private void removeCell(int index) {
        this.getChildren().remove(index);
        this.requestLayout();
    }

    private void replaceCell(int index) {
        this.getChildren().remove(index);
        this.addCell(index);
    }

    private void updateCell(int index) {
        Object item = ((GridView)this.getSkinnable()).getItems().get(index);
        ((GridCell)((Object)this.getChildren().get(index))).setItem(item);
    }

    private void addCell(int index) {
        Object item = ((GridView)this.getSkinnable()).getItems().get(index);
        GridCell<T> cell = this.createCell();
        cell.setItem(item);
        cell.updateIndex(index);
        this.getChildren().add(index, cell);
        this.requestLayout();
    }

    private GridCell<T> createCell() {
        GridCell cell = ((GridView)this.getSkinnable()).getCellFactory() != null ? (GridCell)((Object)((GridView)this.getSkinnable()).getCellFactory().call((Object)this.getSkinnable())) : this.createDefaultCellImpl();
        return cell;
    }

    protected GridCell<T> createDefaultCellImpl() {
        return new DefaultGridCell();
    }

    protected void layoutChildren() {
        super.layoutChildren();
        double currentWidth = this.getWidth();
        double cellWidth = ((GridView)this.getSkinnable()).getCellWidth();
        double cellHeight = ((GridView)this.getSkinnable()).getCellHeight();
        double horizontalCellSpacing = ((GridView)this.getSkinnable()).getHorizontalCellSpacing();
        double verticalCellSpacing = ((GridView)this.getSkinnable()).getVerticalCellSpacing();
        double xPos = 0.0;
        double yPos = 0.0;
        HPos currentHorizontalAlignment = ((GridView)this.getSkinnable()).getHorizontalAlignment();
        if (currentHorizontalAlignment != null) {
            if (currentHorizontalAlignment.equals((Object)HPos.CENTER)) {
                xPos = currentWidth % this.computeCellWidth() / 2.0;
            } else if (currentHorizontalAlignment.equals((Object)HPos.RIGHT)) {
                xPos = currentWidth % this.computeCellWidth();
            }
        }
        for (Node child : this.getChildren()) {
            if (xPos + horizontalCellSpacing + cellWidth + horizontalCellSpacing > currentWidth) {
                xPos = 0.0;
                if (currentHorizontalAlignment != null) {
                    if (currentHorizontalAlignment.equals((Object)HPos.CENTER)) {
                        xPos = currentWidth % this.computeCellWidth() / 2.0;
                    } else if (currentHorizontalAlignment.equals((Object)HPos.RIGHT)) {
                        xPos = currentWidth % this.computeCellWidth();
                    }
                }
                yPos = yPos + verticalCellSpacing + cellHeight + verticalCellSpacing;
            }
            child.relocate(xPos + horizontalCellSpacing, yPos + verticalCellSpacing);
            child.resize(cellWidth, cellHeight);
            xPos = xPos + horizontalCellSpacing + cellWidth + horizontalCellSpacing;
        }
    }

    public Orientation getContentBias() {
        return Orientation.HORIZONTAL;
    }

    protected double computeCellWidth() {
        return ((GridView)this.getSkinnable()).cellWidthProperty().doubleValue() + ((GridView)this.getSkinnable()).horizontalCellSpacingProperty().doubleValue() + ((GridView)this.getSkinnable()).horizontalCellSpacingProperty().doubleValue();
    }

    protected double computeCellHeight() {
        return ((GridView)this.getSkinnable()).cellHeightProperty().doubleValue() + ((GridView)this.getSkinnable()).verticalCellSpacingProperty().doubleValue() + ((GridView)this.getSkinnable()).verticalCellSpacingProperty().doubleValue();
    }

    protected double computeMinHeight(double width) {
        return this.computeCellHeight();
    }

    protected double computeMinWidth(double height) {
        return this.computeCellWidth();
    }

    protected double computeMaxHeight(double width) {
        return Double.MAX_VALUE;
    }

    protected double computeMaxWidth(double height) {
        return Double.MAX_VALUE;
    }

    protected double computePrefHeight(double width) {
        int maxCellsInRow = this.computeMaxCellsInRow(width);
        int rowCount = (int)Math.floor((double)((GridView)this.getSkinnable()).getItems().size() / (double)maxCellsInRow);
        return (double)rowCount * this.computeCellHeight();
    }

    protected double computePrefWidth(double height) {
        int maxCellsInColumn = this.computeMaxCellsInColumn(height);
        int columnCount = (int)Math.floor((double)((GridView)this.getSkinnable()).getItems().size() / (double)maxCellsInColumn);
        return (double)columnCount * this.computeCellWidth();
    }

    public int computeRowIndexForItem(int itemIndex) {
        int maxCellsInRow = this.computeMaxCellsInRow();
        return itemIndex / maxCellsInRow;
    }

    public int computeColumnIndexForItem(int itemIndex) {
        int maxCellsInRow = this.computeMaxCellsInRow();
        return itemIndex % maxCellsInRow;
    }

    public int computeMaxCellsInRow() {
        return this.computeMaxCellsInRow(this.getWidth());
    }

    public int computeCurrentRowCount() {
        return (int)Math.ceil((double)((GridView)this.getSkinnable()).getItems().size() / (double)this.computeMaxCellsInRow());
    }

    public int computeMaxCellsInRow(double width) {
        return Math.max((int)Math.floor(width / this.computeCellWidth()), 1);
    }

    public int computeMaxCellsInColumn(double height) {
        return Math.max((int)Math.floor(height / this.computeCellHeight()), 1);
    }
}

