/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.internal.scene.control.skin;

import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import javafx.animation.Animation;
import javafx.animation.AnimationTimer;
import javafx.animation.FadeTransition;
import javafx.animation.Interpolator;
import javafx.animation.Transition;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.VPos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.Effect;
import javafx.scene.effect.InnerShadow;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import javafx.scene.text.Font;
import javafx.scene.text.FontSmoothingType;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.util.Duration;
import jfxtras.labs.internal.scene.control.behavior.LcdBehavior;
import jfxtras.labs.internal.scene.control.skin.GaugeSkinBase;
import jfxtras.labs.scene.control.gauge.Gauge;
import jfxtras.labs.scene.control.gauge.Lcd;
import jfxtras.labs.scene.control.gauge.Section;

public class LcdSkin
extends GaugeSkinBase<Lcd, LcdBehavior> {
    private static final Rectangle PREF_SIZE = new Rectangle(132.0, 48.0);
    private AnimationTimer lcdBlinkingTimer;
    private AnimationTimer thresholdTimer;
    private Lcd control;
    private boolean valueVisible;
    private boolean thresholdVisible;
    private Group sections;
    private Group glowOn;
    private ArrayList<Color> glowColors;
    private Group lcd;
    private Group lcdContent;
    private Text lcdValueString;
    private Text lcdValueBackgroundString;
    private Text lcdUnitString;
    private double lcdValueOffsetLeft;
    private double lcdValueOffsetRight;
    private Group lcdThresholdIndicator;
    private double lcdDigitalFontSizeFactor;
    private Text lcdTitle;
    private Text lcdNumberSystem;
    private Text lcdMinMeasuredValue;
    private Text lcdMaxMeasuredValue;
    private Text lcdFormerValue;
    private Group minMeasured;
    private Group maxMeasured;
    private DoubleProperty currentValue;
    private double formerValue;
    private DoubleProperty lcdValue;
    private DoubleProperty currentLcdValue;
    private FadeTransition glowPulse;
    private Path trendUp;
    private Path trendRising;
    private Path trendSteady;
    private Path trendFalling;
    private Path trendDown;
    private List<Shape> bargraph;
    private Transition toValueAnimation;
    private boolean isDirty;
    private boolean initialized;
    private long lastLcdTimerCall;
    private long lastThresholdTimerCall;
    private long lastClockTimerCall;
    private AnimationTimer clockTimer;
    private StringProperty lcdClockValue;

    public LcdSkin(Lcd CONTROL) {
        super(CONTROL, new LcdBehavior(CONTROL));
        this.control = CONTROL;
        this.sections = new Group();
        this.glowOn = new Group();
        this.glowColors = new ArrayList(4);
        this.lcd = new Group();
        this.lcdContent = new Group();
        this.lcdValueString = new Text();
        this.lcdValueBackgroundString = new Text();
        this.lcdUnitString = new Text();
        this.lcdValueOffsetLeft = 0.0;
        this.lcdValueOffsetRight = 0.0;
        this.lcdThresholdIndicator = new Group();
        this.lcdDigitalFontSizeFactor = 1.0;
        this.lcdTitle = new Text();
        this.lcdNumberSystem = new Text();
        this.lcdMinMeasuredValue = new Text();
        this.lcdMaxMeasuredValue = new Text();
        this.lcdFormerValue = new Text();
        this.minMeasured = new Group();
        this.maxMeasured = new Group();
        this.currentValue = new SimpleDoubleProperty(0.0);
        this.lcdValue = new SimpleDoubleProperty(0.0);
        this.currentLcdValue = new SimpleDoubleProperty(0.0);
        this.bargraph = new ArrayList<Shape>(20);
        this.glowPulse = new FadeTransition(Duration.millis((double)800.0), (Node)this.glowOn);
        this.toValueAnimation = new Transition(){
            {
                this.setCycleDuration(Duration.millis((double)LcdSkin.this.control.getAnimationDuration()));
            }

            protected void interpolate(double frac) {
                LcdSkin.this.currentValue.set(LcdSkin.this.formerValue + (LcdSkin.this.control.getValue() - LcdSkin.this.formerValue) * frac);
            }
        };
        this.isDirty = false;
        this.initialized = false;
        this.lastLcdTimerCall = System.nanoTime() + this.getBlinkInterval();
        this.valueVisible = true;
        this.lcdBlinkingTimer = new AnimationTimer(){

            public void handle(long NOW) {
                if (NOW > LcdSkin.this.lastLcdTimerCall + LcdSkin.this.getBlinkInterval()) {
                    LcdSkin.this.valueVisible = (byte)(LcdSkin.this.valueVisible ^ 1);
                    LcdSkin.this.lcdValueString.setVisible(LcdSkin.this.valueVisible);
                    LcdSkin.this.lastLcdTimerCall = NOW;
                }
            }
        };
        this.thresholdVisible = false;
        this.lastThresholdTimerCall = System.nanoTime() + this.getBlinkInterval();
        this.thresholdTimer = new AnimationTimer(){

            public void handle(long NOW) {
                if (NOW > LcdSkin.this.lastThresholdTimerCall + LcdSkin.this.getBlinkInterval() && LcdSkin.this.control.isLcdThresholdVisible()) {
                    LcdSkin.this.thresholdVisible = (byte)(LcdSkin.this.thresholdVisible ^ 1);
                    LcdSkin.this.lcdThresholdIndicator.setVisible(LcdSkin.this.thresholdVisible);
                    LcdSkin.this.lastThresholdTimerCall = NOW;
                }
            }
        };
        this.lastClockTimerCall = System.nanoTime();
        this.clockTimer = new AnimationTimer(){

            public void handle(long NOW) {
                if (NOW > LcdSkin.this.lastClockTimerCall + 500000000L) {
                    LcdSkin.this.updateLcdClock();
                }
            }
        };
        this.lcdClockValue = new SimpleStringProperty("00:00:00");
        this.init();
    }

    private void init() {
        if (this.control.getPrefWidth() < 0.0 || this.control.getPrefHeight() < 0.0) {
            this.control.setPrefSize(PREF_SIZE.getWidth(), PREF_SIZE.getHeight());
        }
        if (this.control.getMinWidth() < 0.0 | this.control.getMinHeight() < 0.0) {
            this.control.setMinSize(50.0, 50.0);
        }
        if (this.control.getMaxWidth() < 0.0 | this.control.getMaxHeight() < 0.0) {
            this.control.setMaxSize(1024.0, 1024.0);
        }
        this.glowColors.clear();
        Color GLOW_COLOR = this.control.getGlowColor();
        this.glowColors.add(Color.hsb((double)GLOW_COLOR.getHue(), (double)0.46, (double)0.96, (double)0.0));
        this.glowColors.add(Color.hsb((double)GLOW_COLOR.getHue(), (double)0.67, (double)0.9, (double)1.0));
        this.glowColors.add(Color.hsb((double)GLOW_COLOR.getHue(), (double)1.0, (double)1.0, (double)1.0));
        this.glowColors.add(Color.hsb((double)GLOW_COLOR.getHue(), (double)0.67, (double)0.9, (double)1.0));
        this.glowPulse.setFromValue(0.1);
        this.glowPulse.setToValue(1.0);
        this.glowPulse.setInterpolator(Interpolator.SPLINE((double)0.0, (double)0.0, (double)0.4, (double)1.0));
        this.glowPulse.setInterpolator(Interpolator.EASE_OUT);
        this.glowPulse.setCycleCount(-1);
        this.glowPulse.setAutoReverse(true);
        if (this.control.isPulsatingGlow() && this.control.isGlowVisible()) {
            if (!this.glowOn.isVisible()) {
                this.glowOn.setVisible(true);
            }
            if (this.glowOn.getOpacity() < 1.0) {
                this.glowOn.setOpacity(1.0);
            }
            this.glowPulse.play();
        } else {
            this.glowPulse.stop();
            this.glowOn.setOpacity(0.0);
        }
        if (this.control.isGlowVisible()) {
            if (this.control.isGlowOn()) {
                this.glowOn.setOpacity(1.0);
            } else {
                this.glowOn.setOpacity(0.0);
            }
        } else {
            this.glowOn.setOpacity(0.0);
        }
        if (this.control.isLcdBlinking()) {
            this.lcdBlinkingTimer.start();
        }
        if (this.control.isClockMode()) {
            this.clockTimer.start();
        }
        this.addBindings();
        this.addListeners();
        this.registerChangeListener((ObservableValue)this.control.backgroundVisibleProperty(), "BACKGROUND_VISIBILITY");
        this.registerChangeListener((ObservableValue)this.control.clockModeProperty(), "CLOCK_MODE");
        this.registerChangeListener((ObservableValue)this.lcdClockValue, "CLOCK_VALUE");
        this.registerChangeListener((ObservableValue)this.control.titleProperty(), "LCD");
        this.registerChangeListener((ObservableValue)this.control.unitProperty(), "LCD");
        this.registerChangeListener((ObservableValue)this.control.lcdUnitProperty(), "LCD");
        this.currentLcdValue.set(this.control.getLcdValue());
        this.initialized = true;
        this.repaint();
    }

    private void addBindings() {
        if (this.sections.visibleProperty().isBound()) {
            this.sections.visibleProperty().unbind();
        }
        this.sections.visibleProperty().bind((ObservableValue)this.control.sectionsVisibleProperty());
        if (this.minMeasured.visibleProperty().isBound()) {
            this.minMeasured.visibleProperty().unbind();
        }
        this.minMeasured.visibleProperty().bind((ObservableValue)this.control.minMeasuredValueVisibleProperty());
        if (this.maxMeasured.visibleProperty().isBound()) {
            this.maxMeasured.visibleProperty().unbind();
        }
        this.maxMeasured.visibleProperty().bind((ObservableValue)this.control.maxMeasuredValueVisibleProperty());
        if (this.lcdValue.isBound()) {
            this.lcdValue.unbind();
        }
        this.lcdValue.bind((ObservableValue)this.control.lcdValueProperty());
        if (this.lcdMinMeasuredValue.visibleProperty().isBound()) {
            this.lcdMinMeasuredValue.visibleProperty().unbind();
        }
        this.lcdMinMeasuredValue.visibleProperty().bind((ObservableValue)this.control.lcdMinMeasuredValueVisibleProperty());
        if (this.lcdMaxMeasuredValue.visibleProperty().isBound()) {
            this.lcdMinMeasuredValue.visibleProperty().unbind();
        }
        this.lcdMaxMeasuredValue.visibleProperty().bind((ObservableValue)this.control.lcdMaxMeasuredValueVisibleProperty());
        if (this.lcdFormerValue.visibleProperty().isBound()) {
            this.lcdFormerValue.visibleProperty().unbind();
        }
        this.lcdFormerValue.visibleProperty().bind((ObservableValue)this.control.lcdFormerValueVisibleProperty());
        if (this.lcdNumberSystem.visibleProperty().isBound()) {
            this.lcdNumberSystem.visibleProperty().unbind();
        }
        this.lcdNumberSystem.visibleProperty().bind((ObservableValue)this.control.lcdNumberSystemVisibleProperty());
        if (this.lcdTitle.visibleProperty().isBound()) {
            this.lcdTitle.visibleProperty().unbind();
        }
        this.lcdTitle.visibleProperty().bind((ObservableValue)this.control.titleVisibleProperty());
    }

    private void addListeners() {
        this.control.lcdBlinkingProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> ov, Boolean oldValue, Boolean newValue) {
                if (newValue.booleanValue()) {
                    LcdSkin.this.lcdBlinkingTimer.start();
                } else {
                    LcdSkin.this.lcdBlinkingTimer.stop();
                    LcdSkin.this.lcdValueString.setVisible(true);
                }
            }
        });
        this.control.bargraphVisibleProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> ov, Boolean oldValue, Boolean newValue) {
                LcdSkin.this.repaint();
            }
        });
        this.control.thresholdExceededProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> ov, Boolean oldValue, Boolean newValue) {
                if (LcdSkin.this.control.isLcdThresholdVisible()) {
                    if (newValue.booleanValue()) {
                        LcdSkin.this.thresholdTimer.start();
                    } else {
                        LcdSkin.this.thresholdTimer.stop();
                        LcdSkin.this.lcdThresholdIndicator.setVisible(false);
                    }
                }
            }
        });
        this.control.lcdValueProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> ov, Number oldValue, Number newValue) {
                LcdSkin.this.formerValue = oldValue.doubleValue();
                if (LcdSkin.this.toValueAnimation.getStatus() != Animation.Status.STOPPED) {
                    LcdSkin.this.toValueAnimation.stop();
                }
                if (LcdSkin.this.control.isValueAnimationEnabled()) {
                    LcdSkin.this.toValueAnimation.setInterpolator(Interpolator.SPLINE((double)0.5, (double)0.4, (double)0.4, (double)1.0));
                    LcdSkin.this.toValueAnimation.play();
                } else {
                    LcdSkin.this.currentValue.set(newValue.doubleValue());
                }
                LcdSkin.this.checkMarkers(LcdSkin.this.control, oldValue.doubleValue(), newValue.doubleValue());
            }
        });
        this.control.valueProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> ov, Number oldValue, Number newValue) {
                LcdSkin.this.formerValue = oldValue.doubleValue();
                if (LcdSkin.this.toValueAnimation.getStatus() != Animation.Status.STOPPED) {
                    LcdSkin.this.toValueAnimation.stop();
                }
                if (LcdSkin.this.control.isValueAnimationEnabled()) {
                    LcdSkin.this.toValueAnimation.setInterpolator(Interpolator.SPLINE((double)0.5, (double)0.4, (double)0.4, (double)1.0));
                    LcdSkin.this.toValueAnimation.play();
                } else {
                    LcdSkin.this.currentValue.set(newValue.doubleValue());
                }
                LcdSkin.this.checkMarkers(LcdSkin.this.control, oldValue.doubleValue(), newValue.doubleValue());
            }
        });
        this.currentValue.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> ov, Number oldValue, Number newValue) {
                LcdSkin.this.currentLcdValue.set(LcdSkin.this.control.isLcdValueCoupled() ? LcdSkin.this.currentValue.get() : LcdSkin.this.control.getLcdValue());
                if (Double.compare(LcdSkin.this.currentValue.get(), LcdSkin.this.control.getMinMeasuredValue()) < 0) {
                    LcdSkin.this.control.setMinMeasuredValue(LcdSkin.this.currentValue.get());
                }
                if (Double.compare(LcdSkin.this.currentValue.get(), LcdSkin.this.control.getMaxMeasuredValue()) > 0) {
                    LcdSkin.this.control.setMaxMeasuredValue(LcdSkin.this.currentValue.get());
                }
                if (LcdSkin.this.control.isThresholdBehaviorInverted()) {
                    LcdSkin.this.control.setThresholdExceeded(LcdSkin.this.currentValue.get() < LcdSkin.this.control.getThreshold());
                } else {
                    LcdSkin.this.control.setThresholdExceeded(LcdSkin.this.currentValue.get() > LcdSkin.this.control.getThreshold());
                }
                if (LcdSkin.this.control.isLcdThresholdVisible()) {
                    LcdSkin.this.lcdThresholdIndicator.setVisible(LcdSkin.this.control.isThresholdExceeded());
                }
                LcdSkin.this.drawLcdContent();
                if (!LcdSkin.this.control.getSections().isEmpty()) {
                    for (Section section : LcdSkin.this.control.getSections()) {
                        if (Double.compare(LcdSkin.this.currentValue.get(), section.getStart()) < 0 || Double.compare(LcdSkin.this.currentValue.get(), section.getStop()) > 0) continue;
                        break;
                    }
                    if (LcdSkin.this.control.getWidth() <= LcdSkin.this.control.getHeight()) {
                        // empty if block
                    }
                }
            }
        });
    }

    protected void handleControlPropertyChanged(String PROPERTY) {
        super.handleControlPropertyChanged(PROPERTY);
        if ("LCD".equals(PROPERTY)) {
            this.drawLcd();
            this.drawLcdContent();
        } else if ("GLOW_COLOR".equals(PROPERTY)) {
            this.glowColors.clear();
            Color GLOW_COLOR = this.control.getGlowColor();
            this.glowColors.add(Color.hsb((double)GLOW_COLOR.getHue(), (double)0.46, (double)0.96, (double)0.0));
            this.glowColors.add(Color.hsb((double)GLOW_COLOR.getHue(), (double)0.67, (double)0.9, (double)1.0));
            this.glowColors.add(Color.hsb((double)GLOW_COLOR.getHue(), (double)1.0, (double)1.0, (double)1.0));
            this.glowColors.add(Color.hsb((double)GLOW_COLOR.getHue(), (double)0.67, (double)0.9, (double)1.0));
            this.drawGlowOn();
        } else if ("GLOW_VISIBILITY".equals(PROPERTY)) {
            if (!this.control.isGlowVisible()) {
                this.glowOn.setOpacity(0.0);
            }
        } else if ("GLOW_ON".equals(PROPERTY)) {
            if (this.control.isGlowOn()) {
                this.glowOn.setOpacity(1.0);
            } else {
                this.glowOn.setOpacity(0.0);
            }
        } else if ("PULSATING_GLOW".equals(PROPERTY)) {
            if (this.control.isPulsatingGlow() && this.control.isGlowVisible()) {
                if (!this.glowOn.isVisible()) {
                    this.glowOn.setVisible(true);
                }
                if (this.glowOn.getOpacity() < 1.0) {
                    this.glowOn.setOpacity(1.0);
                }
                this.glowPulse.play();
            } else {
                this.glowPulse.stop();
                this.glowOn.setOpacity(0.0);
            }
        } else if ("TREND".equals(PROPERTY)) {
            this.drawLcdContent();
        } else if ("BACKGROUND_VISIBILITY".equals(PROPERTY)) {
            this.repaint();
        } else if ("GAUGE_MODEL".equals(PROPERTY)) {
            this.addBindings();
            this.repaint();
        } else if ("STYLE_MODEL".equals(PROPERTY)) {
            this.addBindings();
            this.repaint();
        } else if ("PREF_WIDTH".equals(PROPERTY)) {
            this.repaint();
        } else if ("PREF_HEIGHT".equals(PROPERTY)) {
            this.repaint();
        } else if ("CLOCK_MODE".equals(PROPERTY)) {
            if (this.control.isClockMode()) {
                this.clockTimer.start();
            } else {
                this.clockTimer.stop();
            }
        } else if ("CLOCK_VALUE".equals(PROPERTY)) {
            this.drawLcdContent();
        }
    }

    public void repaint() {
        this.isDirty = true;
        this.requestLayout();
    }

    @Override
    public void layoutChildren() {
        if (!this.isDirty) {
            return;
        }
        if (!this.initialized) {
            this.init();
        }
        if (this.control.getScene() != null) {
            this.drawGlowOn();
            this.drawLcd();
            this.drawLcdContent();
            this.getChildren().setAll((Object[])new Node[]{this.minMeasured, this.maxMeasured, this.lcd, this.glowOn, this.lcdContent});
        }
        this.isDirty = false;
        super.layoutChildren();
    }

    public Lcd getSkinnable() {
        return this.control;
    }

    public void dispose() {
        this.control = null;
    }

    @Override
    protected double computePrefWidth(double HEIGHT) {
        double prefWidth = PREF_SIZE.getWidth();
        if (HEIGHT != -1.0) {
            prefWidth = Math.max(0.0, HEIGHT - this.getInsets().getLeft() - this.getInsets().getRight());
        }
        return super.computePrefWidth(prefWidth);
    }

    @Override
    protected double computePrefHeight(double WIDTH) {
        double prefHeight = PREF_SIZE.getHeight();
        if (WIDTH != -1.0) {
            prefHeight = Math.max(0.0, WIDTH - this.getInsets().getTop() - this.getInsets().getBottom());
        }
        return super.computePrefWidth(prefHeight);
    }

    private String formatLcdValue(double VALUE, int DECIMALS) {
        StringBuilder DEC_BUFFER = new StringBuilder(16);
        DEC_BUFFER.append("0");
        boolean lcdScientificFormatEnabled = false;
        if (DECIMALS > 0) {
            DEC_BUFFER.append(".");
        }
        for (int i = 0; i < DECIMALS; ++i) {
            DEC_BUFFER.append("0");
        }
        DEC_BUFFER.trimToSize();
        DecimalFormat DEC_FORMAT = new DecimalFormat(DEC_BUFFER.toString(), new DecimalFormatSymbols(Locale.US));
        return DEC_FORMAT.format(VALUE);
    }

    private void prepareLcd() {
        int i;
        Font LCD_VALUE_FONT;
        double SIZE = this.control.getPrefWidth() < this.control.getPrefHeight() ? this.control.getPrefWidth() : this.control.getPrefHeight();
        double WIDTH = this.control.getPrefWidth();
        double HEIGHT = this.control.getPrefHeight();
        Rectangle LCD_MAIN = new Rectangle(1.0, 1.0, WIDTH - 2.0, HEIGHT - 2.0);
        switch (this.control.getLcdValueFont()) {
            case BUS: {
                LCD_VALUE_FONT = Font.loadFont((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/jfxtras/labs/scene/control/gauge/bus.otf"), (double)(0.4583333333 * SIZE));
                this.lcdDigitalFontSizeFactor = 1.0;
                break;
            }
            case LCD: {
                LCD_VALUE_FONT = Font.loadFont((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/jfxtras/labs/scene/control/gauge/digital.ttf"), (double)(0.5833333333 * SIZE));
                this.lcdDigitalFontSizeFactor = 1.9098073909;
                break;
            }
            case PIXEL: {
                LCD_VALUE_FONT = Font.loadFont((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/jfxtras/labs/scene/control/gauge/pixel.ttf"), (double)(0.5208333333 * SIZE));
                this.lcdDigitalFontSizeFactor = 1.0;
                break;
            }
            case PHONE_LCD: {
                LCD_VALUE_FONT = Font.loadFont((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/jfxtras/labs/scene/control/gauge/phonelcd.ttf"), (double)(0.4583333333 * SIZE));
                this.lcdDigitalFontSizeFactor = 1.0;
                break;
            }
            default: {
                LCD_VALUE_FONT = Font.font((String)"Verdana", (FontWeight)FontWeight.NORMAL, (double)(0.5 * SIZE));
                this.lcdDigitalFontSizeFactor = 1.0;
            }
        }
        this.lcdValueString.setFont(LCD_VALUE_FONT);
        this.lcdValueString.setFontSmoothingType(FontSmoothingType.LCD);
        this.lcdValueString.getStyleClass().clear();
        this.lcdValueString.getStyleClass().add((Object)"lcd");
        this.lcdValueString.getStyleClass().add((Object)this.control.getLcdDesign().CSS);
        this.lcdValueString.getStyleClass().add((Object)"lcd-text");
        Font LCD_UNIT_FONT = Font.font((String)this.control.getLcdUnitFont(), (FontWeight)FontWeight.NORMAL, (double)(0.26 * LCD_MAIN.getLayoutBounds().getHeight()));
        this.lcdUnitString.setFont(LCD_UNIT_FONT);
        this.lcdUnitString.setTextOrigin(VPos.BASELINE);
        this.lcdUnitString.setTextAlignment(TextAlignment.RIGHT);
        this.lcdUnitString.setText(this.control.isLcdValueCoupled() ? this.control.getUnit() : this.control.getLcdUnit());
        if (this.lcdUnitString.visibleProperty().isBound()) {
            this.lcdUnitString.visibleProperty().unbind();
        }
        this.lcdUnitString.visibleProperty().bind((ObservableValue)this.control.lcdUnitVisibleProperty());
        this.lcdValueOffsetLeft = SIZE * 0.04;
        if (this.control.isLcdUnitVisible()) {
            this.lcdUnitString.setX(WIDTH - this.lcdUnitString.getLayoutBounds().getWidth() - SIZE * 0.04);
            this.lcdUnitString.setY(SIZE - this.lcdValueString.getLayoutBounds().getHeight() * this.lcdDigitalFontSizeFactor / 2.0);
            this.lcdUnitString.setFontSmoothingType(FontSmoothingType.LCD);
            this.lcdUnitString.getStyleClass().clear();
            this.lcdUnitString.getStyleClass().add((Object)"lcd");
            this.lcdUnitString.getStyleClass().add((Object)this.control.getLcdDesign().CSS);
            this.lcdUnitString.getStyleClass().add((Object)"lcd-text");
            this.lcdValueOffsetRight = this.lcdUnitString.getLayoutBounds().getWidth() + SIZE * 0.0833333333;
            this.lcdValueString.setX(LCD_MAIN.getX() + LCD_MAIN.getWidth() - this.lcdValueString.getLayoutBounds().getWidth() - this.lcdValueOffsetRight);
        } else {
            this.lcdValueOffsetRight = SIZE * 0.0833333333;
            this.lcdValueString.setX(WIDTH - this.lcdValueString.getLayoutBounds().getWidth() - this.lcdValueOffsetRight);
        }
        this.lcdValueBackgroundString.setFont(LCD_VALUE_FONT);
        this.lcdValueBackgroundString.setTextOrigin(VPos.BASELINE);
        this.lcdValueBackgroundString.setTextAlignment(TextAlignment.RIGHT);
        Text ONE_SEGMENT = new Text("8");
        ONE_SEGMENT.setFont(LCD_VALUE_FONT);
        double ONE_SEGMENT_WIDTH = ONE_SEGMENT.getLayoutBounds().getWidth();
        double WIDTH_OF_DECIMALS = this.control.getLcdDecimals() == 0 ? 0.0 : (double)this.control.getLcdDecimals() * ONE_SEGMENT_WIDTH + ONE_SEGMENT_WIDTH;
        double AVAILABLE_WIDTH = LCD_MAIN.getWidth() - this.lcdValueOffsetRight - WIDTH_OF_DECIMALS;
        int NO_OF_SEGMENTS = (int)Math.floor(AVAILABLE_WIDTH / ONE_SEGMENT_WIDTH);
        StringBuilder lcdBackgroundText = new StringBuilder();
        for (i = 0; i < this.control.getLcdDecimals(); ++i) {
            lcdBackgroundText.append("8");
        }
        if (this.control.getLcdDecimals() != 0) {
            lcdBackgroundText.insert(0, ".");
        }
        for (i = 0; i < NO_OF_SEGMENTS; ++i) {
            lcdBackgroundText.insert(0, "8");
        }
        this.lcdValueBackgroundString.setText(lcdBackgroundText.toString());
        if (this.control.isLcdUnitVisible()) {
            this.lcdValueBackgroundString.setX(LCD_MAIN.getX() + LCD_MAIN.getWidth() - this.lcdValueBackgroundString.getLayoutBounds().getWidth() - this.lcdValueOffsetRight);
        } else {
            this.lcdValueBackgroundString.setX(WIDTH - this.lcdValueBackgroundString.getLayoutBounds().getWidth() - this.lcdValueOffsetRight);
        }
        this.lcdValueBackgroundString.setY(SIZE - this.lcdValueBackgroundString.getLayoutBounds().getHeight() * this.lcdDigitalFontSizeFactor / 2.0);
        this.lcdValueBackgroundString.setFontSmoothingType(FontSmoothingType.LCD);
        this.lcdValueBackgroundString.getStyleClass().clear();
        this.lcdValueBackgroundString.getStyleClass().add((Object)"lcd");
        this.lcdValueBackgroundString.getStyleClass().add((Object)this.control.getLcdDesign().CSS);
        this.lcdValueBackgroundString.getStyleClass().add((Object)"lcd-text-background");
        this.lcdValueBackgroundString.setVisible(Gauge.LcdFont.LCD == this.control.getLcdValueFont());
        Font LCD_TITLE_FONT = Font.font((String)this.control.getLcdTitleFont(), (FontWeight)FontWeight.BOLD, (double)(0.1666666667 * SIZE));
        Font LCD_SMALL_FONT = Font.font((String)"Verdana", (FontWeight)FontWeight.NORMAL, (double)(0.1666666667 * SIZE));
        this.lcdTitle.setFont(LCD_TITLE_FONT);
        this.lcdTitle.setTextOrigin(VPos.BASELINE);
        this.lcdTitle.setTextAlignment(TextAlignment.CENTER);
        this.lcdTitle.setText(this.control.getTitle());
        this.lcdTitle.setX(LCD_MAIN.getLayoutX() + (LCD_MAIN.getLayoutBounds().getWidth() - this.lcdTitle.getLayoutBounds().getWidth()) / 2.0);
        this.lcdTitle.setY(LCD_MAIN.getLayoutY() + this.lcdTitle.getLayoutBounds().getHeight() + 0.04 * SIZE);
        this.lcdTitle.setFontSmoothingType(FontSmoothingType.LCD);
        this.lcdTitle.getStyleClass().clear();
        this.lcdTitle.getStyleClass().add((Object)"lcd");
        this.lcdTitle.getStyleClass().add((Object)this.control.getLcdDesign().CSS);
        this.lcdTitle.getStyleClass().add((Object)"lcd-text");
        this.lcdNumberSystem.setFont(LCD_SMALL_FONT);
        this.lcdNumberSystem.setTextOrigin(VPos.BASELINE);
        this.lcdNumberSystem.setTextAlignment(TextAlignment.RIGHT);
        this.lcdNumberSystem.setText(this.control.getLcdNumberSystem().toString());
        this.lcdNumberSystem.setX(LCD_MAIN.getLayoutX() + (LCD_MAIN.getLayoutBounds().getWidth() - this.lcdTitle.getLayoutBounds().getWidth()) / 2.0);
        this.lcdNumberSystem.setY(LCD_MAIN.getLayoutY() + LCD_MAIN.getHeight() - 0.0416666667 * SIZE);
        this.lcdNumberSystem.setFontSmoothingType(FontSmoothingType.LCD);
        this.lcdNumberSystem.getStyleClass().clear();
        this.lcdNumberSystem.getStyleClass().add((Object)"lcd");
        this.lcdNumberSystem.getStyleClass().add((Object)this.control.getLcdDesign().CSS);
        this.lcdNumberSystem.getStyleClass().add((Object)"lcd-text");
        this.lcdMinMeasuredValue.setFont(LCD_SMALL_FONT);
        this.lcdMinMeasuredValue.setTextOrigin(VPos.BASELINE);
        this.lcdMinMeasuredValue.setTextAlignment(TextAlignment.RIGHT);
        this.lcdMinMeasuredValue.setX(LCD_MAIN.getLayoutX() + 0.0416666667 * SIZE);
        this.lcdMinMeasuredValue.setY(LCD_MAIN.getLayoutY() + this.lcdMinMeasuredValue.getLayoutBounds().getHeight() + 0.04 * SIZE);
        this.lcdMinMeasuredValue.setFontSmoothingType(FontSmoothingType.LCD);
        this.lcdMinMeasuredValue.getStyleClass().clear();
        this.lcdMinMeasuredValue.getStyleClass().add((Object)"lcd");
        this.lcdMinMeasuredValue.getStyleClass().add((Object)this.control.getLcdDesign().CSS);
        this.lcdMinMeasuredValue.getStyleClass().add((Object)"lcd-text");
        this.lcdMaxMeasuredValue.setFont(LCD_SMALL_FONT);
        this.lcdMaxMeasuredValue.setTextOrigin(VPos.BASELINE);
        this.lcdMaxMeasuredValue.setTextAlignment(TextAlignment.RIGHT);
        this.lcdMaxMeasuredValue.setY(LCD_MAIN.getLayoutY() + this.lcdMinMeasuredValue.getLayoutBounds().getHeight() + 0.04 * SIZE);
        this.lcdMaxMeasuredValue.setFontSmoothingType(FontSmoothingType.LCD);
        this.lcdMaxMeasuredValue.getStyleClass().clear();
        this.lcdMaxMeasuredValue.getStyleClass().add((Object)"lcd");
        this.lcdMaxMeasuredValue.getStyleClass().add((Object)this.control.getLcdDesign().CSS);
        this.lcdMaxMeasuredValue.getStyleClass().add((Object)"lcd-text");
        this.lcdFormerValue.setFont(LCD_SMALL_FONT);
        this.lcdFormerValue.setTextOrigin(VPos.BASELINE);
        this.lcdFormerValue.setTextAlignment(TextAlignment.CENTER);
        this.lcdFormerValue.setY(LCD_MAIN.getLayoutY() + LCD_MAIN.getHeight() - 0.0416666667 * SIZE);
        this.lcdFormerValue.setFontSmoothingType(FontSmoothingType.LCD);
        this.lcdFormerValue.getStyleClass().clear();
        this.lcdFormerValue.getStyleClass().add((Object)"lcd");
        this.lcdFormerValue.getStyleClass().add((Object)this.control.getLcdDesign().CSS);
        this.lcdFormerValue.getStyleClass().add((Object)"lcd-text");
    }

    private boolean isNoOfDigitsValid() {
        double NEEDED_WIDTH;
        Rectangle LCD_MAIN = new Rectangle(1.0, 1.0, this.control.getPrefWidth() - 2.0, this.control.getPrefHeight() - 2.0);
        double AVAILABLE_WIDTH = LCD_MAIN.getWidth() - this.lcdValueOffsetLeft - this.lcdValueOffsetRight;
        return Double.compare(AVAILABLE_WIDTH, NEEDED_WIDTH = this.lcdValueString.getLayoutBounds().getWidth()) >= 0;
    }

    private void drawGlowOn() {
        double SIZE = this.control.getPrefWidth() < this.control.getPrefHeight() ? this.control.getPrefWidth() : this.control.getPrefHeight();
        double WIDTH = this.control.getPrefWidth();
        double HEIGHT = this.control.getPrefHeight();
        this.glowOn.getChildren().clear();
        Rectangle LCD_FRAME = new Rectangle(0.0, 0.0, WIDTH, HEIGHT);
        double LCD_FRAME_CORNER_RADIUS = LCD_FRAME.getWidth() > LCD_FRAME.getHeight() ? LCD_FRAME.getHeight() * 0.15 : LCD_FRAME.getWidth() * 0.15;
        LCD_FRAME.setArcWidth(LCD_FRAME_CORNER_RADIUS);
        LCD_FRAME.setArcHeight(LCD_FRAME_CORNER_RADIUS);
        LCD_FRAME.setFill((Paint)Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.5));
        LCD_FRAME.setStroke(null);
        InnerShadow GLOW_EFFECT = new InnerShadow();
        GLOW_EFFECT.setWidth(0.6 * SIZE);
        GLOW_EFFECT.setHeight(0.6 * SIZE);
        GLOW_EFFECT.setBlurType(BlurType.GAUSSIAN);
        if (GLOW_EFFECT.colorProperty().isBound()) {
            GLOW_EFFECT.colorProperty().unbind();
        }
        GLOW_EFFECT.colorProperty().bind(this.control.glowColorProperty());
        LCD_FRAME.effectProperty().set((Object)GLOW_EFFECT);
        this.glowOn.getChildren().addAll((Object[])new Node[]{LCD_FRAME});
        this.glowOn.setCache(true);
    }

    private void drawLcd() {
        double SIZE = this.control.getPrefWidth() < this.control.getPrefHeight() ? this.control.getPrefWidth() : this.control.getPrefHeight();
        double WIDTH = this.control.getPrefWidth();
        double HEIGHT = this.control.getPrefHeight();
        this.lcd.getChildren().clear();
        this.lcd.getStyleClass().add((Object)"lcd");
        Rectangle LCD_FRAME = new Rectangle(0.0, 0.0, WIDTH, HEIGHT);
        double LCD_FRAME_CORNER_RADIUS = LCD_FRAME.getWidth() > LCD_FRAME.getHeight() ? LCD_FRAME.getHeight() * 0.15 : LCD_FRAME.getWidth() * 0.15;
        LCD_FRAME.setArcWidth(LCD_FRAME_CORNER_RADIUS);
        LCD_FRAME.setArcHeight(LCD_FRAME_CORNER_RADIUS);
        LinearGradient LCD_FRAME_FILL = new LinearGradient(0.5 * WIDTH, 0.0, 0.5 * WIDTH, HEIGHT, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)0.1, (double)0.1, (double)0.1, (double)1.0)), new Stop(0.1, Color.color((double)0.3, (double)0.3, (double)0.3, (double)1.0)), new Stop(0.93, Color.color((double)0.3, (double)0.3, (double)0.3, (double)1.0)), new Stop(1.0, Color.color((double)0.86, (double)0.86, (double)0.86, (double)1.0))});
        LCD_FRAME.setFill((Paint)LCD_FRAME_FILL);
        LCD_FRAME.setStroke(null);
        Rectangle LCD_MAIN = new Rectangle(1.0, 1.0, WIDTH - 2.0, HEIGHT - 2.0);
        double LCD_MAIN_CORNER_RADIUS = LCD_FRAME.getArcWidth() - 1.0;
        LCD_MAIN.setArcWidth(LCD_MAIN_CORNER_RADIUS);
        LCD_MAIN.setArcHeight(LCD_MAIN_CORNER_RADIUS);
        LCD_MAIN.getStyleClass().add((Object)this.control.getLcdDesign().CSS);
        LCD_MAIN.getStyleClass().add((Object)"lcd-main");
        InnerShadow INNER_GLOW = new InnerShadow();
        INNER_GLOW.setWidth(0.25 * SIZE);
        INNER_GLOW.setHeight(0.25 * SIZE);
        INNER_GLOW.setOffsetY(-0.05 * SIZE);
        INNER_GLOW.setOffsetX(0.0);
        INNER_GLOW.setColor(Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.2));
        InnerShadow INNER_SHADOW = new InnerShadow();
        INNER_SHADOW.setInput((Effect)INNER_GLOW);
        INNER_SHADOW.setWidth(0.15 * SIZE);
        INNER_SHADOW.setHeight(0.075 * SIZE);
        INNER_SHADOW.setOffsetY(0.025 * SIZE);
        INNER_SHADOW.setColor(Color.color((double)0.0, (double)0.0, (double)0.0, (double)0.65));
        LCD_MAIN.setEffect((Effect)INNER_SHADOW);
        if (!this.control.isLcdBackgroundVisible()) {
            LCD_FRAME.setVisible(false);
            LCD_MAIN.setVisible(false);
        }
        this.trendUp = new Path();
        this.trendUp.setFillRule(FillRule.EVEN_ODD);
        this.trendUp.getElements().add((Object)new MoveTo(0.18181818181818182 * WIDTH, 0.9375 * HEIGHT));
        this.trendUp.getElements().add((Object)new LineTo(0.21212121212121213 * WIDTH, 0.8125 * HEIGHT));
        this.trendUp.getElements().add((Object)new LineTo(0.24242424242424243 * WIDTH, 0.9375 * HEIGHT));
        this.trendUp.getElements().add((Object)new LineTo(0.18181818181818182 * WIDTH, 0.9375 * HEIGHT));
        this.trendUp.getElements().add((Object)new ClosePath());
        this.trendUp.getStyleClass().clear();
        this.trendUp.getStyleClass().add((Object)"lcd");
        this.trendUp.getStyleClass().add((Object)this.control.getLcdDesign().CSS);
        this.trendUp.getStyleClass().add((Object)"lcd-text");
        this.trendUp.setVisible(false);
        this.trendRising = new Path();
        this.trendRising.setFillRule(FillRule.EVEN_ODD);
        this.trendRising.getElements().add((Object)new MoveTo(0.18181818181818182 * WIDTH, 0.8541666666666666 * HEIGHT));
        this.trendRising.getElements().add((Object)new LineTo(0.24242424242424243 * WIDTH, 0.8125 * HEIGHT));
        this.trendRising.getElements().add((Object)new LineTo(0.20454545454545456 * WIDTH, 0.9375 * HEIGHT));
        this.trendRising.getElements().add((Object)new LineTo(0.18181818181818182 * WIDTH, 0.8541666666666666 * HEIGHT));
        this.trendRising.getElements().add((Object)new ClosePath());
        this.trendRising.getStyleClass().clear();
        this.trendRising.getStyleClass().add((Object)"lcd");
        this.trendRising.getStyleClass().add((Object)this.control.getLcdDesign().CSS);
        this.trendRising.getStyleClass().add((Object)"lcd-text");
        this.trendRising.setVisible(false);
        this.trendSteady = new Path();
        this.trendSteady.setFillRule(FillRule.EVEN_ODD);
        this.trendSteady.getElements().add((Object)new MoveTo(0.18181818181818182 * WIDTH, 0.8125 * HEIGHT));
        this.trendSteady.getElements().add((Object)new LineTo(0.24242424242424243 * WIDTH, 0.875 * HEIGHT));
        this.trendSteady.getElements().add((Object)new LineTo(0.18181818181818182 * WIDTH, 0.9375 * HEIGHT));
        this.trendSteady.getElements().add((Object)new LineTo(0.18181818181818182 * WIDTH, 0.8125 * HEIGHT));
        this.trendSteady.getElements().add((Object)new ClosePath());
        this.trendSteady.getStyleClass().clear();
        this.trendSteady.getStyleClass().add((Object)"lcd");
        this.trendSteady.getStyleClass().add((Object)this.control.getLcdDesign().CSS);
        this.trendSteady.getStyleClass().add((Object)"lcd-text");
        this.trendSteady.setVisible(false);
        this.trendFalling = new Path();
        this.trendFalling.setFillRule(FillRule.EVEN_ODD);
        this.trendFalling.getElements().add((Object)new MoveTo(0.18181818181818182 * WIDTH, 0.8958333333333334 * HEIGHT));
        this.trendFalling.getElements().add((Object)new LineTo(0.24242424242424243 * WIDTH, 0.9375 * HEIGHT));
        this.trendFalling.getElements().add((Object)new LineTo(0.20454545454545456 * WIDTH, 0.8125 * HEIGHT));
        this.trendFalling.getElements().add((Object)new LineTo(0.18181818181818182 * WIDTH, 0.8958333333333334 * HEIGHT));
        this.trendFalling.getElements().add((Object)new ClosePath());
        this.trendFalling.getStyleClass().clear();
        this.trendFalling.getStyleClass().add((Object)"lcd");
        this.trendFalling.getStyleClass().add((Object)this.control.getLcdDesign().CSS);
        this.trendFalling.getStyleClass().add((Object)"lcd-text");
        this.trendFalling.setVisible(false);
        this.trendDown = new Path();
        this.trendDown.setFillRule(FillRule.EVEN_ODD);
        this.trendDown.getElements().add((Object)new MoveTo(0.18181818181818182 * WIDTH, 0.8125 * HEIGHT));
        this.trendDown.getElements().add((Object)new LineTo(0.21212121212121213 * WIDTH, 0.9375 * HEIGHT));
        this.trendDown.getElements().add((Object)new LineTo(0.24242424242424243 * WIDTH, 0.8125 * HEIGHT));
        this.trendDown.getElements().add((Object)new LineTo(0.18181818181818182 * WIDTH, 0.8125 * HEIGHT));
        this.trendDown.getElements().add((Object)new ClosePath());
        this.trendDown.getStyleClass().clear();
        this.trendDown.getStyleClass().add((Object)"lcd");
        this.trendDown.getStyleClass().add((Object)this.control.getLcdDesign().CSS);
        this.trendDown.getStyleClass().add((Object)"lcd-text");
        this.trendDown.setVisible(false);
        this.prepareLcd();
        this.lcd.getChildren().addAll((Object[])new Node[]{LCD_FRAME, LCD_MAIN});
        if (this.control.isBargraphVisible() && !this.control.isClockMode()) {
            Path BAR_GRAPH_OFF = new Path();
            BAR_GRAPH_OFF.setFillRule(FillRule.EVEN_ODD);
            BAR_GRAPH_OFF.getElements().add((Object)new MoveTo(0.9166666666666666 * WIDTH, 0.74 * HEIGHT));
            BAR_GRAPH_OFF.getElements().add((Object)new LineTo(0.9166666666666666 * WIDTH, 0.78 * HEIGHT));
            BAR_GRAPH_OFF.getElements().add((Object)new LineTo(0.946969696969697 * WIDTH, 0.78 * HEIGHT));
            BAR_GRAPH_OFF.getElements().add((Object)new LineTo(0.946969696969697 * WIDTH, 0.74 * HEIGHT));
            BAR_GRAPH_OFF.getElements().add((Object)new ClosePath());
            BAR_GRAPH_OFF.getElements().add((Object)new MoveTo(0.8712121212121212 * WIDTH, 0.74 * HEIGHT));
            BAR_GRAPH_OFF.getElements().add((Object)new LineTo(0.8712121212121212 * WIDTH, 0.78 * HEIGHT));
            BAR_GRAPH_OFF.getElements().add((Object)new LineTo(0.9015151515151515 * WIDTH, 0.78 * HEIGHT));
            BAR_GRAPH_OFF.getElements().add((Object)new LineTo(0.9015151515151515 * WIDTH, 0.74 * HEIGHT));
            BAR_GRAPH_OFF.getElements().add((Object)new ClosePath());
            BAR_GRAPH_OFF.getElements().add((Object)new MoveTo(0.8257575757575758 * WIDTH, 0.74 * HEIGHT));
            BAR_GRAPH_OFF.getElements().add((Object)new LineTo(0.8257575757575758 * WIDTH, 0.78 * HEIGHT));
            BAR_GRAPH_OFF.getElements().add((Object)new LineTo(0.8560606060606061 * WIDTH, 0.78 * HEIGHT));
            BAR_GRAPH_OFF.getElements().add((Object)new LineTo(0.8560606060606061 * WIDTH, 0.74 * HEIGHT));
            BAR_GRAPH_OFF.getElements().add((Object)new ClosePath());
            BAR_GRAPH_OFF.getElements().add((Object)new MoveTo(0.7803030303030303 * WIDTH, 0.74 * HEIGHT));
            BAR_GRAPH_OFF.getElements().add((Object)new LineTo(0.7803030303030303 * WIDTH, 0.78 * HEIGHT));
            BAR_GRAPH_OFF.getElements().add((Object)new LineTo(0.8106060606060606 * WIDTH, 0.78 * HEIGHT));
            BAR_GRAPH_OFF.getElements().add((Object)new LineTo(0.8106060606060606 * WIDTH, 0.74 * HEIGHT));
            BAR_GRAPH_OFF.getElements().add((Object)new ClosePath());
            BAR_GRAPH_OFF.getElements().add((Object)new MoveTo(0.7348484848484849 * WIDTH, 0.74 * HEIGHT));
            BAR_GRAPH_OFF.getElements().add((Object)new LineTo(0.7348484848484849 * WIDTH, 0.78 * HEIGHT));
            BAR_GRAPH_OFF.getElements().add((Object)new LineTo(0.7651515151515151 * WIDTH, 0.78 * HEIGHT));
            BAR_GRAPH_OFF.getElements().add((Object)new LineTo(0.7651515151515151 * WIDTH, 0.74 * HEIGHT));
            BAR_GRAPH_OFF.getElements().add((Object)new ClosePath());
            BAR_GRAPH_OFF.getElements().add((Object)new MoveTo(0.6893939393939394 * WIDTH, 0.74 * HEIGHT));
            BAR_GRAPH_OFF.getElements().add((Object)new LineTo(0.6893939393939394 * WIDTH, 0.78 * HEIGHT));
            BAR_GRAPH_OFF.getElements().add((Object)new LineTo(0.7196969696969697 * WIDTH, 0.78 * HEIGHT));
            BAR_GRAPH_OFF.getElements().add((Object)new LineTo(0.7196969696969697 * WIDTH, 0.74 * HEIGHT));
            BAR_GRAPH_OFF.getElements().add((Object)new ClosePath());
            BAR_GRAPH_OFF.getElements().add((Object)new MoveTo(0.6439393939393939 * WIDTH, 0.74 * HEIGHT));
            BAR_GRAPH_OFF.getElements().add((Object)new LineTo(0.6439393939393939 * WIDTH, 0.78 * HEIGHT));
            BAR_GRAPH_OFF.getElements().add((Object)new LineTo(0.6742424242424242 * WIDTH, 0.78 * HEIGHT));
            BAR_GRAPH_OFF.getElements().add((Object)new LineTo(0.6742424242424242 * WIDTH, 0.74 * HEIGHT));
            BAR_GRAPH_OFF.getElements().add((Object)new ClosePath());
            BAR_GRAPH_OFF.getElements().add((Object)new MoveTo(0.5984848484848485 * WIDTH, 0.74 * HEIGHT));
            BAR_GRAPH_OFF.getElements().add((Object)new LineTo(0.5984848484848485 * WIDTH, 0.78 * HEIGHT));
            BAR_GRAPH_OFF.getElements().add((Object)new LineTo(0.6287878787878788 * WIDTH, 0.78 * HEIGHT));
            BAR_GRAPH_OFF.getElements().add((Object)new LineTo(0.6287878787878788 * WIDTH, 0.74 * HEIGHT));
            BAR_GRAPH_OFF.getElements().add((Object)new ClosePath());
            BAR_GRAPH_OFF.getElements().add((Object)new MoveTo(0.553030303030303 * WIDTH, 0.74 * HEIGHT));
            BAR_GRAPH_OFF.getElements().add((Object)new LineTo(0.553030303030303 * WIDTH, 0.78 * HEIGHT));
            BAR_GRAPH_OFF.getElements().add((Object)new LineTo(0.5833333333333334 * WIDTH, 0.78 * HEIGHT));
            BAR_GRAPH_OFF.getElements().add((Object)new LineTo(0.5833333333333334 * WIDTH, 0.74 * HEIGHT));
            BAR_GRAPH_OFF.getElements().add((Object)new ClosePath());
            BAR_GRAPH_OFF.getElements().add((Object)new MoveTo(0.5075757575757576 * WIDTH, 0.74 * HEIGHT));
            BAR_GRAPH_OFF.getElements().add((Object)new LineTo(0.5075757575757576 * WIDTH, 0.78 * HEIGHT));
            BAR_GRAPH_OFF.getElements().add((Object)new LineTo(0.5378787878787878 * WIDTH, 0.78 * HEIGHT));
            BAR_GRAPH_OFF.getElements().add((Object)new LineTo(0.5378787878787878 * WIDTH, 0.74 * HEIGHT));
            BAR_GRAPH_OFF.getElements().add((Object)new ClosePath());
            BAR_GRAPH_OFF.getElements().add((Object)new MoveTo(0.4621212121212121 * WIDTH, 0.74 * HEIGHT));
            BAR_GRAPH_OFF.getElements().add((Object)new LineTo(0.4621212121212121 * WIDTH, 0.78 * HEIGHT));
            BAR_GRAPH_OFF.getElements().add((Object)new LineTo(0.49242424242424243 * WIDTH, 0.78 * HEIGHT));
            BAR_GRAPH_OFF.getElements().add((Object)new LineTo(0.49242424242424243 * WIDTH, 0.74 * HEIGHT));
            BAR_GRAPH_OFF.getElements().add((Object)new ClosePath());
            BAR_GRAPH_OFF.getElements().add((Object)new MoveTo(0.4166666666666667 * WIDTH, 0.74 * HEIGHT));
            BAR_GRAPH_OFF.getElements().add((Object)new LineTo(0.4166666666666667 * WIDTH, 0.78 * HEIGHT));
            BAR_GRAPH_OFF.getElements().add((Object)new LineTo(0.44696969696969696 * WIDTH, 0.78 * HEIGHT));
            BAR_GRAPH_OFF.getElements().add((Object)new LineTo(0.44696969696969696 * WIDTH, 0.74 * HEIGHT));
            BAR_GRAPH_OFF.getElements().add((Object)new ClosePath());
            BAR_GRAPH_OFF.getElements().add((Object)new MoveTo(0.3712121212121212 * WIDTH, 0.74 * HEIGHT));
            BAR_GRAPH_OFF.getElements().add((Object)new LineTo(0.3712121212121212 * WIDTH, 0.78 * HEIGHT));
            BAR_GRAPH_OFF.getElements().add((Object)new LineTo(0.4015151515151515 * WIDTH, 0.78 * HEIGHT));
            BAR_GRAPH_OFF.getElements().add((Object)new LineTo(0.4015151515151515 * WIDTH, 0.74 * HEIGHT));
            BAR_GRAPH_OFF.getElements().add((Object)new ClosePath());
            BAR_GRAPH_OFF.getElements().add((Object)new MoveTo(0.32575757575757575 * WIDTH, 0.74 * HEIGHT));
            BAR_GRAPH_OFF.getElements().add((Object)new LineTo(0.32575757575757575 * WIDTH, 0.78 * HEIGHT));
            BAR_GRAPH_OFF.getElements().add((Object)new LineTo(0.3560606060606061 * WIDTH, 0.78 * HEIGHT));
            BAR_GRAPH_OFF.getElements().add((Object)new LineTo(0.3560606060606061 * WIDTH, 0.74 * HEIGHT));
            BAR_GRAPH_OFF.getElements().add((Object)new ClosePath());
            BAR_GRAPH_OFF.getElements().add((Object)new MoveTo(0.2803030303030303 * WIDTH, 0.74 * HEIGHT));
            BAR_GRAPH_OFF.getElements().add((Object)new LineTo(0.2803030303030303 * WIDTH, 0.78 * HEIGHT));
            BAR_GRAPH_OFF.getElements().add((Object)new LineTo(0.3106060606060606 * WIDTH, 0.78 * HEIGHT));
            BAR_GRAPH_OFF.getElements().add((Object)new LineTo(0.3106060606060606 * WIDTH, 0.74 * HEIGHT));
            BAR_GRAPH_OFF.getElements().add((Object)new ClosePath());
            BAR_GRAPH_OFF.getElements().add((Object)new MoveTo(0.23484848484848486 * WIDTH, 0.74 * HEIGHT));
            BAR_GRAPH_OFF.getElements().add((Object)new LineTo(0.23484848484848486 * WIDTH, 0.78 * HEIGHT));
            BAR_GRAPH_OFF.getElements().add((Object)new LineTo(0.26515151515151514 * WIDTH, 0.78 * HEIGHT));
            BAR_GRAPH_OFF.getElements().add((Object)new LineTo(0.26515151515151514 * WIDTH, 0.74 * HEIGHT));
            BAR_GRAPH_OFF.getElements().add((Object)new ClosePath());
            BAR_GRAPH_OFF.getElements().add((Object)new MoveTo(0.1893939393939394 * WIDTH, 0.74 * HEIGHT));
            BAR_GRAPH_OFF.getElements().add((Object)new LineTo(0.1893939393939394 * WIDTH, 0.78 * HEIGHT));
            BAR_GRAPH_OFF.getElements().add((Object)new LineTo(0.2196969696969697 * WIDTH, 0.78 * HEIGHT));
            BAR_GRAPH_OFF.getElements().add((Object)new LineTo(0.2196969696969697 * WIDTH, 0.74 * HEIGHT));
            BAR_GRAPH_OFF.getElements().add((Object)new ClosePath());
            BAR_GRAPH_OFF.getElements().add((Object)new MoveTo(0.14393939393939395 * WIDTH, 0.74 * HEIGHT));
            BAR_GRAPH_OFF.getElements().add((Object)new LineTo(0.14393939393939395 * WIDTH, 0.78 * HEIGHT));
            BAR_GRAPH_OFF.getElements().add((Object)new LineTo(0.17424242424242425 * WIDTH, 0.78 * HEIGHT));
            BAR_GRAPH_OFF.getElements().add((Object)new LineTo(0.17424242424242425 * WIDTH, 0.74 * HEIGHT));
            BAR_GRAPH_OFF.getElements().add((Object)new ClosePath());
            BAR_GRAPH_OFF.getElements().add((Object)new MoveTo(0.09848484848484848 * WIDTH, 0.74 * HEIGHT));
            BAR_GRAPH_OFF.getElements().add((Object)new LineTo(0.09848484848484848 * WIDTH, 0.78 * HEIGHT));
            BAR_GRAPH_OFF.getElements().add((Object)new LineTo(0.12878787878787878 * WIDTH, 0.78 * HEIGHT));
            BAR_GRAPH_OFF.getElements().add((Object)new LineTo(0.12878787878787878 * WIDTH, 0.74 * HEIGHT));
            BAR_GRAPH_OFF.getElements().add((Object)new ClosePath());
            BAR_GRAPH_OFF.getElements().add((Object)new MoveTo(0.05303030303030303 * WIDTH, 0.74 * HEIGHT));
            BAR_GRAPH_OFF.getElements().add((Object)new LineTo(0.05303030303030303 * WIDTH, 0.78 * HEIGHT));
            BAR_GRAPH_OFF.getElements().add((Object)new LineTo(0.08333333333333333 * WIDTH, 0.78 * HEIGHT));
            BAR_GRAPH_OFF.getElements().add((Object)new LineTo(0.08333333333333333 * WIDTH, 0.74 * HEIGHT));
            BAR_GRAPH_OFF.getElements().add((Object)new ClosePath());
            BAR_GRAPH_OFF.getStyleClass().add((Object)this.control.getLcdDesign().CSS);
            BAR_GRAPH_OFF.getStyleClass().add((Object)"lcd-text-background");
            Rectangle SEG1 = new Rectangle(0.05303030303030303 * WIDTH, 0.74 * HEIGHT, 0.030303030303030304 * WIDTH, 0.04 * HEIGHT);
            SEG1.getStyleClass().add((Object)this.control.getLcdDesign().CSS);
            SEG1.getStyleClass().add((Object)"lcd-text");
            SEG1.setVisible(false);
            Rectangle SEG2 = new Rectangle(0.09848484848484848 * WIDTH, 0.74 * HEIGHT, 0.030303030303030304 * WIDTH, 0.04 * HEIGHT);
            SEG2.getStyleClass().add((Object)this.control.getLcdDesign().CSS);
            SEG2.getStyleClass().add((Object)"lcd-text");
            SEG2.setVisible(false);
            Rectangle SEG3 = new Rectangle(0.14393939393939395 * WIDTH, 0.74 * HEIGHT, 0.030303030303030304 * WIDTH, 0.04 * HEIGHT);
            SEG3.getStyleClass().add((Object)this.control.getLcdDesign().CSS);
            SEG3.getStyleClass().add((Object)"lcd-text");
            SEG3.setVisible(false);
            Rectangle SEG4 = new Rectangle(0.1893939393939394 * WIDTH, 0.74 * HEIGHT, 0.030303030303030304 * WIDTH, 0.04 * HEIGHT);
            SEG4.getStyleClass().add((Object)this.control.getLcdDesign().CSS);
            SEG4.getStyleClass().add((Object)"lcd-text");
            SEG4.setVisible(false);
            Rectangle SEG5 = new Rectangle(0.23484848484848486 * WIDTH, 0.74 * HEIGHT, 0.030303030303030304 * WIDTH, 0.04 * HEIGHT);
            SEG5.getStyleClass().add((Object)this.control.getLcdDesign().CSS);
            SEG5.getStyleClass().add((Object)"lcd-text");
            SEG5.setVisible(false);
            Rectangle SEG6 = new Rectangle(0.2803030303030303 * WIDTH, 0.74 * HEIGHT, 0.030303030303030304 * WIDTH, 0.04 * HEIGHT);
            SEG6.getStyleClass().add((Object)this.control.getLcdDesign().CSS);
            SEG6.getStyleClass().add((Object)"lcd-text");
            SEG6.setVisible(false);
            Rectangle SEG7 = new Rectangle(0.32575757575757575 * WIDTH, 0.74 * HEIGHT, 0.030303030303030304 * WIDTH, 0.04 * HEIGHT);
            SEG7.getStyleClass().add((Object)this.control.getLcdDesign().CSS);
            SEG7.getStyleClass().add((Object)"lcd-text");
            SEG7.setVisible(false);
            Rectangle SEG8 = new Rectangle(0.3712121212121212 * WIDTH, 0.74 * HEIGHT, 0.030303030303030304 * WIDTH, 0.04 * HEIGHT);
            SEG8.getStyleClass().add((Object)this.control.getLcdDesign().CSS);
            SEG8.getStyleClass().add((Object)"lcd-text");
            SEG8.setVisible(false);
            Rectangle SEG9 = new Rectangle(0.4166666666666667 * WIDTH, 0.74 * HEIGHT, 0.030303030303030304 * WIDTH, 0.04 * HEIGHT);
            SEG9.getStyleClass().add((Object)this.control.getLcdDesign().CSS);
            SEG9.getStyleClass().add((Object)"lcd-text");
            SEG9.setVisible(false);
            Rectangle SEG10 = new Rectangle(0.4621212121212121 * WIDTH, 0.74 * HEIGHT, 0.030303030303030304 * WIDTH, 0.04 * HEIGHT);
            SEG10.getStyleClass().add((Object)this.control.getLcdDesign().CSS);
            SEG10.getStyleClass().add((Object)"lcd-text");
            SEG10.setVisible(false);
            Rectangle SEG11 = new Rectangle(0.5075757575757576 * WIDTH, 0.74 * HEIGHT, 0.030303030303030304 * WIDTH, 0.04 * HEIGHT);
            SEG11.getStyleClass().add((Object)this.control.getLcdDesign().CSS);
            SEG11.getStyleClass().add((Object)"lcd-text");
            SEG11.setVisible(false);
            Rectangle SEG12 = new Rectangle(0.553030303030303 * WIDTH, 0.74 * HEIGHT, 0.030303030303030304 * WIDTH, 0.04 * HEIGHT);
            SEG12.getStyleClass().add((Object)this.control.getLcdDesign().CSS);
            SEG12.getStyleClass().add((Object)"lcd-text");
            SEG12.setVisible(false);
            Rectangle SEG13 = new Rectangle(0.5984848484848485 * WIDTH, 0.74 * HEIGHT, 0.030303030303030304 * WIDTH, 0.04 * HEIGHT);
            SEG13.getStyleClass().add((Object)this.control.getLcdDesign().CSS);
            SEG13.getStyleClass().add((Object)"lcd-text");
            SEG13.setVisible(false);
            Rectangle SEG14 = new Rectangle(0.6439393939393939 * WIDTH, 0.74 * HEIGHT, 0.030303030303030304 * WIDTH, 0.04 * HEIGHT);
            SEG14.getStyleClass().add((Object)this.control.getLcdDesign().CSS);
            SEG14.getStyleClass().add((Object)"lcd-text");
            SEG14.setVisible(false);
            Rectangle SEG15 = new Rectangle(0.6893939393939394 * WIDTH, 0.74 * HEIGHT, 0.030303030303030304 * WIDTH, 0.04 * HEIGHT);
            SEG15.getStyleClass().add((Object)this.control.getLcdDesign().CSS);
            SEG15.getStyleClass().add((Object)"lcd-text");
            SEG15.setVisible(false);
            Rectangle SEG16 = new Rectangle(0.7348484848484849 * WIDTH, 0.74 * HEIGHT, 0.030303030303030304 * WIDTH, 0.04 * HEIGHT);
            SEG16.getStyleClass().add((Object)this.control.getLcdDesign().CSS);
            SEG16.getStyleClass().add((Object)"lcd-text");
            SEG16.setVisible(false);
            Rectangle SEG17 = new Rectangle(0.7803030303030303 * WIDTH, 0.74 * HEIGHT, 0.030303030303030304 * WIDTH, 0.04 * HEIGHT);
            SEG17.getStyleClass().add((Object)this.control.getLcdDesign().CSS);
            SEG17.getStyleClass().add((Object)"lcd-text");
            SEG17.setVisible(false);
            Rectangle SEG18 = new Rectangle(0.8257575757575758 * WIDTH, 0.74 * HEIGHT, 0.030303030303030304 * WIDTH, 0.04 * HEIGHT);
            SEG18.getStyleClass().add((Object)this.control.getLcdDesign().CSS);
            SEG18.getStyleClass().add((Object)"lcd-text");
            SEG18.setVisible(false);
            Rectangle SEG19 = new Rectangle(0.8712121212121212 * WIDTH, 0.74 * HEIGHT, 0.030303030303030304 * WIDTH, 0.04 * HEIGHT);
            SEG19.getStyleClass().add((Object)this.control.getLcdDesign().CSS);
            SEG19.getStyleClass().add((Object)"lcd-text");
            SEG19.setVisible(false);
            Rectangle SEG20 = new Rectangle(0.9166666666666666 * WIDTH, 0.74 * HEIGHT, 0.030303030303030304 * WIDTH, 0.04 * HEIGHT);
            SEG20.getStyleClass().add((Object)this.control.getLcdDesign().CSS);
            SEG20.getStyleClass().add((Object)"lcd-text");
            SEG20.setVisible(false);
            this.bargraph.clear();
            this.bargraph.add((Shape)SEG1);
            this.bargraph.add((Shape)SEG2);
            this.bargraph.add((Shape)SEG3);
            this.bargraph.add((Shape)SEG4);
            this.bargraph.add((Shape)SEG5);
            this.bargraph.add((Shape)SEG6);
            this.bargraph.add((Shape)SEG7);
            this.bargraph.add((Shape)SEG8);
            this.bargraph.add((Shape)SEG9);
            this.bargraph.add((Shape)SEG10);
            this.bargraph.add((Shape)SEG11);
            this.bargraph.add((Shape)SEG12);
            this.bargraph.add((Shape)SEG13);
            this.bargraph.add((Shape)SEG14);
            this.bargraph.add((Shape)SEG15);
            this.bargraph.add((Shape)SEG16);
            this.bargraph.add((Shape)SEG17);
            this.bargraph.add((Shape)SEG18);
            this.bargraph.add((Shape)SEG19);
            this.bargraph.add((Shape)SEG20);
            this.lcd.getChildren().add((Object)BAR_GRAPH_OFF);
            this.lcd.getChildren().addAll(this.bargraph);
        }
        this.lcd.getChildren().add((Object)this.lcdTitle);
        this.lcd.getChildren().add((Object)this.lcdNumberSystem);
        this.lcd.getChildren().add((Object)this.lcdUnitString);
        this.lcd.getChildren().add((Object)this.lcdValueBackgroundString);
        this.lcdThresholdIndicator = this.createLcdThresholdIndicator(HEIGHT * 0.2045454545, HEIGHT * 0.2045454545);
        this.lcdThresholdIndicator.setTranslateX(0.04 * SIZE);
        this.lcdThresholdIndicator.setTranslateY(HEIGHT - this.lcdThresholdIndicator.getLayoutBounds().getHeight() - 0.0416666667 * SIZE);
        this.lcdThresholdIndicator.setVisible(this.control.isLcdThresholdVisible());
        this.lcd.getChildren().add((Object)this.lcdThresholdIndicator);
        this.lcd.setCache(true);
    }

    private void drawLcdContent() {
        double SIZE = this.control.getPrefWidth() < this.control.getPrefHeight() ? this.control.getPrefWidth() : this.control.getPrefHeight();
        double WIDTH = this.control.getPrefWidth();
        double HEIGHT = this.control.getPrefHeight();
        this.lcdContent.getChildren().clear();
        Rectangle IBOUNDS = new Rectangle(0.0, 0.0, WIDTH, HEIGHT);
        IBOUNDS.setOpacity(0.0);
        IBOUNDS.setStroke(null);
        this.lcdContent.getChildren().add((Object)IBOUNDS);
        Rectangle LCD_MAIN = new Rectangle(1.0, 1.0, WIDTH - 2.0, HEIGHT - 2.0);
        if (this.control.isClockMode()) {
            this.lcdValueString.setText((String)this.lcdClockValue.get());
        } else {
            switch (this.control.getLcdNumberSystem()) {
                case HEXADECIMAL: {
                    this.lcdValueString.setText(Integer.toHexString((int)this.currentLcdValue.get()).toUpperCase());
                    break;
                }
                case OCTAL: {
                    this.lcdValueString.setText(Integer.toOctalString((int)this.currentLcdValue.get()).toUpperCase());
                    break;
                }
                default: {
                    this.lcdValueString.setText(this.formatLcdValue(this.currentLcdValue.get(), this.control.getLcdDecimals()));
                }
            }
            this.lcdNumberSystem.setText(this.control.getLcdNumberSystem().toString());
            this.lcdNumberSystem.setX(WIDTH - this.lcdNumberSystem.getLayoutBounds().getWidth() - 0.0416666667 * SIZE);
            this.lcdNumberSystem.setY(LCD_MAIN.getLayoutY() + LCD_MAIN.getHeight() - 0.0416666667 * SIZE);
            if (!this.isNoOfDigitsValid()) {
                this.lcdValueString.setText("-E-");
            }
        }
        if (this.control.isLcdUnitVisible() && !this.control.isClockMode()) {
            this.lcdValueString.setX(LCD_MAIN.getX() + (LCD_MAIN.getWidth() - this.lcdValueString.getLayoutBounds().getWidth()) - this.lcdValueOffsetRight);
        } else {
            this.lcdValueString.setX(WIDTH - this.lcdValueString.getLayoutBounds().getWidth() - this.lcdValueOffsetRight);
        }
        this.lcdValueString.setY(SIZE - this.lcdValueString.getLayoutBounds().getHeight() * this.lcdDigitalFontSizeFactor / 2.0);
        if (this.control.isBargraphVisible() && !this.bargraph.isEmpty()) {
            int activeBargraphSegments = (int)((this.currentLcdValue.get() - (double)((long)this.currentLcdValue.get())) * 20.0);
            for (int i = 0; i < 20; ++i) {
                if (i <= activeBargraphSegments) {
                    this.bargraph.get(i).setVisible(true);
                    continue;
                }
                this.bargraph.get(i).setVisible(false);
            }
        }
        this.lcdTitle.setText(this.control.getTitle());
        this.lcdMinMeasuredValue.setText(this.formatLcdValue(this.control.getMinMeasuredValue(), this.control.getLcdMinMeasuredValueDecimals()));
        this.lcdMaxMeasuredValue.setText(this.formatLcdValue(this.control.getMaxMeasuredValue(), this.control.getLcdMaxMeasuredValueDecimals()));
        this.lcdMaxMeasuredValue.setX(WIDTH - this.lcdMaxMeasuredValue.getLayoutBounds().getWidth() - 0.0416666667 * SIZE);
        this.lcdFormerValue.setText(this.formatLcdValue(this.formerValue, this.control.getLcdDecimals()));
        this.lcdFormerValue.setX((WIDTH - this.lcdFormerValue.getLayoutBounds().getWidth()) / 2.0);
        this.lcdFormerValue.setFontSmoothingType(FontSmoothingType.LCD);
        if (this.control.isTrendVisible()) {
            switch (this.control.getTrend()) {
                case UP: {
                    this.trendUp.setVisible(true);
                    this.trendRising.setVisible(false);
                    this.trendSteady.setVisible(false);
                    this.trendFalling.setVisible(false);
                    this.trendDown.setVisible(false);
                    break;
                }
                case RISING: {
                    this.trendUp.setVisible(false);
                    this.trendRising.setVisible(true);
                    this.trendSteady.setVisible(false);
                    this.trendFalling.setVisible(false);
                    this.trendDown.setVisible(false);
                    break;
                }
                case STEADY: {
                    this.trendUp.setVisible(false);
                    this.trendRising.setVisible(false);
                    this.trendSteady.setVisible(true);
                    this.trendFalling.setVisible(false);
                    this.trendDown.setVisible(false);
                    break;
                }
                case FALLING: {
                    this.trendUp.setVisible(false);
                    this.trendRising.setVisible(false);
                    this.trendSteady.setVisible(false);
                    this.trendFalling.setVisible(true);
                    this.trendDown.setVisible(false);
                    break;
                }
                case DOWN: {
                    this.trendUp.setVisible(false);
                    this.trendRising.setVisible(false);
                    this.trendSteady.setVisible(false);
                    this.trendFalling.setVisible(false);
                    this.trendDown.setVisible(true);
                    break;
                }
                default: {
                    this.trendUp.setVisible(false);
                    this.trendRising.setVisible(false);
                    this.trendSteady.setVisible(false);
                    this.trendFalling.setVisible(false);
                    this.trendDown.setVisible(false);
                }
            }
        }
        if (this.control.isClockMode()) {
            this.lcdContent.getChildren().addAll((Object[])new Node[]{this.lcdValueString});
        } else {
            this.lcdContent.getChildren().addAll((Object[])new Node[]{this.lcdValueString, this.lcdMinMeasuredValue, this.lcdMaxMeasuredValue, this.lcdFormerValue, this.trendUp, this.trendRising, this.trendSteady, this.trendFalling, this.trendDown});
        }
    }

    private void updateLcdClock() {
        String secondString;
        int hours = Calendar.getInstance().get(11);
        int minutes = Calendar.getInstance().get(12);
        int seconds = Calendar.getInstance().get(13);
        String hourString = hours < 10 ? "0" + Integer.toString(hours) : Integer.toString(hours);
        String minuteString = minutes < 10 ? "0" + Integer.toString(minutes) : Integer.toString(minutes);
        String string = secondString = seconds < 10 ? "0" + Integer.toString(seconds) : Integer.toString(seconds);
        if (this.control.isClockSecondsVisible()) {
            this.lcdClockValue.set((Object)(hourString + ":" + minuteString + ":" + secondString));
        } else {
            this.lcdClockValue.set((Object)(hourString + ":" + minuteString));
        }
    }

    private Group createLcdThresholdIndicator(double WIDTH, double HEIGHT) {
        Group INDICATOR = new Group();
        INDICATOR.getChildren().clear();
        Rectangle IBOUNDS = new Rectangle(0.0, 0.0, WIDTH, HEIGHT);
        IBOUNDS.setOpacity(0.0);
        IBOUNDS.setStroke(null);
        INDICATOR.getChildren().add((Object)IBOUNDS);
        Path LCD_THRESHOLD = new Path();
        LCD_THRESHOLD.setFillRule(FillRule.EVEN_ODD);
        LCD_THRESHOLD.getElements().add((Object)new MoveTo(WIDTH * 0.4444444444444444, HEIGHT * 0.7777777777777778));
        LCD_THRESHOLD.getElements().add((Object)new LineTo(WIDTH * 0.5555555555555556, HEIGHT * 0.7777777777777778));
        LCD_THRESHOLD.getElements().add((Object)new LineTo(WIDTH * 0.5555555555555556, HEIGHT * 0.8888888888888888));
        LCD_THRESHOLD.getElements().add((Object)new LineTo(WIDTH * 0.4444444444444444, HEIGHT * 0.8888888888888888));
        LCD_THRESHOLD.getElements().add((Object)new LineTo(WIDTH * 0.4444444444444444, HEIGHT * 0.7777777777777778));
        LCD_THRESHOLD.getElements().add((Object)new ClosePath());
        LCD_THRESHOLD.getElements().add((Object)new MoveTo(WIDTH * 0.4444444444444444, HEIGHT * 0.3333333333333333));
        LCD_THRESHOLD.getElements().add((Object)new LineTo(WIDTH * 0.5555555555555556, HEIGHT * 0.3333333333333333));
        LCD_THRESHOLD.getElements().add((Object)new LineTo(WIDTH * 0.5555555555555556, HEIGHT * 0.7222222222222222));
        LCD_THRESHOLD.getElements().add((Object)new LineTo(WIDTH * 0.4444444444444444, HEIGHT * 0.7222222222222222));
        LCD_THRESHOLD.getElements().add((Object)new LineTo(WIDTH * 0.4444444444444444, HEIGHT * 0.3333333333333333));
        LCD_THRESHOLD.getElements().add((Object)new ClosePath());
        LCD_THRESHOLD.getElements().add((Object)new MoveTo(0.0, HEIGHT));
        LCD_THRESHOLD.getElements().add((Object)new LineTo(WIDTH, HEIGHT));
        LCD_THRESHOLD.getElements().add((Object)new LineTo(WIDTH * 0.5, 0.0));
        LCD_THRESHOLD.getElements().add((Object)new LineTo(0.0, HEIGHT));
        LCD_THRESHOLD.getElements().add((Object)new ClosePath());
        LCD_THRESHOLD.getStyleClass().add((Object)"lcd");
        LCD_THRESHOLD.getStyleClass().add((Object)this.control.getLcdDesign().CSS);
        LCD_THRESHOLD.getStyleClass().add((Object)"lcd-text");
        LCD_THRESHOLD.setStroke(null);
        INDICATOR.getChildren().addAll((Object[])new Node[]{LCD_THRESHOLD});
        return INDICATOR;
    }
}

