/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.internal.scene.control.skin;

import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Locale;
import javafx.animation.Animation;
import javafx.animation.AnimationTimer;
import javafx.animation.FadeTransition;
import javafx.animation.Interpolator;
import javafx.animation.Transition;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.geometry.VPos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.effect.InnerShadow;
import javafx.scene.image.ImageView;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.shape.StrokeType;
import javafx.scene.text.Font;
import javafx.scene.text.FontSmoothingType;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.util.Duration;
import jfxtras.labs.internal.scene.control.behavior.LinearBehavior;
import jfxtras.labs.internal.scene.control.skin.GaugeSkinBase;
import jfxtras.labs.scene.control.gauge.Gauge;
import jfxtras.labs.scene.control.gauge.Linear;
import jfxtras.labs.scene.control.gauge.Marker;
import jfxtras.labs.scene.control.gauge.Section;
import jfxtras.labs.util.ConicalGradient;
import jfxtras.labs.util.Util;

public class LinearSkin
extends GaugeSkinBase<Linear, LinearBehavior> {
    private static final Rectangle MIN_SIZE = new Rectangle(25.0, 50.0);
    private static final Rectangle PREF_SIZE = new Rectangle(170.0, 340.0);
    private static final Rectangle MAX_SIZE = new Rectangle(512.0, 1024.0);
    private Linear control;
    private Rectangle gaugeBounds;
    private Point2D framelessOffset;
    private Group frame;
    private Group background;
    private Group sections;
    private Group areas;
    private Group markers;
    private Group titleAndUnit;
    private Group tickmarks;
    private Group glowOff;
    private Group glowOn;
    private ArrayList<Color> glowColors;
    private Group lcd;
    private Group lcdContent;
    private Text lcdValueString;
    private Text lcdUnitString;
    private Group lcdThresholdIndicator;
    private Group threshold;
    private Group minMeasured;
    private Group maxMeasured;
    private Group bar;
    private Rectangle currentBar;
    private Rectangle currentBarHl;
    private Group ledOff;
    private Group ledOn;
    private Group userLedOff;
    private Group userLedOn;
    private Group foreground;
    private DoubleProperty currentValue;
    private double stepsize;
    private double formerValue;
    private DoubleProperty lcdValue;
    private DoubleProperty currentLcdValue;
    private FadeTransition glowPulse;
    private Transition toValueAnimation;
    private AnimationTimer ledTimer;
    private boolean ledOnVisible;
    private long lastLedTimerCall;
    private AnimationTimer userLedTimer;
    private boolean userLedOnVisible;
    private long lastUserLedTimerCall;
    private boolean isDirty;
    private boolean initialized;

    public LinearSkin(Linear CONTROL) {
        super(CONTROL, new LinearBehavior(CONTROL));
        this.control = CONTROL;
        this.gaugeBounds = new Rectangle(150.0, 350.0);
        this.framelessOffset = new Point2D(0.0, 0.0);
        this.frame = new Group();
        this.background = new Group();
        this.sections = new Group();
        this.areas = new Group();
        this.markers = new Group();
        this.titleAndUnit = new Group();
        this.tickmarks = new Group();
        this.glowOff = new Group();
        this.glowOn = new Group();
        this.glowColors = new ArrayList(4);
        this.lcd = new Group();
        this.lcdContent = new Group();
        this.lcdValueString = new Text();
        this.lcdUnitString = new Text();
        this.lcdThresholdIndicator = new Group();
        this.threshold = new Group();
        this.minMeasured = new Group();
        this.maxMeasured = new Group();
        this.bar = new Group();
        this.ledOff = new Group();
        this.ledOn = new Group();
        this.userLedOff = new Group();
        this.userLedOn = new Group();
        this.foreground = new Group();
        this.currentValue = new SimpleDoubleProperty(0.0);
        this.lcdValue = new SimpleDoubleProperty(0.0);
        this.currentLcdValue = new SimpleDoubleProperty(0.0);
        this.glowPulse = new FadeTransition(Duration.millis((double)800.0), (Node)this.glowOn);
        this.toValueAnimation = new Transition(){
            {
                this.setCycleDuration(Duration.millis((double)LinearSkin.this.control.getAnimationDuration()));
            }

            protected void interpolate(double frac) {
                LinearSkin.this.currentValue.set(LinearSkin.this.formerValue + (LinearSkin.this.control.getValue() - LinearSkin.this.formerValue) * frac);
            }
        };
        this.ledTimer = new AnimationTimer(){

            public void handle(long NOW) {
                if (NOW > LinearSkin.this.lastLedTimerCall + LinearSkin.this.getBlinkInterval()) {
                    LinearSkin.this.ledOnVisible = (byte)(LinearSkin.this.ledOnVisible ^ 1);
                    if (LinearSkin.this.ledOnVisible) {
                        LinearSkin.this.ledOn.setOpacity(1.0);
                    } else {
                        LinearSkin.this.ledOn.setOpacity(0.0);
                    }
                    LinearSkin.this.lastLedTimerCall = NOW;
                }
            }
        };
        this.lastLedTimerCall = 0L;
        this.ledOnVisible = false;
        this.userLedTimer = new AnimationTimer(){

            public void handle(long NOW) {
                if (NOW > LinearSkin.this.lastUserLedTimerCall + LinearSkin.this.getBlinkInterval()) {
                    LinearSkin.this.userLedOnVisible = (byte)(LinearSkin.this.userLedOnVisible ^ 1);
                    if (LinearSkin.this.userLedOnVisible) {
                        LinearSkin.this.userLedOn.setOpacity(1.0);
                    } else {
                        LinearSkin.this.userLedOn.setOpacity(0.0);
                    }
                    LinearSkin.this.lastUserLedTimerCall = NOW;
                }
            }
        };
        this.lastUserLedTimerCall = 0L;
        this.userLedOnVisible = false;
        this.isDirty = false;
        this.initialized = false;
        this.init();
    }

    private void init() {
        if (this.control.getPrefWidth() < 0.0 || this.control.getPrefHeight() < 0.0) {
            this.control.setPrefSize(PREF_SIZE.getWidth(), PREF_SIZE.getHeight());
        }
        if (this.control.getMinWidth() < 0.0 | this.control.getMinHeight() < 0.0) {
            this.control.setMinSize(50.0, 50.0);
        }
        if (this.control.getMaxWidth() < 0.0 | this.control.getMaxHeight() < 0.0) {
            this.control.setMaxSize(1024.0, 1024.0);
        }
        this.control.recalcRange();
        this.glowColors.clear();
        Color GLOW_COLOR = this.control.getGlowColor();
        this.glowColors.add(Color.hsb((double)GLOW_COLOR.getHue(), (double)0.46, (double)0.96, (double)0.0));
        this.glowColors.add(Color.hsb((double)GLOW_COLOR.getHue(), (double)0.67, (double)0.9, (double)1.0));
        this.glowColors.add(Color.hsb((double)GLOW_COLOR.getHue(), (double)1.0, (double)1.0, (double)1.0));
        this.glowColors.add(Color.hsb((double)GLOW_COLOR.getHue(), (double)0.67, (double)0.9, (double)1.0));
        this.glowPulse.setFromValue(0.1);
        this.glowPulse.setToValue(1.0);
        this.glowPulse.setInterpolator(Interpolator.SPLINE((double)0.0, (double)0.0, (double)0.4, (double)1.0));
        this.glowPulse.setInterpolator(Interpolator.EASE_OUT);
        this.glowPulse.setCycleCount(-1);
        this.glowPulse.setAutoReverse(true);
        if (this.control.isPulsatingGlow() && this.control.isGlowVisible()) {
            if (!this.glowOn.isVisible()) {
                this.glowOn.setVisible(true);
            }
            if (this.glowOn.getOpacity() < 1.0) {
                this.glowOn.setOpacity(1.0);
            }
            this.glowPulse.play();
        } else {
            this.glowPulse.stop();
            this.glowOn.setOpacity(0.0);
        }
        if (this.control.isGlowVisible()) {
            this.glowOff.setVisible(true);
            if (this.control.isGlowOn()) {
                this.glowOn.setOpacity(1.0);
            } else {
                this.glowOn.setOpacity(0.0);
            }
        } else {
            this.glowOff.setVisible(false);
            this.glowOn.setOpacity(0.0);
        }
        this.ledOn.setOpacity(0.0);
        if (this.control.isUserLedOn()) {
            this.userLedOn.setOpacity(1.0);
        } else {
            this.userLedOn.setOpacity(0.0);
        }
        if (this.control.isUserLedBlinking()) {
            this.userLedTimer.start();
        }
        this.addBindings();
        this.addListeners();
        this.control.recalcRange();
        this.control.setMinMeasuredValue(this.control.getMaxValue());
        this.control.setMaxMeasuredValue(this.control.getMinValue());
        this.calcGaugeBounds();
        this.lcdUnitString.getStyleClass().clear();
        this.lcdUnitString.getStyleClass().add((Object)"lcd");
        this.lcdUnitString.getStyleClass().add((Object)this.control.getLcdDesign().CSS);
        this.lcdUnitString.getStyleClass().add((Object)"lcd-text");
        this.lcdValueString.getStyleClass().clear();
        this.lcdValueString.getStyleClass().add((Object)"lcd");
        this.lcdValueString.getStyleClass().add((Object)this.control.getLcdDesign().CSS);
        this.lcdValueString.getStyleClass().add((Object)"lcd-text");
        this.initialized = true;
        this.repaint();
    }

    private void addBindings() {
        if (this.frame.visibleProperty().isBound()) {
            this.frame.visibleProperty().unbind();
        }
        this.frame.visibleProperty().bind((ObservableValue)this.control.frameVisibleProperty());
        if (this.background.visibleProperty().isBound()) {
            this.background.visibleProperty().unbind();
        }
        this.background.visibleProperty().bind((ObservableValue)this.control.backgroundVisibleProperty());
        if (this.sections.visibleProperty().isBound()) {
            this.sections.visibleProperty().unbind();
        }
        this.sections.visibleProperty().bind((ObservableValue)this.control.sectionsVisibleProperty());
        if (this.areas.visibleProperty().isBound()) {
            this.areas.visibleProperty().unbind();
        }
        this.areas.visibleProperty().bind((ObservableValue)this.control.areasVisibleProperty());
        if (this.markers.visibleProperty().isBound()) {
            this.markers.visibleProperty().unbind();
        }
        this.markers.visibleProperty().bind((ObservableValue)this.control.markersVisibleProperty());
        if (this.ledOff.visibleProperty().isBound()) {
            this.ledOff.visibleProperty().unbind();
        }
        this.ledOff.visibleProperty().bind((ObservableValue)this.control.ledVisibleProperty());
        if (this.ledOn.visibleProperty().isBound()) {
            this.ledOn.visibleProperty().unbind();
        }
        this.ledOn.visibleProperty().bind((ObservableValue)this.control.ledVisibleProperty());
        if (this.userLedOff.visibleProperty().isBound()) {
            this.userLedOff.visibleProperty().unbind();
        }
        this.userLedOff.visibleProperty().bind((ObservableValue)this.control.userLedVisibleProperty());
        if (this.userLedOn.visibleProperty().isBound()) {
            this.userLedOn.visibleProperty().unbind();
        }
        this.userLedOn.visibleProperty().bind((ObservableValue)this.control.userLedVisibleProperty());
        if (this.threshold.visibleProperty().isBound()) {
            this.threshold.visibleProperty().unbind();
        }
        this.threshold.visibleProperty().bind((ObservableValue)this.control.thresholdVisibleProperty());
        if (this.minMeasured.visibleProperty().isBound()) {
            this.minMeasured.visibleProperty().unbind();
        }
        this.minMeasured.visibleProperty().bind((ObservableValue)this.control.minMeasuredValueVisibleProperty());
        if (this.maxMeasured.visibleProperty().isBound()) {
            this.maxMeasured.visibleProperty().unbind();
        }
        this.maxMeasured.visibleProperty().bind((ObservableValue)this.control.maxMeasuredValueVisibleProperty());
        if (this.lcdValue.isBound()) {
            this.lcdValue.unbind();
        }
        this.lcdValue.bind((ObservableValue)this.control.valueProperty());
        if (this.lcd.visibleProperty().isBound()) {
            this.lcd.visibleProperty().unbind();
        }
        this.lcd.visibleProperty().bind((ObservableValue)this.control.lcdVisibleProperty());
        if (this.lcdContent.visibleProperty().isBound()) {
            this.lcdContent.visibleProperty().unbind();
        }
        this.lcdContent.visibleProperty().bind((ObservableValue)this.control.lcdVisibleProperty());
        if (this.foreground.visibleProperty().isBound()) {
            this.foreground.visibleProperty().unbind();
        }
        this.foreground.visibleProperty().bind((ObservableValue)this.control.foregroundVisibleProperty());
    }

    private void addListeners() {
        this.control.getMarkers().addListener(new InvalidationListener(){

            public void invalidated(Observable observable) {
                LinearSkin.this.drawIndicators();
            }
        });
        this.control.valueProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> ov, Number oldValue, Number newValue) {
                LinearSkin.this.formerValue = oldValue.doubleValue();
                if (LinearSkin.this.toValueAnimation.getStatus() != Animation.Status.STOPPED) {
                    LinearSkin.this.toValueAnimation.stop();
                }
                if (newValue.doubleValue() > oldValue.doubleValue() - LinearSkin.this.control.getRedrawToleranceValue() && newValue.doubleValue() < oldValue.doubleValue() + LinearSkin.this.control.getRedrawToleranceValue()) {
                    return;
                }
                if (LinearSkin.this.control.isValueAnimationEnabled()) {
                    LinearSkin.this.toValueAnimation.setInterpolator(Interpolator.SPLINE((double)0.5, (double)0.4, (double)0.4, (double)1.0));
                    LinearSkin.this.toValueAnimation.play();
                } else {
                    LinearSkin.this.currentValue.set(newValue.doubleValue());
                    LinearSkin.this.updateBar();
                }
                LinearSkin.this.checkMarkers(LinearSkin.this.control, oldValue.doubleValue(), newValue.doubleValue());
            }
        });
        this.currentValue.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> ov, Number oldValue, Number newValue) {
                LinearSkin.this.currentLcdValue.set(LinearSkin.this.control.isLcdValueCoupled() ? LinearSkin.this.currentValue.get() : LinearSkin.this.control.getLcdValue());
                if (Double.compare(LinearSkin.this.currentValue.get(), LinearSkin.this.control.getMinMeasuredValue()) < 0) {
                    LinearSkin.this.control.setMinMeasuredValue(LinearSkin.this.currentValue.get());
                }
                if (Double.compare(LinearSkin.this.currentValue.get(), LinearSkin.this.control.getMaxMeasuredValue()) > 0) {
                    LinearSkin.this.control.setMaxMeasuredValue(LinearSkin.this.currentValue.get());
                }
                if (LinearSkin.this.control.isThresholdBehaviorInverted()) {
                    LinearSkin.this.control.setThresholdExceeded(LinearSkin.this.currentValue.get() < LinearSkin.this.control.getThreshold());
                } else {
                    LinearSkin.this.control.setThresholdExceeded(LinearSkin.this.currentValue.get() > LinearSkin.this.control.getThreshold());
                }
                if (!LinearSkin.this.control.isThresholdExceeded()) {
                    LinearSkin.this.ledOn.setOpacity(0.0);
                }
                if (LinearSkin.this.control.isLcdVisible()) {
                    LinearSkin.this.drawLcdContent();
                }
                if (!LinearSkin.this.control.getSections().isEmpty()) {
                    for (Section section : LinearSkin.this.control.getSections()) {
                        if (Double.compare(LinearSkin.this.currentValue.get(), section.getStart()) >= 0 && Double.compare(LinearSkin.this.currentValue.get(), section.getStop()) <= 0) {
                            LinearSkin.this.currentBar.setStyle("-fx-value: " + section.getCssColor());
                            break;
                        }
                        LinearSkin.this.currentBar.setStyle("-fx-value: " + ((LinearSkin)LinearSkin.this).control.getValueColor().CSS);
                    }
                    if (LinearSkin.this.control.getWidth() <= LinearSkin.this.control.getHeight()) {
                        LinearSkin.this.currentBar.getStyleClass().add((Object)"bar-vertical-solid");
                    } else {
                        LinearSkin.this.currentBar.getStyleClass().add((Object)"bar-horizontal-solid");
                    }
                }
                LinearSkin.this.updateBar();
            }
        });
    }

    protected void handleControlPropertyChanged(String PROPERTY) {
        super.handleControlPropertyChanged(PROPERTY);
        if ("FRAME_DESIGN".equals(PROPERTY)) {
            this.drawFrame();
        } else if ("BACKGROUND_DESIGN".equals(PROPERTY)) {
            this.drawBackground();
            this.drawTickmarks();
        } else if ("VALUE_COLOR".equals(PROPERTY)) {
            this.drawBar();
        } else if ("FOREGROUND_TYPE".equals(PROPERTY)) {
            this.drawForeground();
        } else if ("LCD_DESIGN".equals(PROPERTY)) {
            this.drawLcd();
            this.drawLcdContent();
        } else if ("LCD_NUMBER_SYSTEM".equals(PROPERTY)) {
            this.drawLcdContent();
        } else if ("USER_LED_BLINKING".equals(PROPERTY)) {
            if (this.userLedOff.isVisible() && this.userLedOn.isVisible()) {
                if (this.control.isUserLedBlinking()) {
                    this.userLedTimer.start();
                } else {
                    this.userLedTimer.stop();
                    this.userLedOn.setOpacity(0.0);
                }
            }
        } else if ("LED_BLINKING".equals(PROPERTY)) {
            if (this.ledOff.isVisible() && this.ledOn.isVisible()) {
                if (this.control.isLedBlinking()) {
                    this.ledTimer.start();
                } else {
                    this.ledTimer.stop();
                    this.ledOn.setOpacity(0.0);
                }
            }
        } else if ("GLOW_COLOR".equals(PROPERTY)) {
            this.glowColors.clear();
            Color GLOW_COLOR = this.control.getGlowColor();
            this.glowColors.add(Color.hsb((double)GLOW_COLOR.getHue(), (double)0.46, (double)0.96, (double)0.0));
            this.glowColors.add(Color.hsb((double)GLOW_COLOR.getHue(), (double)0.67, (double)0.9, (double)1.0));
            this.glowColors.add(Color.hsb((double)GLOW_COLOR.getHue(), (double)1.0, (double)1.0, (double)1.0));
            this.glowColors.add(Color.hsb((double)GLOW_COLOR.getHue(), (double)0.67, (double)0.9, (double)1.0));
            this.drawGlowOn();
        } else if ("GLOW_VISIBILITY".equals(PROPERTY)) {
            this.glowOff.setVisible(this.control.isGlowVisible());
            if (!this.control.isGlowVisible()) {
                this.glowOn.setOpacity(0.0);
            }
        } else if ("GLOW_ON".equals(PROPERTY)) {
            if (this.glowOff.isVisible() && this.control.isGlowOn()) {
                this.glowOn.setOpacity(1.0);
                this.glowOff.setVisible(true);
            } else {
                this.glowOff.setVisible(true);
                this.glowOn.setOpacity(0.0);
            }
        } else if ("PULSATING_GLOW".equals(PROPERTY)) {
            if (this.control.isPulsatingGlow() && this.control.isGlowVisible()) {
                if (!this.glowOn.isVisible()) {
                    this.glowOn.setVisible(true);
                }
                if (this.glowOn.getOpacity() < 1.0) {
                    this.glowOn.setOpacity(1.0);
                }
                this.glowPulse.play();
            } else {
                this.glowPulse.stop();
                this.glowOn.setOpacity(0.0);
            }
        } else if ("TICKMARKS".equals(PROPERTY)) {
            this.drawTickmarks();
        } else if ("MIN_MEASURED_VALUE".equals(PROPERTY)) {
            if (this.control.getPrefWidth() <= this.control.getPrefHeight()) {
                this.minMeasured.setTranslateY(-(this.control.getMinMeasuredValue() - this.control.getMinValue()) * this.stepsize);
            } else {
                this.minMeasured.setTranslateX(Math.abs((this.control.getMinMeasuredValue() - this.control.getMinValue()) * this.stepsize));
            }
        } else if ("MAX_MEASURED_VALUE".equals(PROPERTY)) {
            if (this.control.getPrefWidth() <= this.control.getPrefHeight()) {
                this.maxMeasured.setTranslateY(-(this.control.getMaxMeasuredValue() - this.control.getMinValue()) * this.stepsize);
            } else {
                this.maxMeasured.setTranslateX(Math.abs((this.control.getMaxMeasuredValue() - this.control.getMinValue()) * this.stepsize));
            }
        } else if ("SIMPLE_GRADIENT_BASE".equals(PROPERTY)) {
            this.isDirty = true;
        } else if ("GAUGE_MODEL".equals(PROPERTY)) {
            this.addBindings();
            this.repaint();
        } else if ("STYLE_MODEL".equals(PROPERTY)) {
            this.addBindings();
            this.repaint();
        } else if (!"AREAS".equals(PROPERTY) && !"SECTIONS".equals(PROPERTY)) {
            if ("MARKERS".equals(PROPERTY)) {
                this.drawIndicators();
            } else if ("PREF_WIDTH".equals(PROPERTY)) {
                this.repaint();
            } else if ("PREF_HEIGHT".equals(PROPERTY)) {
                this.repaint();
            }
        }
    }

    public void repaint() {
        this.isDirty = true;
        this.requestLayout();
    }

    @Override
    public void layoutChildren() {
        if (!this.isDirty) {
            return;
        }
        if (!this.initialized) {
            this.init();
        }
        if (this.control.getScene() != null) {
            this.calcGaugeBounds();
            this.setTranslateX(this.framelessOffset.getX());
            this.setTranslateY(this.framelessOffset.getY());
            this.drawFrame();
            this.drawBackground();
            this.drawTitleAndUnit();
            this.drawTickmarks();
            this.drawLed();
            this.drawUserLed();
            this.drawThreshold();
            this.drawGlowOff();
            this.drawGlowOn();
            this.drawMinMeasuredIndicator();
            this.drawMaxMeasuredIndicator();
            this.drawIndicators();
            this.drawLcd();
            this.drawLcdContent();
            this.drawBar();
            this.drawForeground();
            this.getChildren().setAll((Object[])new Node[]{this.frame, this.background, this.ledOff, this.ledOn, this.userLedOff, this.userLedOn, this.titleAndUnit, this.tickmarks, this.threshold, this.glowOff, this.glowOn, this.minMeasured, this.maxMeasured, this.markers, this.lcd, this.lcdContent, this.bar, this.foreground});
        }
        this.isDirty = false;
        super.layoutChildren();
    }

    public Linear getSkinnable() {
        return this.control;
    }

    public void dispose() {
        this.control = null;
    }

    @Override
    protected double computePrefWidth(double WIDTH) {
        double prefWidth = WIDTH < this.getPrefHeight() ? PREF_SIZE.getWidth() : PREF_SIZE.getHeight();
        if (WIDTH != -1.0) {
            prefWidth = Math.max(0.0, WIDTH - this.getInsets().getLeft() - this.getInsets().getRight());
        }
        return super.computePrefWidth(prefWidth);
    }

    @Override
    protected double computePrefHeight(double HEIGHT) {
        double prefHeight = HEIGHT < this.getPrefHeight() ? PREF_SIZE.getHeight() : PREF_SIZE.getWidth();
        if (HEIGHT != -1.0) {
            prefHeight = Math.max(0.0, HEIGHT - this.getInsets().getTop() - this.getInsets().getBottom());
        }
        return super.computePrefHeight(prefHeight);
    }

    @Override
    protected double computeMinWidth(double WIDTH) {
        double minWidth = this.getPrefWidth() < this.getPrefHeight() ? Math.max(MIN_SIZE.getWidth(), WIDTH) : Math.max(MIN_SIZE.getHeight(), WIDTH);
        return super.computeMinWidth(minWidth);
    }

    @Override
    protected double computeMinHeight(double HEIGHT) {
        double minHeight = this.getPrefWidth() < this.getPrefHeight() ? Math.max(MIN_SIZE.getHeight(), HEIGHT) : Math.max(MIN_SIZE.getWidth(), HEIGHT);
        return super.computeMinHeight(minHeight);
    }

    @Override
    protected double computeMaxWidth(double WIDTH) {
        double maxWidth = this.getPrefWidth() < this.getPrefHeight() ? Math.max(MAX_SIZE.getWidth(), WIDTH) : Math.max(MAX_SIZE.getHeight(), WIDTH);
        return super.computeMaxWidth(maxWidth);
    }

    @Override
    protected double computeMaxHeight(double HEIGHT) {
        double maxHeight = this.getPrefWidth() < this.getPrefHeight() ? Math.max(MAX_SIZE.getHeight(), HEIGHT) : Math.max(MAX_SIZE.getWidth(), HEIGHT);
        return super.computeMaxHeight(maxHeight);
    }

    private String formatLcdValue(double VALUE) {
        StringBuilder DEC_BUFFER = new StringBuilder(16);
        DEC_BUFFER.append("0");
        int lcdDecimals = this.control.getLcdDecimals();
        boolean lcdScientificFormatEnabled = false;
        if (lcdDecimals > 0) {
            DEC_BUFFER.append(".");
        }
        for (int i = 0; i < lcdDecimals; ++i) {
            DEC_BUFFER.append("0");
        }
        DEC_BUFFER.trimToSize();
        DecimalFormat DEC_FORMAT = new DecimalFormat(DEC_BUFFER.toString(), new DecimalFormatSymbols(Locale.US));
        return DEC_FORMAT.format(VALUE);
    }

    private void calcGaugeBounds() {
        if (this.control.isFrameVisible()) {
            this.gaugeBounds.setWidth(this.control.getPrefWidth());
            this.gaugeBounds.setHeight(this.control.getPrefHeight());
            this.framelessOffset = new Point2D(0.0, 0.0);
        } else {
            double SIZE = this.control.getPrefWidth() < this.control.getPrefHeight() ? this.control.getPrefWidth() : this.control.getPrefHeight();
            this.gaugeBounds.setWidth(this.control.getPrefWidth() + SIZE * 0.168224299 + 2.0);
            this.gaugeBounds.setHeight(this.control.getPrefHeight() + SIZE * 0.168224299 + 2.0);
            this.framelessOffset = new Point2D(-SIZE * 0.0841121495 - 1.0, -SIZE * 0.0841121495 - 1.0);
        }
    }

    public void drawFrame() {
        double SIZE = this.gaugeBounds.getWidth() <= this.gaugeBounds.getHeight() ? this.gaugeBounds.getWidth() : this.gaugeBounds.getHeight();
        double WIDTH = this.gaugeBounds.getWidth();
        double HEIGHT = this.gaugeBounds.getHeight();
        this.frame.getChildren().clear();
        Rectangle SUBTRACT = new Rectangle(0.0841121495 * SIZE + 1.0, 0.0841121495 * SIZE + 1.0, WIDTH - 0.168224299 * SIZE - 2.0, HEIGHT - 0.168224299 * SIZE - 2.0);
        SUBTRACT.setArcWidth(0.05 * SIZE);
        SUBTRACT.setArcHeight(0.05 * SIZE);
        Rectangle OUTER_FRAME = new Rectangle(0.0, 0.0, WIDTH, HEIGHT);
        OUTER_FRAME.setArcWidth(0.09333333333333334 * SIZE);
        OUTER_FRAME.setArcHeight(0.09333333333333334 * SIZE);
        OUTER_FRAME.setFill((Paint)Color.color((double)0.5176470588, (double)0.5176470588, (double)0.5176470588, (double)1.0));
        OUTER_FRAME.setStroke(null);
        this.frame.getChildren().add((Object)OUTER_FRAME);
        Rectangle MAIN_FRAME = new Rectangle(1.0, 1.0, WIDTH - 2.0, HEIGHT - 2.0);
        MAIN_FRAME.setArcWidth(0.08 * SIZE);
        MAIN_FRAME.setArcHeight(0.08 * SIZE);
        MAIN_FRAME.setStroke(null);
        Rectangle INNER_FRAME = new Rectangle(0.0841121495 * SIZE, 0.0841121495 * SIZE, WIDTH - 0.168224299 * SIZE, HEIGHT - 0.168224299 * SIZE);
        INNER_FRAME.setArcWidth(0.05 * SIZE);
        INNER_FRAME.setArcHeight(0.05 * SIZE);
        INNER_FRAME.setFill((Paint)Color.color((double)0.6, (double)0.6, (double)0.6, (double)0.8));
        INNER_FRAME.setStroke(null);
        switch (this.control.getFrameDesign()) {
            case BLACK_METAL: {
                ConicalGradient bmGradient = new ConicalGradient(new Point2D(MAIN_FRAME.getLayoutBounds().getWidth() / 2.0, MAIN_FRAME.getLayoutBounds().getHeight() / 2.0), new Stop(0.0, Color.rgb((int)254, (int)254, (int)254)), new Stop(0.125, Color.rgb((int)0, (int)0, (int)0)), new Stop(0.3472, Color.rgb((int)153, (int)153, (int)153)), new Stop(0.5, Color.rgb((int)0, (int)0, (int)0)), new Stop(0.6805, Color.rgb((int)153, (int)153, (int)153)), new Stop(0.875, Color.rgb((int)0, (int)0, (int)0)), new Stop(1.0, Color.rgb((int)254, (int)254, (int)254)));
                MAIN_FRAME.setFill((Paint)bmGradient.apply((Shape)MAIN_FRAME));
                MAIN_FRAME.setStroke(null);
                this.frame.getChildren().addAll((Object[])new Node[]{MAIN_FRAME, INNER_FRAME});
                break;
            }
            case SHINY_METAL: {
                ConicalGradient smGradient = new ConicalGradient(new Point2D(MAIN_FRAME.getLayoutBounds().getWidth() / 2.0, MAIN_FRAME.getLayoutBounds().getHeight() / 2.0), new Stop(0.0, Color.rgb((int)254, (int)254, (int)254)), new Stop(0.125, Util.darker(this.control.getFrameBaseColor(), 0.15)), new Stop(0.25, this.control.getFrameBaseColor().darker()), new Stop(0.3472, this.control.getFrameBaseColor().brighter()), new Stop(0.5, this.control.getFrameBaseColor().darker().darker()), new Stop(0.6527, this.control.getFrameBaseColor().brighter()), new Stop(0.75, this.control.getFrameBaseColor().darker()), new Stop(0.875, Util.darker(this.control.getFrameBaseColor(), 0.15)), new Stop(1.0, Color.rgb((int)254, (int)254, (int)254)));
                MAIN_FRAME.setFill((Paint)smGradient.apply((Shape)MAIN_FRAME));
                MAIN_FRAME.setStroke(null);
                this.frame.getChildren().addAll((Object[])new Node[]{MAIN_FRAME, INNER_FRAME});
                break;
            }
            case CHROME: {
                ConicalGradient cmGradient = new ConicalGradient(new Point2D(MAIN_FRAME.getLayoutBounds().getWidth() / 2.0, MAIN_FRAME.getLayoutBounds().getHeight() / 2.0), new Stop(0.0, Color.WHITE), new Stop(0.09, Color.WHITE), new Stop(0.12, Color.rgb((int)136, (int)136, (int)138)), new Stop(0.16, Color.rgb((int)164, (int)185, (int)190)), new Stop(0.25, Color.rgb((int)158, (int)179, (int)182)), new Stop(0.29, Color.rgb((int)112, (int)112, (int)112)), new Stop(0.33, Color.rgb((int)221, (int)227, (int)227)), new Stop(0.38, Color.rgb((int)155, (int)176, (int)179)), new Stop(0.48, Color.rgb((int)156, (int)176, (int)177)), new Stop(0.52, Color.rgb((int)254, (int)255, (int)255)), new Stop(0.63, Color.WHITE), new Stop(0.68, Color.rgb((int)156, (int)180, (int)180)), new Stop(0.8, Color.rgb((int)198, (int)209, (int)211)), new Stop(0.83, Color.rgb((int)246, (int)248, (int)247)), new Stop(0.87, Color.rgb((int)204, (int)216, (int)216)), new Stop(0.97, Color.rgb((int)164, (int)188, (int)190)), new Stop(1.0, Color.WHITE));
                MAIN_FRAME.setFill((Paint)cmGradient.apply((Shape)MAIN_FRAME));
                MAIN_FRAME.setStroke(null);
                this.frame.getChildren().addAll((Object[])new Node[]{MAIN_FRAME, INNER_FRAME});
                break;
            }
            case GLOSSY_METAL: {
                MAIN_FRAME.setFill((Paint)new LinearGradient(0.4714285714285714 * WIDTH, 0.014285714285714285 * HEIGHT, 0.47142857142857153 * WIDTH, 0.9785714285714285 * HEIGHT, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)0.9764705882, (double)0.9764705882, (double)0.9764705882, (double)1.0)), new Stop(0.1, Color.color((double)0.7843137255, (double)0.7647058824, (double)0.7490196078, (double)1.0)), new Stop(0.26, Color.WHITE), new Stop(0.73, Color.color((double)0.1137254902, (double)0.1137254902, (double)0.1137254902, (double)1.0)), new Stop(1.0, Color.color((double)0.8196078431, (double)0.8196078431, (double)0.8196078431, (double)1.0))}));
                Rectangle GLOSSY2 = new Rectangle(0.08571428571428572 * WIDTH, 0.08571428571428572 * HEIGHT, 0.8285714285714286 * WIDTH, 0.8285714285714286 * HEIGHT);
                GLOSSY2.setArcWidth(0.05714285714285714 * SIZE);
                GLOSSY2.setArcHeight(0.05714285714285714 * SIZE);
                GLOSSY2.setFill((Paint)new LinearGradient(0.0, GLOSSY2.getLayoutBounds().getMinY(), 0.0, GLOSSY2.getLayoutBounds().getMaxY(), false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)0.9764705882, (double)0.9764705882, (double)0.9764705882, (double)1.0)), new Stop(0.23, Color.color((double)0.7843137255, (double)0.7647058824, (double)0.7490196078, (double)1.0)), new Stop(0.36, Color.color((double)1.0, (double)1.0, (double)1.0, (double)1.0)), new Stop(0.59, Color.color((double)0.1137254902, (double)0.1137254902, (double)0.1137254902, (double)1.0)), new Stop(0.76, Color.color((double)0.7843137255, (double)0.7607843137, (double)0.7529411765, (double)1.0)), new Stop(1.0, Color.color((double)0.8196078431, (double)0.8196078431, (double)0.8196078431, (double)1.0))}));
                Rectangle GLOSSY3 = new Rectangle(INNER_FRAME.getX() - 2.0, INNER_FRAME.getY() - 2.0, INNER_FRAME.getWidth() + 4.0, INNER_FRAME.getHeight() + 4.0);
                GLOSSY3.setArcWidth(INNER_FRAME.getArcWidth() + 1.0);
                GLOSSY3.setArcHeight(INNER_FRAME.getArcHeight() + 1.0);
                GLOSSY3.setFill((Paint)Color.web((String)"#F6F6F6"));
                Rectangle GLOSSY4 = new Rectangle(GLOSSY3.getX() + 2.0, GLOSSY3.getY() + 2.0, GLOSSY3.getWidth() - 4.0, GLOSSY3.getHeight() - 4.0);
                GLOSSY4.setArcWidth(GLOSSY3.getArcWidth() - 1.0);
                GLOSSY4.setArcHeight(GLOSSY3.getArcHeight() - 1.0);
                GLOSSY4.setFill((Paint)Color.web((String)"#333333"));
                this.frame.getChildren().addAll((Object[])new Node[]{MAIN_FRAME, GLOSSY2, GLOSSY3, GLOSSY4});
                break;
            }
            case DARK_GLOSSY: {
                MAIN_FRAME.setFill((Paint)new LinearGradient(0.8551401869158879 * WIDTH, 0.14953271028037382 * HEIGHT, 0.15794611761513314 * WIDTH, 0.8467267795811287 * HEIGHT, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)0.3254901961, (double)0.3254901961, (double)0.3254901961, (double)1.0)), new Stop(0.08, Color.color((double)0.9960784314, (double)0.9960784314, (double)1.0, (double)1.0)), new Stop(0.52, Color.color((double)0.0, (double)0.0, (double)0.0, (double)1.0)), new Stop(0.55, Color.color((double)0.0196078431, (double)0.0235294118, (double)0.0196078431, (double)1.0)), new Stop(0.84, Color.color((double)0.9725490196, (double)0.9803921569, (double)0.9764705882, (double)1.0)), new Stop(0.99, Color.color((double)0.3254901961, (double)0.3254901961, (double)0.3254901961, (double)1.0)), new Stop(1.0, Color.color((double)0.3254901961, (double)0.3254901961, (double)0.3254901961, (double)1.0))}));
                Rectangle DARK_GLOSSY2 = new Rectangle(0.08571428571428572 * WIDTH, 0.08571428571428572 * HEIGHT, 0.8285714285714286 * WIDTH, 0.8285714285714286 * HEIGHT);
                DARK_GLOSSY2.setArcWidth(0.05714285714285714 * SIZE);
                DARK_GLOSSY2.setArcHeight(0.05714285714285714 * SIZE);
                DARK_GLOSSY2.setFill((Paint)new LinearGradient(0.5 * WIDTH, 0.014018691588785047 * HEIGHT, 0.5 * WIDTH, 0.985981308411215 * HEIGHT, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)0.2588235294, (double)0.2588235294, (double)0.2588235294, (double)1.0)), new Stop(0.42, Color.color((double)0.2588235294, (double)0.2588235294, (double)0.2588235294, (double)1.0)), new Stop(1.0, Color.color((double)0.0509803922, (double)0.0509803922, (double)0.0509803922, (double)1.0))}));
                DARK_GLOSSY2.setStroke(null);
                Rectangle DARK_GLOSSY3 = new Rectangle(MAIN_FRAME.getX(), MAIN_FRAME.getY(), MAIN_FRAME.getWidth(), MAIN_FRAME.getHeight() * 0.5);
                DARK_GLOSSY3.setArcWidth(MAIN_FRAME.getArcWidth());
                DARK_GLOSSY3.setArcHeight(MAIN_FRAME.getArcHeight());
                DARK_GLOSSY3.setFill((Paint)new LinearGradient(0.5 * WIDTH, 0.014018691588785047 * HEIGHT, 0.5 * WIDTH, 0.5280373831775701 * HEIGHT, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)1.0, (double)1.0, (double)1.0, (double)1.0)), new Stop(0.26, Color.color((double)1.0, (double)1.0, (double)1.0, (double)1.0)), new Stop(0.26009998, Color.color((double)1.0, (double)1.0, (double)1.0, (double)1.0)), new Stop(1.0, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0))}));
                DARK_GLOSSY3.setStroke(null);
                Rectangle DARK_GLOSSY4 = new Rectangle(INNER_FRAME.getX() - 2.0, INNER_FRAME.getY() - 2.0, INNER_FRAME.getWidth() + 4.0, INNER_FRAME.getHeight() + 4.0);
                DARK_GLOSSY4.setArcWidth(INNER_FRAME.getArcWidth() + 1.0);
                DARK_GLOSSY4.setArcHeight(INNER_FRAME.getArcHeight() + 1.0);
                DARK_GLOSSY4.setFill((Paint)new LinearGradient(0.8037383177570093 * WIDTH, 0.1822429906542056 * HEIGHT, 0.18584594354259637 * WIDTH, 0.8001353648686187 * HEIGHT, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)0.6745098039, (double)0.6745098039, (double)0.6784313725, (double)1.0)), new Stop(0.08, Color.color((double)0.9960784314, (double)0.9960784314, (double)1.0, (double)1.0)), new Stop(0.52, Color.color((double)0.0, (double)0.0, (double)0.0, (double)1.0)), new Stop(0.55, Color.color((double)0.0196078431, (double)0.0235294118, (double)0.0196078431, (double)1.0)), new Stop(0.91, Color.color((double)0.9725490196, (double)0.9803921569, (double)0.9764705882, (double)1.0)), new Stop(0.99, Color.color((double)0.6980392157, (double)0.6980392157, (double)0.6980392157, (double)1.0)), new Stop(1.0, Color.color((double)0.6980392157, (double)0.6980392157, (double)0.6980392157, (double)1.0))}));
                DARK_GLOSSY4.setStroke(null);
                this.frame.getChildren().addAll((Object[])new Node[]{MAIN_FRAME, DARK_GLOSSY2, DARK_GLOSSY3, DARK_GLOSSY4});
                break;
            }
            default: {
                ImageView IMAGE_VIEW = new ImageView();
                IMAGE_VIEW.setVisible(false);
                MAIN_FRAME.getStyleClass().add((Object)this.control.getFrameDesign().CSS);
                MAIN_FRAME.setStroke(null);
                this.frame.getChildren().addAll((Object[])new Node[]{MAIN_FRAME, INNER_FRAME});
            }
        }
        this.frame.setCache(true);
    }

    public void drawBackground() {
        LinearGradient BACKGROUND_1_VALUE_RIGHT_BORDER_3_4_FILL;
        Rectangle BAR_RIGHT_BORDER;
        LinearGradient BACKGROUND_1_VALUE_LEFT_BORDER_2_3_FILL;
        Rectangle BAR_LEFT_BORDER;
        LinearGradient BACKGROUND_1_VALUE_BACKGROUND_1_2_FILL;
        Rectangle BAR_BACKGROUND;
        double SIZE = this.gaugeBounds.getWidth() <= this.gaugeBounds.getHeight() ? this.gaugeBounds.getWidth() : this.gaugeBounds.getHeight();
        double WIDTH = this.gaugeBounds.getWidth();
        double HEIGHT = this.gaugeBounds.getHeight();
        this.background.getChildren().clear();
        Rectangle IBOUNDS = new Rectangle(0.0, 0.0, WIDTH, HEIGHT);
        IBOUNDS.setOpacity(0.0);
        IBOUNDS.setStroke(null);
        this.background.getChildren().add((Object)IBOUNDS);
        InnerShadow INNER_SHADOW = new InnerShadow();
        INNER_SHADOW.setWidth(0.2 * SIZE);
        INNER_SHADOW.setHeight(0.2 * SIZE);
        INNER_SHADOW.setOffsetY(0.03 * SIZE);
        INNER_SHADOW.setColor(Color.color((double)0.0, (double)0.0, (double)0.0, (double)0.7));
        INNER_SHADOW.setBlurType(BlurType.GAUSSIAN);
        LinearGradient HL_GRADIENT = new LinearGradient(0.0, 0.0, WIDTH, 0.0, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)0.0, (double)0.0, (double)0.0, (double)0.6)), new Stop(0.4, Color.color((double)0.0, (double)0.0, (double)0.0, (double)0.0)), new Stop(0.6, Color.color((double)0.0, (double)0.0, (double)0.0, (double)0.0)), new Stop(1.0, Color.color((double)0.0, (double)0.0, (double)0.0, (double)0.6))});
        Rectangle BACKGROUND = new Rectangle(0.0841121495 * SIZE + 1.0, 0.0841121495 * SIZE + 1.0, WIDTH - 0.168224299 * SIZE - 2.0, HEIGHT - 0.168224299 * SIZE - 2.0);
        BACKGROUND.setArcWidth(0.05 * SIZE);
        BACKGROUND.setArcHeight(0.05 * SIZE);
        BACKGROUND.setStroke(null);
        Rectangle CLIP_SHAPE = new Rectangle(0.0841121495 * SIZE + 1.0, 0.0841121495 * SIZE + 1.0, WIDTH - 0.168224299 * SIZE - 2.0, HEIGHT - 0.168224299 * SIZE - 2.0);
        CLIP_SHAPE.setArcWidth(0.05 * SIZE);
        CLIP_SHAPE.setArcHeight(0.05 * SIZE);
        switch (this.control.getBackgroundDesign()) {
            case STAINLESS: {
                Color c1 = Color.hsb((double)this.control.getTextureColor().getHue(), (double)this.control.getTextureColor().getSaturation(), (double)Color.web((String)"#FDFDFD").getBrightness());
                Color c2 = Color.hsb((double)this.control.getTextureColor().getHue(), (double)this.control.getTextureColor().getSaturation(), (double)Color.web((String)"#E2E2E2").getBrightness());
                Color c3 = Color.hsb((double)this.control.getTextureColor().getHue(), (double)this.control.getTextureColor().getSaturation(), (double)Color.web((String)"#B2B2B4").getBrightness());
                Color c4 = Color.hsb((double)this.control.getTextureColor().getHue(), (double)this.control.getTextureColor().getSaturation(), (double)Color.web((String)"#ACACAE").getBrightness());
                Color c5 = Color.hsb((double)this.control.getTextureColor().getHue(), (double)this.control.getTextureColor().getSaturation(), (double)Color.web((String)"#FDFDFD").getBrightness());
                Color c6 = Color.hsb((double)this.control.getTextureColor().getHue(), (double)this.control.getTextureColor().getSaturation(), (double)Color.web((String)"#6E6E70").getBrightness());
                Color c7 = Color.hsb((double)this.control.getTextureColor().getHue(), (double)this.control.getTextureColor().getSaturation(), (double)Color.web((String)"#6E6E70").getBrightness());
                Color c8 = Color.hsb((double)this.control.getTextureColor().getHue(), (double)this.control.getTextureColor().getSaturation(), (double)Color.web((String)"#FDFDFD").getBrightness());
                Color c9 = Color.hsb((double)this.control.getTextureColor().getHue(), (double)this.control.getTextureColor().getSaturation(), (double)Color.web((String)"#6E6E70").getBrightness());
                Color c10 = Color.hsb((double)this.control.getTextureColor().getHue(), (double)this.control.getTextureColor().getSaturation(), (double)Color.web((String)"#6E6E70").getBrightness());
                Color c11 = Color.hsb((double)this.control.getTextureColor().getHue(), (double)this.control.getTextureColor().getSaturation(), (double)Color.web((String)"#FDFDFD").getBrightness());
                Color c12 = Color.hsb((double)this.control.getTextureColor().getHue(), (double)this.control.getTextureColor().getSaturation(), (double)Color.web((String)"#ACACAE").getBrightness());
                Color c13 = Color.hsb((double)this.control.getTextureColor().getHue(), (double)this.control.getTextureColor().getSaturation(), (double)Color.web((String)"#B2B2B4").getBrightness());
                Color c14 = Color.hsb((double)this.control.getTextureColor().getHue(), (double)this.control.getTextureColor().getSaturation(), (double)Color.web((String)"#E2E2E2").getBrightness());
                Color c15 = Color.hsb((double)this.control.getTextureColor().getHue(), (double)this.control.getTextureColor().getSaturation(), (double)Color.web((String)"#FDFDFD").getBrightness());
                ConicalGradient gradient = new ConicalGradient(new Point2D(SIZE / 2.0, SIZE / 2.0), new Stop(0.0, c1), new Stop(0.03, c2), new Stop(0.1, c3), new Stop(0.14, c4), new Stop(0.24, c5), new Stop(0.33, c6), new Stop(0.38, c7), new Stop(0.5, c8), new Stop(0.62, c9), new Stop(0.67, c10), new Stop(0.76, c11), new Stop(0.81, c12), new Stop(0.85, c13), new Stop(0.97, c14), new Stop(1.0, c15));
                BACKGROUND.setFill((Paint)gradient.apply((Shape)BACKGROUND));
                BACKGROUND.setEffect((Effect)INNER_SHADOW);
                this.background.getChildren().addAll((Object[])new Node[]{BACKGROUND});
                break;
            }
            case CARBON: {
                BACKGROUND.setFill((Paint)Util.createCarbonPattern());
                BACKGROUND.setStroke(null);
                Rectangle SHADOW_OVERLAY1 = new Rectangle(0.0841121495 * SIZE + 1.0, 0.0841121495 * SIZE + 1.0, WIDTH - 0.168224299 * SIZE - 2.0, HEIGHT - 0.168224299 * SIZE - 2.0);
                SHADOW_OVERLAY1.setArcWidth(0.05 * SIZE);
                SHADOW_OVERLAY1.setArcHeight(0.05 * SIZE);
                SHADOW_OVERLAY1.setStroke(null);
                SHADOW_OVERLAY1.setFill((Paint)new LinearGradient(SHADOW_OVERLAY1.getLayoutBounds().getMinX(), 0.0, SHADOW_OVERLAY1.getLayoutBounds().getMaxX(), 0.0, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)0.0, (double)0.0, (double)0.0, (double)0.5)), new Stop(0.4, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0)), new Stop(0.6, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0)), new Stop(1.0, Color.color((double)0.0, (double)0.0, (double)0.0, (double)0.5))}));
                SHADOW_OVERLAY1.setStroke(null);
                this.background.getChildren().addAll((Object[])new Node[]{BACKGROUND, SHADOW_OVERLAY1});
                break;
            }
            case PUNCHED_SHEET: {
                BACKGROUND.setFill((Paint)Util.createPunchedSheetPattern(this.control.getTextureColor()));
                BACKGROUND.setStroke(null);
                Rectangle SHADOW_OVERLAY2 = new Rectangle(0.0841121495 * SIZE + 1.0, 0.0841121495 * SIZE + 1.0, WIDTH - 0.168224299 * SIZE - 2.0, HEIGHT - 0.168224299 * SIZE - 2.0);
                SHADOW_OVERLAY2.setArcWidth(0.05 * SIZE);
                SHADOW_OVERLAY2.setArcHeight(0.05 * SIZE);
                SHADOW_OVERLAY2.setFill((Paint)new LinearGradient(SHADOW_OVERLAY2.getLayoutBounds().getMinX(), 0.0, SHADOW_OVERLAY2.getLayoutBounds().getMaxX(), 0.0, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)0.0, (double)0.0, (double)0.0, (double)0.5)), new Stop(0.4, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0)), new Stop(0.6, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0)), new Stop(1.0, Color.color((double)0.0, (double)0.0, (double)0.0, (double)0.5))}));
                SHADOW_OVERLAY2.setStroke(null);
                this.background.getChildren().addAll((Object[])new Node[]{BACKGROUND, SHADOW_OVERLAY2});
                break;
            }
            case NOISY_PLASTIC: {
                Rectangle BACKGROUND_PLAIN = new Rectangle(0.0841121495 * SIZE + 1.0, 0.0841121495 * SIZE + 1.0, WIDTH - 0.168224299 * SIZE - 2.0, HEIGHT - 0.168224299 * SIZE - 2.0);
                BACKGROUND_PLAIN.setArcWidth(0.05 * SIZE);
                BACKGROUND_PLAIN.setArcHeight(0.05 * SIZE);
                BACKGROUND_PLAIN.setFill((Paint)new LinearGradient(0.0, BACKGROUND_PLAIN.getLayoutY(), 0.0, BACKGROUND_PLAIN.getLayoutBounds().getHeight(), false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Util.brighter(this.control.getTextureColor(), 0.15)), new Stop(1.0, Util.darker(this.control.getTextureColor(), 0.15))}));
                BACKGROUND_PLAIN.setStroke(null);
                BACKGROUND_PLAIN.setEffect((Effect)INNER_SHADOW);
                BACKGROUND.setFill(Util.applyNoisyBackground((Shape)BACKGROUND, this.control.getTextureColor()));
                this.background.getChildren().addAll((Object[])new Node[]{BACKGROUND_PLAIN, BACKGROUND});
                break;
            }
            case BRUSHED_METAL: {
                BACKGROUND.setFill(Util.applyBrushedMetalBackground((Shape)BACKGROUND, this.control.getTextureColor()));
                BACKGROUND.setEffect((Effect)INNER_SHADOW);
                this.background.getChildren().addAll((Object[])new Node[]{BACKGROUND});
                break;
            }
            default: {
                BACKGROUND.setStyle(this.control.getSimpleGradientBaseColorString());
                BACKGROUND.getStyleClass().add((Object)this.control.getBackgroundDesign().CSS_BACKGROUND);
                BACKGROUND.setEffect((Effect)INNER_SHADOW);
                this.background.getChildren().addAll((Object[])new Node[]{BACKGROUND});
            }
        }
        if (WIDTH <= HEIGHT) {
            BAR_BACKGROUND = new Rectangle(0.42 * WIDTH + 2.0, 0.1657142857142857 * HEIGHT, 0.16 * WIDTH - 3.0, 0.6714285714 * HEIGHT);
            BACKGROUND_1_VALUE_BACKGROUND_1_2_FILL = new LinearGradient(0.5 * WIDTH, 0.1657142857142857 * HEIGHT, 0.5 * WIDTH, 0.8371428571428572 * HEIGHT, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0470588235)), new Stop(0.5, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.1490196078)), new Stop(1.0, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0470588235))});
            BAR_BACKGROUND.setFill((Paint)BACKGROUND_1_VALUE_BACKGROUND_1_2_FILL);
            BAR_BACKGROUND.setStroke(null);
            BAR_LEFT_BORDER = new Rectangle(0.42 * WIDTH, 0.1657142857142857 * HEIGHT, 1.0, 0.6714285714 * HEIGHT);
            BACKGROUND_1_VALUE_LEFT_BORDER_2_3_FILL = new LinearGradient(BAR_LEFT_BORDER.getLayoutBounds().getMinX(), BAR_LEFT_BORDER.getLayoutBounds().getMinY(), BAR_LEFT_BORDER.getLayoutBounds().getMinX(), BAR_LEFT_BORDER.getLayoutBounds().getMaxY(), false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.2901960784)), new Stop(0.5, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.3450980392)), new Stop(1.0, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.4))});
            BAR_LEFT_BORDER.setFill((Paint)BACKGROUND_1_VALUE_LEFT_BORDER_2_3_FILL);
            BAR_LEFT_BORDER.setStroke(null);
            BAR_RIGHT_BORDER = new Rectangle(0.58 * WIDTH, 0.1657142857142857 * HEIGHT, 1.0, 0.6714285714 * HEIGHT);
            BACKGROUND_1_VALUE_RIGHT_BORDER_3_4_FILL = new LinearGradient(BAR_RIGHT_BORDER.getLayoutBounds().getMinX(), BAR_RIGHT_BORDER.getLayoutBounds().getMinY(), BAR_RIGHT_BORDER.getLayoutBounds().getMinX(), BAR_RIGHT_BORDER.getLayoutBounds().getMaxY(), false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.2901960784)), new Stop(0.5, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.3450980392)), new Stop(1.0, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.4))});
            BAR_RIGHT_BORDER.setFill((Paint)BACKGROUND_1_VALUE_RIGHT_BORDER_3_4_FILL);
            BAR_RIGHT_BORDER.setStroke(null);
            this.background.getChildren().addAll((Object[])new Node[]{BAR_BACKGROUND, BAR_LEFT_BORDER, BAR_RIGHT_BORDER});
        } else {
            BAR_BACKGROUND = new Rectangle(0.1657142857142857 * WIDTH, 0.42 * HEIGHT + 2.0, 0.6714285714 * WIDTH, 0.16 * HEIGHT - 3.0);
            BACKGROUND_1_VALUE_BACKGROUND_1_2_FILL = new LinearGradient(0.1657142857142857 * WIDTH, 0.5 * HEIGHT, 0.8371428571428572 * WIDTH, 0.5 * HEIGHT, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0470588235)), new Stop(0.5, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.1490196078)), new Stop(1.0, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0470588235))});
            BAR_BACKGROUND.setFill((Paint)BACKGROUND_1_VALUE_BACKGROUND_1_2_FILL);
            BAR_BACKGROUND.setStroke(null);
            BAR_LEFT_BORDER = new Rectangle(0.1657142857142857 * WIDTH, 0.42 * HEIGHT, 0.6714285714 * WIDTH, 1.0);
            BACKGROUND_1_VALUE_LEFT_BORDER_2_3_FILL = new LinearGradient(BAR_LEFT_BORDER.getLayoutBounds().getMinX(), BAR_LEFT_BORDER.getLayoutBounds().getMinY(), BAR_LEFT_BORDER.getLayoutBounds().getMaxX(), BAR_LEFT_BORDER.getLayoutBounds().getMinY(), false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.2901960784)), new Stop(0.5, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.3450980392)), new Stop(1.0, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.4))});
            BAR_LEFT_BORDER.setFill((Paint)BACKGROUND_1_VALUE_LEFT_BORDER_2_3_FILL);
            BAR_LEFT_BORDER.setStroke(null);
            BAR_RIGHT_BORDER = new Rectangle(0.1657142857142857 * WIDTH, 0.58 * HEIGHT, 0.6714285714 * WIDTH, 1.0);
            BACKGROUND_1_VALUE_RIGHT_BORDER_3_4_FILL = new LinearGradient(BAR_RIGHT_BORDER.getLayoutBounds().getMinX(), BAR_RIGHT_BORDER.getLayoutBounds().getMinY(), BAR_RIGHT_BORDER.getLayoutBounds().getMaxX(), BAR_RIGHT_BORDER.getLayoutBounds().getMinY(), false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.2901960784)), new Stop(0.5, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.3450980392)), new Stop(1.0, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.4))});
            BAR_RIGHT_BORDER.setFill((Paint)BACKGROUND_1_VALUE_RIGHT_BORDER_3_4_FILL);
            BAR_RIGHT_BORDER.setStroke(null);
            this.background.getChildren().addAll((Object[])new Node[]{BAR_BACKGROUND, BAR_LEFT_BORDER, BAR_RIGHT_BORDER});
        }
        this.background.setCache(true);
    }

    public void drawTitleAndUnit() {
        double SIZE = this.gaugeBounds.getWidth() <= this.gaugeBounds.getHeight() ? this.gaugeBounds.getWidth() : this.gaugeBounds.getHeight();
        double WIDTH = this.gaugeBounds.getWidth();
        double HEIGHT = this.gaugeBounds.getHeight();
        this.titleAndUnit.getChildren().clear();
        Rectangle IBOUNDS = new Rectangle(0.0, 0.0, WIDTH, HEIGHT);
        IBOUNDS.setOpacity(0.0);
        IBOUNDS.setStroke(null);
        Font TITLE_FONT = Font.font((String)this.control.getTitleFont(), (FontWeight)FontWeight.NORMAL, (double)(0.08 * SIZE));
        Text title = new Text();
        title.setTextOrigin(VPos.BOTTOM);
        title.setFont(TITLE_FONT);
        title.setText(this.control.getTitle());
        if (WIDTH <= HEIGHT) {
            title.setX((WIDTH - title.getLayoutBounds().getWidth()) / 2.0);
            title.setY(0.0657142857 * HEIGHT + title.getLayoutBounds().getHeight());
        } else {
            title.setX(0.0628571429 * WIDTH);
            title.setY(0.1533333333 * HEIGHT + title.getLayoutBounds().getHeight());
        }
        title.getStyleClass().add((Object)this.control.getBackgroundDesign().CSS_TEXT);
        Font UNIT_FONT = Font.font((String)this.control.getUnitFont(), (FontWeight)FontWeight.NORMAL, (double)(0.0666666667 * SIZE));
        Text unit = new Text();
        unit.setTextOrigin(VPos.BOTTOM);
        unit.setFont(UNIT_FONT);
        unit.setText(this.control.getUnit());
        if (WIDTH <= HEIGHT) {
            unit.setX((WIDTH - unit.getLayoutBounds().getWidth()) / 2.0);
            unit.setY(0.1085714286 * HEIGHT + unit.getLayoutBounds().getHeight());
        } else {
            unit.setX(0.0628571429 * WIDTH);
            unit.setY(0.2666666667 * HEIGHT + unit.getLayoutBounds().getHeight());
        }
        unit.getStyleClass().add((Object)this.control.getBackgroundDesign().CSS_TEXT);
        this.titleAndUnit.getChildren().addAll((Object[])new Node[]{IBOUNDS, title, unit});
        this.titleAndUnit.setCache(true);
    }

    public void drawGlowOff() {
        double SIZE = this.gaugeBounds.getWidth() <= this.gaugeBounds.getHeight() ? this.gaugeBounds.getWidth() : this.gaugeBounds.getHeight();
        double WIDTH = this.gaugeBounds.getWidth();
        double HEIGHT = this.gaugeBounds.getHeight();
        this.glowOff.getChildren().clear();
        Rectangle BACKGROUND = new Rectangle(0.0841121495 * SIZE + 1.0, 0.0841121495 * SIZE + 1.0, WIDTH - 0.168224299 * SIZE - 2.0, HEIGHT - 0.168224299 * SIZE - 2.0);
        BACKGROUND.setArcWidth(0.05 * SIZE);
        BACKGROUND.setArcHeight(0.05 * SIZE);
        BACKGROUND.setStroke(null);
        Rectangle SUBTRACT = new Rectangle(0.11 * SIZE + 1.0, 0.11 * SIZE + 1.0, WIDTH - 0.22 * SIZE - 2.0, HEIGHT - 0.22 * SIZE - 2.0);
        SUBTRACT.setArcWidth(0.045 * SIZE);
        SUBTRACT.setArcHeight(0.045 * SIZE);
        Shape GLOW_RING = Shape.subtract((Shape)BACKGROUND, (Shape)SUBTRACT);
        LinearGradient GLOW_OFF_PAINT = new LinearGradient(0.5 * WIDTH, 0.08411214953271028 * HEIGHT, 0.5 * WIDTH, 0.9112149532710281 * HEIGHT, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)0.8, (double)0.8, (double)0.8, (double)0.4)), new Stop(0.17, Color.color((double)0.6, (double)0.6, (double)0.6, (double)0.4)), new Stop(0.33, Color.color((double)0.9882352941, (double)0.9882352941, (double)0.9882352941, (double)0.4)), new Stop(0.34, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.4)), new Stop(0.63, Color.color((double)0.8, (double)0.8, (double)0.8, (double)0.4)), new Stop(0.64, Color.color((double)0.7960784314, (double)0.7960784314, (double)0.7960784314, (double)0.4)), new Stop(0.83, Color.color((double)0.6, (double)0.6, (double)0.6, (double)0.4)), new Stop(1.0, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.4))});
        GLOW_RING.setFill((Paint)GLOW_OFF_PAINT);
        GLOW_RING.setStroke(null);
        this.glowOff.getChildren().addAll((Object[])new Node[]{GLOW_RING});
        this.glowOff.setCache(true);
    }

    public void drawGlowOn() {
        double SIZE = this.gaugeBounds.getWidth() <= this.gaugeBounds.getHeight() ? this.gaugeBounds.getWidth() : this.gaugeBounds.getHeight();
        double WIDTH = this.gaugeBounds.getWidth();
        double HEIGHT = this.gaugeBounds.getHeight();
        this.glowOn.getChildren().clear();
        Rectangle BACKGROUND = new Rectangle(0.0841121495 * SIZE + 1.0, 0.0841121495 * SIZE + 1.0, WIDTH - 0.168224299 * SIZE - 2.0, HEIGHT - 0.168224299 * SIZE - 2.0);
        BACKGROUND.setArcWidth(0.05 * SIZE);
        BACKGROUND.setArcHeight(0.05 * SIZE);
        BACKGROUND.setStroke(null);
        Rectangle SUBTRACT = new Rectangle(0.11 * SIZE + 1.0, 0.11 * SIZE + 1.0, WIDTH - 0.22 * SIZE - 2.0, HEIGHT - 0.22 * SIZE - 2.0);
        SUBTRACT.setArcWidth(0.045 * SIZE);
        SUBTRACT.setArcHeight(0.045 * SIZE);
        Shape GLOW_RING = Shape.subtract((Shape)BACKGROUND, (Shape)SUBTRACT);
        GLOW_RING.setFill((Paint)this.control.getGlowColor());
        GLOW_RING.setStroke(null);
        DropShadow GLOW_EFFECT = new DropShadow();
        GLOW_EFFECT.setRadius(0.15 * SIZE);
        GLOW_EFFECT.setBlurType(BlurType.GAUSSIAN);
        if (GLOW_EFFECT.colorProperty().isBound()) {
            GLOW_EFFECT.colorProperty().unbind();
        }
        GLOW_EFFECT.colorProperty().bind(this.control.glowColorProperty());
        GLOW_RING.effectProperty().set((Object)GLOW_EFFECT);
        this.glowOn.getChildren().addAll((Object[])new Node[]{GLOW_RING});
        this.glowOn.setCache(true);
    }

    public void drawIndicators() {
        double SIZE = this.gaugeBounds.getWidth() <= this.gaugeBounds.getHeight() ? this.gaugeBounds.getWidth() : this.gaugeBounds.getHeight();
        double WIDTH = this.gaugeBounds.getWidth();
        double HEIGHT = this.gaugeBounds.getHeight();
        this.markers.getChildren().clear();
        Rectangle IBOUNDS = new Rectangle(0.0, 0.0, WIDTH, HEIGHT);
        IBOUNDS.setOpacity(0.0);
        IBOUNDS.setStroke(null);
        this.markers.getChildren().add((Object)IBOUNDS);
        this.markers.getTransforms().clear();
        for (Marker marker : this.control.getMarkers()) {
            Group ARROW;
            if (WIDTH <= HEIGHT) {
                ARROW = this.createIndicator(SIZE, marker, new Point2D(0.59 * WIDTH, 0.8345 * HEIGHT - SIZE * 0.0210280374 - Math.abs(marker.getValue()) * this.stepsize));
                ARROW.setRotate(90.0);
            } else {
                ARROW = this.createIndicator(SIZE, marker, new Point2D(0.1657142857142857 * WIDTH - SIZE * 0.0210280374 + Math.abs(marker.getValue()) * this.stepsize, 0.36 * HEIGHT));
            }
            this.markers.getChildren().add((Object)ARROW);
        }
    }

    public void drawThreshold() {
        double SIZE = this.gaugeBounds.getWidth() <= this.gaugeBounds.getHeight() ? this.gaugeBounds.getWidth() : this.gaugeBounds.getHeight();
        double WIDTH = this.gaugeBounds.getWidth();
        double HEIGHT = this.gaugeBounds.getHeight();
        this.threshold.getChildren().clear();
        Rectangle IBOUNDS = new Rectangle(0.0, 0.0, WIDTH, HEIGHT);
        IBOUNDS.setOpacity(0.0);
        IBOUNDS.setStroke(null);
        Path THRESHOLD = new Path();
        THRESHOLD.setFillRule(FillRule.EVEN_ODD);
        if (WIDTH <= HEIGHT) {
            THRESHOLD.getElements().add((Object)new MoveTo(0.3673333333 * WIDTH, 0.8371428571 * HEIGHT));
            THRESHOLD.getElements().add((Object)new LineTo(0.414 * WIDTH, 0.8471428571 * HEIGHT));
            THRESHOLD.getElements().add((Object)new LineTo(0.414 * WIDTH, 0.8271428571 * HEIGHT));
            THRESHOLD.getElements().add((Object)new ClosePath());
            this.threshold.setTranslateY(-Math.abs(this.control.getThreshold() - this.control.getMinValue()) * this.stepsize);
        } else {
            THRESHOLD.getElements().add((Object)new MoveTo(0.1657142857 * WIDTH, 0.645 * HEIGHT));
            THRESHOLD.getElements().add((Object)new LineTo(0.1757142857 * WIDTH, 0.6 * HEIGHT));
            THRESHOLD.getElements().add((Object)new LineTo(0.1557142857 * WIDTH, 0.6 * HEIGHT));
            THRESHOLD.getElements().add((Object)new ClosePath());
            this.threshold.setTranslateX(Math.abs(this.control.getThreshold() - this.control.getMinValue()) * this.stepsize);
        }
        THRESHOLD.setStrokeType(StrokeType.CENTERED);
        THRESHOLD.setStrokeLineCap(StrokeLineCap.ROUND);
        THRESHOLD.setStrokeLineJoin(StrokeLineJoin.ROUND);
        THRESHOLD.setStrokeWidth(0.005 * SIZE);
        THRESHOLD.getStyleClass().add((Object)"root");
        THRESHOLD.setStyle(this.control.getThresholdColor().CSS);
        THRESHOLD.getStyleClass().add((Object)"threshold-gradient");
        this.threshold.getChildren().addAll((Object[])new Node[]{IBOUNDS, THRESHOLD});
    }

    public void drawMinMeasuredIndicator() {
        double SIZE = this.gaugeBounds.getWidth() <= this.gaugeBounds.getHeight() ? this.gaugeBounds.getWidth() : this.gaugeBounds.getHeight();
        double WIDTH = this.gaugeBounds.getWidth();
        double HEIGHT = this.gaugeBounds.getHeight();
        this.minMeasured.getChildren().clear();
        Rectangle IBOUNDS = new Rectangle(0.0, 0.0, WIDTH, HEIGHT);
        IBOUNDS.setOpacity(0.0);
        IBOUNDS.setStroke(null);
        this.minMeasured.getChildren().add((Object)IBOUNDS);
        Path MARKER = this.createTriangleShape(SIZE * 0.032, SIZE * 0.038, true);
        MARKER.setFill((Paint)Color.color((double)0.0, (double)0.0, (double)0.8, (double)1.0));
        MARKER.setStroke(null);
        if (WIDTH <= HEIGHT) {
            MARKER.setRotate(-90.0);
            MARKER.setTranslateX(0.335 * WIDTH);
            MARKER.setTranslateY(0.8345 * HEIGHT - SIZE * 0.014);
        } else {
            MARKER.setRotate(180.0);
            MARKER.setTranslateX(0.1657142857142857 * WIDTH - SIZE * 0.016);
            MARKER.setTranslateY(0.65 * HEIGHT);
        }
        this.minMeasured.getChildren().add((Object)MARKER);
    }

    public void drawMaxMeasuredIndicator() {
        double SIZE = this.gaugeBounds.getWidth() <= this.gaugeBounds.getHeight() ? this.gaugeBounds.getWidth() : this.gaugeBounds.getHeight();
        double WIDTH = this.gaugeBounds.getWidth();
        double HEIGHT = this.gaugeBounds.getHeight();
        this.maxMeasured.getChildren().clear();
        Rectangle IBOUNDS = new Rectangle(0.0, 0.0, WIDTH, HEIGHT);
        IBOUNDS.setOpacity(0.0);
        IBOUNDS.setStroke(null);
        this.maxMeasured.getChildren().add((Object)IBOUNDS);
        Path MARKER = this.createTriangleShape(SIZE * 0.032, SIZE * 0.038, true);
        MARKER.setFill((Paint)Color.color((double)0.8, (double)0.0, (double)0.0, (double)1.0));
        MARKER.setStroke(null);
        if (WIDTH <= HEIGHT) {
            MARKER.setRotate(-90.0);
            MARKER.setTranslateX(0.335 * WIDTH);
            MARKER.setTranslateY(0.8345 * HEIGHT - SIZE * 0.014);
        } else {
            MARKER.setRotate(180.0);
            MARKER.setTranslateX(0.1657142857142857 * WIDTH - SIZE * 0.016);
            MARKER.setTranslateY(0.65 * HEIGHT);
        }
        this.maxMeasured.getChildren().add((Object)MARKER);
    }

    public void drawBar() {
        double WIDTH = this.gaugeBounds.getWidth();
        double HEIGHT = this.gaugeBounds.getHeight();
        this.bar.getChildren().clear();
        Rectangle IBOUNDS = new Rectangle(0.0, 0.0, WIDTH, HEIGHT);
        IBOUNDS.setOpacity(0.0);
        IBOUNDS.setStroke(null);
        this.bar.getChildren().add((Object)IBOUNDS);
        if (WIDTH <= HEIGHT) {
            Rectangle BAR_BOUNDS = new Rectangle(0.42 * WIDTH + 3.0, 0.1657142857142857 * HEIGHT, 0.16 * WIDTH - 5.0, 0.6714285714 * HEIGHT);
            double MIN_POSITION = BAR_BOUNDS.getLayoutBounds().getMaxY();
            double MAX_POSITION = BAR_BOUNDS.getLayoutBounds().getMinY();
            this.stepsize = Math.abs(BAR_BOUNDS.getLayoutBounds().getHeight() / this.control.getRange());
            double START_POSITION = this.control.getMinValue() > 0.0 ? MIN_POSITION : (this.control.getMaxValue() < 0.0 ? MAX_POSITION : MIN_POSITION + this.control.getMinValue() * this.stepsize);
            this.currentBar = new Rectangle(BAR_BOUNDS.getLayoutBounds().getMinX(), START_POSITION, BAR_BOUNDS.getLayoutBounds().getWidth(), Math.abs(this.currentValue.get()) * this.stepsize);
            if (this.currentValue.get() > 0.0) {
                this.currentBar.setTranslateY(-Math.abs(this.currentValue.get()) * this.stepsize);
            }
            this.currentBar.getStyleClass().add((Object)"root");
            this.currentBar.setStyle("-fx-value: " + this.control.getValueColor().CSS);
            this.currentBar.getStyleClass().add((Object)"bar-vertical-solid");
            this.currentBarHl = new Rectangle(this.currentBar.getLayoutBounds().getMinX(), this.currentBar.getLayoutBounds().getMinY(), this.currentBar.getLayoutBounds().getWidth(), this.currentBar.getLayoutBounds().getHeight());
            this.currentBarHl.getStyleClass().add((Object)"bar-vertical-highlight");
        } else {
            Rectangle BAR_BOUNDS = new Rectangle(0.1657142857142857 * WIDTH, 0.42 * HEIGHT + 3.0, 0.6714285714 * WIDTH, 0.16 * HEIGHT - 5.0);
            double MIN_POSITION = BAR_BOUNDS.getLayoutBounds().getMinX();
            double MAX_POSITION = BAR_BOUNDS.getLayoutBounds().getMaxX();
            this.stepsize = BAR_BOUNDS.getLayoutBounds().getWidth() / this.control.getRange();
            double START_POSITION = this.control.getMinValue() > 0.0 ? MIN_POSITION : (this.control.getMaxValue() < 0.0 ? MAX_POSITION : MIN_POSITION + Math.abs(this.control.getMinValue() * this.stepsize));
            this.currentBar = new Rectangle(START_POSITION, BAR_BOUNDS.getLayoutBounds().getMinY(), Math.abs(this.currentValue.get()) * this.stepsize, BAR_BOUNDS.getLayoutBounds().getHeight());
            if (this.currentValue.get() < 0.0) {
                this.currentBar.setTranslateX(this.currentValue.get() * this.stepsize);
            }
            this.currentBar.getStyleClass().add((Object)"root");
            this.currentBar.setStyle("-fx-value: " + this.control.getValueColor().CSS);
            this.currentBar.getStyleClass().add((Object)"bar-horizontal-solid");
            this.currentBarHl = new Rectangle(this.currentBar.getLayoutBounds().getMinX(), this.currentBar.getLayoutBounds().getMinY(), this.currentBar.getLayoutBounds().getWidth(), this.currentBar.getLayoutBounds().getHeight());
            this.currentBarHl.getStyleClass().add((Object)"bar-horizontal-highlight");
        }
        this.currentBar.setStroke(null);
        this.currentBarHl.setStroke(null);
        this.bar.getChildren().addAll((Object[])new Node[]{this.currentBar, this.currentBarHl});
    }

    public void updateBar() {
        double WIDTH = this.gaugeBounds.getWidth();
        double HEIGHT = this.gaugeBounds.getHeight();
        double barValue = this.currentValue.get();
        if (WIDTH <= HEIGHT) {
            this.currentBar.setHeight(Math.abs(barValue) * this.stepsize);
            this.currentBarHl.setHeight(Math.abs(barValue) * this.stepsize);
            this.currentBar.setTranslateY(0.0);
            this.currentBarHl.setTranslateY(0.0);
            if (Double.compare(barValue, 0.0) >= 0) {
                this.currentBar.setTranslateY(-barValue * this.stepsize);
                this.currentBarHl.setTranslateY(-barValue * this.stepsize);
            }
        } else {
            this.currentBar.setWidth(Math.abs(barValue) * this.stepsize);
            this.currentBarHl.setWidth(Math.abs(barValue) * this.stepsize);
            this.currentBar.setTranslateX(0.0);
            this.currentBarHl.setTranslateX(0.0);
            if (Double.compare(barValue, 0.0) <= 0) {
                this.currentBar.setTranslateX(-Math.abs(barValue) * this.stepsize);
                this.currentBarHl.setTranslateX(-Math.abs(barValue) * this.stepsize);
            }
        }
    }

    public void drawBarGraph() {
        double HEIGHT;
        double WIDTH = this.gaugeBounds.getWidth();
        if (WIDTH <= (HEIGHT = this.gaugeBounds.getHeight())) {
            double LED_WIDTH = 0.16 * WIDTH - 5.0;
            double LED_HEIGHT = 0.0085714286 * HEIGHT;
        } else {
            double LED_WIDTH = 0.0085714286 * WIDTH;
            double LED_HEIGHT = 0.16 * HEIGHT - 5.0;
        }
    }

    public void drawLed() {
        double SIZE = this.gaugeBounds.getWidth() <= this.gaugeBounds.getHeight() ? this.gaugeBounds.getWidth() : this.gaugeBounds.getHeight();
        double WIDTH = this.gaugeBounds.getWidth();
        double HEIGHT = this.gaugeBounds.getHeight();
        this.ledOff.getChildren().clear();
        Rectangle IBOUNDS_OFF = new Rectangle(0.0, 0.0, WIDTH, HEIGHT);
        IBOUNDS_OFF.setOpacity(0.0);
        IBOUNDS_OFF.setStroke(null);
        Group LED_OFF = this.createLed(SIZE * 0.14, this.control.getLedColor(), false);
        if (WIDTH <= HEIGHT) {
            LED_OFF.setLayoutX(WIDTH * 0.68);
            LED_OFF.setLayoutY(HEIGHT * 0.1);
        } else {
            LED_OFF.setLayoutX(WIDTH * 0.87);
            LED_OFF.setLayoutY(HEIGHT * 0.5 - LED_OFF.getLayoutBounds().getHeight());
        }
        this.ledOff.getChildren().addAll((Object[])new Node[]{IBOUNDS_OFF, LED_OFF});
        this.ledOff.setCache(true);
        this.ledOn.getChildren().clear();
        Rectangle IBOUNDS_ON = new Rectangle(0.0, 0.0, WIDTH, HEIGHT);
        IBOUNDS_ON.setOpacity(0.0);
        IBOUNDS_ON.setStroke(null);
        Group LED_ON = this.createLed(SIZE * 0.14, this.control.getLedColor(), true);
        if (WIDTH <= HEIGHT) {
            LED_ON.setLayoutX(WIDTH * 0.68);
            LED_ON.setLayoutY(HEIGHT * 0.1);
        } else {
            LED_ON.setLayoutX(WIDTH * 0.87);
            LED_ON.setLayoutY(HEIGHT * 0.5 - LED_OFF.getLayoutBounds().getHeight());
        }
        this.ledOn.getChildren().addAll((Object[])new Node[]{IBOUNDS_ON, LED_ON});
        this.ledOn.setCache(true);
    }

    public void drawUserLed() {
        double SIZE = this.gaugeBounds.getWidth() <= this.gaugeBounds.getHeight() ? this.gaugeBounds.getWidth() : this.gaugeBounds.getHeight();
        double WIDTH = this.gaugeBounds.getWidth();
        double HEIGHT = this.gaugeBounds.getHeight();
        this.userLedOff.getChildren().clear();
        Rectangle IBOUNDS_OFF = new Rectangle(0.0, 0.0, WIDTH, HEIGHT);
        IBOUNDS_OFF.setOpacity(0.0);
        IBOUNDS_OFF.setStroke(null);
        Group LED_OFF = this.createLed(SIZE * 0.14, this.control.getUserLedColor(), false);
        if (WIDTH <= HEIGHT) {
            LED_OFF.setLayoutX(WIDTH * 0.1933333333);
            LED_OFF.setLayoutY(HEIGHT * 0.1);
        } else {
            LED_OFF.setLayoutX(WIDTH * 0.0828571429);
            LED_OFF.setLayoutY(HEIGHT * 0.5 - LED_OFF.getLayoutBounds().getHeight());
        }
        this.userLedOff.getChildren().addAll((Object[])new Node[]{IBOUNDS_OFF, LED_OFF});
        this.userLedOn.getChildren().clear();
        Rectangle IBOUNDS_ON = new Rectangle(0.0, 0.0, WIDTH, HEIGHT);
        IBOUNDS_ON.setOpacity(0.0);
        IBOUNDS_ON.setStroke(null);
        Group LED_ON = this.createLed(SIZE * 0.14, this.control.getUserLedColor(), true);
        if (WIDTH <= HEIGHT) {
            LED_ON.setLayoutX(WIDTH * 0.1933333333);
            LED_ON.setLayoutY(HEIGHT * 0.1);
        } else {
            LED_ON.setLayoutX(WIDTH * 0.0828571429);
            LED_ON.setLayoutY(HEIGHT * 0.5 - LED_OFF.getLayoutBounds().getHeight());
        }
        this.userLedOn.getChildren().addAll((Object[])new Node[]{IBOUNDS_ON, LED_ON});
    }

    public void drawLcd() {
        double WIDTH = this.gaugeBounds.getWidth();
        double HEIGHT = this.gaugeBounds.getHeight();
        this.lcd.getChildren().clear();
        Rectangle IBOUNDS = new Rectangle(0.0, 0.0, WIDTH, HEIGHT);
        IBOUNDS.setOpacity(0.0);
        IBOUNDS.setStroke(null);
        this.lcd.getChildren().addAll((Object[])new Node[]{IBOUNDS});
        Rectangle LCD_FRAME = WIDTH <= HEIGHT ? new Rectangle(0.16666666666666666 * WIDTH, 0.8571428571428571 * HEIGHT, 0.6666666666666666 * WIDTH, 0.07142857142857142 * HEIGHT) : new Rectangle(0.6457142857142857 * WIDTH, 0.17333333333333334 * HEIGHT, 0.28 * WIDTH, 0.15333333333333332 * HEIGHT);
        double LCD_FRAME_CORNER_RADIUS = LCD_FRAME.getWidth() > LCD_FRAME.getHeight() ? LCD_FRAME.getHeight() * 0.15 : LCD_FRAME.getWidth() * 0.15;
        LCD_FRAME.setArcWidth(LCD_FRAME_CORNER_RADIUS);
        LCD_FRAME.setArcHeight(LCD_FRAME_CORNER_RADIUS);
        LinearGradient LCD_FRAME_FILL = new LinearGradient(0.0, LCD_FRAME.getLayoutBounds().getMinY(), 0.0, LCD_FRAME.getLayoutBounds().getMaxY(), false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)0.1, (double)0.1, (double)0.1, (double)1.0)), new Stop(0.1, Color.color((double)0.3, (double)0.3, (double)0.3, (double)1.0)), new Stop(0.93, Color.color((double)0.3, (double)0.3, (double)0.3, (double)1.0)), new Stop(1.0, Color.color((double)0.86, (double)0.86, (double)0.86, (double)1.0))});
        LCD_FRAME.setFill((Paint)LCD_FRAME_FILL);
        LCD_FRAME.setStroke(null);
        Rectangle LCD_MAIN = new Rectangle(LCD_FRAME.getX() + 1.0, LCD_FRAME.getY() + 1.0, LCD_FRAME.getWidth() - 2.0, LCD_FRAME.getHeight() - 2.0);
        double LCD_MAIN_CORNER_RADIUS = LCD_FRAME.getArcWidth() - 1.0;
        LCD_MAIN.setArcWidth(LCD_MAIN_CORNER_RADIUS);
        LCD_MAIN.setArcHeight(LCD_MAIN_CORNER_RADIUS);
        LCD_MAIN.getStyleClass().add((Object)"lcd");
        LCD_MAIN.getStyleClass().add((Object)this.control.getLcdDesign().CSS);
        LCD_MAIN.getStyleClass().add((Object)"lcd-main");
        InnerShadow INNER_GLOW = new InnerShadow();
        INNER_GLOW.setWidth(0.25 * LCD_FRAME.getHeight());
        INNER_GLOW.setHeight(0.25 * LCD_FRAME.getHeight());
        INNER_GLOW.setOffsetY(-0.05 * LCD_FRAME.getHeight());
        INNER_GLOW.setOffsetX(0.0);
        INNER_GLOW.setColor(Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.2));
        InnerShadow INNER_SHADOW = new InnerShadow();
        INNER_SHADOW.setInput((Effect)INNER_GLOW);
        INNER_SHADOW.setWidth(0.15 * LCD_FRAME.getHeight());
        INNER_SHADOW.setHeight(0.15 * LCD_FRAME.getHeight());
        INNER_SHADOW.setOffsetY(0.025 * LCD_FRAME.getHeight());
        INNER_SHADOW.setColor(Color.color((double)0.0, (double)0.0, (double)0.0, (double)0.65));
        LCD_MAIN.setEffect((Effect)INNER_SHADOW);
        this.lcd.getChildren().addAll((Object[])new Node[]{LCD_FRAME, LCD_MAIN});
        this.lcd.setCache(true);
    }

    public void drawLcdContent() {
        double UNIT_Y_OFFSET;
        Font LCD_VALUE_FONT;
        double WIDTH = this.gaugeBounds.getWidth();
        double HEIGHT = this.gaugeBounds.getHeight();
        this.lcdContent.getChildren().clear();
        Rectangle IBOUNDS = new Rectangle(0.0, 0.0, WIDTH, HEIGHT);
        IBOUNDS.setOpacity(0.0);
        IBOUNDS.setStroke(null);
        Rectangle LCD_FRAME = WIDTH <= HEIGHT ? new Rectangle(0.16666666666666666 * WIDTH, 0.8571428571428571 * HEIGHT, 0.6666666666666666 * WIDTH, 0.07142857142857142 * HEIGHT) : new Rectangle(0.6457142857142857 * WIDTH, 0.17333333333333334 * HEIGHT, 0.28 * WIDTH, 0.15333333333333332 * HEIGHT);
        Font LCD_UNIT_FONT = Font.font((String)this.control.getLcdUnitFont(), (FontWeight)FontWeight.NORMAL, (double)(0.4 * LCD_FRAME.getLayoutBounds().getHeight()));
        switch (this.control.getLcdValueFont()) {
            case LCD: {
                LCD_VALUE_FONT = Font.loadFont((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/jfxtras/labs/scene/control/gauge/digital.ttf"), (double)(0.75 * LCD_FRAME.getLayoutBounds().getHeight()));
                UNIT_Y_OFFSET = 1.5;
                break;
            }
            case BUS: {
                LCD_VALUE_FONT = Font.loadFont((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/jfxtras/labs/scene/control/gauge/bus.otf"), (double)(0.6 * LCD_FRAME.getLayoutBounds().getHeight()));
                UNIT_Y_OFFSET = 2.0;
                break;
            }
            case PIXEL: {
                LCD_VALUE_FONT = Font.loadFont((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/jfxtras/labs/scene/control/gauge/pixel.ttf"), (double)(0.6 * LCD_FRAME.getLayoutBounds().getHeight()));
                UNIT_Y_OFFSET = 2.0;
                break;
            }
            case PHONE_LCD: {
                LCD_VALUE_FONT = Font.loadFont((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/jfxtras/labs/scene/control/gauge/phonelcd.ttf"), (double)(0.6 * LCD_FRAME.getLayoutBounds().getHeight()));
                UNIT_Y_OFFSET = 2.0;
                break;
            }
            default: {
                LCD_VALUE_FONT = Font.font((String)"Verdana", (FontWeight)FontWeight.NORMAL, (double)(0.6 * LCD_FRAME.getLayoutBounds().getHeight()));
                UNIT_Y_OFFSET = 2.0;
            }
        }
        this.lcdValueString.setFont(LCD_VALUE_FONT);
        this.lcdUnitString.setFont(LCD_UNIT_FONT);
        this.lcdUnitString.setText(this.control.isLcdValueCoupled() ? this.control.getUnit() : this.control.getLcdUnit());
        this.lcdUnitString.setTextOrigin(VPos.BOTTOM);
        this.lcdUnitString.setTextAlignment(TextAlignment.RIGHT);
        if (this.lcdUnitString.visibleProperty().isBound()) {
            this.lcdUnitString.visibleProperty().unbind();
        }
        this.lcdUnitString.visibleProperty().bind((ObservableValue)this.control.lcdUnitVisibleProperty());
        if (this.control.isLcdUnitVisible()) {
            this.lcdUnitString.setX(LCD_FRAME.getX() + (LCD_FRAME.getWidth() - this.lcdUnitString.getLayoutBounds().getWidth()) - LCD_FRAME.getHeight() * 0.0625);
            this.lcdUnitString.setY(LCD_FRAME.getY() + (LCD_FRAME.getHeight() + this.lcdValueString.getLayoutBounds().getHeight()) / UNIT_Y_OFFSET - this.lcdValueString.getLayoutBounds().getHeight() * 0.05);
        }
        switch (this.control.getLcdNumberSystem()) {
            case HEXADECIMAL: {
                this.lcdValueString.setText(Integer.toHexString((int)this.currentLcdValue.get()).toUpperCase());
                break;
            }
            case OCTAL: {
                this.lcdValueString.setText(Integer.toOctalString((int)this.currentLcdValue.get()).toUpperCase());
                break;
            }
            default: {
                this.lcdValueString.setText(this.formatLcdValue(this.currentLcdValue.get()));
            }
        }
        if (this.control.isLcdUnitVisible()) {
            this.lcdValueString.setX(LCD_FRAME.getX() + (LCD_FRAME.getWidth() - this.lcdUnitString.getLayoutBounds().getWidth() - this.lcdValueString.getLayoutBounds().getWidth()) - LCD_FRAME.getHeight() * 0.0833333333);
        } else {
            this.lcdValueString.setX(LCD_FRAME.getX() + (LCD_FRAME.getWidth() - this.lcdValueString.getLayoutBounds().getWidth()) - LCD_FRAME.getHeight() * 0.0625);
        }
        this.lcdValueString.setY(LCD_FRAME.getY() + (LCD_FRAME.getHeight() + this.lcdValueString.getLayoutBounds().getHeight()) / 2.0);
        this.lcdValueString.setTextOrigin(VPos.BOTTOM);
        this.lcdValueString.setTextAlignment(TextAlignment.RIGHT);
        this.lcdContent.getChildren().addAll((Object[])new Node[]{IBOUNDS, this.lcdUnitString, this.lcdValueString});
    }

    public void drawTickmarks() {
        Point2D textPoint;
        double TICK_OFFSET;
        double MAX_POSITION;
        double MIN_POSITION;
        Rectangle BAR_BOUNDS;
        boolean ORIENTATION;
        double SIZE = this.gaugeBounds.getWidth() <= this.gaugeBounds.getHeight() ? this.gaugeBounds.getWidth() : this.gaugeBounds.getHeight();
        double WIDTH = this.gaugeBounds.getWidth();
        double HEIGHT = this.gaugeBounds.getHeight();
        this.tickmarks.getChildren().clear();
        Rectangle IBOUNDS = new Rectangle(0.0, 0.0, WIDTH, HEIGHT);
        IBOUNDS.setOpacity(0.0);
        IBOUNDS.setStroke(null);
        this.tickmarks.getChildren().add((Object)IBOUNDS);
        Gauge.NumberFormat numberFormat = this.control.getTickLabelNumberFormat() == Gauge.NumberFormat.AUTO ? (Math.abs(this.control.getMajorTickSpacing()) > 1000.0 ? Gauge.NumberFormat.SCIENTIFIC : (this.control.getMajorTickSpacing() % 1.0 != 0.0 ? Gauge.NumberFormat.FRACTIONAL : Gauge.NumberFormat.STANDARD)) : this.control.getTickLabelNumberFormat();
        Font STD_FONT = Font.font((String)"Verdana", (FontWeight)FontWeight.NORMAL, (double)(0.06 * SIZE));
        double MINOR_TICK_LENGTH = 0.022 * SIZE;
        double MEDIUM_TICK_LENGTH = 0.035 * SIZE;
        double MAJOR_TICK_LENGTH = 0.05 * SIZE;
        Path MAJOR_TICKMARKS_PATH = new Path();
        MAJOR_TICKMARKS_PATH.setFillRule(FillRule.EVEN_ODD);
        MAJOR_TICKMARKS_PATH.setSmooth(true);
        MAJOR_TICKMARKS_PATH.strokeTypeProperty().set((Object)StrokeType.CENTERED);
        MAJOR_TICKMARKS_PATH.strokeLineCapProperty().set((Object)StrokeLineCap.ROUND);
        MAJOR_TICKMARKS_PATH.strokeLineJoinProperty().set((Object)StrokeLineJoin.BEVEL);
        MAJOR_TICKMARKS_PATH.strokeWidthProperty().set(0.0045 * SIZE);
        Path MEDIUM_TICKMARKS_PATH = new Path();
        MEDIUM_TICKMARKS_PATH.setFillRule(FillRule.EVEN_ODD);
        MEDIUM_TICKMARKS_PATH.setSmooth(true);
        MEDIUM_TICKMARKS_PATH.strokeTypeProperty().set((Object)StrokeType.CENTERED);
        MEDIUM_TICKMARKS_PATH.strokeLineCapProperty().set((Object)StrokeLineCap.ROUND);
        MEDIUM_TICKMARKS_PATH.strokeLineJoinProperty().set((Object)StrokeLineJoin.BEVEL);
        MEDIUM_TICKMARKS_PATH.strokeWidthProperty().set(0.0025 * SIZE);
        Path MINOR_TICKMARKS_PATH = new Path();
        MINOR_TICKMARKS_PATH.setFillRule(FillRule.EVEN_ODD);
        MINOR_TICKMARKS_PATH.setSmooth(true);
        MINOR_TICKMARKS_PATH.strokeTypeProperty().set((Object)StrokeType.CENTERED);
        MINOR_TICKMARKS_PATH.strokeLineCapProperty().set((Object)StrokeLineCap.ROUND);
        MINOR_TICKMARKS_PATH.strokeLineJoinProperty().set((Object)StrokeLineJoin.BEVEL);
        MINOR_TICKMARKS_PATH.strokeWidthProperty().set(0.0015 * SIZE);
        ArrayList<Text> tickmarkLabel = new ArrayList<Text>();
        MAJOR_TICKMARKS_PATH.getStyleClass().add((Object)this.control.getBackgroundDesign().CSS_BACKGROUND);
        MEDIUM_TICKMARKS_PATH.getStyleClass().add((Object)this.control.getBackgroundDesign().CSS_BACKGROUND);
        MINOR_TICKMARKS_PATH.getStyleClass().add((Object)this.control.getBackgroundDesign().CSS_BACKGROUND);
        boolean VERTICAL = false;
        boolean HORIZONTAL = true;
        if (WIDTH <= HEIGHT) {
            ORIENTATION = false;
            BAR_BOUNDS = new Rectangle(0.42 * WIDTH + 3.0, 0.1657142857142857 * HEIGHT, 0.16 * WIDTH - 5.0, 0.6714285714 * HEIGHT);
            MIN_POSITION = BAR_BOUNDS.getLayoutBounds().getMaxY();
            MAX_POSITION = BAR_BOUNDS.getLayoutBounds().getMinY();
            this.stepsize = Math.abs(BAR_BOUNDS.getLayoutBounds().getHeight() / this.control.getRange());
            TICK_OFFSET = BAR_BOUNDS.getLayoutBounds().getMinX() - SIZE * 0.05;
            textPoint = new Point2D(TICK_OFFSET - MAJOR_TICK_LENGTH - 5.0, 0.0);
        } else {
            ORIENTATION = true;
            BAR_BOUNDS = new Rectangle(0.1657142857142857 * WIDTH, 0.42 * HEIGHT + 3.0, 0.6714285714 * WIDTH, 0.16 * HEIGHT - 5.0);
            MIN_POSITION = BAR_BOUNDS.getLayoutBounds().getMinX();
            MAX_POSITION = BAR_BOUNDS.getLayoutBounds().getMaxX();
            this.stepsize = BAR_BOUNDS.getLayoutBounds().getWidth() / this.control.getRange();
            TICK_OFFSET = BAR_BOUNDS.getLayoutBounds().getMaxY() + SIZE * 0.05;
            textPoint = new Point2D(0.0, TICK_OFFSET + MAJOR_TICK_LENGTH + 0.06 * SIZE + 5.0);
        }
        double TICK_START = !ORIENTATION ? MAX_POSITION : MIN_POSITION;
        double TICK_STOP = !ORIENTATION ? MIN_POSITION : MAX_POSITION;
        double valueCounter = !ORIENTATION ? this.control.getMaxValue() : this.control.getMinValue();
        int majorTickCounter = this.control.getMaxNoOfMinorTicks() - 1;
        double counter = TICK_START;
        while (Double.compare(counter, TICK_STOP + 1.0) <= 0) {
            Point2D outerPoint;
            Point2D innerPoint;
            if (++majorTickCounter == this.control.getMaxNoOfMinorTicks()) {
                if (!ORIENTATION) {
                    innerPoint = new Point2D(TICK_OFFSET, 0.0);
                    outerPoint = new Point2D(TICK_OFFSET - MAJOR_TICK_LENGTH, 0.0);
                    MAJOR_TICKMARKS_PATH.getElements().add((Object)new MoveTo(innerPoint.getX(), counter));
                    MAJOR_TICKMARKS_PATH.getElements().add((Object)new LineTo(outerPoint.getX(), counter));
                } else {
                    innerPoint = new Point2D(0.0, TICK_OFFSET);
                    outerPoint = new Point2D(0.0, TICK_OFFSET + MAJOR_TICK_LENGTH);
                    MAJOR_TICKMARKS_PATH.getElements().add((Object)new MoveTo(counter, innerPoint.getY()));
                    MAJOR_TICKMARKS_PATH.getElements().add((Object)new LineTo(counter, outerPoint.getY()));
                }
                if (this.control.isTickLabelsVisible()) {
                    Text tickLabel = new Text(numberFormat.format(valueCounter));
                    tickLabel.setSmooth(true);
                    tickLabel.setFontSmoothingType(FontSmoothingType.LCD);
                    tickLabel.setTextAlignment(TextAlignment.CENTER);
                    tickLabel.setTextOrigin(VPos.BOTTOM);
                    tickLabel.getStyleClass().add((Object)this.control.getBackgroundDesign().CSS_TEXT);
                    tickLabel.setStroke(null);
                    tickLabel.setFont(STD_FONT);
                    if (!ORIENTATION) {
                        tickLabel.setX(textPoint.getX() - tickLabel.getLayoutBounds().getWidth());
                        tickLabel.setY(counter + tickLabel.getLayoutBounds().getHeight() / 2.0);
                    } else {
                        tickLabel.setX(counter - tickLabel.getLayoutBounds().getWidth() / 2.0);
                        tickLabel.setY(textPoint.getY());
                    }
                    tickmarkLabel.add(tickLabel);
                    valueCounter = !ORIENTATION ? (valueCounter -= this.control.getMajorTickSpacing()) : (valueCounter += this.control.getMajorTickSpacing());
                }
                majorTickCounter = 0;
            } else if (this.control.getMaxNoOfMinorTicks() % 2 == 0 && majorTickCounter == this.control.getMaxNoOfMinorTicks() / 2) {
                if (!ORIENTATION) {
                    innerPoint = new Point2D(TICK_OFFSET, 0.0);
                    outerPoint = new Point2D(TICK_OFFSET - MEDIUM_TICK_LENGTH, 0.0);
                    MEDIUM_TICKMARKS_PATH.getElements().add((Object)new MoveTo(innerPoint.getX(), counter));
                    MEDIUM_TICKMARKS_PATH.getElements().add((Object)new LineTo(outerPoint.getX(), counter));
                } else {
                    innerPoint = new Point2D(0.0, TICK_OFFSET);
                    outerPoint = new Point2D(0.0, TICK_OFFSET + MEDIUM_TICK_LENGTH);
                    MEDIUM_TICKMARKS_PATH.getElements().add((Object)new MoveTo(counter, innerPoint.getY()));
                    MEDIUM_TICKMARKS_PATH.getElements().add((Object)new LineTo(counter, outerPoint.getY()));
                }
            } else if (this.control.isTickmarksVisible() && this.control.isMinorTicksVisible()) {
                if (!ORIENTATION) {
                    innerPoint = new Point2D(TICK_OFFSET, 0.0);
                    outerPoint = new Point2D(TICK_OFFSET - MINOR_TICK_LENGTH, 0.0);
                    MINOR_TICKMARKS_PATH.getElements().add((Object)new MoveTo(innerPoint.getX(), counter));
                    MINOR_TICKMARKS_PATH.getElements().add((Object)new LineTo(outerPoint.getX(), counter));
                } else {
                    innerPoint = new Point2D(0.0, TICK_OFFSET);
                    outerPoint = new Point2D(0.0, TICK_OFFSET + MINOR_TICK_LENGTH);
                    MINOR_TICKMARKS_PATH.getElements().add((Object)new MoveTo(counter, innerPoint.getY()));
                    MINOR_TICKMARKS_PATH.getElements().add((Object)new LineTo(counter, outerPoint.getY()));
                }
            }
            counter += this.stepsize;
        }
        this.tickmarks.getChildren().addAll((Object[])new Node[]{MAJOR_TICKMARKS_PATH, MEDIUM_TICKMARKS_PATH, MINOR_TICKMARKS_PATH});
        this.tickmarks.getChildren().addAll(tickmarkLabel);
        this.tickmarks.setCache(true);
    }

    public void drawForeground() {
        Point2D STOP;
        Point2D START;
        double SIZE = this.gaugeBounds.getWidth() <= this.gaugeBounds.getHeight() ? this.gaugeBounds.getWidth() : this.gaugeBounds.getHeight();
        double WIDTH = this.gaugeBounds.getWidth();
        double HEIGHT = this.gaugeBounds.getHeight();
        this.foreground.getChildren().clear();
        Insets INSETS = new Insets(0.0841121495 * SIZE + 2.0, WIDTH - 0.0841121495 * SIZE - 2.0, HEIGHT - 0.0841121495 * SIZE - 2.0, 0.0841121495 * SIZE + 2.0);
        Rectangle IBOUNDS = new Rectangle(0.0, 0.0, WIDTH, HEIGHT);
        IBOUNDS.setOpacity(0.0);
        IBOUNDS.setStroke(null);
        this.foreground.getChildren().addAll((Object[])new Node[]{IBOUNDS});
        Path FOREGROUND = new Path();
        if (WIDTH >= HEIGHT) {
            FOREGROUND.setFillRule(FillRule.EVEN_ODD);
            FOREGROUND.getElements().add((Object)new MoveTo(INSETS.getLeft(), INSETS.getBottom()));
            FOREGROUND.getElements().add((Object)new LineTo(INSETS.getRight(), INSETS.getBottom()));
            FOREGROUND.getElements().add((Object)new CubicCurveTo(INSETS.getRight(), INSETS.getBottom(), INSETS.getRight() - 13.0, 0.7 * HEIGHT, INSETS.getRight() - 13.0, 0.5 * HEIGHT));
            FOREGROUND.getElements().add((Object)new CubicCurveTo(INSETS.getRight() - 13.0, 0.3 * HEIGHT, INSETS.getRight(), INSETS.getTop(), INSETS.getRight(), INSETS.getTop()));
            FOREGROUND.getElements().add((Object)new LineTo(INSETS.getLeft(), INSETS.getTop()));
            FOREGROUND.getElements().add((Object)new CubicCurveTo(INSETS.getLeft(), INSETS.getTop(), INSETS.getLeft() + 13.0, 0.3 * HEIGHT, INSETS.getLeft() + 13.0, 0.5 * HEIGHT));
            FOREGROUND.getElements().add((Object)new CubicCurveTo(INSETS.getLeft() + 13.0, 0.7 * HEIGHT, INSETS.getLeft(), INSETS.getBottom(), INSETS.getLeft(), INSETS.getBottom()));
            FOREGROUND.getElements().add((Object)new ClosePath());
            START = new Point2D(0.0, FOREGROUND.getLayoutBounds().getMaxY());
            STOP = new Point2D(0.0, FOREGROUND.getLayoutBounds().getMinY());
        } else {
            FOREGROUND.setFillRule(FillRule.EVEN_ODD);
            FOREGROUND.getElements().add((Object)new MoveTo(INSETS.getLeft(), INSETS.getTop()));
            FOREGROUND.getElements().add((Object)new LineTo(INSETS.getLeft(), INSETS.getBottom()));
            FOREGROUND.getElements().add((Object)new CubicCurveTo(INSETS.getLeft(), INSETS.getBottom(), 0.3 * WIDTH, INSETS.getBottom() - 13.0, 0.5 * WIDTH, INSETS.getBottom() - 13.0));
            FOREGROUND.getElements().add((Object)new CubicCurveTo(0.7 * WIDTH, INSETS.getBottom() - 13.0, INSETS.getRight(), INSETS.getBottom(), INSETS.getRight(), INSETS.getBottom()));
            FOREGROUND.getElements().add((Object)new LineTo(INSETS.getRight(), INSETS.getTop()));
            FOREGROUND.getElements().add((Object)new CubicCurveTo(INSETS.getRight(), INSETS.getTop(), 0.7 * WIDTH, INSETS.getTop() + 13.0, 0.5 * WIDTH, INSETS.getTop() + 13.0));
            FOREGROUND.getElements().add((Object)new CubicCurveTo(0.3 * WIDTH, INSETS.getTop() + 13.0, INSETS.getLeft(), INSETS.getTop(), INSETS.getLeft(), INSETS.getTop()));
            FOREGROUND.getElements().add((Object)new ClosePath());
            START = new Point2D(FOREGROUND.getLayoutBounds().getMinX(), 0.0);
            STOP = new Point2D(FOREGROUND.getLayoutBounds().getMaxX(), 0.0);
        }
        LinearGradient GRADIENT = new LinearGradient(START.getX(), START.getY(), STOP.getX(), STOP.getY(), false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0)), new Stop(0.06, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0)), new Stop(0.07, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0)), new Stop(0.12, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.05)), new Stop(0.17, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0)), new Stop(0.18, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0)), new Stop(0.23, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.02)), new Stop(0.3, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0)), new Stop(0.8, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0)), new Stop(0.84, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.08)), new Stop(0.93, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.18)), new Stop(0.94, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.2)), new Stop(0.96, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.1)), new Stop(0.97, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0)), new Stop(1.0, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0))});
        FOREGROUND.setFill((Paint)GRADIENT);
        FOREGROUND.setStroke(null);
        this.foreground.getChildren().addAll((Object[])new Node[]{FOREGROUND});
        this.foreground.setCache(true);
    }
}

