/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.internal.scene.control.skin;

import com.sun.javafx.scene.control.skin.SkinBase;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.RowConstraints;
import javafx.util.Duration;
import jfxtras.labs.animation.Timer;
import jfxtras.labs.internal.scene.control.behavior.ListSpinnerBehavior;
import jfxtras.labs.scene.control.ListSpinner;

public class ListSpinnerCaspianSkin<T>
extends SkinBase<ListSpinner<T>, ListSpinnerBehavior<T>> {
    private Region decrementArrow = null;
    private Region incrementArrow = null;
    private GridPane gridPane = null;
    private BorderPane valueGroup;
    private final Timer unclickTimer = new Timer(new Runnable(){

        @Override
        public void run() {
            ListSpinnerCaspianSkin.this.unclickArrows();
        }
    }).withDelay(Duration.millis((double)100.0)).withRepeats(false);
    private final Timer repeatDecrementClickTimer = new Timer(new Runnable(){

        @Override
        public void run() {
            ((ListSpinner)ListSpinnerCaspianSkin.this.getSkinnable()).decrement();
        }
    }).withDelay(Duration.millis((double)500.0)).withCycleDuration(Duration.millis((double)50.0));
    private final Timer repeatIncrementClickTimer = new Timer(new Runnable(){

        @Override
        public void run() {
            ((ListSpinner)ListSpinnerCaspianSkin.this.getSkinnable()).increment();
        }
    }).withDelay(Duration.millis((double)500.0)).withCycleDuration(Duration.millis((double)50.0));
    private TextField textField = null;

    public ListSpinnerCaspianSkin(ListSpinner<T> control) {
        super(control, new ListSpinnerBehavior<T>(control));
        this.construct();
    }

    private void construct() {
        this.createNodes();
        ((ListSpinner)this.getSkinnable()).editableProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> arg0, Boolean arg1, Boolean arg2) {
                ListSpinnerCaspianSkin.this.replaceValueNode();
            }
        });
        this.replaceValueNode();
        ((ListSpinner)this.getSkinnable()).valueProperty().addListener(new ChangeListener<T>(){

            public void changed(ObservableValue<? extends T> observableValue, T oldValue, T newValue) {
                ListSpinnerCaspianSkin.this.refreshValue();
            }
        });
        this.refreshValue();
        ((ListSpinner)this.getSkinnable()).arrowDirectionProperty().addListener((ChangeListener)new ChangeListener<ListSpinner.ArrowDirection>(){

            public void changed(ObservableValue<? extends ListSpinner.ArrowDirection> observableValue, ListSpinner.ArrowDirection oldValue, ListSpinner.ArrowDirection newValue) {
                ListSpinnerCaspianSkin.this.setArrowCSS();
                ListSpinnerCaspianSkin.this.layoutGridPane();
            }
        });
        this.setArrowCSS();
        this.layoutGridPane();
        ((ListSpinner)this.getSkinnable()).alignmentProperty().addListener((ChangeListener)new ChangeListener<Pos>(){

            public void changed(ObservableValue<? extends Pos> observableValue, Pos oldValue, Pos newValue) {
                ListSpinnerCaspianSkin.this.alignValue();
            }
        });
        this.alignValue();
    }

    private void refreshValue() {
        if (((ListSpinner)this.getSkinnable()).isEditable().booleanValue()) {
            Object lValue = ((ListSpinner)this.getSkinnable()).getValue();
            this.textField.setText(((ListSpinner)this.getSkinnable()).getPrefix() + ((ListSpinner)this.getSkinnable()).getStringConverter().toString(lValue) + ((ListSpinner)this.getSkinnable()).getPostfix());
        } else {
            Node node = (Node)((ListSpinner)this.getSkinnable()).getCellFactory().call((Object)this.getSkinnable());
        }
    }

    private void createNodes() {
        this.decrementArrow = new Region();
        this.decrementArrow.getStyleClass().add((Object)"idle");
        this.valueGroup = new BorderPane();
        this.valueGroup.getStyleClass().add((Object)"valuePane");
        this.incrementArrow = new Region();
        this.incrementArrow.getStyleClass().add((Object)"idle");
        this.gridPane = new GridPane();
        this.gridPane.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent evt) {
                if (ListSpinnerCaspianSkin.this.mouseEventOverArrow(evt, ListSpinnerCaspianSkin.this.decrementArrow)) {
                    ListSpinnerCaspianSkin.this.unclickArrows();
                    ListSpinnerCaspianSkin.this.decrementArrow.getStyleClass().add((Object)"clicked");
                    ((ListSpinner)ListSpinnerCaspianSkin.this.getSkinnable()).decrement();
                    ListSpinnerCaspianSkin.this.unclickTimer.restart();
                    return;
                }
                if (ListSpinnerCaspianSkin.this.mouseEventOverArrow(evt, ListSpinnerCaspianSkin.this.incrementArrow)) {
                    ListSpinnerCaspianSkin.this.unclickArrows();
                    ListSpinnerCaspianSkin.this.incrementArrow.getStyleClass().add((Object)"clicked");
                    ((ListSpinner)ListSpinnerCaspianSkin.this.getSkinnable()).increment();
                    ListSpinnerCaspianSkin.this.unclickTimer.restart();
                    return;
                }
            }
        });
        this.gridPane.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent evt) {
                if (ListSpinnerCaspianSkin.this.mouseEventOverArrow(evt, ListSpinnerCaspianSkin.this.decrementArrow)) {
                    ListSpinnerCaspianSkin.this.decrementArrow.getStyleClass().add((Object)"clicked");
                    ListSpinnerCaspianSkin.this.repeatDecrementClickTimer.restart();
                    return;
                }
                if (ListSpinnerCaspianSkin.this.mouseEventOverArrow(evt, ListSpinnerCaspianSkin.this.incrementArrow)) {
                    ListSpinnerCaspianSkin.this.incrementArrow.getStyleClass().add((Object)"clicked");
                    ListSpinnerCaspianSkin.this.repeatIncrementClickTimer.restart();
                    return;
                }
            }
        });
        this.gridPane.setOnMouseReleased((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent evt) {
                ListSpinnerCaspianSkin.this.unclickArrows();
                ListSpinnerCaspianSkin.this.repeatDecrementClickTimer.stop();
                ListSpinnerCaspianSkin.this.repeatIncrementClickTimer.stop();
            }
        });
        this.gridPane.setOnMouseExited((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent evt) {
                ListSpinnerCaspianSkin.this.unclickArrows();
                ListSpinnerCaspianSkin.this.repeatDecrementClickTimer.stop();
                ListSpinnerCaspianSkin.this.repeatIncrementClickTimer.stop();
            }
        });
        this.gridPane.setOnScroll((EventHandler)new EventHandler<ScrollEvent>(){

            public void handle(ScrollEvent evt) {
                if (evt.getDeltaY() < 0.0 || evt.getDeltaX() < 0.0) {
                    ListSpinnerCaspianSkin.this.unclickArrows();
                    ListSpinnerCaspianSkin.this.decrementArrow.getStyleClass().add((Object)"clicked");
                    ((ListSpinner)ListSpinnerCaspianSkin.this.getSkinnable()).decrement();
                    ListSpinnerCaspianSkin.this.unclickTimer.restart();
                    return;
                }
                if (evt.getDeltaY() > 0.0 || evt.getDeltaX() > 0.0) {
                    ListSpinnerCaspianSkin.this.unclickArrows();
                    ListSpinnerCaspianSkin.this.incrementArrow.getStyleClass().add((Object)"clicked");
                    ((ListSpinner)ListSpinnerCaspianSkin.this.getSkinnable()).increment();
                    ListSpinnerCaspianSkin.this.unclickTimer.restart();
                    return;
                }
            }
        });
        this.getStyleClass().add((Object)((Object)((Object)this)).getClass().getSimpleName());
        this.getChildren().add((Object)this.gridPane);
    }

    private boolean mouseEventOverArrow(MouseEvent evt, Region region) {
        Point2D lClickInRelationToArrow = region.sceneToLocal(evt.getSceneX(), evt.getSceneY());
        return lClickInRelationToArrow.getX() >= 0.0 && lClickInRelationToArrow.getX() <= region.getWidth() && lClickInRelationToArrow.getY() >= 0.0 && lClickInRelationToArrow.getY() <= region.getHeight();
    }

    private void unclickArrows() {
        this.decrementArrow.getStyleClass().remove((Object)"clicked");
        this.incrementArrow.getStyleClass().remove((Object)"clicked");
    }

    private void replaceValueNode() {
        this.valueGroup.getChildren().clear();
        if (!((ListSpinner)this.getSkinnable()).isEditable().booleanValue()) {
            Node lNode = (Node)((ListSpinner)this.getSkinnable()).getCellFactory().call((Object)this.getSkinnable());
            this.valueGroup.setCenter(lNode);
            if (!lNode.getStyleClass().contains((Object)"value")) {
                lNode.getStyleClass().add((Object)"value");
            }
            if (!lNode.getStyleClass().contains((Object)"readonly")) {
                lNode.getStyleClass().add((Object)"readonly");
            }
        } else {
            if (this.textField == null) {
                this.textField = new TextField();
                this.textField.getStyleClass().add((Object)"value");
                this.textField.getStyleClass().add((Object)"editable");
                this.textField.focusedProperty().addListener(new InvalidationListener(){

                    public void invalidated(Observable arg0) {
                        if (!ListSpinnerCaspianSkin.this.textField.isFocused()) {
                            ListSpinnerCaspianSkin.this.parse(ListSpinnerCaspianSkin.this.textField);
                        }
                    }
                });
                this.textField.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                    public void handle(ActionEvent evt) {
                        ListSpinnerCaspianSkin.this.parse(ListSpinnerCaspianSkin.this.textField);
                    }
                });
                this.textField.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                    public void handle(KeyEvent t) {
                        if (t.getCode() == KeyCode.ESCAPE) {
                            ListSpinnerCaspianSkin.this.refreshValue();
                        }
                    }
                });
                this.textField.alignmentProperty().bind(((ListSpinner)this.getSkinnable()).alignmentProperty());
            }
            this.valueGroup.setCenter((Node)this.textField);
        }
        this.alignValue();
    }

    private void alignValue() {
        BorderPane.setAlignment((Node)((Node)this.valueGroup.getChildren().get(0)), (Pos)((Pos)((ListSpinner)this.getSkinnable()).alignmentProperty().getValue()));
    }

    protected void parse(TextField textField) {
        String lText = textField.getText();
        ((ListSpinnerBehavior)this.getBehavior()).parse(lText);
        this.refreshValue();
    }

    private void layoutGridPane() {
        ListSpinner.ArrowDirection lArrowDirection = ((ListSpinner)this.getSkinnable()).getArrowDirection();
        ListSpinner.ArrowPosition lArrowPosition = ((ListSpinner)this.getSkinnable()).getArrowPosition();
        ColumnConstraints lColumnValue = new ColumnConstraints(this.valueGroup.getMinWidth(), this.valueGroup.getPrefWidth(), Double.MAX_VALUE);
        lColumnValue.setHgrow(Priority.ALWAYS);
        ColumnConstraints lColumnArrow = new ColumnConstraints(10.0);
        RowConstraints lRowValue = new RowConstraints(this.valueGroup.getMinHeight(), this.valueGroup.getPrefHeight(), Double.MAX_VALUE);
        lRowValue.setVgrow(Priority.ALWAYS);
        RowConstraints lRowArrow = new RowConstraints(10.0);
        this.gridPane.getChildren().clear();
        this.gridPane.getColumnConstraints().clear();
        this.gridPane.getRowConstraints().clear();
        if (lArrowDirection == ListSpinner.ArrowDirection.HORIZONTAL) {
            if (lArrowPosition == ListSpinner.ArrowPosition.LEADING) {
                this.gridPane.setHgap(3.0);
                this.gridPane.setVgap(0.0);
                this.gridPane.add((Node)this.decrementArrow, 0, 0);
                this.gridPane.add((Node)this.incrementArrow, 1, 0);
                this.gridPane.add((Node)this.valueGroup, 2, 0);
                this.gridPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{lColumnArrow, lColumnArrow, lColumnValue});
            }
            if (lArrowPosition == ListSpinner.ArrowPosition.TRAILING) {
                this.gridPane.setHgap(3.0);
                this.gridPane.setVgap(0.0);
                this.gridPane.add((Node)this.valueGroup, 0, 0);
                this.gridPane.add((Node)this.decrementArrow, 1, 0);
                this.gridPane.add((Node)this.incrementArrow, 2, 0);
                this.gridPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{lColumnValue, lColumnArrow, lColumnArrow});
            }
            if (lArrowPosition == ListSpinner.ArrowPosition.SPLIT) {
                this.gridPane.setHgap(3.0);
                this.gridPane.setVgap(0.0);
                this.gridPane.add((Node)this.decrementArrow, 0, 0);
                this.gridPane.add((Node)this.valueGroup, 1, 0);
                this.gridPane.add((Node)this.incrementArrow, 2, 0);
                this.gridPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{lColumnArrow, lColumnValue, lColumnArrow});
            }
        }
        if (lArrowDirection == ListSpinner.ArrowDirection.VERTICAL) {
            if (lArrowPosition == ListSpinner.ArrowPosition.LEADING) {
                this.gridPane.setHgap(3.0);
                this.gridPane.setVgap(0.0);
                this.gridPane.add((Node)this.incrementArrow, 0, 0);
                this.gridPane.add((Node)this.decrementArrow, 0, 1);
                this.gridPane.add((Node)this.valueGroup, 1, 0, 1, 2);
                this.gridPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{lColumnArrow, lColumnValue});
                this.gridPane.getRowConstraints().addAll((Object[])new RowConstraints[]{lRowArrow, lRowArrow});
            }
            if (lArrowPosition == ListSpinner.ArrowPosition.TRAILING) {
                this.gridPane.setHgap(3.0);
                this.gridPane.setVgap(0.0);
                this.gridPane.add((Node)this.valueGroup, 0, 0, 1, 2);
                this.gridPane.add((Node)this.incrementArrow, 1, 0);
                this.gridPane.add((Node)this.decrementArrow, 1, 1);
                this.gridPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{lColumnValue, lColumnArrow});
                this.gridPane.getRowConstraints().addAll((Object[])new RowConstraints[]{lRowArrow, lRowArrow});
            }
            if (lArrowPosition == ListSpinner.ArrowPosition.SPLIT) {
                this.gridPane.setHgap(3.0);
                this.gridPane.setVgap(0.0);
                this.gridPane.add((Node)this.incrementArrow, 0, 0);
                this.gridPane.add((Node)this.valueGroup, 0, 1);
                this.gridPane.add((Node)this.decrementArrow, 0, 2);
                this.gridPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{lColumnValue});
                this.gridPane.getRowConstraints().addAll((Object[])new RowConstraints[]{lRowArrow, lRowValue, lRowArrow});
            }
        }
    }

    private void setArrowCSS() {
        if (((ListSpinner)this.getSkinnable()).getArrowDirection().equals((Object)ListSpinner.ArrowDirection.HORIZONTAL)) {
            this.decrementArrow.getStyleClass().add((Object)"left-arrow");
            this.incrementArrow.getStyleClass().add((Object)"right-arrow");
        } else {
            this.decrementArrow.getStyleClass().add((Object)"down-arrow");
            this.incrementArrow.getStyleClass().add((Object)"up-arrow");
        }
    }
}

