/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.internal.scene.control.skin;

import java.util.ArrayList;
import javafx.animation.Animation;
import javafx.animation.AnimationTimer;
import javafx.animation.FadeTransition;
import javafx.animation.Interpolator;
import javafx.animation.RotateTransition;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Point2D;
import javafx.geometry.VPos;
import javafx.scene.CacheHint;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.effect.InnerShadow;
import javafx.scene.image.ImageView;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.RadialGradient;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Arc;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.Circle;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.shape.StrokeType;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.scene.transform.Transform;
import javafx.util.Duration;
import jfxtras.labs.internal.scene.control.behavior.RadialHalfSBehavior;
import jfxtras.labs.internal.scene.control.skin.GaugeSkinBase;
import jfxtras.labs.scene.control.gauge.Gauge;
import jfxtras.labs.scene.control.gauge.Marker;
import jfxtras.labs.scene.control.gauge.RadialHalfS;
import jfxtras.labs.scene.control.gauge.Section;

public class RadialHalfSSkin
extends GaugeSkinBase<RadialHalfS, RadialHalfSBehavior> {
    private static final Rectangle MIN_SIZE = new Rectangle(38.0, 25.0);
    private static final Rectangle PREF_SIZE = new Rectangle(200.0, 130.0);
    private static final Rectangle MAX_SIZE = new Rectangle(1024.0, 666.0);
    private RadialHalfS control;
    private Rectangle gaugeBounds;
    private Point2D framelessOffset;
    private Group frame;
    private Group background;
    private Group trend;
    private Group sections;
    private Group areas;
    private Group markers;
    private Group titleAndUnit;
    private Group tickmarks;
    private Group glowOff;
    private Group glowOn;
    private ArrayList<Color> glowColors;
    private Group knobs;
    private Group knobsShadow;
    private Group threshold;
    private Group minMeasured;
    private Group maxMeasured;
    private Group pointer;
    private Group pointerShadow;
    private Group bargraphOff;
    private Group bargraphOn;
    private Group ledOff;
    private Group ledOn;
    private Group userLedOff;
    private Group userLedOn;
    private Group foreground;
    private Point2D center;
    private int noOfLeds;
    private ArrayList<Shape> ledsOff;
    private ArrayList<Shape> ledsOn;
    private DoubleProperty currentValue;
    private DoubleProperty formerValue;
    private FadeTransition glowPulse;
    private RotateTransition pointerRotation;
    private AnimationTimer ledTimer;
    private boolean ledOnVisible;
    private long lastLedTimerCall;
    private AnimationTimer userLedTimer;
    private boolean userLedOnVisible;
    private long lastUserLedTimerCall;
    private boolean isDirty;
    private boolean initialized;

    public RadialHalfSSkin(RadialHalfS CONTROL) {
        super(CONTROL, new RadialHalfSBehavior(CONTROL));
        this.control = CONTROL;
        this.gaugeBounds = new Rectangle(200.0, 130.0);
        this.framelessOffset = new Point2D(0.0, 0.0);
        this.center = new Point2D(0.0, 0.0);
        this.frame = new Group();
        this.background = new Group();
        this.trend = new Group();
        this.sections = new Group();
        this.areas = new Group();
        this.markers = new Group();
        this.titleAndUnit = new Group();
        this.tickmarks = new Group();
        this.glowOff = new Group();
        this.glowOn = new Group();
        this.glowColors = new ArrayList(4);
        this.knobs = new Group();
        this.knobsShadow = new Group(new Node[]{this.knobs});
        this.threshold = new Group();
        this.minMeasured = new Group();
        this.maxMeasured = new Group();
        this.pointer = new Group();
        this.pointerShadow = new Group(new Node[]{this.pointer});
        this.bargraphOff = new Group();
        this.bargraphOn = new Group();
        this.ledOff = new Group();
        this.ledOn = new Group();
        this.userLedOff = new Group();
        this.userLedOn = new Group();
        this.foreground = new Group();
        this.noOfLeds = 35;
        this.ledsOff = new ArrayList(this.noOfLeds);
        this.ledsOn = new ArrayList(this.noOfLeds);
        this.currentValue = new SimpleDoubleProperty(0.0);
        this.formerValue = new SimpleDoubleProperty(0.0);
        this.glowPulse = new FadeTransition(Duration.millis((double)800.0), (Node)this.glowOn);
        this.pointerRotation = new RotateTransition(Duration.millis((double)this.control.getAnimationDuration()), (Node)this.pointer);
        this.isDirty = false;
        this.ledTimer = new AnimationTimer(){

            public void handle(long NOW) {
                if (NOW > RadialHalfSSkin.this.lastLedTimerCall + RadialHalfSSkin.this.getBlinkInterval()) {
                    RadialHalfSSkin.this.ledOnVisible = (byte)(RadialHalfSSkin.this.ledOnVisible ^ 1);
                    if (RadialHalfSSkin.this.ledOnVisible) {
                        RadialHalfSSkin.this.ledOn.setOpacity(1.0);
                    } else {
                        RadialHalfSSkin.this.ledOn.setOpacity(0.0);
                    }
                    RadialHalfSSkin.this.lastLedTimerCall = NOW;
                }
            }
        };
        this.lastLedTimerCall = 0L;
        this.ledOnVisible = false;
        this.userLedTimer = new AnimationTimer(){

            public void handle(long NOW) {
                if (NOW > RadialHalfSSkin.this.lastUserLedTimerCall + RadialHalfSSkin.this.getBlinkInterval()) {
                    RadialHalfSSkin.this.userLedOnVisible = (byte)(RadialHalfSSkin.this.userLedOnVisible ^ 1);
                    if (RadialHalfSSkin.this.userLedOnVisible) {
                        RadialHalfSSkin.this.userLedOn.setOpacity(1.0);
                    } else {
                        RadialHalfSSkin.this.userLedOn.setOpacity(0.0);
                    }
                    RadialHalfSSkin.this.lastUserLedTimerCall = NOW;
                }
            }
        };
        this.lastUserLedTimerCall = 0L;
        this.userLedOnVisible = false;
        this.initialized = false;
        this.init();
    }

    private void init() {
        if (this.control.getPrefWidth() < 0.0 || this.control.getPrefHeight() < 0.0) {
            this.control.setPrefSize(PREF_SIZE.getWidth(), PREF_SIZE.getHeight());
        }
        if (this.control.getMinWidth() < 0.0 | this.control.getMinHeight() < 0.0) {
            this.control.setMinSize(50.0, 50.0);
        }
        if (this.control.getMaxWidth() < 0.0 | this.control.getMaxHeight() < 0.0) {
            this.control.setMaxSize(1024.0, 1024.0);
        }
        this.control.recalcRange();
        this.glowColors.clear();
        Color GLOW_COLOR = this.control.getGlowColor();
        this.glowColors.add(Color.hsb((double)GLOW_COLOR.getHue(), (double)0.46, (double)0.96, (double)0.0));
        this.glowColors.add(Color.hsb((double)GLOW_COLOR.getHue(), (double)0.67, (double)0.9, (double)1.0));
        this.glowColors.add(Color.hsb((double)GLOW_COLOR.getHue(), (double)1.0, (double)1.0, (double)1.0));
        this.glowColors.add(Color.hsb((double)GLOW_COLOR.getHue(), (double)0.67, (double)0.9, (double)1.0));
        this.glowPulse.setFromValue(0.1);
        this.glowPulse.setToValue(1.0);
        this.glowPulse.setInterpolator(Interpolator.SPLINE((double)0.0, (double)0.0, (double)0.4, (double)1.0));
        this.glowPulse.setInterpolator(Interpolator.EASE_OUT);
        this.glowPulse.setCycleCount(-1);
        this.glowPulse.setAutoReverse(true);
        if (this.control.isPulsatingGlow() && this.control.isGlowVisible()) {
            if (!this.glowOn.isVisible()) {
                this.glowOn.setVisible(true);
            }
            if (this.glowOn.getOpacity() < 1.0) {
                this.glowOn.setOpacity(1.0);
            }
            this.glowPulse.play();
        } else {
            this.glowPulse.stop();
            this.glowOn.setOpacity(0.0);
        }
        if (this.control.isGlowVisible()) {
            this.glowOff.setVisible(true);
            if (this.control.isGlowOn()) {
                this.glowOn.setOpacity(1.0);
            } else {
                this.glowOn.setOpacity(0.0);
            }
        } else {
            this.glowOff.setVisible(false);
            this.glowOn.setOpacity(0.0);
        }
        this.ledOn.setOpacity(0.0);
        if (this.control.isUserLedOn()) {
            this.userLedOn.setOpacity(1.0);
        } else {
            this.userLedOn.setOpacity(0.0);
        }
        if (this.control.isUserLedBlinking()) {
            this.userLedTimer.start();
        }
        if (!this.control.getSections().isEmpty()) {
            this.updateSections();
        }
        if (!this.control.getAreas().isEmpty()) {
            this.updateAreas();
        }
        this.noOfLeds = (int)(this.control.getRadialRange().ANGLE_RANGE / 5.0);
        this.control.recalcRange();
        this.control.setMinMeasuredValue(this.control.getMaxValue());
        this.control.setMaxMeasuredValue(this.control.getMinValue());
        this.addBindings();
        this.addListeners();
        this.calcGaugeBounds();
        this.initialized = true;
        this.repaint();
    }

    private void addBindings() {
        if (this.frame.visibleProperty().isBound()) {
            this.frame.visibleProperty().unbind();
        }
        this.frame.visibleProperty().bind((ObservableValue)this.control.frameVisibleProperty());
        if (this.background.visibleProperty().isBound()) {
            this.background.visibleProperty().unbind();
        }
        this.background.visibleProperty().bind((ObservableValue)this.control.backgroundVisibleProperty());
        if (this.sections.visibleProperty().isBound()) {
            this.sections.visibleProperty().unbind();
        }
        this.sections.visibleProperty().bind((ObservableValue)this.control.sectionsVisibleProperty());
        if (this.areas.visibleProperty().isBound()) {
            this.areas.visibleProperty().unbind();
        }
        this.areas.visibleProperty().bind((ObservableValue)this.control.areasVisibleProperty());
        if (this.bargraphOff.visibleProperty().isBound()) {
            this.bargraphOff.visibleProperty().unbind();
        }
        this.bargraphOff.visibleProperty().bind((ObservableValue)this.control.bargraphProperty());
        if (this.bargraphOn.visibleProperty().isBound()) {
            this.bargraphOn.visibleProperty().unbind();
        }
        this.bargraphOn.visibleProperty().bind((ObservableValue)this.control.bargraphProperty());
        this.pointer.setVisible(!this.bargraphOff.isVisible());
        this.knobs.setVisible(!this.bargraphOff.isVisible());
        if (this.bargraphOff.isVisible()) {
            this.areas.setOpacity(0.0);
            this.sections.setOpacity(0.0);
        } else {
            this.areas.setOpacity(1.0);
            this.sections.setOpacity(1.0);
        }
        if (this.markers.visibleProperty().isBound()) {
            this.markers.visibleProperty().unbind();
        }
        this.markers.visibleProperty().bind((ObservableValue)this.control.markersVisibleProperty());
        if (this.ledOff.visibleProperty().isBound()) {
            this.ledOff.visibleProperty().unbind();
        }
        this.ledOff.visibleProperty().bind((ObservableValue)this.control.ledVisibleProperty());
        if (this.ledOn.visibleProperty().isBound()) {
            this.ledOn.visibleProperty().unbind();
        }
        this.ledOn.visibleProperty().bind((ObservableValue)this.control.ledVisibleProperty());
        if (this.userLedOff.visibleProperty().isBound()) {
            this.userLedOff.visibleProperty().unbind();
        }
        this.userLedOff.visibleProperty().bind((ObservableValue)this.control.userLedVisibleProperty());
        if (this.userLedOn.visibleProperty().isBound()) {
            this.userLedOn.visibleProperty().unbind();
        }
        this.userLedOn.visibleProperty().bind((ObservableValue)this.control.userLedVisibleProperty());
        if (this.threshold.visibleProperty().isBound()) {
            this.threshold.visibleProperty().unbind();
        }
        this.threshold.visibleProperty().bind((ObservableValue)this.control.thresholdVisibleProperty());
        if (this.minMeasured.visibleProperty().isBound()) {
            this.minMeasured.visibleProperty().unbind();
        }
        this.minMeasured.visibleProperty().bind((ObservableValue)this.control.minMeasuredValueVisibleProperty());
        if (this.maxMeasured.visibleProperty().isBound()) {
            this.maxMeasured.visibleProperty().unbind();
        }
        this.maxMeasured.visibleProperty().bind((ObservableValue)this.control.maxMeasuredValueVisibleProperty());
        if (this.foreground.visibleProperty().isBound()) {
            this.foreground.visibleProperty().unbind();
        }
        this.foreground.visibleProperty().bind((ObservableValue)this.control.foregroundVisibleProperty());
        if (this.trend.visibleProperty().isBound()) {
            this.trend.visibleProperty().unbind();
        }
        this.trend.visibleProperty().bind((ObservableValue)this.control.trendVisibleProperty());
    }

    private void addListeners() {
        this.control.getAreas().addListener(new InvalidationListener(){

            public void invalidated(Observable observable) {
                RadialHalfSSkin.this.updateAreas();
                RadialHalfSSkin.this.drawCircularAreas(RadialHalfSSkin.this.control, RadialHalfSSkin.this.areas, RadialHalfSSkin.this.gaugeBounds);
            }
        });
        this.control.getSections().addListener(new InvalidationListener(){

            public void invalidated(Observable observable) {
                RadialHalfSSkin.this.updateSections();
                RadialHalfSSkin.this.drawCircularSections(RadialHalfSSkin.this.control, RadialHalfSSkin.this.sections, RadialHalfSSkin.this.gaugeBounds);
            }
        });
        this.control.getMarkers().addListener(new InvalidationListener(){

            public void invalidated(Observable observable) {
                RadialHalfSSkin.this.drawCircularIndicators(RadialHalfSSkin.this.control, RadialHalfSSkin.this.markers, RadialHalfSSkin.this.center, RadialHalfSSkin.this.gaugeBounds);
            }
        });
        this.control.valueProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> ov, Number oldValue, Number newValue) {
                RadialHalfSSkin.this.formerValue.set(oldValue.doubleValue() < RadialHalfSSkin.this.control.getMinValue() ? RadialHalfSSkin.this.control.getMinValue() : oldValue.doubleValue());
                if (RadialHalfSSkin.this.pointerRotation.getStatus() != Animation.Status.STOPPED) {
                    RadialHalfSSkin.this.pointerRotation.stop();
                }
                if (newValue.doubleValue() > oldValue.doubleValue() - RadialHalfSSkin.this.control.getRedrawToleranceValue() && newValue.doubleValue() < oldValue.doubleValue() + RadialHalfSSkin.this.control.getRedrawToleranceValue()) {
                    return;
                }
                if (RadialHalfSSkin.this.control.isValueAnimationEnabled()) {
                    RadialHalfSSkin.this.pointerRotation.setFromAngle(-(RadialHalfSSkin.this.formerValue.doubleValue() - RadialHalfSSkin.this.control.getMinValue()) * RadialHalfSSkin.this.control.getAngleStep());
                    RadialHalfSSkin.this.pointerRotation.setToAngle(-(newValue.doubleValue() - RadialHalfSSkin.this.control.getMinValue()) * RadialHalfSSkin.this.control.getAngleStep());
                    RadialHalfSSkin.this.pointerRotation.setInterpolator(Interpolator.SPLINE((double)0.5, (double)0.4, (double)0.4, (double)1.0));
                    RadialHalfSSkin.this.pointerRotation.play();
                } else {
                    RadialHalfSSkin.this.pointer.setRotate(-(newValue.doubleValue() - RadialHalfSSkin.this.control.getMinValue()) * RadialHalfSSkin.this.control.getAngleStep());
                }
                RadialHalfSSkin.this.checkMarkers(RadialHalfSSkin.this.control, oldValue.doubleValue(), newValue.doubleValue());
                if (RadialHalfSSkin.this.control.isSectionsHighlighting()) {
                    InnerShadow SECTION_INNER_GLOW = new InnerShadow();
                    SECTION_INNER_GLOW.setBlurType(BlurType.GAUSSIAN);
                    DropShadow SECTION_GLOW = new DropShadow();
                    SECTION_GLOW.setWidth(0.05 * RadialHalfSSkin.this.gaugeBounds.getWidth());
                    SECTION_GLOW.setHeight(0.05 * RadialHalfSSkin.this.gaugeBounds.getHeight());
                    SECTION_GLOW.setBlurType(BlurType.GAUSSIAN);
                    for (Section section : RadialHalfSSkin.this.control.getSections()) {
                        Shape currentSection = section.getSectionArea();
                        if (section.contains(newValue.doubleValue())) {
                            SECTION_INNER_GLOW.setColor(section.getColor().darker());
                            SECTION_GLOW.setInput((Effect)SECTION_INNER_GLOW);
                            SECTION_GLOW.setColor(section.getColor().brighter());
                            currentSection.setEffect((Effect)SECTION_GLOW);
                            continue;
                        }
                        currentSection.setEffect(null);
                    }
                }
                if (RadialHalfSSkin.this.control.isAreasHighlighting()) {
                    InnerShadow AREA_INNER_GLOW = new InnerShadow();
                    AREA_INNER_GLOW.setBlurType(BlurType.GAUSSIAN);
                    DropShadow AREA_GLOW = new DropShadow();
                    AREA_GLOW.setWidth(0.05 * RadialHalfSSkin.this.gaugeBounds.getWidth());
                    AREA_GLOW.setHeight(0.05 * RadialHalfSSkin.this.gaugeBounds.getHeight());
                    AREA_GLOW.setBlurType(BlurType.GAUSSIAN);
                    for (Section area : RadialHalfSSkin.this.control.getAreas()) {
                        Shape currentArea = area.getFilledArea();
                        if (area.contains(newValue.doubleValue())) {
                            AREA_INNER_GLOW.setColor(area.getColor().darker());
                            AREA_GLOW.setInput((Effect)AREA_INNER_GLOW);
                            AREA_GLOW.setColor(area.getColor().brighter());
                            currentArea.setEffect((Effect)AREA_GLOW);
                            continue;
                        }
                        currentArea.setEffect(null);
                    }
                }
            }
        });
        this.pointer.rotateProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> ov, Number oldValue, Number newValue) {
                RadialHalfSSkin.this.currentValue.set(-newValue.doubleValue() / RadialHalfSSkin.this.control.getAngleStep() + RadialHalfSSkin.this.control.getMinValue());
                if (RadialHalfSSkin.this.bargraphOff.isVisible()) {
                    int CURRENT_LED_INDEX;
                    int CALC_CURRENT_INDEX = newValue.intValue() / 5 * -1;
                    int CALC_FORMER_INDEX = oldValue.intValue() / 5 * -1;
                    int n = CALC_CURRENT_INDEX < 0 ? 0 : (CURRENT_LED_INDEX = CALC_CURRENT_INDEX >= RadialHalfSSkin.this.noOfLeds ? RadialHalfSSkin.this.noOfLeds : CALC_CURRENT_INDEX);
                    int FORMER_LED_INDEX = CALC_FORMER_INDEX < 0 ? 0 : (CALC_FORMER_INDEX >= RadialHalfSSkin.this.noOfLeds ? RadialHalfSSkin.this.noOfLeds - 1 : CALC_FORMER_INDEX);
                    int THRESHOLD_LED_INDEX = (int)(RadialHalfSSkin.this.control.getThreshold() * RadialHalfSSkin.this.control.getAngleStep() / 5.0);
                    if (Double.compare(RadialHalfSSkin.this.control.getValue(), RadialHalfSSkin.this.formerValue.doubleValue()) >= 0) {
                        for (int i = FORMER_LED_INDEX; i < CURRENT_LED_INDEX; ++i) {
                            ((Shape)RadialHalfSSkin.this.ledsOn.get(i)).setVisible(true);
                        }
                    } else {
                        for (int i = FORMER_LED_INDEX; i > CURRENT_LED_INDEX; --i) {
                            ((Shape)RadialHalfSSkin.this.ledsOn.get(i)).setVisible(false);
                        }
                    }
                    if (RadialHalfSSkin.this.control.isThresholdVisible()) {
                        ((Shape)RadialHalfSSkin.this.ledsOn.get(THRESHOLD_LED_INDEX)).setVisible(true);
                        ((Shape)RadialHalfSSkin.this.ledsOn.get(THRESHOLD_LED_INDEX)).getStyleClass().clear();
                        ((Shape)RadialHalfSSkin.this.ledsOn.get(THRESHOLD_LED_INDEX)).getStyleClass().add((Object)"bargraph-threshold");
                    }
                }
                if (Double.compare(RadialHalfSSkin.this.currentValue.get(), RadialHalfSSkin.this.control.getMinMeasuredValue()) < 0) {
                    RadialHalfSSkin.this.control.setMinMeasuredValue(RadialHalfSSkin.this.currentValue.get());
                } else if (Double.compare(RadialHalfSSkin.this.currentValue.get(), RadialHalfSSkin.this.control.getMaxMeasuredValue()) > 0) {
                    RadialHalfSSkin.this.control.setMaxMeasuredValue(RadialHalfSSkin.this.currentValue.get());
                }
                if (RadialHalfSSkin.this.control.isThresholdBehaviorInverted()) {
                    RadialHalfSSkin.this.control.setThresholdExceeded(RadialHalfSSkin.this.currentValue.get() < RadialHalfSSkin.this.control.getThreshold());
                } else {
                    RadialHalfSSkin.this.control.setThresholdExceeded(RadialHalfSSkin.this.currentValue.get() > RadialHalfSSkin.this.control.getThreshold());
                }
                if (!RadialHalfSSkin.this.control.isThresholdExceeded()) {
                    RadialHalfSSkin.this.ledOn.setOpacity(0.0);
                }
            }
        });
    }

    protected void handleControlPropertyChanged(String PROPERTY) {
        super.handleControlPropertyChanged(PROPERTY);
        if ("ANIMATION_DURATION".equals(PROPERTY)) {
            this.pointerRotation.setDuration(Duration.millis((double)this.control.getAnimationDuration()));
        } else if ("RADIAL_RANGE".equals(PROPERTY)) {
            this.noOfLeds = (int)(this.control.getRadialRange().ANGLE_RANGE / 5.0);
            this.isDirty = true;
        } else if ("FRAME_DESIGN".equals(PROPERTY)) {
            this.drawFrame();
        } else if ("BACKGROUND_DESIGN".equals(PROPERTY)) {
            this.drawBackground();
            this.drawCircularTickmarks(this.control, this.tickmarks, this.center, this.gaugeBounds);
        } else if ("KNOB_DESIGN".equals(PROPERTY)) {
            this.drawCircularKnobs(this.control, this.knobs, this.center, this.gaugeBounds);
        } else if ("KNOB_COLOR".equals(PROPERTY)) {
            this.drawCircularKnobs(this.control, this.knobs, this.center, this.gaugeBounds);
        } else if ("POINTER_TYPE".equals(PROPERTY)) {
            this.drawPointer();
        } else if ("VALUE_COLOR".equals(PROPERTY)) {
            this.drawPointer();
        } else if ("THRESHOLD_COLOR".equals(PROPERTY)) {
            int THRESHOLD_LED_INDEX = (int)(this.control.getThreshold() * this.control.getAngleStep() / 5.0);
            this.ledsOn.get(THRESHOLD_LED_INDEX).getStyleClass().clear();
            this.ledsOn.get(THRESHOLD_LED_INDEX).getStyleClass().add((Object)"bargraph-threshold");
        } else if ("FOREGROUND_TYPE".equals(PROPERTY)) {
            this.drawForeground();
        } else if ("USER_LED_BLINKING".equals(PROPERTY)) {
            if (this.userLedOff.isVisible() && this.userLedOn.isVisible()) {
                if (this.control.isUserLedBlinking()) {
                    this.userLedTimer.start();
                } else {
                    this.userLedTimer.stop();
                    this.userLedOn.setOpacity(0.0);
                }
            }
        } else if ("LED_BLINKING".equals(PROPERTY)) {
            if (this.ledOff.isVisible() && this.ledOn.isVisible()) {
                if (this.control.isLedBlinking()) {
                    this.ledTimer.start();
                } else {
                    this.ledTimer.stop();
                    this.ledOn.setOpacity(0.0);
                }
            }
        } else if ("GLOW_COLOR".equals(PROPERTY)) {
            this.glowColors.clear();
            Color GLOW_COLOR = this.control.getGlowColor();
            this.glowColors.add(Color.hsb((double)GLOW_COLOR.getHue(), (double)0.46, (double)0.96, (double)0.0));
            this.glowColors.add(Color.hsb((double)GLOW_COLOR.getHue(), (double)0.67, (double)0.9, (double)1.0));
            this.glowColors.add(Color.hsb((double)GLOW_COLOR.getHue(), (double)1.0, (double)1.0, (double)1.0));
            this.glowColors.add(Color.hsb((double)GLOW_COLOR.getHue(), (double)0.67, (double)0.9, (double)1.0));
            this.drawGlowOn();
        } else if ("GLOW_VISIBILITY".equals(PROPERTY)) {
            this.glowOff.setVisible(this.control.isGlowVisible());
            if (!this.control.isGlowVisible()) {
                this.glowOn.setOpacity(0.0);
            }
        } else if ("GLOW_ON".equals(PROPERTY)) {
            if (this.glowOff.isVisible() && this.control.isGlowOn()) {
                this.glowOn.setOpacity(1.0);
                this.glowOff.setVisible(true);
            } else {
                this.glowOff.setVisible(true);
                this.glowOn.setOpacity(0.0);
            }
        } else if ("PULSATING_GLOW".equals(PROPERTY)) {
            if (this.control.isPulsatingGlow() && this.control.isGlowVisible()) {
                if (!this.glowOn.isVisible()) {
                    this.glowOn.setVisible(true);
                }
                if (this.glowOn.getOpacity() < 1.0) {
                    this.glowOn.setOpacity(1.0);
                }
                this.glowPulse.play();
            } else {
                this.glowPulse.stop();
                this.glowOn.setOpacity(0.0);
            }
        } else if ("TICKMARKS".equals(PROPERTY)) {
            this.drawCircularTickmarks(this.control, this.tickmarks, this.center, this.gaugeBounds);
        } else if ("MIN_MEASURED_VALUE".equals(PROPERTY)) {
            double ZERO_OFFSET = -90.0 + this.control.getRadialRange().ROTATION_OFFSET;
            this.minMeasured.setRotate(ZERO_OFFSET - (this.control.getMinMeasuredValue() - this.control.getMinValue()) * this.control.getAngleStep());
        } else if ("MAX_MEASURED_VALUE".equals(PROPERTY)) {
            double ZERO_OFFSET = -90.0 + this.control.getRadialRange().ROTATION_OFFSET;
            this.maxMeasured.setRotate(ZERO_OFFSET - (this.control.getMaxMeasuredValue() - this.control.getMinValue()) * this.control.getAngleStep());
        } else if ("TREND".equals(PROPERTY)) {
            this.drawCircularTrend(this.control, this.trend, this.gaugeBounds);
        } else if ("SIMPLE_GRADIENT_BASE".equals(PROPERTY)) {
            this.isDirty = true;
        } else if ("GAUGE_MODEL".equals(PROPERTY)) {
            this.addBindings();
            this.repaint();
        } else if ("STYLE_MODEL".equals(PROPERTY)) {
            this.addBindings();
            this.repaint();
        } else if ("THRESHOLD_EXCEEDED".equals(PROPERTY)) {
            if (this.control.isThresholdExceeded()) {
                this.ledTimer.start();
            } else {
                this.ledTimer.stop();
            }
        } else if ("PREF_WIDTH".equals(PROPERTY)) {
            this.repaint();
        } else if ("PREF_HEIGHT".equals(PROPERTY)) {
            this.repaint();
        } else if ("AREAS".equals(PROPERTY)) {
            this.updateAreas();
            this.drawCircularAreas(this.control, this.areas, this.gaugeBounds);
        } else if ("SECTIONS".equals(PROPERTY)) {
            this.updateSections();
            this.drawCircularSections(this.control, this.sections, this.gaugeBounds);
        } else if ("MARKERS".equals(PROPERTY)) {
            this.drawCircularIndicators(this.control, this.markers, this.center, this.gaugeBounds);
        }
    }

    public void repaint() {
        this.isDirty = true;
        this.requestLayout();
    }

    @Override
    public void layoutChildren() {
        if (!this.isDirty) {
            return;
        }
        if (!this.initialized) {
            this.init();
        }
        if (this.control.getScene() != null) {
            this.calcGaugeBounds();
            this.setTranslateX(this.framelessOffset.getX());
            this.setTranslateY(this.framelessOffset.getY());
            this.center = new Point2D(this.gaugeBounds.getWidth() * 0.5, this.gaugeBounds.getWidth() * 0.15);
            this.drawFrame();
            this.drawBackground();
            this.drawCircularTrend(this.control, this.trend, this.gaugeBounds);
            this.updateSections();
            this.drawSections();
            this.updateAreas();
            this.drawAreas();
            this.drawTitleAndUnit();
            this.drawCircularTickmarks(this.control, this.tickmarks, this.center, this.gaugeBounds);
            this.drawCircularLed(this.control, this.ledOff, this.ledOn, this.gaugeBounds);
            this.drawCircularUserLed(this.control, this.userLedOff, this.userLedOn, this.gaugeBounds);
            this.drawThreshold();
            this.drawGlowOff();
            this.drawGlowOn();
            this.drawMinMeasuredIndicator();
            this.drawMaxMeasuredIndicator();
            this.drawIndicators();
            this.drawPointer();
            this.bargraphOff.getTransforms().clear();
            this.bargraphOff.setTranslateY(-this.gaugeBounds.getWidth() * 0.35);
            this.drawCircularBargraph(this.control, this.bargraphOff, this.noOfLeds, this.ledsOff, false, true, new Point2D(this.center.getX(), this.gaugeBounds.getWidth() * 0.5), this.gaugeBounds);
            this.bargraphOn.getTransforms().clear();
            this.bargraphOn.setTranslateY(-this.gaugeBounds.getWidth() * 0.35);
            this.drawCircularBargraph(this.control, this.bargraphOn, this.noOfLeds, this.ledsOn, true, false, new Point2D(this.center.getX(), this.gaugeBounds.getWidth() * 0.5), this.gaugeBounds);
            this.drawCircularKnobs(this.control, this.knobs, this.center, this.gaugeBounds);
            this.drawForeground();
            if (this.control.isPointerShadowEnabled() && !this.control.isPointerGlowEnabled()) {
                this.addDropShadow(this.control, new Node[]{this.knobs, this.pointerShadow});
            }
            this.getChildren().setAll((Object[])new Node[]{this.frame, this.background, this.sections, this.areas, this.trend, this.ledOff, this.ledOn, this.userLedOff, this.userLedOn, this.titleAndUnit, this.tickmarks, this.threshold, this.glowOff, this.glowOn, this.pointerShadow, this.bargraphOff, this.bargraphOn, this.minMeasured, this.maxMeasured, this.markers, this.knobsShadow, this.foreground});
        }
        this.isDirty = false;
        super.layoutChildren();
    }

    public RadialHalfS getSkinnable() {
        return this.control;
    }

    public void dispose() {
        this.control = null;
    }

    @Override
    protected double computePrefWidth(double HEIGHT) {
        double prefWidth = PREF_SIZE.getWidth();
        if (HEIGHT != -1.0) {
            prefWidth = Math.max(0.0, HEIGHT - this.getInsets().getLeft() - this.getInsets().getRight()) * 1.5384615385;
        }
        return super.computePrefWidth(prefWidth);
    }

    @Override
    protected double computePrefHeight(double WIDTH) {
        double prefHeight = PREF_SIZE.getHeight();
        if (WIDTH != -1.0) {
            prefHeight = Math.max(0.0, WIDTH - this.getInsets().getTop() - this.getInsets().getBottom()) / 1.5384615385;
        }
        return super.computePrefWidth(prefHeight);
    }

    @Override
    protected double computeMinWidth(double WIDTH) {
        return super.computeMinWidth(Math.max(MIN_SIZE.getWidth(), WIDTH - this.getInsets().getLeft() - this.getInsets().getRight()));
    }

    @Override
    protected double computeMinHeight(double HEIGHT) {
        return super.computeMinHeight(Math.max(MIN_SIZE.getHeight(), HEIGHT - this.getInsets().getTop() - this.getInsets().getBottom()));
    }

    @Override
    protected double computeMaxWidth(double WIDTH) {
        return super.computeMaxWidth(Math.max(MAX_SIZE.getWidth(), WIDTH - this.getInsets().getLeft() - this.getInsets().getRight()));
    }

    @Override
    protected double computeMaxHeight(double HEIGHT) {
        return super.computeMaxHeight(Math.max(MAX_SIZE.getHeight(), HEIGHT - this.getInsets().getTop() - this.getInsets().getBottom()));
    }

    private void calcGaugeBounds() {
        if (this.control.isFrameVisible()) {
            this.gaugeBounds.setWidth(this.control.getPrefWidth());
            this.gaugeBounds.setHeight(this.control.getPrefHeight());
            this.framelessOffset = new Point2D(0.0, 0.0);
        } else {
            this.gaugeBounds.setWidth(this.control.getPrefWidth() * 1.202247191);
            this.gaugeBounds.setHeight(this.control.getPrefHeight() * 1.202247191);
            this.framelessOffset = new Point2D(-this.gaugeBounds.getWidth() * 0.0841121495, -this.gaugeBounds.getWidth() * 0.0841121495);
        }
    }

    private void updateSections() {
        double OUTER_RADIUS = this.control.getPrefWidth() * 0.38;
        double INNER_RADIUS = this.control.isExpandedSections() ? OUTER_RADIUS - this.control.getPrefWidth() * 0.12 : OUTER_RADIUS - this.control.getPrefWidth() * 0.04;
        Circle INNER = new Circle(this.center.getX(), this.center.getY(), INNER_RADIUS);
        for (Section section : this.control.getSections()) {
            double SECTION_START = section.getStart() < this.control.getMinValue() ? this.control.getMinValue() : section.getStart();
            double SECTION_STOP = section.getStop() > this.control.getMaxValue() ? this.control.getMaxValue() : section.getStop();
            double ANGLE_START = this.control.getRadialRange().SECTIONS_OFFSET + SECTION_START * this.control.getAngleStep() - this.control.getMinValue() * this.control.getAngleStep();
            double ANGLE_EXTEND = (SECTION_STOP - SECTION_START) * this.control.getAngleStep();
            Arc OUTER_ARC = new Arc();
            OUTER_ARC.setType(ArcType.ROUND);
            OUTER_ARC.setCenterX(this.center.getX());
            OUTER_ARC.setCenterY(this.center.getY());
            OUTER_ARC.setRadiusX(OUTER_RADIUS);
            OUTER_ARC.setRadiusY(OUTER_RADIUS);
            OUTER_ARC.setStartAngle(ANGLE_START);
            OUTER_ARC.setLength(ANGLE_EXTEND);
            Shape SECTION = Shape.subtract((Shape)OUTER_ARC, (Shape)INNER);
            section.setSectionArea(SECTION);
        }
    }

    private void updateAreas() {
        double OUTER_RADIUS = this.control.getPrefWidth() * 0.38;
        double INNER_RADIUS = this.control.isExpandedSections() ? this.control.getPrefWidth() * 0.12 : this.control.getPrefWidth() * 0.04;
        double RADIUS = OUTER_RADIUS - INNER_RADIUS;
        for (Section area : this.control.getAreas()) {
            double AREA_START = area.getStart() < this.control.getMinValue() ? this.control.getMinValue() : area.getStart();
            double AREA_STOP = area.getStop() > this.control.getMaxValue() ? this.control.getMaxValue() : area.getStop();
            double ANGLE_START = this.control.getRadialRange().SECTIONS_OFFSET + AREA_START * this.control.getAngleStep() - this.control.getMinValue() * this.control.getAngleStep();
            double ANGLE_EXTEND = (AREA_STOP - AREA_START) * this.control.getAngleStep();
            Arc ARC = new Arc();
            ARC.setType(ArcType.ROUND);
            ARC.setCenterX(this.center.getX());
            ARC.setCenterY(this.center.getY());
            ARC.setRadiusX(RADIUS);
            ARC.setRadiusY(RADIUS);
            ARC.setStartAngle(ANGLE_START);
            ARC.setLength(ANGLE_EXTEND);
            area.setFilledArea((Shape)ARC);
        }
    }

    public void drawFrame() {
        double SIZE = this.control.getPrefWidth() < this.control.getPrefHeight() ? this.control.getPrefWidth() : this.control.getPrefHeight();
        double WIDTH = this.control.getPrefWidth();
        double HEIGHT = this.control.getPrefHeight();
        this.frame.getChildren().clear();
        Path OUTER_FRAME = new Path();
        OUTER_FRAME.setFillRule(FillRule.EVEN_ODD);
        OUTER_FRAME.getElements().add((Object)new MoveTo(WIDTH, 0.23076923076923078 * HEIGHT));
        OUTER_FRAME.getElements().add((Object)new CubicCurveTo(WIDTH, 0.6538461538461539 * HEIGHT, 0.775 * WIDTH, HEIGHT, 0.5 * WIDTH, HEIGHT));
        OUTER_FRAME.getElements().add((Object)new CubicCurveTo(0.225 * WIDTH, HEIGHT, 0.0, 0.6538461538461539 * HEIGHT, 0.0, 0.23076923076923078 * HEIGHT));
        OUTER_FRAME.getElements().add((Object)new CubicCurveTo(0.0, 0.23076923076923078 * HEIGHT, 0.0, 0.0, 0.0, 0.0));
        OUTER_FRAME.getElements().add((Object)new LineTo(WIDTH, 0.0));
        OUTER_FRAME.getElements().add((Object)new CubicCurveTo(WIDTH, 0.0, WIDTH, 0.23076923076923078 * HEIGHT, WIDTH, 0.23076923076923078 * HEIGHT));
        OUTER_FRAME.getElements().add((Object)new ClosePath());
        OUTER_FRAME.setFill((Paint)Color.color((double)0.5176470588, (double)0.5176470588, (double)0.5176470588, (double)1.0));
        OUTER_FRAME.setStroke(null);
        this.frame.getChildren().add((Object)OUTER_FRAME);
        Path INNER_FRAME = new Path();
        INNER_FRAME.setFillRule(FillRule.EVEN_ODD);
        INNER_FRAME.getElements().add((Object)new MoveTo(0.07 * WIDTH, 0.23846153846153847 * HEIGHT));
        INNER_FRAME.getElements().add((Object)new CubicCurveTo(0.07 * WIDTH, 0.23846153846153847 * HEIGHT, 0.07 * WIDTH, 0.1076923076923077 * HEIGHT, 0.07 * WIDTH, 0.1076923076923077 * HEIGHT));
        INNER_FRAME.getElements().add((Object)new LineTo(0.92 * WIDTH, 0.1076923076923077 * HEIGHT));
        INNER_FRAME.getElements().add((Object)new CubicCurveTo(0.92 * WIDTH, 0.1076923076923077 * HEIGHT, 0.92 * WIDTH, 0.23846153846153847 * HEIGHT, 0.92 * WIDTH, 0.23846153846153847 * HEIGHT));
        INNER_FRAME.getElements().add((Object)new CubicCurveTo(0.92 * WIDTH, 0.6 * HEIGHT, 0.73 * WIDTH, 0.8923076923076924 * HEIGHT, 0.495 * WIDTH, 0.8923076923076924 * HEIGHT));
        INNER_FRAME.getElements().add((Object)new CubicCurveTo(0.26 * WIDTH, 0.8923076923076924 * HEIGHT, 0.07 * WIDTH, 0.6 * HEIGHT, 0.07 * WIDTH, 0.23846153846153847 * HEIGHT));
        INNER_FRAME.getElements().add((Object)new ClosePath());
        INNER_FRAME.setFill((Paint)Color.color((double)0.6, (double)0.6, (double)0.6, (double)0.8));
        INNER_FRAME.setStroke(null);
        Path MAIN_FRAME = new Path();
        MAIN_FRAME.setFillRule(FillRule.EVEN_ODD);
        MAIN_FRAME.getElements().add((Object)new MoveTo(0.995 * WIDTH, 0.23076923076923078 * HEIGHT));
        MAIN_FRAME.getElements().add((Object)new CubicCurveTo(0.995 * WIDTH, 0.6538461538461539 * HEIGHT, 0.775 * WIDTH, 0.9923076923076923 * HEIGHT, 0.5 * WIDTH, 0.9923076923076923 * HEIGHT));
        MAIN_FRAME.getElements().add((Object)new CubicCurveTo(0.225 * WIDTH, 0.9923076923076923 * HEIGHT, 0.005 * WIDTH, 0.6538461538461539 * HEIGHT, 0.005 * WIDTH, 0.23076923076923078 * HEIGHT));
        MAIN_FRAME.getElements().add((Object)new CubicCurveTo(0.005 * WIDTH, 0.23076923076923078 * HEIGHT, 0.005 * WIDTH, 0.007692307692307693 * HEIGHT, 0.005 * WIDTH, 0.007692307692307693 * HEIGHT));
        MAIN_FRAME.getElements().add((Object)new LineTo(0.995 * WIDTH, 0.007692307692307693 * HEIGHT));
        MAIN_FRAME.getElements().add((Object)new CubicCurveTo(0.995 * WIDTH, 0.007692307692307693 * HEIGHT, 0.995 * WIDTH, 0.23076923076923078 * HEIGHT, 0.995 * WIDTH, 0.23076923076923078 * HEIGHT));
        MAIN_FRAME.getElements().add((Object)new ClosePath());
        switch (this.control.getFrameDesign()) {
            case GLOSSY_METAL: {
                RadialGradient GLOSSY1_FILL = new RadialGradient(0.0, 0.0, 0.5 * WIDTH, 0.9923076923076923 * HEIGHT, 0.495 * WIDTH, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)0.8235294118, (double)0.8235294118, (double)0.8235294118, (double)1.0)), new Stop(0.95, Color.color((double)0.8235294118, (double)0.8235294118, (double)0.8235294118, (double)1.0)), new Stop(1.0, Color.color((double)0.9960784314, (double)0.9960784314, (double)0.9960784314, (double)1.0))});
                MAIN_FRAME.setFill((Paint)GLOSSY1_FILL);
                MAIN_FRAME.setStroke(null);
                Path GLOSSY2 = new Path();
                GLOSSY2.setFillRule(FillRule.EVEN_ODD);
                GLOSSY2.getElements().add((Object)new MoveTo(0.985 * WIDTH, 0.23076923076923078 * HEIGHT));
                GLOSSY2.getElements().add((Object)new CubicCurveTo(0.985 * WIDTH, 0.6153846153846154 * HEIGHT, 0.775 * WIDTH, 0.9769230769230769 * HEIGHT, 0.5 * WIDTH, 0.9769230769230769 * HEIGHT));
                GLOSSY2.getElements().add((Object)new CubicCurveTo(0.225 * WIDTH, 0.9769230769230769 * HEIGHT, 0.015 * WIDTH, 0.6153846153846154 * HEIGHT, 0.015 * WIDTH, 0.23076923076923078 * HEIGHT));
                GLOSSY2.getElements().add((Object)new CubicCurveTo(0.015 * WIDTH, 0.23076923076923078 * HEIGHT, 0.015 * WIDTH, 0.023076923076923078 * HEIGHT, 0.015 * WIDTH, 0.023076923076923078 * HEIGHT));
                GLOSSY2.getElements().add((Object)new LineTo(0.985 * WIDTH, 0.023076923076923078 * HEIGHT));
                GLOSSY2.getElements().add((Object)new CubicCurveTo(0.985 * WIDTH, 0.023076923076923078 * HEIGHT, 0.985 * WIDTH, 0.23076923076923078 * HEIGHT, 0.985 * WIDTH, 0.23076923076923078 * HEIGHT));
                GLOSSY2.getElements().add((Object)new ClosePath());
                LinearGradient GLOSSY2_FILL = new LinearGradient(0.0, 0.03076923076923077 * HEIGHT, 0.0, 0.9692307692307692 * HEIGHT, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)0.9764705882, (double)0.9764705882, (double)0.9764705882, (double)1.0)), new Stop(0.23, Color.color((double)0.7843137255, (double)0.7647058824, (double)0.7490196078, (double)1.0)), new Stop(0.34, Color.color((double)0.8235294118, (double)0.8235294118, (double)0.8235294118, (double)1.0)), new Stop(0.65, Color.color((double)0.1215686275, (double)0.1215686275, (double)0.1215686275, (double)1.0)), new Stop(0.84, Color.color((double)0.7843137255, (double)0.7607843137, (double)0.7529411765, (double)1.0)), new Stop(1.0, Color.color((double)0.7843137255, (double)0.7607843137, (double)0.7529411765, (double)1.0))});
                GLOSSY2.setFill((Paint)GLOSSY2_FILL);
                GLOSSY2.setStroke(null);
                Path GLOSSY3 = new Path();
                GLOSSY3.setFillRule(FillRule.EVEN_ODD);
                GLOSSY3.getElements().add((Object)new MoveTo(0.935 * WIDTH, 0.23076923076923078 * HEIGHT));
                GLOSSY3.getElements().add((Object)new CubicCurveTo(0.935 * WIDTH, 0.5692307692307692 * HEIGHT, 0.77 * WIDTH, 0.9153846153846154 * HEIGHT, 0.495 * WIDTH, 0.9153846153846154 * HEIGHT));
                GLOSSY3.getElements().add((Object)new CubicCurveTo(0.22 * WIDTH, 0.9153846153846154 * HEIGHT, 0.055 * WIDTH, 0.5615384615384615 * HEIGHT, 0.055 * WIDTH, 0.23076923076923078 * HEIGHT));
                GLOSSY3.getElements().add((Object)new CubicCurveTo(0.055 * WIDTH, 0.23076923076923078 * HEIGHT, 0.055 * WIDTH, 0.08461538461538462 * HEIGHT, 0.055 * WIDTH, 0.08461538461538462 * HEIGHT));
                GLOSSY3.getElements().add((Object)new LineTo(0.935 * WIDTH, 0.08461538461538462 * HEIGHT));
                GLOSSY3.getElements().add((Object)new CubicCurveTo(0.935 * WIDTH, 0.08461538461538462 * HEIGHT, 0.935 * WIDTH, 0.23076923076923078 * HEIGHT, 0.935 * WIDTH, 0.23076923076923078 * HEIGHT));
                GLOSSY3.getElements().add((Object)new ClosePath());
                Color GLOSSY3_FILL = Color.color((double)0.9647058824, (double)0.9647058824, (double)0.9647058824, (double)1.0);
                GLOSSY3.setFill((Paint)GLOSSY3_FILL);
                GLOSSY3.setStroke(null);
                Path GLOSSY4 = new Path();
                GLOSSY4.setFillRule(FillRule.EVEN_ODD);
                GLOSSY4.getElements().add((Object)new MoveTo(0.065 * WIDTH, 0.23846153846153847 * HEIGHT));
                GLOSSY4.getElements().add((Object)new CubicCurveTo(0.065 * WIDTH, 0.23846153846153847 * HEIGHT, 0.065 * WIDTH, 0.1 * HEIGHT, 0.065 * WIDTH, 0.1 * HEIGHT));
                GLOSSY4.getElements().add((Object)new LineTo(0.925 * WIDTH, 0.1 * HEIGHT));
                GLOSSY4.getElements().add((Object)new CubicCurveTo(0.925 * WIDTH, 0.1 * HEIGHT, 0.925 * WIDTH, 0.23846153846153847 * HEIGHT, 0.925 * WIDTH, 0.23846153846153847 * HEIGHT));
                GLOSSY4.getElements().add((Object)new CubicCurveTo(0.925 * WIDTH, 0.6076923076923076 * HEIGHT, 0.73 * WIDTH, 0.9 * HEIGHT, 0.495 * WIDTH, 0.9 * HEIGHT));
                GLOSSY4.getElements().add((Object)new CubicCurveTo(0.26 * WIDTH, 0.9 * HEIGHT, 0.065 * WIDTH, 0.6076923076923076 * HEIGHT, 0.065 * WIDTH, 0.23846153846153847 * HEIGHT));
                GLOSSY4.getElements().add((Object)new ClosePath());
                Color GLOSSY4_FILL = Color.color((double)0.2, (double)0.2, (double)0.2, (double)1.0);
                GLOSSY4.setFill((Paint)GLOSSY4_FILL);
                GLOSSY4.setStroke(null);
                this.frame.getChildren().addAll((Object[])new Node[]{MAIN_FRAME, GLOSSY2, GLOSSY3, GLOSSY4});
                break;
            }
            case DARK_GLOSSY: {
                LinearGradient DARK_GLOSSY1_FILL = new LinearGradient(0.855 * WIDTH, 0.0, 0.1691064222490489 * WIDTH, 1.0552208888476171 * HEIGHT, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)0.6745098039, (double)0.6745098039, (double)0.6784313725, (double)1.0)), new Stop(0.08, Color.color((double)0.9960784314, (double)0.9960784314, (double)1.0, (double)1.0)), new Stop(0.52, Color.BLACK), new Stop(0.55, Color.color((double)0.0196078431, (double)0.0235294118, (double)0.0196078431, (double)1.0)), new Stop(0.84, Color.color((double)0.9725490196, (double)0.9803921569, (double)0.9764705882, (double)1.0)), new Stop(0.99, Color.color((double)0.7058823529, (double)0.7058823529, (double)0.7058823529, (double)1.0)), new Stop(1.0, Color.color((double)0.6980392157, (double)0.6980392157, (double)0.6980392157, (double)1.0))});
                MAIN_FRAME.setFill((Paint)DARK_GLOSSY1_FILL);
                MAIN_FRAME.setStroke(null);
                Path DARK_GLOSSY2 = new Path();
                DARK_GLOSSY2.setFillRule(FillRule.EVEN_ODD);
                DARK_GLOSSY2.getElements().add((Object)new MoveTo(0.985 * WIDTH, 0.23076923076923078 * HEIGHT));
                DARK_GLOSSY2.getElements().add((Object)new CubicCurveTo(0.985 * WIDTH, 0.6153846153846154 * HEIGHT, 0.775 * WIDTH, 0.9769230769230769 * HEIGHT, 0.5 * WIDTH, 0.9769230769230769 * HEIGHT));
                DARK_GLOSSY2.getElements().add((Object)new CubicCurveTo(0.225 * WIDTH, 0.9769230769230769 * HEIGHT, 0.015 * WIDTH, 0.6153846153846154 * HEIGHT, 0.015 * WIDTH, 0.23076923076923078 * HEIGHT));
                DARK_GLOSSY2.getElements().add((Object)new CubicCurveTo(0.015 * WIDTH, 0.23076923076923078 * HEIGHT, 0.015 * WIDTH, 0.023076923076923078 * HEIGHT, 0.015 * WIDTH, 0.023076923076923078 * HEIGHT));
                DARK_GLOSSY2.getElements().add((Object)new LineTo(0.985 * WIDTH, 0.023076923076923078 * HEIGHT));
                DARK_GLOSSY2.getElements().add((Object)new CubicCurveTo(0.985 * WIDTH, 0.023076923076923078 * HEIGHT, 0.985 * WIDTH, 0.23076923076923078 * HEIGHT, 0.985 * WIDTH, 0.23076923076923078 * HEIGHT));
                DARK_GLOSSY2.getElements().add((Object)new ClosePath());
                LinearGradient DARK_GLOSSY2_FILL = new LinearGradient(0.0, 0.023076923076923078 * HEIGHT, 0.0, 0.9769230769230769 * HEIGHT, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)0.9764705882, (double)0.9764705882, (double)0.9764705882, (double)1.0)), new Stop(1.0E-4, Color.BLACK), new Stop(0.41, Color.color((double)0.2588235294, (double)0.2588235294, (double)0.2588235294, (double)1.0)), new Stop(1.0, Color.color((double)0.0509803922, (double)0.0509803922, (double)0.0509803922, (double)1.0))});
                DARK_GLOSSY2.setFill((Paint)DARK_GLOSSY2_FILL);
                DARK_GLOSSY2.setStroke(null);
                Path DARK_GLOSSY3 = new Path();
                DARK_GLOSSY3.setFillRule(FillRule.EVEN_ODD);
                DARK_GLOSSY3.getElements().add((Object)new MoveTo(0.985 * WIDTH, 0.26153846153846155 * HEIGHT));
                DARK_GLOSSY3.getElements().add((Object)new CubicCurveTo(0.985 * WIDTH, 0.26153846153846155 * HEIGHT, 0.985 * WIDTH, 0.023076923076923078 * HEIGHT, 0.985 * WIDTH, 0.023076923076923078 * HEIGHT));
                DARK_GLOSSY3.getElements().add((Object)new LineTo(0.015 * WIDTH, 0.023076923076923078 * HEIGHT));
                DARK_GLOSSY3.getElements().add((Object)new CubicCurveTo(0.015 * WIDTH, 0.023076923076923078 * HEIGHT, 0.015 * WIDTH, 0.23076923076923078 * HEIGHT, 0.015 * WIDTH, 0.23076923076923078 * HEIGHT));
                DARK_GLOSSY3.getElements().add((Object)new CubicCurveTo(0.015 * WIDTH, 0.36153846153846153 * HEIGHT, 0.04 * WIDTH, 0.49230769230769234 * HEIGHT, 0.08 * WIDTH, 0.6 * HEIGHT));
                DARK_GLOSSY3.getElements().add((Object)new CubicCurveTo(0.175 * WIDTH, 0.4153846153846154 * HEIGHT, 0.35 * WIDTH, 0.1076923076923077 * HEIGHT, 0.5 * WIDTH, 0.1076923076923077 * HEIGHT));
                DARK_GLOSSY3.getElements().add((Object)new CubicCurveTo(0.66 * WIDTH, 0.1076923076923077 * HEIGHT, 0.83 * WIDTH, 0.4076923076923077 * HEIGHT, 0.92 * WIDTH, 0.6 * HEIGHT));
                DARK_GLOSSY3.getElements().add((Object)new CubicCurveTo(0.96 * WIDTH, 0.49230769230769234 * HEIGHT, 0.98 * WIDTH, 0.3769230769230769 * HEIGHT, 0.985 * WIDTH, 0.26153846153846155 * HEIGHT));
                DARK_GLOSSY3.getElements().add((Object)new ClosePath());
                LinearGradient DARK_GLOSSY3_FILL = new LinearGradient(0.0, 0.03076923076923077 * HEIGHT, 0.0, 0.6 * HEIGHT, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)0.9764705882, (double)0.9764705882, (double)0.9764705882, (double)1.0)), new Stop(0.26, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.737254902)), new Stop(1.0, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0))});
                DARK_GLOSSY3.setFill((Paint)DARK_GLOSSY3_FILL);
                DARK_GLOSSY3.setStroke(null);
                Path DARK_GLOSSY4 = new Path();
                DARK_GLOSSY4.setFillRule(FillRule.EVEN_ODD);
                DARK_GLOSSY4.getElements().add((Object)new MoveTo(0.065 * WIDTH, 0.23846153846153847 * HEIGHT));
                DARK_GLOSSY4.getElements().add((Object)new CubicCurveTo(0.065 * WIDTH, 0.23846153846153847 * HEIGHT, 0.065 * WIDTH, 0.1 * HEIGHT, 0.065 * WIDTH, 0.1 * HEIGHT));
                DARK_GLOSSY4.getElements().add((Object)new LineTo(0.925 * WIDTH, 0.1 * HEIGHT));
                DARK_GLOSSY4.getElements().add((Object)new CubicCurveTo(0.925 * WIDTH, 0.1 * HEIGHT, 0.925 * WIDTH, 0.23846153846153847 * HEIGHT, 0.925 * WIDTH, 0.23846153846153847 * HEIGHT));
                DARK_GLOSSY4.getElements().add((Object)new CubicCurveTo(0.925 * WIDTH, 0.6076923076923076 * HEIGHT, 0.73 * WIDTH, 0.9 * HEIGHT, 0.495 * WIDTH, 0.9 * HEIGHT));
                DARK_GLOSSY4.getElements().add((Object)new CubicCurveTo(0.26 * WIDTH, 0.9 * HEIGHT, 0.065 * WIDTH, 0.6076923076923076 * HEIGHT, 0.065 * WIDTH, 0.23846153846153847 * HEIGHT));
                DARK_GLOSSY4.getElements().add((Object)new ClosePath());
                LinearGradient DARK_GLOSSY4_FILL = new LinearGradient(0.805 * WIDTH, 0.1 * HEIGHT, 0.1755776747036804 * WIDTH, 1.035117037156343 * HEIGHT, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)0.6745098039, (double)0.6745098039, (double)0.6784313725, (double)1.0)), new Stop(0.07, Color.color((double)0.9568627451, (double)0.9568627451, (double)0.9607843137, (double)1.0)), new Stop(0.08, Color.color((double)0.9960784314, (double)0.9960784314, (double)1.0, (double)1.0)), new Stop(0.52, Color.BLACK), new Stop(0.5201, Color.BLACK), new Stop(0.55, Color.color((double)0.0196078431, (double)0.0235294118, (double)0.0196078431, (double)1.0)), new Stop(0.56, Color.color((double)0.0352941176, (double)0.0392156863, (double)0.0352941176, (double)1.0)), new Stop(0.9, Color.color((double)0.9725490196, (double)0.9803921569, (double)0.9764705882, (double)1.0)), new Stop(0.92, Color.color((double)0.9058823529, (double)0.9137254902, (double)0.9098039216, (double)1.0)), new Stop(1.0, Color.color((double)0.6980392157, (double)0.6980392157, (double)0.6980392157, (double)1.0))});
                DARK_GLOSSY4.setFill((Paint)DARK_GLOSSY4_FILL);
                DARK_GLOSSY4.setStroke(null);
                this.frame.getChildren().addAll((Object[])new Node[]{MAIN_FRAME, DARK_GLOSSY2, DARK_GLOSSY3, DARK_GLOSSY4});
                break;
            }
            default: {
                ImageView IMAGE_VIEW = new ImageView();
                IMAGE_VIEW.setVisible(false);
                MAIN_FRAME.getStyleClass().add((Object)this.control.getFrameDesign().CSS);
                MAIN_FRAME.setStroke(null);
                this.frame.getChildren().addAll((Object[])new Node[]{MAIN_FRAME, INNER_FRAME});
            }
        }
    }

    public void drawBackground() {
        double SIZE = this.gaugeBounds.getWidth() <= this.gaugeBounds.getHeight() ? this.gaugeBounds.getWidth() : this.gaugeBounds.getHeight();
        double WIDTH = this.gaugeBounds.getWidth();
        double HEIGHT = this.gaugeBounds.getHeight();
        this.background.getChildren().clear();
        Rectangle IBOUNDS = new Rectangle(0.0, 0.0, WIDTH, HEIGHT);
        IBOUNDS.setOpacity(0.0);
        IBOUNDS.setStroke(null);
        this.background.getChildren().add((Object)IBOUNDS);
        InnerShadow INNER_SHADOW = new InnerShadow();
        INNER_SHADOW.setWidth(0.2 * SIZE);
        INNER_SHADOW.setHeight(0.2 * SIZE);
        INNER_SHADOW.setOffsetY(0.03 * SIZE);
        INNER_SHADOW.setColor(Color.color((double)0.0, (double)0.0, (double)0.0, (double)0.7));
        INNER_SHADOW.setBlurType(BlurType.GAUSSIAN);
        LinearGradient HL_GRADIENT = new LinearGradient(0.0, 0.0, SIZE, 0.0, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)0.0, (double)0.0, (double)0.0, (double)0.6)), new Stop(0.4, Color.color((double)0.0, (double)0.0, (double)0.0, (double)0.0)), new Stop(0.6, Color.color((double)0.0, (double)0.0, (double)0.0, (double)0.0)), new Stop(1.0, Color.color((double)0.0, (double)0.0, (double)0.0, (double)0.6))});
        Path BACKGROUND = new Path();
        BACKGROUND.setFillRule(FillRule.EVEN_ODD);
        BACKGROUND.getElements().add((Object)new MoveTo(0.075 * WIDTH, 0.23846153846153847 * HEIGHT));
        BACKGROUND.getElements().add((Object)new CubicCurveTo(0.075 * WIDTH, 0.23846153846153847 * HEIGHT, 0.075 * WIDTH, 0.11538461538461539 * HEIGHT, 0.075 * WIDTH, 0.11538461538461539 * HEIGHT));
        BACKGROUND.getElements().add((Object)new LineTo(0.915 * WIDTH, 0.11538461538461539 * HEIGHT));
        BACKGROUND.getElements().add((Object)new CubicCurveTo(0.915 * WIDTH, 0.11538461538461539 * HEIGHT, 0.915 * WIDTH, 0.23846153846153847 * HEIGHT, 0.915 * WIDTH, 0.23846153846153847 * HEIGHT));
        BACKGROUND.getElements().add((Object)new CubicCurveTo(0.915 * WIDTH, 0.5923076923076923 * HEIGHT, 0.725 * WIDTH, 0.8846153846153846 * HEIGHT, 0.495 * WIDTH, 0.8846153846153846 * HEIGHT));
        BACKGROUND.getElements().add((Object)new CubicCurveTo(0.265 * WIDTH, 0.8846153846153846 * HEIGHT, 0.075 * WIDTH, 0.5923076923076923 * HEIGHT, 0.075 * WIDTH, 0.23846153846153847 * HEIGHT));
        BACKGROUND.getElements().add((Object)new ClosePath());
        BACKGROUND.setStroke(null);
        Path CLIP = new Path();
        CLIP.setFillRule(FillRule.EVEN_ODD);
        CLIP.getElements().add((Object)new MoveTo(0.075 * WIDTH, 0.23846153846153847 * HEIGHT));
        CLIP.getElements().add((Object)new CubicCurveTo(0.075 * WIDTH, 0.23846153846153847 * HEIGHT, 0.075 * WIDTH, 0.11538461538461539 * HEIGHT, 0.075 * WIDTH, 0.11538461538461539 * HEIGHT));
        CLIP.getElements().add((Object)new LineTo(0.915 * WIDTH, 0.11538461538461539 * HEIGHT));
        CLIP.getElements().add((Object)new CubicCurveTo(0.915 * WIDTH, 0.11538461538461539 * HEIGHT, 0.915 * WIDTH, 0.23846153846153847 * HEIGHT, 0.915 * WIDTH, 0.23846153846153847 * HEIGHT));
        CLIP.getElements().add((Object)new CubicCurveTo(0.915 * WIDTH, 0.5923076923076923 * HEIGHT, 0.725 * WIDTH, 0.8846153846153846 * HEIGHT, 0.495 * WIDTH, 0.8846153846153846 * HEIGHT));
        CLIP.getElements().add((Object)new CubicCurveTo(0.265 * WIDTH, 0.8846153846153846 * HEIGHT, 0.075 * WIDTH, 0.5923076923076923 * HEIGHT, 0.075 * WIDTH, 0.23846153846153847 * HEIGHT));
        CLIP.getElements().add((Object)new ClosePath());
        switch (this.control.getBackgroundDesign()) {
            default: 
        }
        BACKGROUND.setStyle(this.control.getSimpleGradientBaseColorString());
        BACKGROUND.getStyleClass().add((Object)this.control.getBackgroundDesign().CSS_BACKGROUND);
        BACKGROUND.setEffect((Effect)INNER_SHADOW);
        BACKGROUND.setStroke(null);
        this.background.getChildren().addAll((Object[])new Node[]{BACKGROUND});
    }

    public void drawSections() {
        double SIZE = this.gaugeBounds.getWidth() <= this.gaugeBounds.getHeight() ? this.gaugeBounds.getWidth() : this.gaugeBounds.getHeight();
        double WIDTH = this.gaugeBounds.getWidth();
        double HEIGHT = this.gaugeBounds.getHeight();
        this.sections.getChildren().clear();
        Rectangle IBOUNDS = new Rectangle(0.0, 0.0, WIDTH, HEIGHT);
        IBOUNDS.setOpacity(0.0);
        IBOUNDS.setStroke(null);
        this.sections.getChildren().add((Object)IBOUNDS);
        for (Section section : this.control.getSections()) {
            Shape currentSection = section.getSectionArea();
            currentSection.setFill((Paint)section.getTransparentColor());
            currentSection.setStroke(null);
            this.sections.getChildren().add((Object)currentSection);
        }
    }

    public void drawAreas() {
        double SIZE = this.gaugeBounds.getWidth() <= this.gaugeBounds.getHeight() ? this.gaugeBounds.getWidth() : this.gaugeBounds.getHeight();
        double WIDTH = this.gaugeBounds.getWidth();
        double HEIGHT = this.gaugeBounds.getHeight();
        this.areas.getChildren().clear();
        Rectangle IBOUNDS = new Rectangle(0.0, 0.0, WIDTH, HEIGHT);
        IBOUNDS.setOpacity(0.0);
        IBOUNDS.setStroke(null);
        this.areas.getChildren().add((Object)IBOUNDS);
        for (Section area : this.control.getAreas()) {
            Shape currentArea = area.getFilledArea();
            currentArea.setFill((Paint)area.getTransparentColor());
            currentArea.setStroke(null);
            this.areas.getChildren().add((Object)currentArea);
        }
    }

    public void drawTitleAndUnit() {
        double SIZE = this.gaugeBounds.getWidth() <= this.gaugeBounds.getHeight() ? this.gaugeBounds.getWidth() : this.gaugeBounds.getHeight();
        double WIDTH = this.gaugeBounds.getWidth();
        double HEIGHT = this.gaugeBounds.getHeight();
        this.titleAndUnit.getChildren().clear();
        Rectangle IBOUNDS = new Rectangle(0.0, 0.0, WIDTH, HEIGHT);
        IBOUNDS.setOpacity(0.0);
        IBOUNDS.setStroke(null);
        this.titleAndUnit.getChildren().add((Object)IBOUNDS);
        Font TITLE_FONT = Font.font((String)this.control.getTitleFont(), (FontWeight)FontWeight.NORMAL, (double)(0.046728972 * WIDTH));
        Text title = new Text();
        title.setTextOrigin(VPos.BOTTOM);
        title.setFont(TITLE_FONT);
        title.setText(this.control.getTitle());
        title.setX((WIDTH - title.getLayoutBounds().getWidth()) / 2.0);
        title.setY(0.3 * WIDTH + title.getLayoutBounds().getHeight());
        title.getStyleClass().add((Object)this.control.getBackgroundDesign().CSS_TEXT);
        Font UNIT_FONT = Font.font((String)this.control.getUnitFont(), (FontWeight)FontWeight.NORMAL, (double)(0.046728972 * WIDTH));
        Text unit = new Text();
        unit.setTextOrigin(VPos.BOTTOM);
        unit.setFont(UNIT_FONT);
        unit.setText(this.control.getUnit());
        unit.setX((WIDTH - unit.getLayoutBounds().getWidth()) / 2.0);
        unit.setY(0.25 * WIDTH + unit.getLayoutBounds().getHeight());
        unit.getStyleClass().add((Object)this.control.getBackgroundDesign().CSS_TEXT);
        this.titleAndUnit.getChildren().addAll((Object[])new Node[]{title, unit});
    }

    public void drawGlowOff() {
        double SIZE = this.gaugeBounds.getWidth() <= this.gaugeBounds.getHeight() ? this.gaugeBounds.getWidth() : this.gaugeBounds.getHeight();
        double WIDTH = this.gaugeBounds.getWidth();
        double HEIGHT = this.gaugeBounds.getHeight();
        this.glowOff.getChildren().clear();
        Path GLOW_RING = new Path();
        GLOW_RING.setFillRule(FillRule.EVEN_ODD);
        GLOW_RING.getElements().add((Object)new MoveTo(0.1 * WIDTH, 0.23846153846153847 * HEIGHT));
        GLOW_RING.getElements().add((Object)new CubicCurveTo(0.1 * WIDTH, 0.5846153846153846 * HEIGHT, 0.275 * WIDTH, 0.8461538461538461 * HEIGHT, 0.495 * WIDTH, 0.8461538461538461 * HEIGHT));
        GLOW_RING.getElements().add((Object)new CubicCurveTo(0.715 * WIDTH, 0.8461538461538461 * HEIGHT, 0.89 * WIDTH, 0.5846153846153846 * HEIGHT, 0.89 * WIDTH, 0.23846153846153847 * HEIGHT));
        GLOW_RING.getElements().add((Object)new CubicCurveTo(0.89 * WIDTH, 0.2153846153846154 * HEIGHT, 0.89 * WIDTH, 0.15384615384615385 * HEIGHT, 0.89 * WIDTH, 0.15384615384615385 * HEIGHT));
        GLOW_RING.getElements().add((Object)new LineTo(0.1 * WIDTH, 0.15384615384615385 * HEIGHT));
        GLOW_RING.getElements().add((Object)new CubicCurveTo(0.1 * WIDTH, 0.15384615384615385 * HEIGHT, 0.1 * WIDTH, 0.2153846153846154 * HEIGHT, 0.1 * WIDTH, 0.23846153846153847 * HEIGHT));
        GLOW_RING.getElements().add((Object)new ClosePath());
        GLOW_RING.getElements().add((Object)new MoveTo(0.075 * WIDTH, 0.23846153846153847 * HEIGHT));
        GLOW_RING.getElements().add((Object)new CubicCurveTo(0.075 * WIDTH, 0.2153846153846154 * HEIGHT, 0.075 * WIDTH, 0.15384615384615385 * HEIGHT, 0.075 * WIDTH, 0.15384615384615385 * HEIGHT));
        GLOW_RING.getElements().add((Object)new LineTo(0.075 * WIDTH, 0.11538461538461539 * HEIGHT));
        GLOW_RING.getElements().add((Object)new LineTo(0.915 * WIDTH, 0.11538461538461539 * HEIGHT));
        GLOW_RING.getElements().add((Object)new LineTo(0.915 * WIDTH, 0.15384615384615385 * HEIGHT));
        GLOW_RING.getElements().add((Object)new CubicCurveTo(0.915 * WIDTH, 0.15384615384615385 * HEIGHT, 0.915 * WIDTH, 0.2153846153846154 * HEIGHT, 0.915 * WIDTH, 0.23846153846153847 * HEIGHT));
        GLOW_RING.getElements().add((Object)new CubicCurveTo(0.915 * WIDTH, 0.5923076923076923 * HEIGHT, 0.725 * WIDTH, 0.8846153846153846 * HEIGHT, 0.495 * WIDTH, 0.8846153846153846 * HEIGHT));
        GLOW_RING.getElements().add((Object)new CubicCurveTo(0.265 * WIDTH, 0.8846153846153846 * HEIGHT, 0.075 * WIDTH, 0.5923076923076923 * HEIGHT, 0.075 * WIDTH, 0.23846153846153847 * HEIGHT));
        GLOW_RING.getElements().add((Object)new ClosePath());
        LinearGradient GLOW_OFF_PAINT = new LinearGradient(0.495 * WIDTH, 0.11538461538461539 * HEIGHT, 0.495 * WIDTH, 0.8846153846153846 * HEIGHT, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)0.8, (double)0.8, (double)0.8, (double)0.4)), new Stop(0.17, Color.color((double)0.6, (double)0.6, (double)0.6, (double)0.4)), new Stop(0.33, Color.color((double)0.9882352941, (double)0.9882352941, (double)0.9882352941, (double)0.4)), new Stop(0.34, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.4)), new Stop(0.63, Color.color((double)0.8, (double)0.8, (double)0.8, (double)0.4)), new Stop(0.64, Color.color((double)0.7960784314, (double)0.7960784314, (double)0.7960784314, (double)0.4)), new Stop(0.83, Color.color((double)0.6, (double)0.6, (double)0.6, (double)0.4)), new Stop(1.0, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.4))});
        GLOW_RING.setFill((Paint)GLOW_OFF_PAINT);
        GLOW_RING.setStroke(null);
        Path HIGHLIGHT_LOWER_RIGHT = new Path();
        HIGHLIGHT_LOWER_RIGHT.setFillRule(FillRule.EVEN_ODD);
        HIGHLIGHT_LOWER_RIGHT.getElements().add((Object)new MoveTo(0.86 * WIDTH, 0.49230769230769234 * HEIGHT));
        HIGHLIGHT_LOWER_RIGHT.getElements().add((Object)new CubicCurveTo(0.795 * WIDTH, 0.7153846153846154 * HEIGHT, 0.66 * WIDTH, 0.8461538461538461 * HEIGHT, 0.5 * WIDTH, 0.8461538461538461 * HEIGHT));
        HIGHLIGHT_LOWER_RIGHT.getElements().add((Object)new CubicCurveTo(0.5 * WIDTH, 0.8461538461538461 * HEIGHT, 0.5 * WIDTH, 0.8846153846153846 * HEIGHT, 0.5 * WIDTH, 0.8846153846153846 * HEIGHT));
        HIGHLIGHT_LOWER_RIGHT.getElements().add((Object)new CubicCurveTo(0.665 * WIDTH, 0.8846153846153846 * HEIGHT, 0.81 * WIDTH, 0.7384615384615385 * HEIGHT, 0.88 * WIDTH, 0.5076923076923077 * HEIGHT));
        HIGHLIGHT_LOWER_RIGHT.getElements().add((Object)new CubicCurveTo(0.88 * WIDTH, 0.5076923076923077 * HEIGHT, 0.86 * WIDTH, 0.49230769230769234 * HEIGHT, 0.86 * WIDTH, 0.49230769230769234 * HEIGHT));
        HIGHLIGHT_LOWER_RIGHT.getElements().add((Object)new ClosePath());
        RadialGradient HIGHLIGHT_LOWER_RIGHT_FILL = new RadialGradient(0.0, 0.0, 0.73 * WIDTH, 0.7615384615384615 * HEIGHT, 0.2375 * WIDTH, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.5490196078)), new Stop(1.0, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0))});
        HIGHLIGHT_LOWER_RIGHT.setFill((Paint)HIGHLIGHT_LOWER_RIGHT_FILL);
        HIGHLIGHT_LOWER_RIGHT.setStroke(null);
        this.glowOff.getChildren().addAll((Object[])new Node[]{GLOW_RING, HIGHLIGHT_LOWER_RIGHT});
    }

    public void drawGlowOn() {
        double SIZE = this.gaugeBounds.getWidth() <= this.gaugeBounds.getHeight() ? this.gaugeBounds.getWidth() : this.gaugeBounds.getHeight();
        double WIDTH = this.gaugeBounds.getWidth();
        double HEIGHT = this.gaugeBounds.getHeight();
        this.glowOn.getChildren().clear();
        Path GLOW_RING = new Path();
        GLOW_RING.setFillRule(FillRule.EVEN_ODD);
        GLOW_RING.getElements().add((Object)new MoveTo(0.1 * WIDTH, 0.23846153846153847 * HEIGHT));
        GLOW_RING.getElements().add((Object)new CubicCurveTo(0.1 * WIDTH, 0.5846153846153846 * HEIGHT, 0.275 * WIDTH, 0.8461538461538461 * HEIGHT, 0.495 * WIDTH, 0.8461538461538461 * HEIGHT));
        GLOW_RING.getElements().add((Object)new CubicCurveTo(0.715 * WIDTH, 0.8461538461538461 * HEIGHT, 0.89 * WIDTH, 0.5846153846153846 * HEIGHT, 0.89 * WIDTH, 0.23846153846153847 * HEIGHT));
        GLOW_RING.getElements().add((Object)new CubicCurveTo(0.89 * WIDTH, 0.2153846153846154 * HEIGHT, 0.89 * WIDTH, 0.15384615384615385 * HEIGHT, 0.89 * WIDTH, 0.15384615384615385 * HEIGHT));
        GLOW_RING.getElements().add((Object)new LineTo(0.1 * WIDTH, 0.15384615384615385 * HEIGHT));
        GLOW_RING.getElements().add((Object)new CubicCurveTo(0.1 * WIDTH, 0.15384615384615385 * HEIGHT, 0.1 * WIDTH, 0.2153846153846154 * HEIGHT, 0.1 * WIDTH, 0.23846153846153847 * HEIGHT));
        GLOW_RING.getElements().add((Object)new ClosePath());
        GLOW_RING.getElements().add((Object)new MoveTo(0.075 * WIDTH, 0.23846153846153847 * HEIGHT));
        GLOW_RING.getElements().add((Object)new CubicCurveTo(0.075 * WIDTH, 0.2153846153846154 * HEIGHT, 0.075 * WIDTH, 0.15384615384615385 * HEIGHT, 0.075 * WIDTH, 0.15384615384615385 * HEIGHT));
        GLOW_RING.getElements().add((Object)new LineTo(0.075 * WIDTH, 0.11538461538461539 * HEIGHT));
        GLOW_RING.getElements().add((Object)new LineTo(0.915 * WIDTH, 0.11538461538461539 * HEIGHT));
        GLOW_RING.getElements().add((Object)new LineTo(0.915 * WIDTH, 0.15384615384615385 * HEIGHT));
        GLOW_RING.getElements().add((Object)new CubicCurveTo(0.915 * WIDTH, 0.15384615384615385 * HEIGHT, 0.915 * WIDTH, 0.2153846153846154 * HEIGHT, 0.915 * WIDTH, 0.23846153846153847 * HEIGHT));
        GLOW_RING.getElements().add((Object)new CubicCurveTo(0.915 * WIDTH, 0.5923076923076923 * HEIGHT, 0.725 * WIDTH, 0.8846153846153846 * HEIGHT, 0.495 * WIDTH, 0.8846153846153846 * HEIGHT));
        GLOW_RING.getElements().add((Object)new CubicCurveTo(0.265 * WIDTH, 0.8846153846153846 * HEIGHT, 0.075 * WIDTH, 0.5923076923076923 * HEIGHT, 0.075 * WIDTH, 0.23846153846153847 * HEIGHT));
        GLOW_RING.getElements().add((Object)new ClosePath());
        RadialGradient GLOW_ON_PAINT = new RadialGradient(0.0, 0.0, 0.5 * WIDTH, 0.5 * HEIGHT, 0.4158878504672897 * WIDTH, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, this.glowColors.get(0)), new Stop(0.91, this.glowColors.get(1)), new Stop(0.96, this.glowColors.get(2)), new Stop(1.0, this.glowColors.get(3))});
        GLOW_RING.setFill((Paint)GLOW_ON_PAINT);
        GLOW_RING.setStroke(null);
        DropShadow GLOW_EFFECT = new DropShadow();
        GLOW_EFFECT.setRadius(0.15 * WIDTH);
        GLOW_EFFECT.setBlurType(BlurType.GAUSSIAN);
        if (GLOW_EFFECT.colorProperty().isBound()) {
            GLOW_EFFECT.colorProperty().unbind();
        }
        GLOW_EFFECT.colorProperty().bind(this.control.glowColorProperty());
        GLOW_RING.setEffect((Effect)GLOW_EFFECT);
        Path HIGHLIGHT_LOWER_RIGHT = new Path();
        HIGHLIGHT_LOWER_RIGHT.setFillRule(FillRule.EVEN_ODD);
        HIGHLIGHT_LOWER_RIGHT.getElements().add((Object)new MoveTo(0.86 * WIDTH, 0.49230769230769234 * HEIGHT));
        HIGHLIGHT_LOWER_RIGHT.getElements().add((Object)new CubicCurveTo(0.795 * WIDTH, 0.7153846153846154 * HEIGHT, 0.66 * WIDTH, 0.8461538461538461 * HEIGHT, 0.5 * WIDTH, 0.8461538461538461 * HEIGHT));
        HIGHLIGHT_LOWER_RIGHT.getElements().add((Object)new CubicCurveTo(0.5 * WIDTH, 0.8461538461538461 * HEIGHT, 0.5 * WIDTH, 0.8846153846153846 * HEIGHT, 0.5 * WIDTH, 0.8846153846153846 * HEIGHT));
        HIGHLIGHT_LOWER_RIGHT.getElements().add((Object)new CubicCurveTo(0.665 * WIDTH, 0.8846153846153846 * HEIGHT, 0.81 * WIDTH, 0.7384615384615385 * HEIGHT, 0.88 * WIDTH, 0.5076923076923077 * HEIGHT));
        HIGHLIGHT_LOWER_RIGHT.getElements().add((Object)new CubicCurveTo(0.88 * WIDTH, 0.5076923076923077 * HEIGHT, 0.86 * WIDTH, 0.49230769230769234 * HEIGHT, 0.86 * WIDTH, 0.49230769230769234 * HEIGHT));
        HIGHLIGHT_LOWER_RIGHT.getElements().add((Object)new ClosePath());
        RadialGradient HIGHLIGHT_LOWER_RIGHT_FILL = new RadialGradient(0.0, 0.0, 0.73 * WIDTH, 0.7615384615384615 * HEIGHT, 0.2375 * WIDTH, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.5490196078)), new Stop(1.0, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0))});
        HIGHLIGHT_LOWER_RIGHT.setFill((Paint)HIGHLIGHT_LOWER_RIGHT_FILL);
        HIGHLIGHT_LOWER_RIGHT.setStroke(null);
        this.glowOn.getChildren().addAll((Object[])new Node[]{GLOW_RING, HIGHLIGHT_LOWER_RIGHT});
    }

    public void drawIndicators() {
        double SIZE = this.gaugeBounds.getWidth() <= this.gaugeBounds.getHeight() ? this.gaugeBounds.getWidth() : this.gaugeBounds.getHeight();
        double WIDTH = this.gaugeBounds.getWidth();
        double HEIGHT = this.gaugeBounds.getHeight();
        this.markers.getChildren().clear();
        Rectangle IBOUNDS = new Rectangle(0.0, 0.0, WIDTH, HEIGHT);
        IBOUNDS.setOpacity(0.0);
        IBOUNDS.setStroke(null);
        this.markers.getChildren().add((Object)IBOUNDS);
        for (Marker marker : this.control.getMarkers()) {
            if (Double.compare(marker.getValue(), this.control.getMinValue()) < 0 || Double.compare(marker.getValue(), this.control.getMaxValue()) > 0) continue;
            Group ARROW_GROUP = this.createIndicator(WIDTH, marker, new Point2D(WIDTH * 0.4813084112, WIDTH * 0.0841121495));
            ARROW_GROUP.getTransforms().clear();
            ARROW_GROUP.setTranslateY(-WIDTH * 0.35);
            ARROW_GROUP.getTransforms().add((Object)Transform.rotate((double)(-this.control.getRadialRange().ROTATION_OFFSET), (double)this.center.getX(), (double)this.center.getX()));
            double ZERO_OFFSET = -90.0 + this.control.getRadialRange().ROTATION_OFFSET;
            ARROW_GROUP.getTransforms().add((Object)Transform.rotate((double)(ZERO_OFFSET - (marker.getValue() - this.control.getMinValue()) * this.control.getAngleStep()), (double)this.center.getX(), (double)this.center.getX()));
            this.markers.getChildren().add((Object)ARROW_GROUP);
        }
    }

    public void drawThreshold() {
        double SIZE = this.gaugeBounds.getWidth() <= this.gaugeBounds.getHeight() ? this.gaugeBounds.getWidth() : this.gaugeBounds.getHeight();
        double WIDTH = this.gaugeBounds.getWidth();
        double HEIGHT = this.gaugeBounds.getHeight();
        this.threshold.getChildren().clear();
        Rectangle IBOUNDS = new Rectangle(0.0, 0.0, WIDTH, HEIGHT);
        IBOUNDS.setOpacity(0.0);
        IBOUNDS.setStroke(null);
        this.threshold.getChildren().add((Object)IBOUNDS);
        Path THRESHOLD = this.createTriangleShape(0.03 * WIDTH, 0.03 * WIDTH, false);
        THRESHOLD.setStrokeType(StrokeType.CENTERED);
        THRESHOLD.setStrokeLineCap(StrokeLineCap.ROUND);
        THRESHOLD.setStrokeLineJoin(StrokeLineJoin.ROUND);
        THRESHOLD.setStrokeWidth(0.002 * HEIGHT);
        THRESHOLD.getStyleClass().add((Object)"root");
        THRESHOLD.setStyle(this.control.getThresholdColor().CSS);
        THRESHOLD.getStyleClass().add((Object)"threshold-gradient");
        THRESHOLD.setTranslateX(0.485 * WIDTH);
        THRESHOLD.setTranslateY(0.14 * WIDTH);
        this.threshold.getChildren().addAll((Object[])new Node[]{THRESHOLD});
        this.threshold.getTransforms().clear();
        this.threshold.setTranslateY(-WIDTH * 0.35);
        this.threshold.getTransforms().add((Object)Transform.rotate((double)(-this.control.getRadialRange().ROTATION_OFFSET), (double)this.center.getX(), (double)this.center.getX()));
        double ZERO_OFFSET = -90.0 + this.control.getRadialRange().ROTATION_OFFSET;
        this.threshold.getTransforms().add((Object)Transform.rotate((double)(ZERO_OFFSET - (this.control.getThreshold() - this.control.getMinValue()) * this.control.getAngleStep()), (double)this.center.getX(), (double)this.center.getX()));
    }

    public void drawMinMeasuredIndicator() {
        double WIDTH = this.gaugeBounds.getWidth();
        double HEIGHT = this.gaugeBounds.getWidth();
        this.minMeasured.getChildren().clear();
        Rectangle IBOUNDS = new Rectangle(0.0, 0.0, WIDTH, HEIGHT);
        IBOUNDS.setOpacity(0.0);
        IBOUNDS.setStroke(null);
        this.minMeasured.getChildren().add((Object)IBOUNDS);
        Path MIN_MEASURED = this.createTriangleShape(0.03 * WIDTH, 0.035 * WIDTH, true);
        MIN_MEASURED.setFill((Paint)Color.color((double)0.0, (double)0.0, (double)0.8));
        MIN_MEASURED.setStroke(null);
        MIN_MEASURED.setTranslateX(0.485 * WIDTH);
        MIN_MEASURED.setTranslateY(0.1 * WIDTH);
        this.minMeasured.getChildren().add((Object)MIN_MEASURED);
        this.minMeasured.getTransforms().clear();
        this.minMeasured.setTranslateY(-WIDTH * 0.35);
        this.minMeasured.getTransforms().add((Object)Transform.rotate((double)(-this.control.getRadialRange().ROTATION_OFFSET), (double)this.center.getX(), (double)this.center.getX()));
        double ZERO_OFFSET = -90.0 + this.control.getRadialRange().ROTATION_OFFSET;
        this.minMeasured.setRotate(ZERO_OFFSET - (this.control.getMinMeasuredValue() - this.control.getMinValue()) * this.control.getAngleStep());
    }

    public void drawMaxMeasuredIndicator() {
        double WIDTH = this.gaugeBounds.getWidth();
        double HEIGHT = this.gaugeBounds.getWidth();
        this.maxMeasured.getChildren().clear();
        Rectangle IBOUNDS = new Rectangle(0.0, 0.0, WIDTH, HEIGHT);
        IBOUNDS.setOpacity(0.0);
        IBOUNDS.setStroke(null);
        this.maxMeasured.getChildren().add((Object)IBOUNDS);
        Path MAX_MEASURED = this.createTriangleShape(0.03 * WIDTH, 0.035 * WIDTH, true);
        MAX_MEASURED.setFill((Paint)Color.color((double)0.8, (double)0.0, (double)0.0));
        MAX_MEASURED.setStroke(null);
        MAX_MEASURED.setTranslateX(0.485 * WIDTH);
        MAX_MEASURED.setTranslateY(0.1 * WIDTH);
        this.maxMeasured.getChildren().add((Object)MAX_MEASURED);
        this.maxMeasured.getTransforms().clear();
        this.maxMeasured.setTranslateY(-WIDTH * 0.35);
        this.maxMeasured.getTransforms().add((Object)Transform.rotate((double)(-this.control.getRadialRange().ROTATION_OFFSET), (double)this.center.getX(), (double)this.center.getX()));
        double ZERO_OFFSET = -90.0 + this.control.getRadialRange().ROTATION_OFFSET;
        this.maxMeasured.setRotate(ZERO_OFFSET - (this.control.getMaxMeasuredValue() - this.control.getMinValue()) * this.control.getAngleStep());
    }

    public void drawPointer() {
        double SIZE = this.gaugeBounds.getWidth() <= this.gaugeBounds.getHeight() ? this.gaugeBounds.getWidth() : this.gaugeBounds.getHeight();
        double WIDTH = this.gaugeBounds.getWidth();
        double HEIGHT = this.gaugeBounds.getWidth();
        this.pointer.getChildren().clear();
        Rectangle IBOUNDS = new Rectangle(0.0, 0.0, WIDTH, HEIGHT);
        IBOUNDS.setOpacity(0.0);
        IBOUNDS.setStroke(null);
        this.pointer.getChildren().add((Object)IBOUNDS);
        Path POINTER = new Path();
        Path POINTER_FRONT = new Path();
        POINTER.setSmooth(true);
        POINTER.getStyleClass().add((Object)"root");
        POINTER.setStyle("-fx-value: " + this.control.getValueColor().CSS);
        switch (this.control.getPointerType()) {
            case TYPE2: {
                POINTER.getStyleClass().add((Object)"pointer2-gradient");
                POINTER.setFillRule(FillRule.EVEN_ODD);
                POINTER.getElements().add((Object)new MoveTo(0.514018691588785 * WIDTH, 0.4719626168224299 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.5046728971962616 * WIDTH, 0.46261682242990654 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.5046728971962616 * WIDTH, 0.3411214953271028 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.5046728971962616 * WIDTH, 0.2336448598130841 * HEIGHT));
                POINTER.getElements().add((Object)new CubicCurveTo(0.5046728971962616 * WIDTH, 0.2336448598130841 * HEIGHT, 0.5046728971962616 * WIDTH, 0.1308411214953271 * HEIGHT, 0.4953271028037383 * WIDTH, 0.1308411214953271 * HEIGHT));
                POINTER.getElements().add((Object)new CubicCurveTo(0.49065420560747663 * WIDTH, 0.1308411214953271 * HEIGHT, 0.49065420560747663 * WIDTH, 0.2336448598130841 * HEIGHT, 0.49065420560747663 * WIDTH, 0.2336448598130841 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.49065420560747663 * WIDTH, 0.3411214953271028 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.49065420560747663 * WIDTH, 0.46261682242990654 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.48130841121495327 * WIDTH, 0.4719626168224299 * HEIGHT));
                POINTER.getElements().add((Object)new CubicCurveTo(0.48130841121495327 * WIDTH, 0.4719626168224299 * HEIGHT, 0.4672897196261682 * WIDTH, 0.49065420560747663 * HEIGHT, 0.4672897196261682 * WIDTH, 0.5 * HEIGHT));
                POINTER.getElements().add((Object)new CubicCurveTo(0.4672897196261682 * WIDTH, 0.5186915887850467 * HEIGHT, 0.48130841121495327 * WIDTH, 0.5327102803738317 * HEIGHT, 0.4953271028037383 * WIDTH, 0.5327102803738317 * HEIGHT));
                POINTER.getElements().add((Object)new CubicCurveTo(0.514018691588785 * WIDTH, 0.5327102803738317 * HEIGHT, 0.5327102803738317 * WIDTH, 0.5186915887850467 * HEIGHT, 0.5327102803738317 * WIDTH, 0.5 * HEIGHT));
                POINTER.getElements().add((Object)new CubicCurveTo(0.5327102803738317 * WIDTH, 0.49065420560747663 * HEIGHT, 0.514018691588785 * WIDTH, 0.4719626168224299 * HEIGHT, 0.514018691588785 * WIDTH, 0.4719626168224299 * HEIGHT));
                POINTER.getElements().add((Object)new ClosePath());
                POINTER.setStroke(null);
                break;
            }
            case TYPE3: {
                POINTER.getStyleClass().add((Object)"pointer3-gradient");
                POINTER.setFillRule(FillRule.EVEN_ODD);
                POINTER.getElements().add((Object)new MoveTo(0.4953271028037383 * WIDTH, 0.1308411214953271 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.5046728971962616 * WIDTH, 0.1308411214953271 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.5046728971962616 * WIDTH, 0.5046728971962616 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.4953271028037383 * WIDTH, 0.5046728971962616 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.4953271028037383 * WIDTH, 0.1308411214953271 * HEIGHT));
                POINTER.getElements().add((Object)new ClosePath());
                POINTER.setStroke(null);
                break;
            }
            case TYPE4: {
                POINTER.getStyleClass().add((Object)"pointer4-gradient");
                POINTER.setFillRule(FillRule.EVEN_ODD);
                POINTER.getElements().add((Object)new MoveTo(0.5 * WIDTH, 0.1261682242990654 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.5093457943925234 * WIDTH, 0.13551401869158877 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.5327102803738317 * WIDTH, 0.5 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.5233644859813084 * WIDTH, 0.602803738317757 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.4766355140186916 * WIDTH, 0.602803738317757 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.46261682242990654 * WIDTH, 0.5 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.48598130841121495 * WIDTH, 0.13551401869158877 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.5 * WIDTH, 0.1261682242990654 * HEIGHT));
                POINTER.getElements().add((Object)new ClosePath());
                POINTER.setStroke(null);
                break;
            }
            case TYPE5: {
                POINTER.getStyleClass().add((Object)"pointer5-gradient");
                POINTER.setFillRule(FillRule.EVEN_ODD);
                POINTER.getElements().add((Object)new MoveTo(WIDTH * 0.5, HEIGHT * 0.4953271028037383));
                POINTER.getElements().add((Object)new LineTo(WIDTH * 0.5280373831775701, HEIGHT * 0.4953271028037383));
                POINTER.getElements().add((Object)new LineTo(WIDTH * 0.5, HEIGHT * 0.14953271028037382));
                POINTER.getElements().add((Object)new LineTo(WIDTH * 0.4719626168224299, HEIGHT * 0.4953271028037383));
                POINTER.getElements().add((Object)new LineTo(WIDTH * 0.5, HEIGHT * 0.4953271028037383));
                POINTER.getElements().add((Object)new ClosePath());
                POINTER.setStrokeType(StrokeType.CENTERED);
                POINTER.setStrokeLineCap(StrokeLineCap.BUTT);
                POINTER.setStrokeLineJoin(StrokeLineJoin.ROUND);
                POINTER.setStrokeWidth(0.002 * WIDTH);
                break;
            }
            case TYPE6: {
                POINTER.getStyleClass().add((Object)"pointer6-gradient");
                POINTER.setFillRule(FillRule.EVEN_ODD);
                POINTER.getElements().add((Object)new MoveTo(WIDTH * 0.48130841121495327, HEIGHT * 0.48598130841121495));
                POINTER.getElements().add((Object)new LineTo(WIDTH * 0.48130841121495327, HEIGHT * 0.3925233644859813));
                POINTER.getElements().add((Object)new LineTo(WIDTH * 0.48598130841121495, HEIGHT * 0.3177570093457944));
                POINTER.getElements().add((Object)new LineTo(WIDTH * 0.4953271028037383, HEIGHT * 0.1308411214953271));
                POINTER.getElements().add((Object)new LineTo(WIDTH * 0.5046728971962616, HEIGHT * 0.1308411214953271));
                POINTER.getElements().add((Object)new LineTo(WIDTH * 0.514018691588785, HEIGHT * 0.3177570093457944));
                POINTER.getElements().add((Object)new LineTo(WIDTH * 0.5186915887850467, HEIGHT * 0.3878504672897196));
                POINTER.getElements().add((Object)new LineTo(WIDTH * 0.5186915887850467, HEIGHT * 0.48598130841121495));
                POINTER.getElements().add((Object)new LineTo(WIDTH * 0.5046728971962616, HEIGHT * 0.48598130841121495));
                POINTER.getElements().add((Object)new LineTo(WIDTH * 0.5046728971962616, HEIGHT * 0.3878504672897196));
                POINTER.getElements().add((Object)new LineTo(WIDTH * 0.5, HEIGHT * 0.3177570093457944));
                POINTER.getElements().add((Object)new LineTo(WIDTH * 0.4953271028037383, HEIGHT * 0.3925233644859813));
                POINTER.getElements().add((Object)new LineTo(WIDTH * 0.4953271028037383, HEIGHT * 0.48598130841121495));
                POINTER.getElements().add((Object)new LineTo(WIDTH * 0.48130841121495327, HEIGHT * 0.48598130841121495));
                POINTER.getElements().add((Object)new ClosePath());
                POINTER.setStroke(null);
                break;
            }
            case TYPE7: {
                POINTER.getStyleClass().add((Object)"pointer7-gradient");
                POINTER.setFillRule(FillRule.EVEN_ODD);
                POINTER.getElements().add((Object)new MoveTo(0.49065420560747663 * WIDTH, 0.1308411214953271 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.4766355140186916 * WIDTH, 0.5 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.5186915887850467 * WIDTH, 0.5 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.5046728971962616 * WIDTH, 0.1308411214953271 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.49065420560747663 * WIDTH, 0.1308411214953271 * HEIGHT));
                POINTER.getElements().add((Object)new ClosePath());
                POINTER.setStroke(null);
                break;
            }
            case TYPE8: {
                POINTER.getStyleClass().add((Object)"pointer8-gradient");
                POINTER.setFillRule(FillRule.EVEN_ODD);
                POINTER.getElements().add((Object)new MoveTo(0.4953271028037383 * WIDTH, 0.5327102803738317 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.5327102803738317 * WIDTH, 0.5 * HEIGHT));
                POINTER.getElements().add((Object)new CubicCurveTo(0.5327102803738317 * WIDTH, 0.5 * HEIGHT, 0.5046728971962616 * WIDTH, 0.45794392523364486 * HEIGHT, 0.4953271028037383 * WIDTH, 0.14953271028037382 * HEIGHT));
                POINTER.getElements().add((Object)new CubicCurveTo(0.49065420560747663 * WIDTH, 0.45794392523364486 * HEIGHT, 0.46261682242990654 * WIDTH, 0.5 * HEIGHT, 0.46261682242990654 * WIDTH, 0.5 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.4953271028037383 * WIDTH, 0.5327102803738317 * HEIGHT));
                POINTER.getElements().add((Object)new ClosePath());
                POINTER.setStrokeType(StrokeType.CENTERED);
                POINTER.setStrokeLineCap(StrokeLineCap.BUTT);
                POINTER.setStrokeLineJoin(StrokeLineJoin.ROUND);
                POINTER.setStrokeWidth(0.002 * WIDTH);
                break;
            }
            case TYPE9: {
                POINTER.getStyleClass().add((Object)"pointer9-gradient");
                POINTER.setFillRule(FillRule.EVEN_ODD);
                POINTER.getElements().add((Object)new MoveTo(WIDTH * 0.4953271028037383, HEIGHT * 0.2336448598130841));
                POINTER.getElements().add((Object)new LineTo(WIDTH * 0.5046728971962616, HEIGHT * 0.2336448598130841));
                POINTER.getElements().add((Object)new LineTo(WIDTH * 0.514018691588785, HEIGHT * 0.4392523364485981));
                POINTER.getElements().add((Object)new LineTo(WIDTH * 0.48598130841121495, HEIGHT * 0.4392523364485981));
                POINTER.getElements().add((Object)new LineTo(WIDTH * 0.4953271028037383, HEIGHT * 0.2336448598130841));
                POINTER.getElements().add((Object)new ClosePath());
                POINTER.getElements().add((Object)new MoveTo(WIDTH * 0.49065420560747663, HEIGHT * 0.1308411214953271));
                POINTER.getElements().add((Object)new LineTo(WIDTH * 0.4719626168224299, HEIGHT * 0.4719626168224299));
                POINTER.getElements().add((Object)new LineTo(WIDTH * 0.4719626168224299, HEIGHT * 0.5280373831775701));
                POINTER.getElements().add((Object)new CubicCurveTo(WIDTH * 0.4719626168224299, HEIGHT * 0.5280373831775701, WIDTH * 0.4766355140186916, HEIGHT * 0.602803738317757, WIDTH * 0.4766355140186916, HEIGHT * 0.602803738317757));
                POINTER.getElements().add((Object)new CubicCurveTo(WIDTH * 0.4766355140186916, HEIGHT * 0.6074766355140186, WIDTH * 0.48130841121495327, HEIGHT * 0.6074766355140186, WIDTH * 0.5, HEIGHT * 0.6074766355140186));
                POINTER.getElements().add((Object)new CubicCurveTo(WIDTH * 0.5186915887850467, HEIGHT * 0.6074766355140186, WIDTH * 0.5233644859813084, HEIGHT * 0.6074766355140186, WIDTH * 0.5233644859813084, HEIGHT * 0.602803738317757));
                POINTER.getElements().add((Object)new CubicCurveTo(WIDTH * 0.5233644859813084, HEIGHT * 0.602803738317757, WIDTH * 0.5280373831775701, HEIGHT * 0.5280373831775701, WIDTH * 0.5280373831775701, HEIGHT * 0.5280373831775701));
                POINTER.getElements().add((Object)new LineTo(WIDTH * 0.5280373831775701, HEIGHT * 0.4719626168224299));
                POINTER.getElements().add((Object)new LineTo(WIDTH * 0.5093457943925234, HEIGHT * 0.1308411214953271));
                POINTER.getElements().add((Object)new LineTo(WIDTH * 0.49065420560747663, HEIGHT * 0.1308411214953271));
                POINTER.getElements().add((Object)new ClosePath());
                POINTER.setStrokeType(StrokeType.CENTERED);
                POINTER.setStrokeLineCap(StrokeLineCap.BUTT);
                POINTER.setStrokeLineJoin(StrokeLineJoin.ROUND);
                POINTER.setStrokeWidth(0.002 * WIDTH);
                POINTER_FRONT.getStyleClass().add((Object)"root");
                POINTER_FRONT.setStyle("-fx-value: " + this.control.getValueColor().CSS);
                POINTER_FRONT.getStyleClass().add((Object)"pointer9-box");
                POINTER_FRONT.setFillRule(FillRule.EVEN_ODD);
                POINTER_FRONT.getElements().add((Object)new MoveTo(WIDTH * 0.4953271028037383, HEIGHT * 0.21962616822429906));
                POINTER_FRONT.getElements().add((Object)new LineTo(WIDTH * 0.5046728971962616, HEIGHT * 0.21962616822429906));
                POINTER_FRONT.getElements().add((Object)new LineTo(WIDTH * 0.5046728971962616, HEIGHT * 0.13551401869158877));
                POINTER_FRONT.getElements().add((Object)new LineTo(WIDTH * 0.4953271028037383, HEIGHT * 0.13551401869158877));
                POINTER_FRONT.getElements().add((Object)new LineTo(WIDTH * 0.4953271028037383, HEIGHT * 0.21962616822429906));
                POINTER_FRONT.getElements().add((Object)new ClosePath());
                POINTER_FRONT.setStroke(null);
                break;
            }
            case TYPE10: {
                POINTER.getStyleClass().add((Object)"pointer10-gradient");
                POINTER.setFillRule(FillRule.EVEN_ODD);
                POINTER.getElements().add((Object)new MoveTo(0.4953271028037383 * WIDTH, 0.14953271028037382 * HEIGHT));
                POINTER.getElements().add((Object)new CubicCurveTo(0.4953271028037383 * WIDTH, 0.14953271028037382 * HEIGHT, 0.4439252336448598 * WIDTH, 0.49065420560747663 * HEIGHT, 0.4439252336448598 * WIDTH, 0.5 * HEIGHT));
                POINTER.getElements().add((Object)new CubicCurveTo(0.4439252336448598 * WIDTH, 0.5327102803738317 * HEIGHT, 0.4672897196261682 * WIDTH, 0.5560747663551402 * HEIGHT, 0.4953271028037383 * WIDTH, 0.5560747663551402 * HEIGHT));
                POINTER.getElements().add((Object)new CubicCurveTo(0.5280373831775701 * WIDTH, 0.5560747663551402 * HEIGHT, 0.5560747663551402 * WIDTH, 0.5327102803738317 * HEIGHT, 0.5560747663551402 * WIDTH, 0.5 * HEIGHT));
                POINTER.getElements().add((Object)new CubicCurveTo(0.5560747663551402 * WIDTH, 0.49065420560747663 * HEIGHT, 0.4953271028037383 * WIDTH, 0.14953271028037382 * HEIGHT, 0.4953271028037383 * WIDTH, 0.14953271028037382 * HEIGHT));
                POINTER.getElements().add((Object)new ClosePath());
                POINTER.setStrokeType(StrokeType.CENTERED);
                POINTER.setStrokeLineCap(StrokeLineCap.BUTT);
                POINTER.setStrokeLineJoin(StrokeLineJoin.ROUND);
                POINTER.setStrokeWidth(0.002 * WIDTH);
                break;
            }
            case TYPE11: {
                POINTER.getStyleClass().add((Object)"pointer11-gradient");
                POINTER.setFillRule(FillRule.EVEN_ODD);
                POINTER.getElements().add((Object)new MoveTo(0.5 * WIDTH, 0.16822429906542055 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.48598130841121495 * WIDTH, 0.5 * HEIGHT));
                POINTER.getElements().add((Object)new CubicCurveTo(0.48598130841121495 * WIDTH, 0.5 * HEIGHT, 0.48130841121495327 * WIDTH, 0.5841121495327103 * HEIGHT, 0.5 * WIDTH, 0.5841121495327103 * HEIGHT));
                POINTER.getElements().add((Object)new CubicCurveTo(0.514018691588785 * WIDTH, 0.5841121495327103 * HEIGHT, 0.5093457943925234 * WIDTH, 0.5 * HEIGHT, 0.5093457943925234 * WIDTH, 0.5 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.5 * WIDTH, 0.16822429906542055 * HEIGHT));
                POINTER.getElements().add((Object)new ClosePath());
                POINTER.setStrokeType(StrokeType.CENTERED);
                POINTER.setStrokeLineCap(StrokeLineCap.BUTT);
                POINTER.setStrokeLineJoin(StrokeLineJoin.ROUND);
                POINTER.setStrokeWidth(0.002 * WIDTH);
                break;
            }
            case TYPE12: {
                POINTER.getStyleClass().add((Object)"pointer12-gradient");
                POINTER.setFillRule(FillRule.EVEN_ODD);
                POINTER.getElements().add((Object)new MoveTo(0.5 * WIDTH, 0.16822429906542055 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.48598130841121495 * WIDTH, 0.5 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.5 * WIDTH, 0.5046728971962616 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.5093457943925234 * WIDTH, 0.5 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.5 * WIDTH, 0.16822429906542055 * HEIGHT));
                POINTER.getElements().add((Object)new ClosePath());
                POINTER.setStrokeType(StrokeType.CENTERED);
                POINTER.setStrokeLineCap(StrokeLineCap.BUTT);
                POINTER.setStrokeLineJoin(StrokeLineJoin.ROUND);
                POINTER.setStrokeWidth(0.002 * WIDTH);
                break;
            }
            case TYPE13: {
                POINTER.getStyleClass().add((Object)"pointer13-gradient");
                POINTER.setFillRule(FillRule.EVEN_ODD);
                POINTER.getElements().add((Object)new MoveTo(0.48598130841121495 * WIDTH, 0.16822429906542055 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.5 * WIDTH, 0.1308411214953271 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.5093457943925234 * WIDTH, 0.16822429906542055 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.5093457943925234 * WIDTH, 0.5093457943925234 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.48598130841121495 * WIDTH, 0.5093457943925234 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.48598130841121495 * WIDTH, 0.16822429906542055 * HEIGHT));
                POINTER.getElements().add((Object)new ClosePath());
                POINTER.setStroke(null);
                break;
            }
            case TYPE14: {
                POINTER.getStyleClass().add((Object)"pointer14-gradient");
                POINTER.setFillRule(FillRule.EVEN_ODD);
                POINTER.getElements().add((Object)new MoveTo(0.48598130841121495 * WIDTH, 0.16822429906542055 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.5 * WIDTH, 0.1308411214953271 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.5093457943925234 * WIDTH, 0.16822429906542055 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.5093457943925234 * WIDTH, 0.5093457943925234 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.48598130841121495 * WIDTH, 0.5093457943925234 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.48598130841121495 * WIDTH, 0.16822429906542055 * HEIGHT));
                POINTER.getElements().add((Object)new ClosePath());
                POINTER.setStroke(null);
                break;
            }
            case TYPE15: {
                POINTER.getStyleClass().add((Object)"pointer15-gradient");
                POINTER.setFillRule(FillRule.EVEN_ODD);
                POINTER.getElements().add((Object)new MoveTo(0.48 * WIDTH, 0.505 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.48 * WIDTH, 0.275 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.46 * WIDTH, 0.275 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.495 * WIDTH, 0.15 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.53 * WIDTH, 0.275 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.515 * WIDTH, 0.275 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.515 * WIDTH, 0.505 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.48 * WIDTH, 0.505 * HEIGHT));
                POINTER.getElements().add((Object)new ClosePath());
                POINTER.setStroke(null);
                break;
            }
            case TYPE16: {
                POINTER.getStyleClass().add((Object)"pointer16-gradient");
                POINTER.setFillRule(FillRule.EVEN_ODD);
                POINTER.getElements().add((Object)new MoveTo(0.495 * WIDTH, 0.625 * HEIGHT));
                POINTER.getElements().add((Object)new CubicCurveTo(0.515 * WIDTH, 0.625 * HEIGHT, 0.535 * WIDTH, 0.61 * HEIGHT, 0.535 * WIDTH, 0.61 * HEIGHT));
                POINTER.getElements().add((Object)new CubicCurveTo(0.525 * WIDTH, 0.6 * HEIGHT, 0.505 * WIDTH, 0.53 * HEIGHT, 0.505 * WIDTH, 0.53 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.505 * WIDTH, 0.47 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.505 * WIDTH, 0.17 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.5 * WIDTH, 0.165 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.5 * WIDTH, 0.13 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.495 * WIDTH, 0.13 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.495 * WIDTH, 0.165 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.49 * WIDTH, 0.17 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.49 * WIDTH, 0.47 * HEIGHT));
                POINTER.getElements().add((Object)new LineTo(0.49 * WIDTH, 0.53 * HEIGHT));
                POINTER.getElements().add((Object)new CubicCurveTo(0.49 * WIDTH, 0.53 * HEIGHT, 0.47 * WIDTH, 0.6 * HEIGHT, 0.465 * WIDTH, 0.61 * HEIGHT));
                POINTER.getElements().add((Object)new CubicCurveTo(0.465 * WIDTH, 0.61 * HEIGHT, 0.475 * WIDTH, 0.625 * HEIGHT, 0.495 * WIDTH, 0.625 * HEIGHT));
                POINTER.getElements().add((Object)new ClosePath());
                POINTER.setStroke(null);
                break;
            }
            default: {
                POINTER.setStyle("-fx-pointer: " + this.control.getValueColor().CSS);
                POINTER.getStyleClass().add((Object)"pointer1-gradient");
                POINTER.setFillRule(FillRule.EVEN_ODD);
                POINTER.getElements().add((Object)new MoveTo(WIDTH * 0.5186915887850467, HEIGHT * 0.4719626168224299));
                POINTER.getElements().add((Object)new CubicCurveTo(WIDTH * 0.514018691588785, HEIGHT * 0.45794392523364486, WIDTH * 0.5093457943925234, HEIGHT * 0.4158878504672897, WIDTH * 0.5093457943925234, HEIGHT * 0.40186915887850466));
                POINTER.getElements().add((Object)new CubicCurveTo(WIDTH * 0.5046728971962616, HEIGHT * 0.38317757009345793, WIDTH * 0.5, HEIGHT * 0.1308411214953271, WIDTH * 0.5, HEIGHT * 0.1308411214953271));
                POINTER.getElements().add((Object)new CubicCurveTo(WIDTH * 0.5, HEIGHT * 0.1308411214953271, WIDTH * 0.49065420560747663, HEIGHT * 0.38317757009345793, WIDTH * 0.49065420560747663, HEIGHT * 0.397196261682243));
                POINTER.getElements().add((Object)new CubicCurveTo(WIDTH * 0.49065420560747663, HEIGHT * 0.4158878504672897, WIDTH * 0.48598130841121495, HEIGHT * 0.45794392523364486, WIDTH * 0.48130841121495327, HEIGHT * 0.4719626168224299));
                POINTER.getElements().add((Object)new CubicCurveTo(WIDTH * 0.4719626168224299, HEIGHT * 0.48130841121495327, WIDTH * 0.4672897196261682, HEIGHT * 0.49065420560747663, WIDTH * 0.4672897196261682, HEIGHT * 0.5));
                POINTER.getElements().add((Object)new CubicCurveTo(WIDTH * 0.4672897196261682, HEIGHT * 0.5186915887850467, WIDTH * 0.48130841121495327, HEIGHT * 0.5327102803738317, WIDTH * 0.5, HEIGHT * 0.5327102803738317));
                POINTER.getElements().add((Object)new CubicCurveTo(WIDTH * 0.5186915887850467, HEIGHT * 0.5327102803738317, WIDTH * 0.5327102803738317, HEIGHT * 0.5186915887850467, WIDTH * 0.5327102803738317, HEIGHT * 0.5));
                POINTER.getElements().add((Object)new CubicCurveTo(WIDTH * 0.5327102803738317, HEIGHT * 0.49065420560747663, WIDTH * 0.5280373831775701, HEIGHT * 0.48130841121495327, WIDTH * 0.5186915887850467, HEIGHT * 0.4719626168224299));
                POINTER.getElements().add((Object)new ClosePath());
                POINTER.setStrokeType(StrokeType.CENTERED);
                POINTER.setStrokeLineCap(StrokeLineCap.BUTT);
                POINTER.setStrokeLineJoin(StrokeLineJoin.ROUND);
                POINTER.setStrokeWidth(0.002 * WIDTH);
            }
        }
        if (this.control.isPointerGlowEnabled()) {
            DropShadow GLOW = new DropShadow();
            GLOW.setWidth(0.04 * SIZE);
            GLOW.setHeight(0.04 * SIZE);
            GLOW.setOffsetX(0.0);
            GLOW.setOffsetY(0.0);
            GLOW.setRadius(0.04 * SIZE);
            GLOW.setColor(this.control.getValueColor().COLOR);
            GLOW.setBlurType(BlurType.GAUSSIAN);
            if (this.control.getPointerType() == Gauge.PointerType.TYPE9) {
                POINTER_FRONT.setEffect((Effect)GLOW);
            } else {
                POINTER.setEffect((Effect)GLOW);
            }
        }
        this.pointer.getChildren().addAll((Object[])new Node[]{POINTER});
        if (this.control.getPointerType() == Gauge.PointerType.TYPE9) {
            this.pointer.getChildren().add((Object)POINTER_FRONT);
        }
        this.pointer.getTransforms().clear();
        this.pointer.setTranslateY(-WIDTH * 0.35);
        this.pointer.getTransforms().add((Object)Transform.rotate((double)this.control.getRadialRange().ROTATION_OFFSET, (double)this.center.getX(), (double)this.center.getX()));
        this.pointer.setCache(true);
        this.pointer.setCacheHint(CacheHint.ROTATE);
    }

    public void drawForeground() {
        double SIZE = this.gaugeBounds.getWidth() <= this.gaugeBounds.getHeight() ? this.gaugeBounds.getWidth() : this.gaugeBounds.getHeight();
        double WIDTH = this.gaugeBounds.getWidth();
        double HEIGHT = this.gaugeBounds.getHeight();
        this.foreground.getChildren().clear();
        Rectangle IBOUNDS = new Rectangle(0.0, 0.0, WIDTH, HEIGHT);
        IBOUNDS.setOpacity(0.0);
        IBOUNDS.setStroke(null);
        this.foreground.getChildren().add((Object)IBOUNDS);
        Path FOREGROUND = new Path();
        switch (this.control.getForegroundType()) {
            case TYPE2: {
                FOREGROUND.setFillRule(FillRule.EVEN_ODD);
                FOREGROUND.getElements().add((Object)new MoveTo(0.495 * WIDTH, 0.36923076923076925 * HEIGHT));
                FOREGROUND.getElements().add((Object)new CubicCurveTo(0.65 * WIDTH, 0.49230769230769234 * HEIGHT, 0.73 * WIDTH, 0.4846153846153846 * HEIGHT, 0.87 * WIDTH, 0.4846153846153846 * HEIGHT));
                FOREGROUND.getElements().add((Object)new CubicCurveTo(0.765 * WIDTH, 0.8 * HEIGHT, 0.52 * WIDTH, 0.9461538461538461 * HEIGHT, 0.31 * WIDTH, 0.7769230769230769 * HEIGHT));
                FOREGROUND.getElements().add((Object)new CubicCurveTo(0.155 * WIDTH, 0.6615384615384615 * HEIGHT, 0.075 * WIDTH, 0.4307692307692308 * HEIGHT, 0.08 * WIDTH, 0.19230769230769232 * HEIGHT));
                FOREGROUND.getElements().add((Object)new CubicCurveTo(0.085 * WIDTH, 0.1 * HEIGHT, 0.35 * WIDTH, 0.25384615384615383 * HEIGHT, 0.495 * WIDTH, 0.36923076923076925 * HEIGHT));
                FOREGROUND.getElements().add((Object)new ClosePath());
                FOREGROUND.setFill((Paint)new LinearGradient(0.495 * WIDTH, 0.23076923076923078 * HEIGHT, 0.3072113748856438 * WIDTH, 0.7741215956054937 * HEIGHT, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0)), new Stop(1.0, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0980392157))}));
                FOREGROUND.setStroke(null);
                this.foreground.getChildren().addAll((Object[])new Node[]{FOREGROUND});
                break;
            }
            case TYPE3: {
                FOREGROUND.setFillRule(FillRule.EVEN_ODD);
                FOREGROUND.getElements().add((Object)new MoveTo(0.08 * WIDTH, 0.26153846153846155 * HEIGHT));
                FOREGROUND.getElements().add((Object)new CubicCurveTo(0.09 * WIDTH, 0.6 * HEIGHT, 0.27 * WIDTH, 0.8692307692307693 * HEIGHT, 0.495 * WIDTH, 0.8692307692307693 * HEIGHT));
                FOREGROUND.getElements().add((Object)new CubicCurveTo(0.72 * WIDTH, 0.8692307692307693 * HEIGHT, 0.9 * WIDTH, 0.6 * HEIGHT, 0.91 * WIDTH, 0.26153846153846155 * HEIGHT));
                FOREGROUND.getElements().add((Object)new CubicCurveTo(0.865 * WIDTH, 0.5538461538461539 * HEIGHT, 0.695 * WIDTH, 0.7692307692307693 * HEIGHT, 0.495 * WIDTH, 0.7692307692307693 * HEIGHT));
                FOREGROUND.getElements().add((Object)new CubicCurveTo(0.295 * WIDTH, 0.7692307692307693 * HEIGHT, 0.125 * WIDTH, 0.5538461538461539 * HEIGHT, 0.08 * WIDTH, 0.26153846153846155 * HEIGHT));
                FOREGROUND.getElements().add((Object)new ClosePath());
                FOREGROUND.setFill((Paint)new RadialGradient(0.0, 0.0, 0.495 * WIDTH, 0.23076923076923078 * HEIGHT, 0.415 * WIDTH, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0)), new Stop(0.9, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.2274509804)), new Stop(0.96, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0)), new Stop(1.0, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0))}));
                FOREGROUND.setStroke(null);
                this.foreground.getChildren().addAll((Object[])new Node[]{FOREGROUND});
                break;
            }
            default: {
                FOREGROUND.setFillRule(FillRule.EVEN_ODD);
                FOREGROUND.getElements().add((Object)new MoveTo(0.075 * WIDTH, 0.11538461538461539 * HEIGHT));
                FOREGROUND.getElements().add((Object)new CubicCurveTo(0.145 * WIDTH, 0.11538461538461539 * HEIGHT, 0.855 * WIDTH, 0.11538461538461539 * HEIGHT, 0.915 * WIDTH, 0.11538461538461539 * HEIGHT));
                FOREGROUND.getElements().add((Object)new CubicCurveTo(0.915 * WIDTH, 0.15384615384615385 * HEIGHT, 0.735 * WIDTH, 0.2076923076923077 * HEIGHT, 0.495 * WIDTH, 0.2076923076923077 * HEIGHT));
                FOREGROUND.getElements().add((Object)new CubicCurveTo(0.255 * WIDTH, 0.2076923076923077 * HEIGHT, 0.075 * WIDTH, 0.15384615384615385 * HEIGHT, 0.075 * WIDTH, 0.11538461538461539 * HEIGHT));
                FOREGROUND.getElements().add((Object)new ClosePath());
                FOREGROUND.setFill((Paint)new LinearGradient(0.5 * WIDTH, 0.11538461538461539 * HEIGHT, 0.5 * WIDTH, 0.2076923076923077 * HEIGHT, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.2470588235)), new Stop(1.0, Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.0))}));
                FOREGROUND.setStroke(null);
                this.foreground.getChildren().addAll((Object[])new Node[]{FOREGROUND});
            }
        }
    }
}

