/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.internal.scene.control.skin;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.skin.SkinBase;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.effect.InnerShadow;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.Rectangle;
import jfxtras.labs.internal.scene.control.behavior.RaterBehavior;
import jfxtras.labs.scene.control.gauge.Rater;
import jfxtras.labs.util.Util;

public class RaterSkin
extends SkinBase<Rater, RaterBehavior> {
    private Rater control;
    private boolean isDirty;
    private boolean initialized;
    private int noOfStars;
    private int rating;
    private HBox starContainer;
    private List<Group> stars;
    private int currentIndex;
    private int currentMouseOverIndex;

    public RaterSkin(Rater CONTROL) {
        super((Control)CONTROL, (BehaviorBase)new RaterBehavior(CONTROL));
        this.control = CONTROL;
        this.initialized = false;
        this.isDirty = false;
        this.noOfStars = this.control.getNoOfStars();
        this.rating = this.control.getRating();
        this.starContainer = new HBox();
        this.stars = new ArrayList<Group>(this.noOfStars);
        this.currentIndex = 0;
        this.currentMouseOverIndex = 0;
        this.init();
    }

    private void init() {
        if (this.control.getPrefWidth() < 0.0 | this.control.getPrefHeight() < 0.0) {
            this.control.setPrefSize(this.noOfStars * 32, 32.0);
        }
        if (this.control.getMinWidth() < 0.0 | this.control.getMinHeight() < 0.0) {
            this.control.setMinSize(this.noOfStars * 8, this.noOfStars * 8);
        }
        if (this.control.getMaxWidth() < 0.0 | this.control.getMaxHeight() < 0.0) {
            this.control.setMaxSize(this.noOfStars * 256, this.noOfStars * 256);
        }
        this.registerChangeListener((ObservableValue)this.control.prefWidthProperty(), "PREF_WIDTH");
        this.registerChangeListener((ObservableValue)this.control.prefHeightProperty(), "PREF_HEIGHT");
        this.registerChangeListener((ObservableValue)this.control.darkColorProperty(), "DARK_COLOR");
        this.registerChangeListener((ObservableValue)this.control.brightColorProperty(), "BRIGHT_COLOR");
        this.registerChangeListener((ObservableValue)this.control.noOfStarsProperty(), "NO_OF_STARS");
        this.registerChangeListener((ObservableValue)this.control.ratingProperty(), "RATING");
        this.initialized = true;
        this.repaint();
    }

    protected void handleControlPropertyChanged(String PROPERTY) {
        super.handleControlPropertyChanged(PROPERTY);
        if ("NO_OF_STARS".equals(PROPERTY)) {
            this.noOfStars = this.control.getNoOfStars();
            this.drawStars();
            this.repaint();
        } else if ("RATING".equals(PROPERTY)) {
            this.rating = this.control.getRating();
            this.updateStars();
        } else if ("BRIGHT_COLOR".equals(PROPERTY)) {
            this.updateStars();
        } else if ("DARK_COLOR".equals(PROPERTY)) {
            this.updateStars();
        } else if ("PREF_WIDTH".equals(PROPERTY)) {
            this.repaint();
        } else if ("PREF_HEIGHT".equals(PROPERTY)) {
            this.repaint();
        }
    }

    public final void repaint() {
        this.isDirty = true;
        this.requestLayout();
    }

    public void layoutChildren() {
        if (!this.isDirty) {
            return;
        }
        if (!this.initialized) {
            this.init();
        }
        if (this.control.getScene() != null) {
            this.drawStars();
            this.getChildren().setAll((Object[])new Node[]{this.starContainer});
        }
        this.isDirty = false;
        super.layoutChildren();
    }

    public final Rater getSkinnable() {
        return this.control;
    }

    public final void dispose() {
        this.control = null;
    }

    protected double computePrefWidth(double PREF_WIDTH) {
        double prefWidth = 160.0;
        if (PREF_WIDTH != -1.0) {
            prefWidth = Math.max(0.0, PREF_WIDTH - this.getInsets().getLeft() - this.getInsets().getRight());
        }
        return super.computePrefWidth(prefWidth);
    }

    protected double computePrefHeight(double PREF_HEIGHT) {
        double prefHeight = 32.0;
        if (PREF_HEIGHT != -1.0) {
            prefHeight = Math.max(0.0, PREF_HEIGHT - this.getInsets().getTop() - this.getInsets().getBottom());
        }
        return super.computePrefWidth(prefHeight);
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    private void addMouseEventListener(Group STAR, final int INDEX) {
        STAR.setOnMouseEntered((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                RaterSkin.this.currentMouseOverIndex = INDEX;
                RaterSkin.this.highlightStars();
            }
        });
        STAR.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent EVENT) {
                RaterSkin.this.currentIndex = INDEX;
            }
        });
    }

    private void drawStars() {
        int i;
        this.starContainer.getChildren().clear();
        this.stars.clear();
        for (i = 0; i < this.rating; ++i) {
            this.stars.add(this.createStar(true));
        }
        for (i = 0; i < this.noOfStars - this.rating; ++i) {
            this.stars.add(this.createStar(false));
        }
        int index = 0;
        for (Group star : this.stars) {
            this.starContainer.getChildren().add((Object)star);
            this.addMouseEventListener(star, index + 1);
            ++index;
        }
    }

    private void updateStars() {
        StringBuilder styleBuilder = new StringBuilder(128);
        for (int i = 0; i < this.stars.size(); ++i) {
            styleBuilder.setLength(0);
            if (i < this.rating) {
                styleBuilder.append("-fx-rater-bright-color: " + Util.colorToCssColor(this.control.getBrightColor()));
                styleBuilder.append("-fx-rater-dark-color: " + Util.colorToCssColor(this.control.getDarkColor()));
                if (i <= this.currentMouseOverIndex - 1) {
                    styleBuilder.append("-fx-rater-stroke: " + Util.colorToCssColor(this.control.getBrightColor()));
                } else {
                    styleBuilder.append("-fx-rater-stroke: transparent;");
                }
            } else {
                styleBuilder.append("-fx-rater-bright-color: white;");
                styleBuilder.append("-fx-rater-dark-color: rgb(204, 204, 204);");
                if (i <= this.currentMouseOverIndex - 1) {
                    styleBuilder.append("-fx-rater-stroke: " + Util.colorToCssColor(this.control.getBrightColor()));
                } else {
                    styleBuilder.append("-fx-rater-stroke: transparent;");
                }
            }
            this.stars.get(i).setStyle(styleBuilder.toString());
        }
    }

    public void highlightStars() {
        StringBuilder styleBuilder = new StringBuilder(128);
        for (int i = 0; i < this.stars.size(); ++i) {
            styleBuilder.setLength(0);
            if (i < this.rating) {
                styleBuilder.append("-fx-rater-bright-color: " + Util.colorToCssColor(this.control.getBrightColor()));
                styleBuilder.append("-fx-rater-dark-color: " + Util.colorToCssColor(this.control.getDarkColor()));
            } else {
                styleBuilder.append("-fx-rater-bright-color: white;");
                styleBuilder.append("-fx-rater-dark-color: rgb(204, 204, 204);");
            }
            if (i < this.currentMouseOverIndex) {
                styleBuilder.append("-fx-rater-stroke: " + Util.colorToCssColor(this.control.getBrightColor()));
            } else {
                styleBuilder.append("-fx-rater-stroke: transparent;");
            }
            this.stars.get(i).setStyle(styleBuilder.toString());
        }
    }

    public void deHighlightStars() {
        StringBuilder styleBuilder = new StringBuilder(128);
        this.currentMouseOverIndex = 0;
        for (int i = 0; i < this.stars.size(); ++i) {
            styleBuilder.setLength(0);
            if (i < this.rating) {
                styleBuilder.append("-fx-rater-bright-color: " + Util.colorToCssColor(this.control.getBrightColor()));
                styleBuilder.append("-fx-rater-dark-color: " + Util.colorToCssColor(this.control.getDarkColor()));
            } else {
                styleBuilder.append("-fx-rater-bright-color: white;");
                styleBuilder.append("-fx-rater-dark-color: rgb(204, 204, 204);");
            }
            styleBuilder.append("-fx-rater-stroke: transparent;");
            this.stars.get(i).setStyle(styleBuilder.toString());
        }
    }

    private final Group createStar(boolean SELECTED) {
        double SIZE;
        double WIDTH = SIZE = this.control.getPrefWidth() < this.control.getPrefHeight() ? this.control.getPrefWidth() : this.control.getPrefHeight();
        double HEIGHT = SIZE;
        Group STAR = new Group();
        if (SELECTED) {
            STAR.setStyle("-fx-rater-bright-color: " + Util.colorToCssColor(this.control.getBrightColor()) + "-fx-rater-dark-color: " + Util.colorToCssColor(this.control.getDarkColor()) + "-fx-rater-stroke: transparent");
        } else {
            STAR.setStyle("-fx-rater-bright-color: white;-fx-rater-dark-color: rgb(204, 204, 204);-fx-rater-stroke: transparent");
        }
        Rectangle IBOUNDS = new Rectangle(0.0, 0.0, WIDTH, HEIGHT);
        IBOUNDS.setOpacity(0.0);
        STAR.getChildren().add((Object)IBOUNDS);
        Path STAR_SHAPE = new Path();
        STAR_SHAPE.setFillRule(FillRule.EVEN_ODD);
        STAR_SHAPE.getElements().add((Object)new MoveTo(0.5 * WIDTH, 0.04 * HEIGHT));
        STAR_SHAPE.getElements().add((Object)new CubicCurveTo(0.505 * WIDTH, 0.04 * HEIGHT, 0.64 * WIDTH, 0.35 * HEIGHT, 0.64 * WIDTH, 0.35 * HEIGHT));
        STAR_SHAPE.getElements().add((Object)new CubicCurveTo(0.64 * WIDTH, 0.35 * HEIGHT, 0.975 * WIDTH, 0.385 * HEIGHT, 0.975 * WIDTH, 0.385 * HEIGHT));
        STAR_SHAPE.getElements().add((Object)new CubicCurveTo(0.975 * WIDTH, 0.39 * HEIGHT, 0.725 * WIDTH, 0.615 * HEIGHT, 0.725 * WIDTH, 0.615 * HEIGHT));
        STAR_SHAPE.getElements().add((Object)new CubicCurveTo(0.725 * WIDTH, 0.615 * HEIGHT, 0.795 * WIDTH, 0.94 * HEIGHT, 0.795 * WIDTH, 0.945 * HEIGHT));
        STAR_SHAPE.getElements().add((Object)new CubicCurveTo(0.79 * WIDTH, 0.945 * HEIGHT, 0.5 * WIDTH, 0.78 * HEIGHT, 0.5 * WIDTH, 0.78 * HEIGHT));
        STAR_SHAPE.getElements().add((Object)new CubicCurveTo(0.5 * WIDTH, 0.78 * HEIGHT, 0.21 * WIDTH, 0.945 * HEIGHT, 0.205 * WIDTH, 0.945 * HEIGHT));
        STAR_SHAPE.getElements().add((Object)new CubicCurveTo(0.205 * WIDTH, 0.94 * HEIGHT, 0.275 * WIDTH, 0.615 * HEIGHT, 0.275 * WIDTH, 0.615 * HEIGHT));
        STAR_SHAPE.getElements().add((Object)new CubicCurveTo(0.275 * WIDTH, 0.615 * HEIGHT, 0.025 * WIDTH, 0.39 * HEIGHT, 0.025 * WIDTH, 0.385 * HEIGHT));
        STAR_SHAPE.getElements().add((Object)new CubicCurveTo(0.025 * WIDTH, 0.385 * HEIGHT, 0.36 * WIDTH, 0.35 * HEIGHT, 0.36 * WIDTH, 0.35 * HEIGHT));
        STAR_SHAPE.getElements().add((Object)new CubicCurveTo(0.36 * WIDTH, 0.35 * HEIGHT, 0.495 * WIDTH, 0.04 * HEIGHT, 0.5 * WIDTH, 0.04 * HEIGHT));
        STAR_SHAPE.getElements().add((Object)new ClosePath());
        STAR_SHAPE.setSmooth(true);
        STAR_SHAPE.getStyleClass().add((Object)"star-fill");
        InnerShadow INNER_GLOW = new InnerShadow();
        INNER_GLOW.setWidth(0.2 * STAR_SHAPE.getLayoutBounds().getWidth());
        INNER_GLOW.setHeight(0.2 * STAR_SHAPE.getLayoutBounds().getHeight());
        INNER_GLOW.setOffsetX(0.0);
        INNER_GLOW.setOffsetY(0.0);
        INNER_GLOW.setRadius(0.2 * STAR_SHAPE.getLayoutBounds().getWidth());
        INNER_GLOW.setColor(Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.65));
        INNER_GLOW.setBlurType(BlurType.GAUSSIAN);
        InnerShadow INNER_SHADOW = new InnerShadow();
        INNER_SHADOW.setWidth(0.1 * STAR_SHAPE.getLayoutBounds().getWidth());
        INNER_SHADOW.setHeight(0.1 * STAR_SHAPE.getLayoutBounds().getHeight());
        INNER_SHADOW.setOffsetX(0.0);
        INNER_SHADOW.setOffsetY(0.0);
        INNER_SHADOW.setRadius(0.1 * STAR_SHAPE.getLayoutBounds().getWidth());
        INNER_SHADOW.setColor(Color.color((double)0.0, (double)0.0, (double)0.0, (double)0.65));
        INNER_SHADOW.setBlurType(BlurType.GAUSSIAN);
        INNER_SHADOW.inputProperty().set((Object)INNER_GLOW);
        DropShadow DROP_SHADOW = new DropShadow();
        DROP_SHADOW.setWidth(0.1 * STAR_SHAPE.getLayoutBounds().getWidth());
        DROP_SHADOW.setHeight(0.1 * STAR_SHAPE.getLayoutBounds().getHeight());
        DROP_SHADOW.setOffsetX(0.0);
        DROP_SHADOW.setOffsetY(0.0);
        DROP_SHADOW.setRadius(0.1 * STAR_SHAPE.getLayoutBounds().getWidth());
        DROP_SHADOW.setColor(Color.color((double)0.0, (double)0.0, (double)0.0, (double)0.65));
        DROP_SHADOW.setBlurType(BlurType.GAUSSIAN);
        DROP_SHADOW.inputProperty().set((Object)INNER_SHADOW);
        STAR_SHAPE.setEffect((Effect)DROP_SHADOW);
        Path INNER_HIGHLIGHT = new Path();
        INNER_HIGHLIGHT.setFillRule(FillRule.EVEN_ODD);
        INNER_HIGHLIGHT.getElements().add((Object)new MoveTo(0.5 * WIDTH, 0.09 * HEIGHT));
        INNER_HIGHLIGHT.getElements().add((Object)new CubicCurveTo(0.49 * WIDTH, 0.09 * HEIGHT, 0.365 * WIDTH, 0.355 * HEIGHT, 0.365 * WIDTH, 0.355 * HEIGHT));
        INNER_HIGHLIGHT.getElements().add((Object)new CubicCurveTo(0.365 * WIDTH, 0.355 * HEIGHT, 0.05 * WIDTH, 0.39 * HEIGHT, 0.045 * WIDTH, 0.395 * HEIGHT));
        INNER_HIGHLIGHT.getElements().add((Object)new CubicCurveTo(0.045 * WIDTH, 0.395 * HEIGHT, 0.055 * WIDTH, 0.4 * HEIGHT, 0.065 * WIDTH, 0.41 * HEIGHT));
        INNER_HIGHLIGHT.getElements().add((Object)new CubicCurveTo(0.135 * WIDTH, 0.4 * HEIGHT, 0.375 * WIDTH, 0.375 * HEIGHT, 0.375 * WIDTH, 0.375 * HEIGHT));
        INNER_HIGHLIGHT.getElements().add((Object)new CubicCurveTo(0.375 * WIDTH, 0.375 * HEIGHT, 0.495 * WIDTH, 0.155 * HEIGHT, 0.5 * WIDTH, 0.155 * HEIGHT));
        INNER_HIGHLIGHT.getElements().add((Object)new CubicCurveTo(0.51 * WIDTH, 0.155 * HEIGHT, 0.625 * WIDTH, 0.375 * HEIGHT, 0.625 * WIDTH, 0.375 * HEIGHT));
        INNER_HIGHLIGHT.getElements().add((Object)new CubicCurveTo(0.625 * WIDTH, 0.375 * HEIGHT, 0.865 * WIDTH, 0.4 * HEIGHT, 0.935 * WIDTH, 0.41 * HEIGHT));
        INNER_HIGHLIGHT.getElements().add((Object)new CubicCurveTo(0.945 * WIDTH, 0.4 * HEIGHT, 0.955 * WIDTH, 0.395 * HEIGHT, 0.955 * WIDTH, 0.395 * HEIGHT));
        INNER_HIGHLIGHT.getElements().add((Object)new CubicCurveTo(0.95 * WIDTH, 0.39 * HEIGHT, 0.635 * WIDTH, 0.355 * HEIGHT, 0.635 * WIDTH, 0.355 * HEIGHT));
        INNER_HIGHLIGHT.getElements().add((Object)new CubicCurveTo(0.635 * WIDTH, 0.355 * HEIGHT, 0.51 * WIDTH, 0.09 * HEIGHT, 0.5 * WIDTH, 0.09 * HEIGHT));
        INNER_HIGHLIGHT.getElements().add((Object)new ClosePath());
        INNER_HIGHLIGHT.setSmooth(true);
        INNER_HIGHLIGHT.getStyleClass().add((Object)"highlights-inner-fill");
        INNER_HIGHLIGHT.setStroke(null);
        Path TOP_HIGHLIGHT = new Path();
        TOP_HIGHLIGHT.setFillRule(FillRule.EVEN_ODD);
        TOP_HIGHLIGHT.getElements().add((Object)new MoveTo(0.5 * WIDTH, 0.065 * HEIGHT));
        TOP_HIGHLIGHT.getElements().add((Object)new CubicCurveTo(0.495 * WIDTH, 0.065 * HEIGHT, 0.365 * WIDTH, 0.355 * HEIGHT, 0.365 * WIDTH, 0.355 * HEIGHT));
        TOP_HIGHLIGHT.getElements().add((Object)new CubicCurveTo(0.365 * WIDTH, 0.355 * HEIGHT, 0.05 * WIDTH, 0.39 * HEIGHT, 0.045 * WIDTH, 0.395 * HEIGHT));
        TOP_HIGHLIGHT.getElements().add((Object)new CubicCurveTo(0.045 * WIDTH, 0.395 * HEIGHT, 0.21 * WIDTH, 0.54 * HEIGHT, 0.265 * WIDTH, 0.595 * HEIGHT));
        TOP_HIGHLIGHT.getElements().add((Object)new CubicCurveTo(0.415 * WIDTH, 0.485 * HEIGHT, 0.655 * WIDTH, 0.415 * HEIGHT, 0.93 * WIDTH, 0.415 * HEIGHT));
        TOP_HIGHLIGHT.getElements().add((Object)new CubicCurveTo(0.93 * WIDTH, 0.415 * HEIGHT, 0.93 * WIDTH, 0.415 * HEIGHT, 0.93 * WIDTH, 0.415 * HEIGHT));
        TOP_HIGHLIGHT.getElements().add((Object)new CubicCurveTo(0.945 * WIDTH, 0.4 * HEIGHT, 0.955 * WIDTH, 0.395 * HEIGHT, 0.955 * WIDTH, 0.395 * HEIGHT));
        TOP_HIGHLIGHT.getElements().add((Object)new CubicCurveTo(0.95 * WIDTH, 0.39 * HEIGHT, 0.635 * WIDTH, 0.355 * HEIGHT, 0.635 * WIDTH, 0.355 * HEIGHT));
        TOP_HIGHLIGHT.getElements().add((Object)new CubicCurveTo(0.635 * WIDTH, 0.355 * HEIGHT, 0.505 * WIDTH, 0.065 * HEIGHT, 0.5 * WIDTH, 0.065 * HEIGHT));
        TOP_HIGHLIGHT.getElements().add((Object)new ClosePath());
        TOP_HIGHLIGHT.setSmooth(true);
        TOP_HIGHLIGHT.getStyleClass().add((Object)"highlights-top-fill");
        TOP_HIGHLIGHT.setStroke(null);
        STAR.getChildren().addAll((Object[])new Node[]{STAR_SHAPE, INNER_HIGHLIGHT, TOP_HIGHLIGHT});
        STAR.setCache(true);
        return STAR;
    }
}

