/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.internal.scene.control.skin;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.skin.SkinBase;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import javafx.animation.AnimationTimer;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Point2D;
import javafx.geometry.VPos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Control;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.DropShadowBuilder;
import javafx.scene.effect.Effect;
import javafx.scene.effect.InnerShadowBuilder;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.RadialGradient;
import javafx.scene.paint.Stop;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.Circle;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.RotateBuilder;
import javafx.util.Duration;
import jfxtras.labs.internal.scene.control.behavior.SmallRadialBehavior;
import jfxtras.labs.scene.control.gauge.Section;
import jfxtras.labs.scene.control.gauge.SmallRadial;

public class SmallRadialSkin
extends SkinBase<SmallRadial, SmallRadialBehavior> {
    private SmallRadial control;
    private Group smallRadial;
    private Path pointer;
    private Text valueText;
    private Canvas background;
    private GraphicsContext ctxBackground;
    private Canvas ledOn;
    private GraphicsContext ctxLedOn;
    private boolean on;
    private Point2D center;
    private double angleOffset;
    private NumberFormat valueFormat;
    private Timeline timeline;
    private DoubleProperty gaugeValue;
    private double size;
    private Rotate rotate;
    private boolean isDirty;
    private boolean initialized;
    private long lastTimerCall;
    private AnimationTimer timer;

    public SmallRadialSkin(SmallRadial CONTROL) {
        super((Control)CONTROL, (BehaviorBase)new SmallRadialBehavior(CONTROL));
        this.control = CONTROL;
        this.initialized = false;
        this.isDirty = false;
        this.smallRadial = new Group();
        this.pointer = new Path();
        this.valueFormat = new DecimalFormat("0.0", new DecimalFormatSymbols(Locale.US));
        this.valueText = new Text(this.valueFormat.format(this.control.getValue()));
        this.background = new Canvas();
        this.ctxBackground = this.background.getGraphicsContext2D();
        this.ledOn = new Canvas();
        this.ctxLedOn = this.ledOn.getGraphicsContext2D();
        this.on = false;
        this.center = new Point2D(100.0, 100.0);
        this.angleOffset = -(this.control.getRadialRange().ANGLE_RANGE * 0.5);
        this.timeline = new Timeline();
        this.gaugeValue = new SimpleDoubleProperty(this.control.getValue());
        this.size = 200.0;
        this.rotate = RotateBuilder.create().pivotX(100.0).pivotY(100.0).angle(this.angleOffset + (this.gaugeValue.get() - this.control.getMinValue()) * this.control.getAngleStep()).build();
        this.lastTimerCall = System.nanoTime();
        this.timer = new AnimationTimer(){

            public void handle(long NOW) {
                if (NOW > SmallRadialSkin.this.lastTimerCall + 500000000L) {
                    SmallRadialSkin.this.on = (byte)(SmallRadialSkin.this.on ^ 1);
                    SmallRadialSkin.this.ledOn.setVisible(SmallRadialSkin.this.on);
                    SmallRadialSkin.this.lastTimerCall = NOW;
                }
            }
        };
        this.init();
    }

    private void init() {
        if (this.control.getPrefWidth() < 0.0 | this.control.getPrefHeight() < 0.0) {
            this.control.setPrefSize(121.0, 121.0);
        }
        if (this.control.getMinWidth() < 0.0 | this.control.getMinHeight() < 0.0) {
            this.control.setMinSize(50.0, 50.0);
        }
        if (this.control.getMaxWidth() < 0.0 | this.control.getMaxHeight() < 0.0) {
            this.control.setMaxSize(1024.0, 1024.0);
        }
        this.ledOn.setVisible(false);
        this.registerChangeListener((ObservableValue)this.control.widthProperty(), "WIDTH");
        this.registerChangeListener((ObservableValue)this.control.heightProperty(), "HEIGHT");
        this.registerChangeListener((ObservableValue)this.control.prefWidthProperty(), "WIDTH");
        this.registerChangeListener((ObservableValue)this.control.prefHeightProperty(), "HEIGHT");
        this.registerChangeListener((ObservableValue)this.control.minWidthProperty(), "WIDTH");
        this.registerChangeListener((ObservableValue)this.control.minHeightProperty(), "HEIGHT");
        this.registerChangeListener((ObservableValue)this.control.maxWidthProperty(), "WIDTH");
        this.registerChangeListener((ObservableValue)this.control.maxHeightProperty(), "HEIGHT");
        this.registerChangeListener((ObservableValue)this.control.titleProperty(), "FULL_REPAINT");
        this.registerChangeListener((ObservableValue)this.control.ledVisibleProperty(), "FULL_REPAINT");
        this.registerChangeListener((ObservableValue)this.control.minValueProperty(), "FULL_REPAINT");
        this.registerChangeListener((ObservableValue)this.control.maxValueProperty(), "FULL_REPAINT");
        this.registerChangeListener((ObservableValue)this.control.gaugeModelProperty(), "FULL_REPAINT");
        this.registerChangeListener((ObservableValue)this.control.labelColorProperty(), "FULL_REPAINT");
        this.registerChangeListener((ObservableValue)this.control.frameColorProperty(), "FULL_REPAINT");
        this.registerChangeListener((ObservableValue)this.control.backgroundColorProperty(), "FULL_REPAINT");
        this.registerChangeListener((ObservableValue)this.control.tickMarkColorProperty(), "FULL_REPAINT");
        this.registerChangeListener((ObservableValue)this.control.pointerColorProperty(), "FULL_REPAINT");
        this.registerChangeListener((ObservableValue)this.control.centerKnobColorProperty(), "FULL_REPAINT");
        this.registerChangeListener((ObservableValue)this.control.thresholdLedColorProperty(), "FULL_REPAINT");
        this.registerChangeListener((ObservableValue)this.control.pointerShadowVisibleProperty(), "FULL_REPAINT");
        this.registerChangeListener((ObservableValue)this.control.noOfDecimalsProperty(), "LABEL");
        this.registerChangeListener((ObservableValue)this.control.valueProperty(), "VALUE");
        this.registerChangeListener((ObservableValue)this.control.thresholdExceededProperty(), "THRESHOLD_EXCEEDED");
        this.registerChangeListener((ObservableValue)this.gaugeValue, "GAUGE_VALUE");
        this.addBindings();
        this.addListeners();
        this.pointer.getTransforms().add((Object)this.rotate);
        if (this.control.getValue() > this.control.getThreshold()) {
            this.control.setThresholdExceeded(true);
        }
        this.initialized = true;
        this.repaint();
    }

    private void addBindings() {
        if (this.valueText.visibleProperty().isBound()) {
            this.valueText.visibleProperty().unbind();
        }
        this.valueText.visibleProperty().bind((ObservableValue)this.control.valueLabelVisibleProperty());
    }

    private void addListeners() {
        this.gaugeValue.addListener(new InvalidationListener(){

            public void invalidated(Observable observable) {
                if (SmallRadialSkin.this.control.isThresholdBehaviorInverted()) {
                    SmallRadialSkin.this.control.setThresholdExceeded(SmallRadialSkin.this.gaugeValue.doubleValue() < SmallRadialSkin.this.control.getThreshold());
                } else {
                    SmallRadialSkin.this.control.setThresholdExceeded(SmallRadialSkin.this.gaugeValue.doubleValue() > SmallRadialSkin.this.control.getThreshold());
                }
            }
        });
    }

    protected void handleControlPropertyChanged(String PROPERTY) {
        super.handleControlPropertyChanged(PROPERTY);
        if ("WIDTH".equals(PROPERTY)) {
            this.reCalcParameters();
            this.repaint();
        } else if ("HEIGHT".equals(PROPERTY)) {
            this.reCalcParameters();
            this.repaint();
        } else if ("FULL_REPAINT".equals(PROPERTY)) {
            this.repaint();
        } else if ("VALUE".equals(PROPERTY)) {
            if (this.control.isValueAnimationEnabled()) {
                KeyValue KEY_VALUE = new KeyValue((WritableValue)this.gaugeValue, (Object)this.control.getValue(), Interpolator.EASE_BOTH);
                KeyFrame KEY_FRAME = new KeyFrame(Duration.millis((double)this.control.getTimeToValueInMs()), new KeyValue[]{KEY_VALUE});
                this.timeline.setOnFinished((EventHandler)new EventHandler<ActionEvent>(){

                    public void handle(ActionEvent actionEvent) {
                        SmallRadialSkin.this.gaugeValue.set(SmallRadialSkin.this.control.getValue());
                    }
                });
                this.timeline = new Timeline();
                this.timeline.getKeyFrames().add((Object)KEY_FRAME);
                this.timeline.play();
            } else {
                this.gaugeValue.set(this.control.getValue());
            }
        } else if ("LABEL".equals(PROPERTY)) {
            this.updateNumberFormat();
            this.repaint();
        } else if ("GAUGE_VALUE".equals(PROPERTY)) {
            this.valueText.setText(this.valueFormat.format(this.gaugeValue.get()));
            this.valueText.setX((this.size - this.valueText.getLayoutBounds().getWidth()) * 0.5);
            this.valueText.setY(0.88 * this.size);
            this.rotate.setAngle(this.angleOffset + (this.gaugeValue.get() - this.control.getMinValue()) * this.control.getAngleStep());
        } else if ("THRESHOLD_EXCEEDED".equals(PROPERTY)) {
            if (this.control.isThresholdExceeded()) {
                this.timer.start();
            } else {
                this.timer.stop();
                this.on = false;
                this.ledOn.setVisible(this.on);
            }
        }
    }

    public final void repaint() {
        this.isDirty = true;
        this.requestLayout();
    }

    public void layoutChildren() {
        if (!this.isDirty) {
            return;
        }
        if (!this.initialized) {
            this.init();
        }
        this.drawGauge();
        this.getChildren().setAll((Object[])new Node[]{this.smallRadial});
        this.isDirty = false;
        super.layoutChildren();
    }

    public final SmallRadial getSkinnable() {
        return this.control;
    }

    public final void dispose() {
        this.control = null;
    }

    protected double computePrefWidth(double PREF_HEIGHT) {
        double prefHeight = 121.0;
        if (PREF_HEIGHT != -1.0) {
            prefHeight = Math.max(0.0, PREF_HEIGHT - this.getInsets().getLeft() - this.getInsets().getRight());
        }
        return super.computePrefWidth(prefHeight);
    }

    protected double computePrefHeight(double PREF_WIDTH) {
        double prefWidth = 121.0;
        if (PREF_WIDTH != -1.0) {
            prefWidth = Math.max(0.0, PREF_WIDTH - this.getInsets().getTop() - this.getInsets().getBottom());
        }
        return super.computePrefHeight(prefWidth);
    }

    protected double computeMinWidth(double MIN_HEIGHT) {
        return super.computeMinWidth(Math.max(121.0, MIN_HEIGHT - this.getInsets().getLeft() - this.getInsets().getRight()));
    }

    protected double computeMinHeight(double MIN_WIDTH) {
        return super.computeMinHeight(Math.max(121.0, MIN_WIDTH - this.getInsets().getTop() - this.getInsets().getBottom()));
    }

    protected double computeMaxWidth(double MAX_HEIGHT) {
        return super.computeMaxWidth(Math.max(121.0, MAX_HEIGHT - this.getInsets().getLeft() - this.getInsets().getRight()));
    }

    protected double computeMaxHeight(double MAX_WIDTH) {
        return super.computeMaxHeight(Math.max(121.0, MAX_WIDTH - this.getInsets().getTop() - this.getInsets().getBottom()));
    }

    private void updateNumberFormat() {
        StringBuilder noOfDecimals = new StringBuilder(5);
        if (this.control.getNoOfDecimals() == 0) {
            noOfDecimals.append("0");
        } else {
            noOfDecimals.append("0.");
            for (int i = 0; i < this.control.getNoOfDecimals(); ++i) {
                noOfDecimals.append("0");
            }
        }
        this.valueFormat = new DecimalFormat(noOfDecimals.toString(), new DecimalFormatSymbols(Locale.US));
    }

    private void reCalcParameters() {
        this.size = this.control.getPrefWidth() < this.control.getPrefHeight() ? this.control.getPrefWidth() : this.control.getPrefHeight();
        double c = 0.5 * this.size;
        this.angleOffset = -(this.control.getRadialRange().ANGLE_RANGE * 0.5);
        this.center = new Point2D(c, c);
        this.rotate.setPivotX(c);
        this.rotate.setPivotY(c);
        this.valueText.setFont(Font.font((String)"Verdana", (FontWeight)FontWeight.NORMAL, (FontPosture)FontPosture.REGULAR, (double)(0.11570247933884298 * this.size)));
        this.valueText.setX((this.size - this.valueText.getLayoutBounds().getWidth()) * 0.5);
        this.valueText.setY(0.88 * this.size);
        this.background.setWidth(this.size);
        this.background.setHeight(this.size);
        this.ledOn.setWidth(this.size);
        this.ledOn.setHeight(this.size);
        this.drawGaugeBackground();
        this.drawLedOn(this.ctxLedOn);
    }

    private final void drawGauge() {
        this.valueText.setFont(Font.font((String)"Verdana", (FontWeight)FontWeight.NORMAL, (FontPosture)FontPosture.REGULAR, (double)(0.11570247933884298 * this.size)));
        this.valueText.setX((this.size - this.valueText.getLayoutBounds().getWidth()) * 0.5);
        this.valueText.setY(0.88 * this.size);
        this.valueText.setTextOrigin(VPos.BOTTOM);
        this.valueText.setFill((Paint)this.control.getValueLabelColor());
        this.pointer.setFillRule(FillRule.EVEN_ODD);
        this.pointer.getElements().add((Object)new MoveTo(0.5 * this.size, 0.12396694214876033 * this.size));
        this.pointer.getElements().add((Object)new CubicCurveTo(0.5 * this.size, 0.12396694214876033 * this.size, 0.48760330578512395 * this.size, 0.371900826446281 * this.size, 0.48760330578512395 * this.size, 0.4380165289256198 * this.size));
        this.pointer.getElements().add((Object)new CubicCurveTo(0.48760330578512395 * this.size, 0.4380165289256198 * this.size, 0.48760330578512395 * this.size, 0.5619834710743802 * this.size, 0.48760330578512395 * this.size, 0.5619834710743802 * this.size));
        this.pointer.getElements().add((Object)new CubicCurveTo(0.48760330578512395 * this.size, 0.5619834710743802 * this.size, 0.48760330578512395 * this.size, 0.6033057851239669 * this.size, 0.5 * this.size, 0.6033057851239669 * this.size));
        this.pointer.getElements().add((Object)new CubicCurveTo(0.512396694214876 * this.size, 0.6033057851239669 * this.size, 0.512396694214876 * this.size, 0.5619834710743802 * this.size, 0.512396694214876 * this.size, 0.5619834710743802 * this.size));
        this.pointer.getElements().add((Object)new CubicCurveTo(0.512396694214876 * this.size, 0.5619834710743802 * this.size, 0.512396694214876 * this.size, 0.4380165289256198 * this.size, 0.512396694214876 * this.size, 0.4380165289256198 * this.size));
        this.pointer.getElements().add((Object)new CubicCurveTo(0.512396694214876 * this.size, 0.371900826446281 * this.size, 0.5 * this.size, 0.12396694214876033 * this.size, 0.5 * this.size, 0.12396694214876033 * this.size));
        this.pointer.getElements().add((Object)new ClosePath());
        Color POINTER_FILL = Color.color((double)this.control.getPointerColor().getRed(), (double)this.control.getPointerColor().getGreen(), (double)this.control.getPointerColor().getBlue(), (double)0.8);
        this.pointer.setStroke((Paint)POINTER_FILL.darker());
        this.pointer.setFill((Paint)POINTER_FILL);
        if (this.control.isPointerShadowVisible()) {
            this.pointer.setEffect((Effect)DropShadowBuilder.create().radius(0.05 * this.size).color(Color.rgb((int)0, (int)0, (int)0, (double)0.5)).blurType(BlurType.GAUSSIAN).build());
        }
        Circle KNOB = new Circle(0.5 * this.size, 0.5 * this.size, 0.06198347107438017 * this.size);
        KNOB.setFill((Paint)new LinearGradient(0.0, KNOB.getLayoutBounds().getMinY(), 0.0, KNOB.getLayoutBounds().getMaxY(), false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, this.control.getCenterKnobColor().brighter()), new Stop(1.0, this.control.getCenterKnobColor().darker())}));
        KNOB.setStroke(null);
        KNOB.setEffect((Effect)InnerShadowBuilder.create().radius(0.0085 * this.size).blurType(BlurType.GAUSSIAN).build());
        this.smallRadial.getChildren().clear();
        this.smallRadial.getChildren().addAll((Object[])new Node[]{this.background, this.valueText, this.ledOn});
        this.smallRadial.getChildren().addAll((Object[])new Node[]{this.pointer, KNOB});
    }

    private void drawTickmarks(GraphicsContext CTX) {
        double offset = 180.0 + this.control.getRadialRange().ANGLE_RANGE * 0.5;
        double angle = 0.0;
        double counter = this.control.getMinValue();
        while (Double.compare(counter, this.control.getMaxValue()) <= 0) {
            double sinValue = Math.sin(Math.toRadians(angle + offset));
            double cosValue = Math.cos(Math.toRadians(angle + offset));
            Point2D innerPoint = new Point2D(this.center.getX() + this.size * 0.36 * sinValue, this.center.getY() + this.size * 0.36 * cosValue);
            Point2D outerPoint = new Point2D(this.center.getX() + this.size * 0.41 * sinValue, this.center.getY() + this.size * 0.41 * cosValue);
            Point2D textPoint = new Point2D(this.center.getX() + this.size * 0.32 * sinValue, this.center.getY() + this.size * 0.32 * cosValue);
            CTX.setStroke((Paint)this.control.getTickMarkColor());
            if (counter % 10.0 == 0.0) {
                CTX.strokeLine(innerPoint.getX(), innerPoint.getY(), outerPoint.getX(), outerPoint.getY());
            }
            if (Double.compare(this.control.getMinValue(), counter) == 0 || Double.compare(this.control.getMaxValue(), counter) == 0) {
                CTX.save();
                CTX.setFont(Font.font((String)"Verdana", (FontWeight)FontWeight.NORMAL, (double)(0.04 * this.size)));
                CTX.setTextAlign(TextAlignment.CENTER);
                CTX.setFill((Paint)this.control.getTickMarkColor());
                CTX.fillText(Integer.toString((int)counter), textPoint.getX(), textPoint.getY());
                CTX.restore();
            }
            angle -= this.control.getAngleStep();
            counter += 1.0;
        }
    }

    private final void drawSections(GraphicsContext CTX) {
        double xy = (this.size - 0.77 * this.size) * 0.5;
        double wh = this.size * 0.77;
        double OFFSET = this.angleOffset - 90.0;
        for (Section section : this.control.getSections()) {
            double ANGLE_START = (section.getStart() - this.control.getMinValue()) * this.control.getAngleStep();
            double ANGLE_EXTEND = (section.getStop() - section.getStart()) * this.control.getAngleStep();
            CTX.save();
            CTX.setStroke((Paint)section.getColor());
            CTX.setLineWidth(this.size * 0.07);
            CTX.setLineCap(StrokeLineCap.BUTT);
            CTX.strokeArc(xy, xy, wh, wh, -(OFFSET + ANGLE_START), -ANGLE_EXTEND, ArcType.OPEN);
            CTX.restore();
        }
    }

    private final void drawLedOff(GraphicsContext ctx) {
        ctx.save();
        ctx.beginPath();
        ctx.arc(0.3677685950413223 * this.size, 0.6074380165289256 * this.size, 0.05371900826446281 * this.size, 0.05371900826446281 * this.size, 0.0, 360.0);
        ctx.setFill((Paint)new LinearGradient(0.3305785123966942 * this.size, 0.5702479338842975 * this.size, 0.40654866244152993 * this.size, 0.6462180839291333 * this.size, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)0.0784313725, (double)0.0784313725, (double)0.0784313725, (double)0.6470588235)), new Stop(0.15, Color.color((double)0.0784313725, (double)0.0784313725, (double)0.0784313725, (double)0.6470588235)), new Stop(0.26, Color.color((double)0.1607843137, (double)0.1607843137, (double)0.1607843137, (double)0.6470588235)), new Stop(0.261, Color.color((double)0.1607843137, (double)0.1607843137, (double)0.1607843137, (double)0.6431372549)), new Stop(0.85, Color.color((double)0.7843137255, (double)0.7843137255, (double)0.7843137255, (double)0.4039215686)), new Stop(1.0, Color.color((double)0.7843137255, (double)0.7843137255, (double)0.7843137255, (double)0.3450980392))}));
        ctx.fill();
        ctx.restore();
        ctx.save();
        ctx.beginPath();
        ctx.arc(0.3677685950413223 * this.size, 0.6074380165289256 * this.size, 0.045454545454545456 * this.size, 0.045454545454545456 * this.size, 0.0, 360.0);
        ctx.setFill((Paint)new LinearGradient(0.33884297520661155 * this.size, 0.5785123966942148 * this.size, 0.3972815521641775 * this.size, 0.6369509736517808 * this.size, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, this.control.getThresholdLedColor().darker().darker()), new Stop(0.49, this.control.getThresholdLedColor().darker().darker().darker()), new Stop(1.0, this.control.getThresholdLedColor().darker().darker())}));
        ctx.fill();
        ctx.applyEffect((Effect)InnerShadowBuilder.create().offsetX(0.0 * this.size).offsetY(0.0 * this.size).radius(0.0013523666 * this.size).color(Color.color((double)0.0, (double)0.0, (double)0.0, (double)1.0)).blurType(BlurType.GAUSSIAN).input(null).build());
        ctx.restore();
        ctx.save();
        ctx.beginPath();
        ctx.arc(0.3677685950413223 * this.size, 0.6074380165289256 * this.size, 0.0371900826446281 * this.size, 0.0371900826446281 * this.size, 0.0, 360.0);
        ctx.setFill((Paint)new RadialGradient(0.0, 0.0, 0.33884297520661155 * this.size, 0.5785123966942148 * this.size, 0.0371900826446281 * this.size, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)0.7843137255, (double)0.7607843137, (double)0.8156862745, (double)0.6)), new Stop(1.0, Color.TRANSPARENT)}));
        ctx.fill();
        ctx.restore();
    }

    private final void drawLedOn(GraphicsContext ctx) {
        ctx.save();
        ctx.beginPath();
        ctx.arc(0.3677685950413223 * this.size, 0.6074380165289256 * this.size, 0.045454545454545456 * this.size, 0.045454545454545456 * this.size, 0.0, 360.0);
        ctx.setFill((Paint)new LinearGradient(0.33884297520661155 * this.size, 0.5785123966942148 * this.size, 0.3972815521641775 * this.size, 0.6369509736517808 * this.size, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, this.control.getThresholdLedColor()), new Stop(0.49, this.control.getThresholdLedColor().darker()), new Stop(1.0, this.control.getThresholdLedColor().brighter())}));
        ctx.fill();
        ctx.applyEffect((Effect)DropShadowBuilder.create().offsetX(0.0 * this.size).offsetY(0.0 * this.size).radius(0.05 * this.size).color(this.control.getThresholdLedColor().brighter()).blurType(BlurType.GAUSSIAN).input((Effect)InnerShadowBuilder.create().offsetX(0.0 * this.size).offsetY(0.0 * this.size).radius(0.0013523666 * this.size).color(Color.color((double)0.0, (double)0.0, (double)0.0, (double)1.0)).blurType(BlurType.GAUSSIAN).build()).build());
        ctx.restore();
        ctx.save();
        ctx.beginPath();
        ctx.arc(0.3677685950413223 * this.size, 0.6074380165289256 * this.size, 0.0371900826446281 * this.size, 0.0371900826446281 * this.size, 0.0, 360.0);
        ctx.setFill((Paint)new RadialGradient(0.0, 0.0, 0.33884297520661155 * this.size, 0.5785123966942148 * this.size, 0.0371900826446281 * this.size, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.color((double)0.7843137255, (double)0.7607843137, (double)0.8156862745, (double)0.6)), new Stop(1.0, Color.TRANSPARENT)}));
        ctx.fill();
        ctx.restore();
    }

    private final void drawGaugeBackground() {
        this.ctxBackground.clearRect(0.0, 0.0, this.size, this.size);
        this.ctxBackground.save();
        this.ctxBackground.beginPath();
        this.ctxBackground.arc(0.5 * this.size, 0.5 * this.size, 0.5 * this.size, 0.5 * this.size, 0.0, 360.0);
        this.ctxBackground.setFill((Paint)new LinearGradient(0.0, 0.0, 0.0, this.size, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, this.control.getFrameColor().brighter()), new Stop(1.0, this.control.getFrameColor().darker())}));
        this.ctxBackground.fill();
        this.ctxBackground.restore();
        this.ctxBackground.save();
        this.ctxBackground.beginPath();
        this.ctxBackground.arc(0.5 * this.size, 0.5 * this.size, 0.43388429752066116 * this.size, 0.43388429752066116 * this.size, 0.0, 360.0);
        this.ctxBackground.setFill((Paint)new LinearGradient(0.0, 0.0661157025 * this.size, 0.0, 0.9338842975 * this.size, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, this.control.getBackgroundColor().darker()), new Stop(1.0, this.control.getBackgroundColor().brighter())}));
        this.ctxBackground.fill();
        this.ctxBackground.arc(0.5 * this.size, 0.5 * this.size, 0.43388429752066116 * this.size, 0.43388429752066116 * this.size, 0.0, 360.0);
        this.ctxBackground.setFill((Paint)new RadialGradient(0.0, 0.0, 0.5 * this.size, 0.57 * this.size, 0.5 * this.size, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.TRANSPARENT), new Stop(0.9, Color.TRANSPARENT), new Stop(0.95, Color.rgb((int)0, (int)0, (int)0, (double)0.1)), new Stop(1.0, Color.rgb((int)0, (int)0, (int)0, (double)0.3))}));
        this.ctxBackground.fill();
        this.ctxBackground.restore();
        this.drawSections(this.ctxBackground);
        this.drawTickmarks(this.ctxBackground);
        if (this.control.isLedVisible()) {
            this.ctxBackground.save();
            this.drawLedOff(this.ctxBackground);
            this.ctxBackground.restore();
        }
        this.ctxBackground.save();
        this.ctxBackground.setFont(Font.font((String)"Verdana", (FontWeight)FontWeight.NORMAL, (double)(0.1 * this.size)));
        this.ctxBackground.setTextAlign(TextAlignment.CENTER);
        this.ctxBackground.setFill((Paint)this.control.getTickMarkColor());
        this.ctxBackground.fillText(this.control.getTitle(), 0.5 * this.size, 0.35 * this.size);
        this.ctxBackground.restore();
        this.background.setCache(true);
    }
}

