/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.internal.scene.control.skin;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.skin.SkinBase;
import java.io.InputStream;
import java.util.ArrayList;
import javafx.animation.AnimationTimer;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.VPos;
import javafx.scene.CacheHint;
import javafx.scene.DepthTest;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.Effect;
import javafx.scene.effect.InnerShadow;
import javafx.scene.input.MouseEvent;
import javafx.scene.media.AudioClip;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import javafx.scene.text.Font;
import javafx.scene.text.FontSmoothingType;
import javafx.scene.text.Text;
import javafx.scene.transform.Rotate;
import jfxtras.labs.internal.scene.control.behavior.SplitFlapBehavior;
import jfxtras.labs.scene.control.gauge.SplitFlap;

public class SplitFlapSkin
extends SkinBase<SplitFlap, SplitFlapBehavior> {
    private SplitFlap control;
    private static double MIN_FLIP_TIME = 1.66666666666667E7;
    private final AudioClip SOUND1 = new AudioClip(((Object)((Object)this)).getClass().getResource("/jfxtras/labs/scene/control/gauge/flap.mp3").toExternalForm());
    private final AudioClip SOUND2 = new AudioClip(((Object)((Object)this)).getClass().getResource("/jfxtras/labs/scene/control/gauge/flap1.mp3").toExternalForm());
    private final AudioClip SOUND3 = new AudioClip(((Object)((Object)this)).getClass().getResource("/jfxtras/labs/scene/control/gauge/flap2.mp3").toExternalForm());
    private boolean isDirty;
    private boolean initialized;
    private Group background;
    private Group fixture;
    private Group flip;
    private Group frame;
    private Shape upper;
    private Text upperText;
    private Shape upperNext;
    private Text upperNextText;
    private Shape lower;
    private Text lowerText;
    private Text lowerNextText;
    private ArrayList<String> selectedSet;
    private int currentSelectionIndex;
    private int nextSelectionIndex;
    private Rotate rotate;
    private Rotate lowerFlipVert;
    private double angleStep;
    private double currentAngle;
    private boolean flipping;
    private int lastFlapDirection;
    private AnimationTimer timer;

    public SplitFlapSkin(SplitFlap CONTROL) {
        super((Control)CONTROL, (BehaviorBase)new SplitFlapBehavior(CONTROL));
        this.control = CONTROL;
        this.initialized = false;
        this.isDirty = false;
        this.background = new Group();
        this.fixture = new Group();
        this.flip = new Group();
        this.frame = new Group();
        this.upperText = new Text(this.control.getText());
        this.lowerText = new Text(this.control.getText());
        this.upperNextText = new Text(this.control.getNextText());
        this.lowerNextText = new Text(this.control.getNextText());
        this.selectedSet = new ArrayList(64);
        this.currentSelectionIndex = 0;
        this.nextSelectionIndex = 1;
        this.rotate = new Rotate();
        this.angleStep = 180.0 / ((double)(this.control.getFlipTimeInMs() * 1000000L) / MIN_FLIP_TIME);
        this.currentAngle = 0.0;
        this.flipping = false;
        this.lastFlapDirection = 0;
        this.timer = new AnimationTimer(){

            public void handle(long l) {
                if (SplitFlapSkin.this.initialized) {
                    if (!SplitFlapSkin.this.control.isCountdownMode()) {
                        SplitFlapSkin.this.flipForward(SplitFlapSkin.this.angleStep);
                    } else {
                        SplitFlapSkin.this.flipBackward(SplitFlapSkin.this.angleStep);
                    }
                }
            }
        };
        this.init();
    }

    private void init() {
        if (this.control.getPrefWidth() < 0.0 | this.control.getPrefHeight() < 0.0) {
            this.control.setPrefSize(132.0, 227.0);
        }
        if (this.control.getMinWidth() < 0.0 | this.control.getMinHeight() < 0.0) {
            this.control.setMinSize(13.0, 22.0);
        }
        if (this.control.getMaxWidth() < 0.0 | this.control.getMaxHeight() < 0.0) {
            this.control.setMaxSize(660.0, 1135.0);
        }
        this.rotate.setAxis(Rotate.X_AXIS);
        this.rotate.setPivotY(this.control.getPrefHeight() * 0.4625550661);
        this.lowerFlipVert = new Rotate();
        this.selectedSet.clear();
        this.selectedSet.addAll(this.control.getSelectedSet());
        this.upperText.setVisible(!this.control.isImageMode());
        this.upperNextText.setVisible(!this.control.isImageMode());
        this.lowerText.setVisible(!this.control.isImageMode());
        this.lowerNextText.setVisible(!this.control.isImageMode());
        this.registerChangeListener((ObservableValue)this.control.prefWidthProperty(), "PREF_WIDTH");
        this.registerChangeListener((ObservableValue)this.control.prefHeightProperty(), "PREF_HEIGHT");
        this.registerChangeListener((ObservableValue)this.control.colorProperty(), "COLOR");
        this.registerChangeListener((ObservableValue)this.control.textColorProperty(), "TEXT_COLOR");
        this.registerChangeListener((ObservableValue)this.control.textProperty(), "TEXT");
        this.registerChangeListener((ObservableValue)this.control.flipTimeInMsProperty(), "FLIP_TIME");
        this.registerChangeListener((ObservableValue)this.control.frameVisibleProperty(), "FRAME_VISIBILITY");
        this.registerChangeListener((ObservableValue)this.control.backgroundVisibleProperty(), "BACKGROUND_VISIBILITY");
        this.registerChangeListener((ObservableValue)this.control.countdownModeProperty(), "COUNTDOWN_MODE");
        this.registerChangeListener((ObservableValue)this.control.imageModeProperty(), "IMAGE_MODE");
        this.control.selectionProperty().addListener((ChangeListener)new ChangeListener<String[]>(){

            public void changed(ObservableValue<? extends String[]> ov, String[] oldValue, String[] newValue) {
                SplitFlapSkin.this.selectedSet.clear();
                for (String text : newValue) {
                    SplitFlapSkin.this.selectedSet.add(text);
                }
            }
        });
        this.frame.setVisible(this.control.isFrameVisible());
        this.background.setVisible(this.control.isBackgroundVisible());
        this.initialized = true;
        this.repaint();
    }

    protected void handleControlPropertyChanged(String PROPERTY) {
        super.handleControlPropertyChanged(PROPERTY);
        if ("COLOR".equals(PROPERTY)) {
            this.repaint();
        } else if ("TEXT_COLOR".equals(PROPERTY)) {
            this.repaint();
        } else if ("TEXT".equals(PROPERTY)) {
            if (this.control.getText() != this.selectedSet.get(this.currentSelectionIndex)) {
                this.timer.stop();
                this.flipping = true;
                this.timer.start();
            }
        } else if ("FLIP_TIME".equals(PROPERTY)) {
            this.angleStep = 180.0 / ((double)(this.control.getFlipTimeInMs() * 1000000L) / MIN_FLIP_TIME);
        } else if ("FRAME_VISIBILITY".equals(PROPERTY)) {
            this.frame.setVisible(this.control.isFrameVisible());
        } else if ("BACKGROUND_VISIBILITY".equals(PROPERTY)) {
            this.background.setVisible(this.control.isBackgroundVisible());
        } else if ("COUNDOWN_MODE".equals(PROPERTY)) {
            this.currentAngle = 180.0;
        } else if ("SELECTION".equals(PROPERTY)) {
            this.selectedSet.clear();
            this.selectedSet.addAll(this.control.getSelectedSet());
        } else if ("IMAGE_MODE".equals(PROPERTY)) {
            this.upperText.setVisible(!this.control.isImageMode());
            this.upperNextText.setVisible(!this.control.isImageMode());
            this.lowerText.setVisible(!this.control.isImageMode());
            this.lowerNextText.setVisible(!this.control.isImageMode());
        } else if ("PREF_WIDTH".equals(PROPERTY)) {
            this.repaint();
        } else if ("PREF_HEIGHT".equals(PROPERTY)) {
            this.repaint();
        }
    }

    public final void repaint() {
        this.isDirty = true;
        this.requestLayout();
    }

    public void layoutChildren() {
        if (!this.isDirty) {
            return;
        }
        if (!this.initialized) {
            this.init();
        }
        if (this.control.getScene() != null) {
            this.drawBackground();
            this.drawFixture();
            this.drawFlip();
            this.drawFrame();
            this.getChildren().setAll((Object[])new Node[]{this.background, this.fixture, this.flip, this.frame});
        }
        this.isDirty = false;
        super.layoutChildren();
    }

    public final SplitFlap getSkinnable() {
        return this.control;
    }

    public final void dispose() {
        this.control = null;
    }

    protected double computePrefWidth(double PREF_WIDTH) {
        double prefWidth = 132.0;
        if (PREF_WIDTH != -1.0) {
            prefWidth = Math.max(0.0, PREF_WIDTH - this.getInsets().getLeft() - this.getInsets().getRight());
        }
        return super.computePrefWidth(prefWidth);
    }

    protected double computePrefHeight(double PREF_HEIGHT) {
        double prefHeight = 227.0;
        if (PREF_HEIGHT != -1.0) {
            prefHeight = Math.max(0.0, PREF_HEIGHT - this.getInsets().getTop() - this.getInsets().getBottom());
        }
        return super.computePrefWidth(prefHeight);
    }

    private void flipForward(double ANGLE_STEP) {
        this.currentAngle += ANGLE_STEP;
        if (Double.compare(this.currentAngle, 180.0) >= 0) {
            double textOffset;
            if (this.control.isSoundOn()) {
                switch (this.control.getSound()) {
                    case SOUND1: {
                        this.SOUND1.play();
                        break;
                    }
                    case SOUND2: {
                        this.SOUND2.play();
                        break;
                    }
                    case SOUND3: {
                        this.SOUND3.play();
                    }
                }
            }
            this.currentAngle = 0.0;
            this.upper.getTransforms().clear();
            this.upperText.getTransforms().clear();
            this.lowerNextText.getTransforms().clear();
            this.lowerNextText.setVisible(false);
            this.lowerFlipVert.setAxis(Rotate.X_AXIS);
            this.lowerFlipVert.setPivotY(this.control.getPrefHeight() * 0.4625550661);
            this.lowerFlipVert.setAngle(180.0);
            this.lowerNextText.getTransforms().add((Object)this.lowerFlipVert);
            this.upperText.setVisible(true);
            ++this.currentSelectionIndex;
            if (this.currentSelectionIndex >= this.selectedSet.size()) {
                this.currentSelectionIndex = 0;
            }
            this.nextSelectionIndex = this.currentSelectionIndex + 1;
            if (this.nextSelectionIndex >= this.selectedSet.size()) {
                this.nextSelectionIndex = 0;
            }
            if (this.selectedSet.get(this.currentSelectionIndex).equals(this.control.getText())) {
                this.timer.stop();
                this.flipping = false;
            }
            this.upperText.setText(this.selectedSet.get(this.currentSelectionIndex));
            this.lowerText.setText(this.selectedSet.get(this.currentSelectionIndex));
            this.upperNextText.setText(this.selectedSet.get(this.nextSelectionIndex));
            this.lowerNextText.setText(this.selectedSet.get(this.nextSelectionIndex));
            if (this.selectedSet.get(this.currentSelectionIndex).length() > 1) {
                textOffset = 0.105 * this.frame.getLayoutBounds().getHeight();
                this.upperText.setX(textOffset);
                this.lowerText.setX(textOffset);
            }
            if (this.selectedSet.get(this.nextSelectionIndex).length() > 1) {
                textOffset = 0.105 * this.frame.getLayoutBounds().getHeight();
                this.upperNextText.setX(textOffset);
                this.lowerNextText.setX(textOffset);
            }
        }
        if (this.currentAngle > 90.0) {
            this.upperText.setVisible(false);
            this.lowerNextText.setVisible(true);
        }
        if (this.flipping) {
            this.upper.getTransforms().remove((Object)this.rotate);
            this.upperText.getTransforms().remove((Object)this.rotate);
            this.lowerNextText.getTransforms().remove((Object)this.rotate);
            this.rotate.setAngle(this.currentAngle);
            this.upper.getTransforms().add((Object)this.rotate);
            this.upperText.getTransforms().add((Object)this.rotate);
            this.lowerNextText.getTransforms().add((Object)this.rotate);
        }
    }

    private void flipBackward(double ANGLE_STEP) {
        this.currentAngle -= ANGLE_STEP;
        if (Double.compare(this.currentAngle, 0.0) <= 0) {
            if (this.control.isSoundOn()) {
                switch (this.control.getSound()) {
                    case SOUND1: {
                        this.SOUND1.play();
                        break;
                    }
                    case SOUND2: {
                        this.SOUND2.play();
                        break;
                    }
                    case SOUND3: {
                        this.SOUND3.play();
                    }
                }
            }
            this.currentAngle = 180.0;
            this.upper.getTransforms().clear();
            this.upperText.getTransforms().clear();
            this.lowerNextText.getTransforms().clear();
            this.lowerNextText.setVisible(true);
            this.lowerFlipVert.setAxis(Rotate.X_AXIS);
            this.lowerFlipVert.setPivotY(this.control.getPrefHeight() * 0.4625550661);
            this.lowerFlipVert.setAngle(180.0);
            this.lowerNextText.getTransforms().add((Object)this.lowerFlipVert);
            this.upperText.setVisible(false);
            --this.currentSelectionIndex;
            if (this.currentSelectionIndex < 0) {
                this.currentSelectionIndex = this.selectedSet.size() - 1;
            }
            this.nextSelectionIndex = this.currentSelectionIndex - 1;
            if (this.nextSelectionIndex < 0) {
                this.nextSelectionIndex = this.selectedSet.size() - 1;
            }
            if (this.selectedSet.get(this.currentSelectionIndex).equals(this.control.getText())) {
                this.timer.stop();
                this.flipping = false;
            }
            this.upperText.setText(this.selectedSet.get(this.nextSelectionIndex));
            this.lowerText.setText(this.selectedSet.get(this.nextSelectionIndex));
            this.upperNextText.setText(this.selectedSet.get(this.currentSelectionIndex));
            this.lowerNextText.setText(this.selectedSet.get(this.currentSelectionIndex));
            if (this.selectedSet.get(this.currentSelectionIndex).length() > 1) {
                double textOffset = 0.1057268722 * this.getPrefHeight();
                this.upperText.setX(textOffset);
                this.lowerText.setX(textOffset);
                this.upperNextText.setX(textOffset);
                this.lowerNextText.setX(textOffset);
            }
            this.rotate.setAngle(this.currentAngle);
            this.upper.getTransforms().add((Object)this.rotate);
            this.upperText.getTransforms().add((Object)this.rotate);
            this.lowerNextText.getTransforms().add((Object)this.rotate);
        }
        if (this.currentAngle < 90.0) {
            this.upperText.setVisible(true);
            this.lowerNextText.setVisible(false);
        }
        if (this.flipping) {
            this.upper.getTransforms().remove((Object)this.rotate);
            this.upperText.getTransforms().remove((Object)this.rotate);
            this.lowerNextText.getTransforms().remove((Object)this.rotate);
            this.rotate.setAngle(this.currentAngle);
            this.upper.getTransforms().add((Object)this.rotate);
            this.upperText.getTransforms().add((Object)this.rotate);
            this.lowerNextText.getTransforms().add((Object)this.rotate);
        }
    }

    private void addMouseEventListener(Shape FLAP, final int FLAP_DIRECTION) {
        FLAP.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent EVENT) {
                switch (FLAP_DIRECTION) {
                    case 1: {
                        SplitFlapSkin.this.currentAngle = 0.0;
                        SplitFlapSkin.this.checkLastFlapDirection(FLAP_DIRECTION);
                        SplitFlapSkin.this.control.flipForward();
                        SplitFlapSkin.this.lastFlapDirection = FLAP_DIRECTION;
                        break;
                    }
                    case -1: {
                        SplitFlapSkin.this.currentAngle = 180.0;
                        SplitFlapSkin.this.checkLastFlapDirection(FLAP_DIRECTION);
                        SplitFlapSkin.this.control.flipBackward();
                        SplitFlapSkin.this.lastFlapDirection = FLAP_DIRECTION;
                    }
                }
            }
        });
    }

    private void checkLastFlapDirection(int CURRENT_FLAP_DIRECTION) {
        if (CURRENT_FLAP_DIRECTION == 1 && this.lastFlapDirection == -1) {
            System.out.println("changed from backward to forward");
        } else if (CURRENT_FLAP_DIRECTION == -1 && this.lastFlapDirection == 1) {
            this.rotate.setAngle(this.currentAngle);
            this.upper.getTransforms().add((Object)this.rotate);
            this.upperText.getTransforms().add((Object)this.rotate);
            this.lowerNextText.getTransforms().add((Object)this.rotate);
            System.out.println("changed from forward to backward");
        }
    }

    public final void drawBackground() {
        double offset;
        double SIZE = this.control.getPrefWidth() < this.control.getPrefHeight() ? this.control.getPrefWidth() : this.control.getPrefHeight();
        double WIDTH = this.control.getPrefWidth();
        double HEIGHT = this.control.getPrefHeight();
        this.background.getChildren().clear();
        Rectangle IBOUNDS = new Rectangle(0.0, 0.0, WIDTH, HEIGHT);
        IBOUNDS.setOpacity(0.0);
        this.background.getChildren().add((Object)IBOUNDS);
        Rectangle INNER_BACKGROUND = new Rectangle(0.0352422907 * HEIGHT, 0.0352422907 * HEIGHT, WIDTH - 0.0352422907 * HEIGHT, 0.9207048458 * HEIGHT);
        LinearGradient INNER_BACKGROUND_FILL = new LinearGradient(0.0, 0.0352422907 * HEIGHT, 0.0, 0.9559471366 * HEIGHT, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.BLACK), new Stop(1.0, Color.rgb((int)20, (int)20, (int)20))});
        INNER_BACKGROUND.setFill((Paint)INNER_BACKGROUND_FILL);
        INNER_BACKGROUND.setStroke(null);
        double posLeft = offset = 0.04405286343612335 * HEIGHT;
        Rectangle RECT3 = new Rectangle(posLeft, 0.8149779736 * HEIGHT, WIDTH - 2.0 * offset, 0.1321585903 * HEIGHT);
        RECT3.setArcWidth(0.05286343612334802 * HEIGHT);
        RECT3.setArcHeight(0.05286343612334802 * HEIGHT);
        LinearGradient RECT3_FILL = new LinearGradient(0.0, 0.8149779736 * HEIGHT, 0.0, 0.8149779736 * HEIGHT + 0.1321585903 * HEIGHT, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, this.control.getLowerFlapTopColor()), new Stop(1.0, this.control.getLowerFlapBottomColor())});
        RECT3.setFill((Paint)RECT3_FILL);
        RECT3.setStroke(null);
        Rectangle RECT2 = new Rectangle(posLeft, 0.7973568282 * HEIGHT, WIDTH - 2.0 * offset, 0.1321585903 * HEIGHT);
        RECT2.setArcWidth(0.05286343612334802 * HEIGHT);
        RECT2.setArcHeight(0.05286343612334802 * HEIGHT);
        LinearGradient RECT2_FILL = new LinearGradient(0.0, 0.7973568282 * HEIGHT, 0.0, 0.7973568282 * HEIGHT + 0.1321585903 * HEIGHT, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, this.control.getLowerFlapTopColor()), new Stop(1.0, this.control.getLowerFlapBottomColor())});
        RECT2.setFill((Paint)RECT2_FILL);
        RECT2.setStroke(null);
        Rectangle RECT1 = new Rectangle(posLeft, 0.7797356828 * HEIGHT, WIDTH - 2.0 * offset, 0.1321585903 * HEIGHT);
        RECT1.setArcWidth(0.05286343612334802 * HEIGHT);
        RECT1.setArcHeight(0.05286343612334802 * HEIGHT);
        LinearGradient RECT1_FILL = new LinearGradient(0.0, 0.7797356828 * HEIGHT, 0.0, 0.7797356828 * HEIGHT + 0.1321585903 * HEIGHT, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, this.control.getLowerFlapTopColor()), new Stop(1.0, this.control.getLowerFlapBottomColor())});
        RECT1.setFill((Paint)RECT1_FILL);
        RECT1.setStroke(null);
        Rectangle RECT0 = new Rectangle(posLeft, 0.7621145374 * HEIGHT, WIDTH - 2.0 * offset, 0.1321585903 * HEIGHT);
        RECT0.setArcWidth(0.05286343612334802 * HEIGHT);
        RECT0.setArcHeight(0.05286343612334802 * HEIGHT);
        LinearGradient RECT0_FILL = new LinearGradient(0.0, 0.7621145374 * HEIGHT, 0.0, 0.7621145374 * HEIGHT + 0.1321585903 * HEIGHT, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, this.control.getLowerFlapTopColor()), new Stop(1.0, this.control.getLowerFlapBottomColor())});
        RECT0.setFill((Paint)RECT0_FILL);
        RECT0.setStroke(null);
        InnerShadow LOWER_INNER_SHADOW = new InnerShadow();
        LOWER_INNER_SHADOW.setWidth(0.01 * RECT3.getLayoutBounds().getHeight());
        LOWER_INNER_SHADOW.setHeight(0.01 * RECT3.getLayoutBounds().getHeight());
        LOWER_INNER_SHADOW.setOffsetX(0.0);
        LOWER_INNER_SHADOW.setOffsetY(-0.066 * RECT3.getLayoutBounds().getHeight());
        LOWER_INNER_SHADOW.setRadius(0.001 * RECT3.getLayoutBounds().getHeight());
        LOWER_INNER_SHADOW.setColor(Color.BLACK);
        LOWER_INNER_SHADOW.setBlurType(BlurType.GAUSSIAN);
        InnerShadow LOWER_LIGHT_EFFECT = new InnerShadow();
        LOWER_LIGHT_EFFECT.setWidth(0.04 * RECT3.getLayoutBounds().getHeight());
        LOWER_LIGHT_EFFECT.setHeight(0.04 * RECT3.getLayoutBounds().getHeight());
        LOWER_LIGHT_EFFECT.setOffsetX(0.0);
        LOWER_LIGHT_EFFECT.setOffsetY(0.01 * SIZE);
        LOWER_LIGHT_EFFECT.setRadius(0.04 * RECT3.getLayoutBounds().getHeight());
        LOWER_LIGHT_EFFECT.setColor(Color.WHITE);
        LOWER_LIGHT_EFFECT.setBlurType(BlurType.GAUSSIAN);
        LOWER_LIGHT_EFFECT.inputProperty().set((Object)LOWER_INNER_SHADOW);
        RECT3.setEffect((Effect)LOWER_INNER_SHADOW);
        RECT2.setEffect((Effect)LOWER_INNER_SHADOW);
        RECT1.setEffect((Effect)LOWER_INNER_SHADOW);
        RECT0.setEffect((Effect)LOWER_INNER_SHADOW);
        this.background.getChildren().addAll((Object[])new Node[]{INNER_BACKGROUND, RECT3, RECT2, RECT1, RECT0});
        this.background.setCache(true);
    }

    public void drawFixture() {
        LinearGradient LEFT_MAIN_FILL;
        LinearGradient LEFT_FRAME_FILL;
        LinearGradient RIGHT_MAIN_FILL;
        LinearGradient RIGHT_FRAME_FILL;
        double offset;
        double WIDTH = this.control.getPrefWidth();
        double HEIGHT = this.control.getPrefHeight();
        this.fixture.getChildren().clear();
        Rectangle IBOUNDS = new Rectangle(0.0, 0.0, WIDTH, HEIGHT);
        IBOUNDS.setOpacity(0.0);
        this.fixture.getChildren().add((Object)IBOUNDS);
        double frameWidth = 0.0396475771 * HEIGHT;
        double frameHeight = 0.13656387665198239 * HEIGHT;
        double mainWidth = 0.0308370044 * HEIGHT;
        double mainHeight = 0.1277533039647577 * HEIGHT;
        double posLeftFrame = offset = 0.04405286343612335 * HEIGHT;
        double posLeftMain = 0.0484581498 * HEIGHT;
        double posRightFrame = WIDTH - offset - frameWidth;
        double posRightMain = WIDTH - posLeftMain - mainWidth;
        Rectangle RIGHT_FRAME = new Rectangle(posRightFrame, 0.3920704845814978 * HEIGHT, frameWidth, frameHeight);
        Rectangle RIGHT_MAIN = new Rectangle(posRightMain, 0.3964757709251101 * HEIGHT, mainWidth, mainHeight);
        if (this.control.isDarkFixtureEnabled()) {
            RIGHT_FRAME_FILL = new LinearGradient(0.0, 0.3920704845814978 * HEIGHT, 0.0, 0.5286343612334802 * HEIGHT, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)26, (int)26, (int)26)), new Stop(0.18, Color.rgb((int)86, (int)86, (int)86)), new Stop(0.65, Color.rgb((int)17, (int)17, (int)17)), new Stop(0.89, Color.rgb((int)24, (int)24, (int)24)), new Stop(1.0, Color.rgb((int)25, (int)24, (int)24))});
            RIGHT_MAIN_FILL = new LinearGradient(0.0, 0.3964757709251101 * HEIGHT, 0.0 * WIDTH, 0.5242290748898678 * HEIGHT, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)66, (int)66, (int)66)), new Stop(0.13, Color.rgb((int)153, (int)153, (int)153)), new Stop(0.66, Color.rgb((int)6, (int)6, (int)6)), new Stop(0.73, Color.rgb((int)14, (int)14, (int)14)), new Stop(0.9, Color.rgb((int)39, (int)39, (int)39)), new Stop(1.0, Color.rgb((int)23, (int)23, (int)23))});
        } else {
            RIGHT_FRAME_FILL = new LinearGradient(0.0, 0.3920704845814978 * HEIGHT, 0.0, 0.5286343612334802 * HEIGHT, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)56, (int)56, (int)56)), new Stop(0.18, Color.rgb((int)156, (int)156, (int)156)), new Stop(0.65, Color.rgb((int)47, (int)47, (int)47)), new Stop(0.89, Color.rgb((int)84, (int)84, (int)84)), new Stop(1.0, Color.rgb((int)55, (int)55, (int)55))});
            RIGHT_MAIN_FILL = new LinearGradient(0.0, 0.3964757709251101 * HEIGHT, 0.0 * WIDTH, 0.5242290748898678 * HEIGHT, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)116, (int)116, (int)116)), new Stop(0.13, Color.rgb((int)213, (int)213, (int)213)), new Stop(0.66, Color.rgb((int)56, (int)56, (int)56)), new Stop(0.73, Color.rgb((int)64, (int)64, (int)64)), new Stop(0.9, Color.rgb((int)109, (int)109, (int)109)), new Stop(1.0, Color.rgb((int)83, (int)83, (int)83))});
        }
        RIGHT_FRAME.setFill((Paint)RIGHT_FRAME_FILL);
        RIGHT_FRAME.setStroke(null);
        RIGHT_MAIN.setFill((Paint)RIGHT_MAIN_FILL);
        RIGHT_MAIN.setStroke(null);
        Rectangle LEFT_FRAME = new Rectangle(posLeftFrame, 0.3920704845814978 * HEIGHT, frameWidth, frameHeight);
        Rectangle LEFT_MAIN = new Rectangle(posLeftMain, 0.3964757709251101 * HEIGHT, mainWidth, mainHeight);
        if (this.control.isDarkFixtureEnabled()) {
            LEFT_FRAME_FILL = new LinearGradient(0.0, 0.3920704845814978 * HEIGHT, 0.0, 0.5286343612334802 * HEIGHT, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)26, (int)26, (int)26)), new Stop(0.18, Color.rgb((int)86, (int)86, (int)86)), new Stop(0.65, Color.rgb((int)17, (int)17, (int)17)), new Stop(0.89, Color.rgb((int)24, (int)24, (int)24)), new Stop(1.0, Color.rgb((int)25, (int)24, (int)24))});
            LEFT_MAIN_FILL = new LinearGradient(0.0, 0.3964757709251101 * HEIGHT, 0.0, 0.5242290748898678 * HEIGHT, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)66, (int)66, (int)66)), new Stop(0.13, Color.rgb((int)153, (int)153, (int)153)), new Stop(0.66, Color.rgb((int)6, (int)6, (int)6)), new Stop(0.73, Color.rgb((int)14, (int)14, (int)14)), new Stop(0.9, Color.rgb((int)39, (int)39, (int)39)), new Stop(1.0, Color.rgb((int)23, (int)23, (int)23))});
        } else {
            LEFT_FRAME_FILL = new LinearGradient(0.0, 0.3920704845814978 * HEIGHT, 0.0, 0.5286343612334802 * HEIGHT, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)56, (int)56, (int)56)), new Stop(0.18, Color.rgb((int)156, (int)156, (int)156)), new Stop(0.65, Color.rgb((int)47, (int)47, (int)47)), new Stop(0.89, Color.rgb((int)84, (int)84, (int)84)), new Stop(1.0, Color.rgb((int)55, (int)55, (int)55))});
            LEFT_MAIN_FILL = new LinearGradient(0.0, 0.3964757709251101 * HEIGHT, 0.0, 0.5242290748898678 * HEIGHT, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)116, (int)116, (int)116)), new Stop(0.13, Color.rgb((int)213, (int)213, (int)213)), new Stop(0.66, Color.rgb((int)56, (int)56, (int)56)), new Stop(0.73, Color.rgb((int)64, (int)64, (int)64)), new Stop(0.9, Color.rgb((int)109, (int)109, (int)109)), new Stop(1.0, Color.rgb((int)83, (int)83, (int)83))});
        }
        LEFT_FRAME.setFill((Paint)LEFT_FRAME_FILL);
        LEFT_FRAME.setStroke(null);
        LEFT_MAIN.setFill((Paint)LEFT_MAIN_FILL);
        LEFT_MAIN.setStroke(null);
        this.fixture.getChildren().addAll((Object[])new Node[]{RIGHT_FRAME, RIGHT_MAIN, LEFT_FRAME, LEFT_MAIN});
        this.fixture.setCache(true);
    }

    public final void drawFlip() {
        double textOffset;
        double offset;
        double SIZE = this.control.getPrefWidth() < this.control.getPrefHeight() ? this.control.getPrefWidth() : this.control.getPrefHeight();
        double WIDTH = this.control.getPrefWidth();
        double HEIGHT = this.control.getPrefHeight();
        this.flip.getChildren().clear();
        Rectangle IBOUNDS = new Rectangle(0.0, 0.0, WIDTH, HEIGHT);
        IBOUNDS.setOpacity(0.0);
        this.flip.getChildren().add((Object)IBOUNDS);
        double posLeft = offset = 0.04405286343612335 * HEIGHT;
        double posRight = WIDTH - offset;
        double cutOffWidth = 0.0484581498 * HEIGHT;
        double cutOffHeight = 0.0748898678 * HEIGHT;
        double flapWidth = WIDTH - 2.0 * offset;
        double flapHeight = 0.4140969163 * HEIGHT;
        double flapCornerRadius = this.control.getFlapCornerRadius() / 227.0 * HEIGHT;
        Rectangle CUT_UPPER_LEFT = new Rectangle(posLeft, 0.3832599118942731 * HEIGHT, cutOffWidth, cutOffHeight);
        Rectangle CUT_UPPER_RIGHT = new Rectangle(posRight - cutOffWidth, 0.3832599118942731 * HEIGHT, cutOffWidth, cutOffHeight);
        Rectangle CUT_LOWER_LEFT = new Rectangle(posLeft, 0.4625550661 * HEIGHT, cutOffWidth, cutOffHeight);
        Rectangle CUT_LOWER_RIGHT = new Rectangle(posRight - cutOffWidth, 0.4625550661 * HEIGHT, cutOffWidth, cutOffHeight);
        Rectangle UPPER_FLAP = new Rectangle(posLeft, posLeft, flapWidth, flapHeight);
        UPPER_FLAP.setArcWidth(flapCornerRadius);
        UPPER_FLAP.setArcHeight(flapCornerRadius);
        Rectangle LOWER_FLAP = new Rectangle(posLeft, 0.4625550661 * HEIGHT, flapWidth, flapHeight);
        LOWER_FLAP.setArcWidth(flapCornerRadius);
        LOWER_FLAP.setArcHeight(flapCornerRadius);
        this.upper = Shape.subtract((Shape)Shape.subtract((Shape)UPPER_FLAP, (Shape)CUT_UPPER_LEFT), (Shape)CUT_UPPER_RIGHT);
        this.lower = Shape.subtract((Shape)Shape.subtract((Shape)LOWER_FLAP, (Shape)CUT_LOWER_LEFT), (Shape)CUT_LOWER_RIGHT);
        LinearGradient LOWER_FILL = new LinearGradient(0.0, this.lower.getLayoutBounds().getMinY(), 0.0, this.lower.getLayoutBounds().getMaxY(), false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, this.control.getLowerFlapTopColor().brighter().brighter()), new Stop(0.05, this.control.getLowerFlapTopColor()), new Stop(0.99, this.control.getLowerFlapBottomColor()), new Stop(0.0, this.control.getLowerFlapBottomColor().darker().darker())});
        this.lower.setFill((Paint)LOWER_FILL);
        this.lower.setStroke(null);
        this.lower.setCache(true);
        this.lower.setCacheHint(CacheHint.QUALITY);
        InnerShadow LOWER_INNER_SHADOW = new InnerShadow();
        LOWER_INNER_SHADOW.setWidth(0.01 * this.lower.getLayoutBounds().getHeight());
        LOWER_INNER_SHADOW.setHeight(0.01 * this.lower.getLayoutBounds().getHeight());
        LOWER_INNER_SHADOW.setOffsetX(0.0);
        LOWER_INNER_SHADOW.setOffsetY(-0.022 * this.lower.getLayoutBounds().getHeight());
        LOWER_INNER_SHADOW.setRadius(0.01 * this.lower.getLayoutBounds().getHeight());
        LOWER_INNER_SHADOW.setColor(Color.BLACK);
        LOWER_INNER_SHADOW.setBlurType(BlurType.GAUSSIAN);
        InnerShadow LOWER_LIGHT_EFFECT = new InnerShadow();
        LOWER_LIGHT_EFFECT.setWidth(0.04 * this.lower.getLayoutBounds().getHeight());
        LOWER_LIGHT_EFFECT.setHeight(0.04 * this.lower.getLayoutBounds().getHeight());
        LOWER_LIGHT_EFFECT.setOffsetX(0.0);
        LOWER_LIGHT_EFFECT.setOffsetY(0.015 * this.lower.getLayoutBounds().getHeight());
        LOWER_LIGHT_EFFECT.setRadius(0.04 * this.lower.getLayoutBounds().getHeight());
        LOWER_LIGHT_EFFECT.setColor(Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.8));
        LOWER_LIGHT_EFFECT.setBlurType(BlurType.GAUSSIAN);
        LOWER_LIGHT_EFFECT.inputProperty().set((Object)LOWER_INNER_SHADOW);
        if (this.control.isLowerFlapHighlightEnabled()) {
            this.lower.setEffect((Effect)LOWER_LIGHT_EFFECT);
        } else {
            this.lower.setEffect((Effect)LOWER_INNER_SHADOW);
        }
        LinearGradient UPPER_FILL = new LinearGradient(0.0, this.upper.getLayoutBounds().getMinY(), 0.0, this.upper.getLayoutBounds().getMaxY(), false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, this.control.getUpperFlapTopColor().darker()), new Stop(0.01, this.control.getUpperFlapTopColor()), new Stop(0.95, this.control.getUpperFlapBottomColor()), new Stop(1.0, this.control.getUpperFlapBottomColor().darker())});
        this.upper.setFill((Paint)UPPER_FILL);
        this.upper.setStroke(null);
        InnerShadow UPPER_INNER_SHADOW = new InnerShadow();
        UPPER_INNER_SHADOW.setWidth(0.02 * this.upper.getLayoutBounds().getHeight());
        UPPER_INNER_SHADOW.setHeight(0.02 * this.upper.getLayoutBounds().getHeight());
        UPPER_INNER_SHADOW.setOffsetX(0.0);
        UPPER_INNER_SHADOW.setOffsetY(0.022 * this.upper.getLayoutBounds().getHeight());
        UPPER_INNER_SHADOW.setRadius(0.02 * this.upper.getLayoutBounds().getHeight());
        UPPER_INNER_SHADOW.setColor(Color.BLACK);
        UPPER_INNER_SHADOW.setBlurType(BlurType.GAUSSIAN);
        InnerShadow UPPER_LIGHT_EFFECT = new InnerShadow();
        UPPER_LIGHT_EFFECT.setWidth(0.04 * this.upper.getLayoutBounds().getHeight());
        UPPER_LIGHT_EFFECT.setHeight(0.04 * this.upper.getLayoutBounds().getHeight());
        UPPER_LIGHT_EFFECT.setOffsetX(0.0);
        UPPER_LIGHT_EFFECT.setOffsetY(0.01 * this.upper.getLayoutBounds().getHeight());
        UPPER_LIGHT_EFFECT.setRadius(0.04 * this.upper.getLayoutBounds().getHeight());
        UPPER_LIGHT_EFFECT.setColor(Color.color((double)1.0, (double)1.0, (double)1.0, (double)0.8));
        UPPER_LIGHT_EFFECT.setBlurType(BlurType.GAUSSIAN);
        UPPER_LIGHT_EFFECT.inputProperty().set((Object)UPPER_INNER_SHADOW);
        if (this.control.isUpperFlapHighlightEnabled()) {
            this.upper.setEffect((Effect)UPPER_LIGHT_EFFECT);
        } else {
            this.upper.setEffect((Effect)UPPER_INNER_SHADOW);
        }
        this.upper.setCache(true);
        this.upper.setCacheHint(CacheHint.SPEED);
        Font FONT = Font.loadFont((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/jfxtras/labs/scene/control/gauge/droidsansmono.ttf"), (double)(0.704845815 * HEIGHT));
        Rectangle UPPER_CLIP = new Rectangle(0.0, this.upper.getLayoutBounds().getMinY(), WIDTH, this.upper.getLayoutBounds().getHeight());
        this.upperText.setTextOrigin(VPos.BOTTOM);
        this.upperText.setFont(FONT);
        this.upperText.setFontSmoothingType(FontSmoothingType.LCD);
        this.upperText.setText(this.control.getText());
        this.upperText.setX((WIDTH - this.upperText.getLayoutBounds().getWidth()) / 2.0);
        this.upperText.setY(HEIGHT * 0.04 + this.upperText.getLayoutBounds().getHeight());
        this.upperText.setClip((Node)UPPER_CLIP);
        LinearGradient UPPER_TEXT_FILL = new LinearGradient(0.0, this.upperText.getLayoutBounds().getMinY(), 0.0, this.upperText.getLayoutBounds().getMaxY(), false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, this.control.getTextUpperFlapColor()), new Stop(0.49, this.control.getTextColor()), new Stop(0.5, this.control.getTextColor().darker())});
        this.upperText.setFill((Paint)UPPER_TEXT_FILL);
        this.upperText.setStroke(null);
        Rectangle LOWER_CLIP = new Rectangle(0.0, this.lower.getLayoutBounds().getMinY(), WIDTH, this.lower.getLayoutBounds().getHeight());
        this.lowerText.setTextOrigin(VPos.BOTTOM);
        this.lowerText.setFont(FONT);
        this.lowerText.setFontSmoothingType(FontSmoothingType.LCD);
        this.lowerText.setText(this.control.getText());
        this.lowerText.setX((WIDTH - this.upperText.getLayoutBounds().getWidth()) / 2.0);
        this.lowerText.setY(HEIGHT * 0.04 + this.upperText.getLayoutBounds().getHeight());
        this.lowerText.setClip((Node)LOWER_CLIP);
        LinearGradient LOWER_TEXT_FILL = new LinearGradient(0.0, this.lower.getLayoutBounds().getMinY(), 0.0, this.lowerText.getLayoutBounds().getMaxY(), false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, this.control.getTextColor().darker()), new Stop(0.05, this.control.getTextLowerFlapColor()), new Stop(1.0, this.control.getTextColor())});
        this.lowerText.setFill((Paint)LOWER_TEXT_FILL);
        this.lowerText.setStroke(null);
        this.upperNext = Shape.subtract((Shape)Shape.subtract((Shape)UPPER_FLAP, (Shape)CUT_UPPER_LEFT), (Shape)CUT_UPPER_RIGHT);
        LinearGradient UPPER_NEXT_FILL = new LinearGradient(0.0, this.upperNext.getLayoutBounds().getMinY(), 0.0, this.upperNext.getLayoutBounds().getMaxY(), false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, this.control.getUpperFlapTopColor().darker()), new Stop(0.01, this.control.getUpperFlapTopColor()), new Stop(0.95, this.control.getUpperFlapBottomColor()), new Stop(1.0, this.control.getUpperFlapBottomColor().darker())});
        this.upperNext.setFill((Paint)UPPER_NEXT_FILL);
        this.upperNext.setStroke(null);
        this.upperNext.setCache(true);
        this.upperNext.setCacheHint(CacheHint.SPEED);
        Rectangle UPPER_NEXT_CLIP = new Rectangle(0.0, this.upper.getLayoutBounds().getMinY(), WIDTH, this.upper.getLayoutBounds().getHeight());
        this.upperNextText.setTextOrigin(VPos.BOTTOM);
        this.upperNextText.setFont(FONT);
        this.upperNextText.setFontSmoothingType(FontSmoothingType.LCD);
        this.upperNextText.setText(this.control.getNextText());
        this.upperNextText.setX((WIDTH - this.upperNextText.getLayoutBounds().getWidth()) / 2.0);
        this.upperNextText.setY(HEIGHT * 0.04 + this.upperNextText.getLayoutBounds().getHeight());
        this.upperNextText.setClip((Node)UPPER_NEXT_CLIP);
        LinearGradient upperNextTextFill = new LinearGradient(0.0, this.upperNextText.getLayoutBounds().getMinY(), 0.0, this.upperNextText.getLayoutBounds().getMaxY(), false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, this.control.getTextUpperFlapColor()), new Stop(0.47, this.control.getTextColor()), new Stop(0.5, this.control.getTextColor().darker())});
        this.upperNextText.setFill((Paint)upperNextTextFill);
        this.upperNextText.setStroke(null);
        Rectangle LOWER_NEXT_CLIP = new Rectangle(0.0, this.lower.getLayoutBounds().getMinY(), WIDTH, this.lower.getLayoutBounds().getHeight());
        this.lowerNextText.setTextOrigin(VPos.BOTTOM);
        this.lowerNextText.setFont(FONT);
        this.lowerNextText.setFontSmoothingType(FontSmoothingType.LCD);
        this.lowerNextText.setText(this.control.getNextText());
        this.lowerNextText.setX((WIDTH - this.lowerNextText.getLayoutBounds().getWidth()) / 2.0);
        this.lowerNextText.setY(HEIGHT * 0.04 + this.lowerNextText.getLayoutBounds().getHeight());
        this.lowerNextText.setClip((Node)LOWER_NEXT_CLIP);
        LinearGradient LOWER_NEXT_TEXT_FILL = new LinearGradient(0.0, this.lowerNextText.getLayoutBounds().getMinY(), 0.0, this.lowerNextText.getLayoutBounds().getMaxY(), false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.5, this.control.getTextColor().brighter()), new Stop(0.53, this.control.getTextLowerFlapColor()), new Stop(1.0, this.control.getTextColor())});
        this.lowerNextText.setFill((Paint)LOWER_NEXT_TEXT_FILL);
        this.lowerNextText.setStroke(null);
        this.lowerNextText.setVisible(false);
        this.lowerFlipVert = new Rotate();
        this.lowerFlipVert.setAxis(Rotate.X_AXIS);
        this.lowerFlipVert.setPivotY(HEIGHT * 0.4625550661);
        this.lowerFlipVert.setAngle(180.0);
        this.lowerNextText.getTransforms().add((Object)this.lowerFlipVert);
        if (this.selectedSet.get(this.currentSelectionIndex).length() > 1) {
            textOffset = 0.1057268722 * HEIGHT;
            this.upperText.setX(textOffset);
            this.lowerText.setX(textOffset);
        }
        if (this.selectedSet.get(this.nextSelectionIndex).length() > 1) {
            textOffset = 0.1057268722 * HEIGHT;
            this.upperNextText.setX(textOffset);
            this.lowerNextText.setX(textOffset);
        }
        if (this.control.isInteractive()) {
            this.addMouseEventListener((Shape)this.upperText, 1);
            this.addMouseEventListener((Shape)this.upperNextText, 1);
            this.addMouseEventListener((Shape)this.lowerText, -1);
            this.addMouseEventListener((Shape)this.lowerNextText, -1);
        }
        this.flip.setDepthTest(DepthTest.ENABLE);
        this.flip.getChildren().addAll((Object[])new Node[]{this.lower, this.lowerText, this.upperNext, this.upperNextText, this.upper, this.upperText, this.lowerNextText});
    }

    public final void drawFrame() {
        double WIDTH = this.control.getPrefWidth();
        double HEIGHT = this.control.getPrefHeight();
        this.frame.getChildren().clear();
        Shape FRAME = Shape.subtract((Shape)new Rectangle(0.0, 0.0, WIDTH, HEIGHT), (Shape)new Rectangle(0.0352422907 * HEIGHT, 0.0352422907 * HEIGHT, WIDTH - 0.0704845814 * HEIGHT, 0.9207048458 * HEIGHT));
        LinearGradient FRAME_FILL = new LinearGradient(0.0, 0.0, 0.0, HEIGHT, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, this.control.getFrameTopColor()), new Stop(1.0, this.control.getFrameBottomColor())});
        FRAME.setFill((Paint)FRAME_FILL);
        FRAME.setStroke(null);
        this.frame.getChildren().addAll((Object[])new Node[]{FRAME});
        this.frame.setCache(true);
    }
}

