/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.internal.scene.control.skin;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.skin.SkinBase;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.VPos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.effect.InnerShadow;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import javafx.scene.text.Font;
import javafx.scene.text.FontSmoothingType;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import jfxtras.labs.internal.scene.control.behavior.StepIndicatorBehavior;
import jfxtras.labs.scene.control.gauge.StepIndicator;
import jfxtras.labs.util.Util;

public class StepIndicatorSkin
extends SkinBase<StepIndicator, StepIndicatorBehavior> {
    private StepIndicator control;
    private boolean isDirty;
    private boolean initialized;
    private int noOfCircles;
    private Group circles;
    private Group selectedCircles;

    public StepIndicatorSkin(StepIndicator CONTROL) {
        super((Control)CONTROL, (BehaviorBase)new StepIndicatorBehavior(CONTROL));
        this.control = CONTROL;
        this.initialized = false;
        this.isDirty = false;
        this.noOfCircles = this.control.getNoOfSteps();
        this.circles = new Group();
        this.selectedCircles = new Group();
        this.init();
    }

    private void init() {
        if (this.control.getPrefWidth() < 0.0 | this.control.getPrefHeight() < 0.0) {
            this.control.setPrefSize(this.noOfCircles * 60 + (this.noOfCircles - 1) * 20, 60.0);
        }
        if (this.control.getMinWidth() < 0.0 | this.control.getMinHeight() < 0.0) {
            this.control.setMinSize(this.noOfCircles * 6 + (this.noOfCircles - 1) * 2, 6.0);
        }
        if (this.control.getMaxWidth() < 0.0 | this.control.getMaxHeight() < 0.0) {
            this.control.setMaxSize(this.noOfCircles * 600 + (this.noOfCircles - 1) * 200, 600.0);
        }
        this.registerChangeListener((ObservableValue)this.control.prefWidthProperty(), "PREF_WIDTH");
        this.registerChangeListener((ObservableValue)this.control.prefHeightProperty(), "PREF_HEIGHT");
        this.registerChangeListener((ObservableValue)this.control.colorProperty(), "COLOR");
        this.registerChangeListener((ObservableValue)this.control.noOfStepsProperty(), "NO_OF_CIRCLES");
        this.registerChangeListener((ObservableValue)this.control.currentStepProperty(), "SELECTION");
        this.initialized = true;
        this.repaint();
    }

    protected void handleControlPropertyChanged(String PROPERTY) {
        super.handleControlPropertyChanged(PROPERTY);
        if ("NO_OF_CIRCLES".equals(PROPERTY)) {
            this.noOfCircles = this.control.getNoOfSteps();
            this.repaint();
        } else if ("SELECTION".equals(PROPERTY)) {
            this.drawSelectedCircles();
        } else if ("COLOR".equals(PROPERTY)) {
            this.drawSelectedCircles();
        } else if ("PREF_WIDTH".equals(PROPERTY)) {
            this.repaint();
        } else if ("PREF_HEIGHT".equals(PROPERTY)) {
            this.repaint();
        }
    }

    public final void repaint() {
        this.isDirty = true;
        this.requestLayout();
    }

    public void layoutChildren() {
        if (!this.isDirty) {
            return;
        }
        if (!this.initialized) {
            this.init();
        }
        if (this.control.getScene() != null) {
            this.drawCircles();
            this.drawSelectedCircles();
            this.getChildren().setAll((Object[])new Node[]{this.circles, this.selectedCircles});
        }
        this.isDirty = false;
        super.layoutChildren();
    }

    public final StepIndicator getSkinnable() {
        return this.control;
    }

    public final void dispose() {
        this.control = null;
    }

    protected double computePrefWidth(double PREF_WIDTH) {
        double prefWidth = 200.0;
        if (PREF_WIDTH != -1.0) {
            prefWidth = Math.max(0.0, PREF_WIDTH - this.getInsets().getLeft() - this.getInsets().getRight());
        }
        return super.computePrefWidth(prefWidth);
    }

    protected double computePrefHeight(double PREF_HEIGHT) {
        double prefHeight = 60.0;
        if (PREF_HEIGHT != -1.0) {
            prefHeight = Math.max(0.0, PREF_HEIGHT - this.getInsets().getTop() - this.getInsets().getBottom());
        }
        return super.computePrefWidth(prefHeight);
    }

    private void addMouseEventListener(Shape CIRCLE, final int INDEX) {
        CIRCLE.setOnMouseEntered((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent EVENT) {
                StepIndicatorSkin.this.control.setSelectedStep(INDEX);
            }
        });
        CIRCLE.setOnMouseExited((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent EVENT) {
                StepIndicatorSkin.this.control.setSelectedStep(-1);
            }
        });
    }

    private final void drawCircles() {
        double SIZE;
        double WIDTH = SIZE = this.control.getPrefWidth() < this.control.getPrefHeight() ? this.control.getPrefWidth() : this.control.getPrefHeight();
        double HEIGHT = SIZE;
        this.circles.getChildren().clear();
        this.circles.setStyle("-fx-step-indicator-selected-inner-frame-fill: " + Util.colorToCssColor(this.control.getColor().darker()) + "-fx-step-indicator-selected-inner-background-fill: " + Util.colorToCssColor(this.control.getColor()) + "-fx-step-indicator-selected-text-fill: " + Util.colorToCssColor(this.control.getColor().darker().darker()) + "-fx-step-indicator-inner-frame-fill: rgb(158, 158, 158);" + "-fx-step-indicator-inner-background-fill: rgb(244, 244, 244);" + "-fx-step-indicator-stroke: transparent");
        InnerShadow OUTER_BACKGROUND_INNER_SHADOW = new InnerShadow();
        OUTER_BACKGROUND_INNER_SHADOW.setWidth(0.1933333333 * HEIGHT);
        OUTER_BACKGROUND_INNER_SHADOW.setHeight(0.1933333333 * HEIGHT);
        OUTER_BACKGROUND_INNER_SHADOW.setOffsetX(0.0);
        OUTER_BACKGROUND_INNER_SHADOW.setOffsetY(0.04 * SIZE);
        OUTER_BACKGROUND_INNER_SHADOW.setRadius(0.1933333333 * HEIGHT);
        OUTER_BACKGROUND_INNER_SHADOW.setColor(Color.color((double)0.6, (double)0.6, (double)0.6, (double)0.65));
        OUTER_BACKGROUND_INNER_SHADOW.setBlurType(BlurType.GAUSSIAN);
        OUTER_BACKGROUND_INNER_SHADOW.inputProperty().set(null);
        DropShadow INNER_FRAME_DROP_SHADOW = new DropShadow();
        INNER_FRAME_DROP_SHADOW.setWidth(0.048 * HEIGHT);
        INNER_FRAME_DROP_SHADOW.setHeight(0.048 * HEIGHT);
        INNER_FRAME_DROP_SHADOW.setOffsetX(0.0);
        INNER_FRAME_DROP_SHADOW.setOffsetY(0.02 * SIZE);
        INNER_FRAME_DROP_SHADOW.setRadius(0.048 * HEIGHT);
        INNER_FRAME_DROP_SHADOW.setColor(Color.color((double)0.4, (double)0.4, (double)0.4, (double)0.65));
        INNER_FRAME_DROP_SHADOW.setBlurType(BlurType.GAUSSIAN);
        INNER_FRAME_DROP_SHADOW.inputProperty().set(null);
        InnerShadow INNER_BACKGROUND_INNER_SHADOW = new InnerShadow();
        INNER_BACKGROUND_INNER_SHADOW.setWidth(0.092 * HEIGHT);
        INNER_BACKGROUND_INNER_SHADOW.setHeight(0.092 * HEIGHT);
        INNER_BACKGROUND_INNER_SHADOW.setOffsetX(0.0);
        INNER_BACKGROUND_INNER_SHADOW.setOffsetY(0.0);
        INNER_BACKGROUND_INNER_SHADOW.setRadius(0.092 * HEIGHT);
        INNER_BACKGROUND_INNER_SHADOW.setColor(Color.WHITE);
        INNER_BACKGROUND_INNER_SHADOW.setBlurType(BlurType.GAUSSIAN);
        INNER_BACKGROUND_INNER_SHADOW.inputProperty().set(null);
        double STEP_SIZE = 1.3333333333 * WIDTH;
        Circle outerFrame = new Circle(0.5 * WIDTH, 0.5 * HEIGHT, 0.5 * WIDTH);
        Circle outerBackground = new Circle(0.5 * WIDTH, 0.5 * HEIGHT, 0.48333333333333334 * WIDTH);
        for (int i = 1; i < this.control.getNoOfSteps(); ++i) {
            Rectangle FRAME_CONNECTOR = new Rectangle(0.5 * WIDTH + (double)(i - 1) * STEP_SIZE, 0.3166666667 * HEIGHT, 1.3333333333 * WIDTH, 0.3666666667 * HEIGHT);
            outerFrame = Shape.union((Shape)outerFrame, (Shape)FRAME_CONNECTOR);
            Circle OUTER_FRAME = new Circle(0.5 * WIDTH + (double)i * STEP_SIZE, 0.5 * HEIGHT, 0.5 * WIDTH);
            outerFrame = Shape.union((Shape)outerFrame, (Shape)OUTER_FRAME);
            Rectangle BACKGROUND_CONNECTOR = new Rectangle(0.5 * WIDTH + (double)(i - 1) * STEP_SIZE, 0.3333333333 * HEIGHT, 1.3333333333 * WIDTH, 0.3333333333 * HEIGHT);
            outerBackground = Shape.union((Shape)outerBackground, (Shape)BACKGROUND_CONNECTOR);
            Circle OUTER_BACKGROUND = new Circle(0.5 * WIDTH + (double)i * STEP_SIZE, 0.5 * HEIGHT, 0.48333333333333334 * WIDTH);
            outerBackground = Shape.union((Shape)outerBackground, (Shape)OUTER_BACKGROUND);
        }
        outerFrame.getStyleClass().add((Object)"step-indicator-outer-frame");
        outerBackground.getStyleClass().add((Object)"step-indicator-outer-background");
        outerFrame.setFill((Paint)Color.rgb((int)201, (int)201, (int)201));
        outerBackground.setFill((Paint)Color.WHITE);
        outerBackground.setEffect((Effect)OUTER_BACKGROUND_INNER_SHADOW);
        Circle innerFrame = new Circle(0.5 * WIDTH, 0.5 * HEIGHT, 0.4 * WIDTH);
        Circle innerBackground = new Circle(0.5 * WIDTH, 0.5 * HEIGHT, 0.38333333333333336 * WIDTH);
        for (int i = 1; i < this.control.getNoOfSteps(); ++i) {
            if (i != 0) {
                Rectangle FRAME_CONNECTOR = new Rectangle(0.5 * WIDTH + (double)(i - 1) * STEP_SIZE, 0.4333333333 * HEIGHT, 1.3333333333 * WIDTH, 0.1333333333 * HEIGHT);
                innerFrame = Shape.union((Shape)innerFrame, (Shape)FRAME_CONNECTOR);
            }
            Circle INNER_FRAME = new Circle(0.5 * WIDTH + (double)i * STEP_SIZE, 0.5 * HEIGHT, 0.4 * WIDTH);
            innerFrame = Shape.union((Shape)innerFrame, (Shape)INNER_FRAME);
            if (i != 0) {
                Rectangle BACKGROUND_CONNECTOR = new Rectangle(0.5 * WIDTH + (double)(i - 1) * STEP_SIZE, 0.45 * HEIGHT, 1.3333333333 * WIDTH, 0.1 * HEIGHT);
                innerBackground = Shape.union((Shape)innerBackground, (Shape)BACKGROUND_CONNECTOR);
            }
            Circle INNER_BACKGROUND = new Circle(0.5 * WIDTH + (double)i * STEP_SIZE, 0.5 * HEIGHT, 0.38333333333333336 * WIDTH);
            innerBackground = Shape.union((Shape)innerBackground, (Shape)INNER_BACKGROUND);
        }
        innerFrame.getStyleClass().add((Object)"step-indicator-inner-frame");
        innerBackground.getStyleClass().add((Object)"step-indicator-inner-background");
        innerFrame.setFill((Paint)Color.rgb((int)158, (int)158, (int)158));
        innerBackground.setFill((Paint)Color.rgb((int)244, (int)244, (int)244));
        innerFrame.setEffect((Effect)INNER_FRAME_DROP_SHADOW);
        innerBackground.setEffect((Effect)INNER_BACKGROUND_INNER_SHADOW);
        this.circles.getChildren().addAll((Object[])new Node[]{outerFrame, outerBackground, innerFrame, innerBackground});
        this.circles.setCache(true);
    }

    private final void drawSelectedCircles() {
        int i;
        double SIZE;
        double WIDTH = SIZE = this.control.getPrefWidth() < this.control.getPrefHeight() ? this.control.getPrefWidth() : this.control.getPrefHeight();
        double HEIGHT = SIZE;
        this.selectedCircles.getChildren().clear();
        Rectangle IBOUNDS = new Rectangle(0.0, 0.0, (double)this.control.getNoOfSteps() * WIDTH + (double)(this.control.getNoOfSteps() - 1) * 0.3333333333 * HEIGHT, HEIGHT);
        IBOUNDS.setOpacity(0.0);
        this.selectedCircles.getChildren().add((Object)IBOUNDS);
        this.selectedCircles.setStyle("-fx-step-indicator-selected-inner-frame-fill: " + Util.colorToCssColor(this.control.getColor().darker()) + "-fx-step-indicator-selected-inner-background-fill: " + Util.colorToCssColor(this.control.getColor()) + "-fx-step-indicator-selected-text-fill: " + Util.colorToCssColor(this.control.getColor().darker().darker()) + "-fx-step-indicator-inner-frame-fill: rgb(158, 158, 158);" + "-fx-step-indicator-inner-background-fill: rgb(244, 244, 244);" + "-fx-step-indicator-stroke: transparent");
        InnerShadow INNER_BACKGROUND_INNER_SHADOW = new InnerShadow();
        INNER_BACKGROUND_INNER_SHADOW.setWidth(0.092 * HEIGHT);
        INNER_BACKGROUND_INNER_SHADOW.setHeight(0.092 * HEIGHT);
        INNER_BACKGROUND_INNER_SHADOW.setOffsetX(0.0);
        INNER_BACKGROUND_INNER_SHADOW.setOffsetY(0.0);
        INNER_BACKGROUND_INNER_SHADOW.setRadius(0.092 * HEIGHT);
        INNER_BACKGROUND_INNER_SHADOW.setColor(Color.WHITE);
        INNER_BACKGROUND_INNER_SHADOW.setBlurType(BlurType.GAUSSIAN);
        INNER_BACKGROUND_INNER_SHADOW.inputProperty().set(null);
        double STEP_SIZE = 1.3333333333 * WIDTH;
        Circle innerFrameSelected = new Circle(0.5 * WIDTH, 0.5 * HEIGHT, 0.4 * WIDTH);
        Circle innerBackgroundSelected = new Circle(0.5 * WIDTH, 0.5 * HEIGHT, 0.38333333333333336 * WIDTH);
        for (int i2 = 1; i2 < this.control.getCurrentStep(); ++i2) {
            Rectangle FRAME_CONNECTOR = new Rectangle(0.5 * WIDTH + (double)(i2 - 1) * STEP_SIZE, 0.4333333333 * HEIGHT, 1.3333333333 * WIDTH, 0.1333333333 * HEIGHT);
            innerFrameSelected = Shape.union((Shape)innerFrameSelected, (Shape)FRAME_CONNECTOR);
            Circle INNER_FRAME = new Circle(0.5 * WIDTH + (double)i2 * STEP_SIZE, 0.5 * HEIGHT, 0.4 * WIDTH);
            innerFrameSelected = Shape.union((Shape)innerFrameSelected, (Shape)INNER_FRAME);
            Rectangle BACKGROUND_CONNECTOR = new Rectangle(0.5 * WIDTH + (double)(i2 - 1) * STEP_SIZE, 0.45 * HEIGHT, 1.3333333333 * WIDTH, 0.1 * HEIGHT);
            innerBackgroundSelected = Shape.union((Shape)innerBackgroundSelected, (Shape)BACKGROUND_CONNECTOR);
            Circle INNER_BACKGROUND = new Circle(0.5 * WIDTH + (double)i2 * STEP_SIZE, 0.5 * HEIGHT, 0.38333333333333336 * WIDTH);
            innerBackgroundSelected = Shape.union((Shape)innerBackgroundSelected, (Shape)INNER_BACKGROUND);
        }
        innerFrameSelected.getStyleClass().add((Object)"step-indicator-inner-frame");
        innerBackgroundSelected.getStyleClass().add((Object)"step-indicator-inner-background");
        innerFrameSelected.setFill((Paint)this.control.getColor().darker());
        innerBackgroundSelected.setFill((Paint)this.control.getColor());
        innerBackgroundSelected.setEffect((Effect)INNER_BACKGROUND_INNER_SHADOW);
        if (this.control.getCurrentStep() == 0) {
            innerFrameSelected.setVisible(false);
            innerBackgroundSelected.setVisible(false);
        }
        this.selectedCircles.getChildren().addAll((Object[])new Node[]{innerFrameSelected, innerBackgroundSelected});
        Font FONT = Font.font((String)"Arial", (FontWeight)FontWeight.BOLD, (double)(0.4 * HEIGHT));
        for (i = 0; i < this.control.getNoOfSteps(); ++i) {
            Text NUMBER = new Text(Integer.toString(i + 1));
            NUMBER.setTextOrigin(VPos.CENTER);
            NUMBER.setTextAlignment(TextAlignment.CENTER);
            NUMBER.setFontSmoothingType(FontSmoothingType.LCD);
            NUMBER.setFont(FONT);
            if (i < this.control.getCurrentStep()) {
                NUMBER.getStyleClass().add((Object)"step-indicator-selected-text");
            } else {
                NUMBER.getStyleClass().add((Object)"step-indicator-text");
            }
            NUMBER.setTranslateX((WIDTH - NUMBER.getLayoutBounds().getWidth()) / 2.0 + (double)i * STEP_SIZE);
            NUMBER.setTranslateY(0.5 * HEIGHT);
            this.selectedCircles.getChildren().add((Object)NUMBER);
        }
        for (i = 0; i < this.control.getCurrentStep(); ++i) {
            Circle HOT_SPOT = new Circle(0.5 * WIDTH + (double)i * STEP_SIZE, 0.5 * HEIGHT, 0.4 * WIDTH);
            HOT_SPOT.setFill((Paint)Color.TRANSPARENT);
            HOT_SPOT.setStroke((Paint)Color.TRANSPARENT);
            this.selectedCircles.getChildren().add((Object)HOT_SPOT);
            this.addMouseEventListener((Shape)HOT_SPOT, i + 1);
        }
        this.selectedCircles.setCache(true);
    }
}

