/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.map;

public class Mercator {
    private static int TILE_SIZE = 256;
    public static final double MAX_LAT = 85.05112877980659;
    public static final double MIN_LAT = -85.05112877980659;

    public static double radius(int aZoomlevel) {
        return (double)(TILE_SIZE * (1 << aZoomlevel)) / (Math.PI * 2);
    }

    public static int getMaxPixels(int aZoomlevel) {
        return TILE_SIZE * (1 << aZoomlevel);
    }

    public static int falseEasting(int aZoomlevel) {
        return Mercator.getMaxPixels(aZoomlevel) / 2;
    }

    public static int falseNorthing(int aZoomlevel) {
        return -1 * Mercator.getMaxPixels(aZoomlevel) / 2;
    }

    public static int lonToX(double aLongitude, int aZoomlevel) {
        int mp = Mercator.getMaxPixels(aZoomlevel);
        int x = (int)((double)mp * (aLongitude + 180.0) / 360.0);
        x = Math.min(x, mp - 1);
        return x;
    }

    public static int latToY(double aLat, int aZoomlevel) {
        if (aLat < -85.05112877980659) {
            aLat = -85.05112877980659;
        } else if (aLat > 85.05112877980659) {
            aLat = 85.05112877980659;
        }
        double sinLat = Math.sin(Math.toRadians(aLat));
        double log = Math.log((1.0 + sinLat) / (1.0 - sinLat));
        int mp = Mercator.getMaxPixels(aZoomlevel);
        int y = (int)((double)mp * (0.5 - log / (Math.PI * 4)));
        y = Math.min(y, mp - 1);
        return y;
    }

    public static double xToLon(int aX, int aZoomlevel) {
        return 360.0 * (double)aX / (double)Mercator.getMaxPixels(aZoomlevel) - 180.0;
    }

    public static double yToLat(int aY, int aZoomlevel) {
        double latitude = 1.5707963267948966 - 2.0 * Math.atan(Math.exp(-1.0 * (double)(aY += Mercator.falseNorthing(aZoomlevel)) / Mercator.radius(aZoomlevel)));
        return -1.0 * Math.toDegrees(latitude);
    }
}

