/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.map;

import java.awt.Point;
import javafx.event.EventHandler;
import javafx.scene.Cursor;
import javafx.scene.Group;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import jfxtras.labs.map.MapControlable;

public class TilesMouseHandler {
    private MapControlable controlable;
    private boolean adjusted;

    public TilesMouseHandler(MapControlable controlable) {
        this.controlable = controlable;
    }

    public void setEventPublisher(Group tilesGroup) {
        tilesGroup.setOnScroll((EventHandler)new ScrollEventAdapter());
        tilesGroup.setOnMouseEntered((EventHandler)new MouseEnterAdapter(tilesGroup));
        tilesGroup.setOnMouseExited((EventHandler)new MouseExitAdapter(tilesGroup));
        tilesGroup.setOnMouseMoved((EventHandler)new MouseMovedAdapter());
        tilesGroup.setOnMousePressed((EventHandler)new MousePressedAdapter());
        tilesGroup.setOnMouseReleased((EventHandler)new MouseReleasedAdapter(tilesGroup));
        tilesGroup.setOnMouseDragged((EventHandler)new MouseDraggedAdapter(tilesGroup));
    }

    private void updateCursorLocationText(ScrollEvent me) {
        this.updateCursorLocationText(me.getX(), me.getY());
    }

    private void updateCursorLocationText(MouseEvent me) {
        this.updateCursorLocationText(me.getX(), me.getY());
    }

    private void updateCursorLocationText(double x, double y) {
        this.controlable.setCursorLocationText(x, y);
        if (!this.adjusted) {
            this.controlable.adjustCursorLocationText();
            this.adjusted = true;
        }
    }

    private void moveMap(MouseEvent me) {
        this.moveMap(new Point((int)me.getX(), (int)me.getY()));
    }

    private void moveMap(Point p) {
        Point lastDragPoint = this.controlable.getLastDragPoint();
        if (lastDragPoint != null) {
            int diffx = lastDragPoint.x - p.x;
            int diffy = lastDragPoint.y - p.y;
            this.controlable.moveMap(diffx, diffy);
        }
    }

    private void setLastDragPoint(MouseEvent me) {
        Point p = new Point((int)me.getX(), (int)me.getY());
        this.controlable.setLastDragPoint(p);
    }

    private class MouseDraggedAdapter
    implements EventHandler<MouseEvent> {
        private Group tilesGroup;

        MouseDraggedAdapter(Group tilesGroup) {
            this.tilesGroup = tilesGroup;
        }

        public void handle(MouseEvent me) {
            if (me.isPrimaryButtonDown()) {
                this.tilesGroup.setCursor(Cursor.MOVE);
                Point point = TilesMouseHandler.this.controlable.getLastDragPoint();
                if (point == null) {
                    TilesMouseHandler.this.setLastDragPoint(me);
                }
            }
        }
    }

    private class MouseReleasedAdapter
    implements EventHandler<MouseEvent> {
        private Group tilesGroup;

        MouseReleasedAdapter(Group tilesGroup) {
            this.tilesGroup = tilesGroup;
        }

        public void handle(MouseEvent me) {
            this.tilesGroup.setCursor(Cursor.CROSSHAIR);
            TilesMouseHandler.this.moveMap(me);
            TilesMouseHandler.this.controlable.setLastDragPoint(null);
        }
    }

    private class MouseMovedAdapter
    implements EventHandler<MouseEvent> {
        private MouseMovedAdapter() {
        }

        public void handle(MouseEvent me) {
            if (me.isPrimaryButtonDown()) {
                TilesMouseHandler.this.setLastDragPoint(me);
            } else {
                TilesMouseHandler.this.updateCursorLocationText(me);
            }
        }
    }

    private static class MouseExitAdapter
    implements EventHandler<MouseEvent> {
        private Group group;

        MouseExitAdapter(Group group) {
            this.group = group;
        }

        public void handle(MouseEvent e) {
            this.group.setCursor(Cursor.DEFAULT);
        }
    }

    private class MouseEnterAdapter
    implements EventHandler<MouseEvent> {
        private Group group;

        MouseEnterAdapter(Group group) {
            this.group = group;
        }

        public void handle(MouseEvent e) {
            this.group.setCursor(Cursor.CROSSHAIR);
            TilesMouseHandler.this.updateCursorLocationText(e);
        }
    }

    private class MousePressedAdapter
    implements EventHandler<MouseEvent> {
        private MousePressedAdapter() {
        }

        public void handle(MouseEvent me) {
            if (me.isPrimaryButtonDown()) {
                TilesMouseHandler.this.controlable.setLastDragPoint(new Point((int)me.getX(), (int)me.getY()));
            }
        }
    }

    private class ScrollEventAdapter
    implements EventHandler<ScrollEvent> {
        private ScrollEventAdapter() {
        }

        public void handle(ScrollEvent se) {
            if (se.getDeltaY() > 0.0) {
                if (TilesMouseHandler.this.controlable.getZoom() < TilesMouseHandler.this.controlable.getTileSource().getMaxZoom()) {
                    TilesMouseHandler.this.controlable.zoomIn(new Point((int)se.getX(), (int)se.getY()));
                    TilesMouseHandler.this.updateCursorLocationText(se);
                }
            } else if (TilesMouseHandler.this.controlable.getZoom() > TilesMouseHandler.this.controlable.getTileSource().getMinZoom()) {
                TilesMouseHandler.this.controlable.zoomOut(new Point((int)se.getX(), (int)se.getY()));
                TilesMouseHandler.this.updateCursorLocationText(se);
            }
        }
    }
}

