/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.map.render;

import java.awt.Point;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.effect.DropShadow;
import javafx.scene.paint.Color;
import jfxtras.labs.map.MapControlable;
import jfxtras.labs.map.render.MapMarkable;

abstract class AbstractMapMarker
implements MapMarkable {
    private static final int SHADOW_OFFSET = 10;
    private double lat;
    private double lon;

    AbstractMapMarker() {
    }

    AbstractMapMarker(double lat, double lon) {
        this.lat = lat;
        this.lon = lon;
    }

    @Override
    public double getLat() {
        return this.lat;
    }

    @Override
    public double getLon() {
        return this.lon;
    }

    @Override
    public void render(MapControlable mapController) {
        Point postion = mapController.getMapPoint(this.lat, this.lon, true);
        if (postion != null) {
            Group tilesGroup = mapController.getTilesGroup();
            ObservableList children = tilesGroup.getChildren();
            List<? extends Node> nodes = this.createChildren(postion);
            for (Node node : nodes) {
                if (children.contains((Object)node)) continue;
                children.add((Object)node);
            }
        }
    }

    abstract List<? extends Node> createChildren(Point var1);

    public void setLat(double val) {
        this.lat = val;
    }

    public void setLon(double val) {
        this.lon = val;
    }

    protected DropShadow createShadow(Color color) {
        DropShadow dropShadow = new DropShadow();
        dropShadow.setOffsetX(10.0);
        dropShadow.setOffsetY(10.0);
        dropShadow.setColor(color);
        return dropShadow;
    }

    public String toString() {
        return this.getClass().getName() + " " + this.getLat() + " " + this.getLon();
    }
}

