/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.map.render;

import java.awt.Point;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Polyline;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.shape.StrokeType;
import jfxtras.labs.map.Coordinate;
import jfxtras.labs.map.MapControlable;
import jfxtras.labs.map.render.MapLineable;

public class DefaultMapLine
implements MapLineable {
    private String name;
    private Color color;
    private double dashOffset;
    private double width;
    private ObservableList<Coordinate> coordinates;

    public DefaultMapLine(List<Coordinate> coordinates) {
        this("", Color.BLACK, 1.0, 0.0, (List<Coordinate>)FXCollections.observableList(coordinates));
    }

    public DefaultMapLine(String n, Color c, double width, double dashOffset, List<Coordinate> coords) {
        this.name = n;
        this.color = c;
        this.dashOffset = dashOffset;
        this.width = width;
        this.coordinates = FXCollections.observableList(coords);
    }

    @Override
    public void addCoordinate(Coordinate coordinate) {
        this.coordinates.add((Object)coordinate);
    }

    @Override
    public void render(MapControlable viewer) {
        Polyline polyline = new Polyline();
        polyline.setStrokeType(StrokeType.CENTERED);
        polyline.setStrokeDashOffset(this.dashOffset);
        polyline.setStroke((Paint)this.color);
        polyline.setStrokeWidth(this.width);
        polyline.setStrokeLineCap(StrokeLineCap.ROUND);
        polyline.setStrokeLineJoin(StrokeLineJoin.ROUND);
        DropShadow dropShadow = new DropShadow();
        dropShadow.setOffsetX(10.0);
        dropShadow.setOffsetY(10.0);
        dropShadow.setColor(Color.rgb((int)50, (int)50, (int)50, (double)0.7));
        polyline.setEffect((Effect)dropShadow);
        for (Coordinate coordinate : this.coordinates) {
            Point p = viewer.getMapPoint(coordinate.getLatitude(), coordinate.getLongitude(), false);
            polyline.getPoints().add((Object)p.x);
            polyline.getPoints().add((Object)p.y);
        }
        viewer.getTilesGroup().getChildren().add((Object)polyline);
    }

    public String toString() {
        return "MapLine" + this.name;
    }
}

