/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.map.tile;

import javafx.scene.image.Image;
import jfxtras.labs.map.Coordinate;
import jfxtras.labs.map.tile.OsmTilePathBuilder;
import jfxtras.labs.map.tile.TilePathBuildable;
import jfxtras.labs.map.tile.TileSource;
import jfxtras.labs.map.tile.TileUrlBuildable;
import jfxtras.labs.map.tile.ZoomBounds;

public class DefaultTileSource
implements TileSource {
    public static final int DEFAULT_TILE_SIZE = 256;
    protected String name;
    protected String baseUrl;
    private Image attributionImage;
    private int minZoom = ZoomBounds.Min.getValue();
    private int maxZoom = ZoomBounds.MAX.getValue();
    private boolean attributionRequired = true;
    private TileUrlBuildable urlBuilder;
    private TilePathBuildable tilePathBuilder;
    private String termsOfUserURL;
    private String attributionLinkURL;
    private String attributionText;
    protected String apiKey;

    public DefaultTileSource(String name, String base_url) {
        this.name = name;
        this.baseUrl = base_url;
        this.tilePathBuilder = new OsmTilePathBuilder();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getMaxZoom() {
        return this.maxZoom;
    }

    @Override
    public int getMinZoom() {
        return this.minZoom;
    }

    public String getTilePath(int zoom, int tilex, int tiley) {
        return this.tilePathBuilder.buildPath(zoom, tilex, tiley);
    }

    public void setUrlBuilder(TileUrlBuildable urlBuilder) {
        this.urlBuilder = urlBuilder;
    }

    public String getBaseUrl() {
        String url = this.urlBuilder != null ? this.urlBuilder.build(this.baseUrl) : this.baseUrl;
        return url;
    }

    @Override
    public String getTileUrl(int zoom, int tilex, int tiley) {
        return this.getBaseUrl() + this.getTilePath(zoom, tilex, tiley);
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public int getTileSize() {
        return 256;
    }

    @Override
    public Image getAttributionImage() {
        return this.attributionImage;
    }

    public void setAttributionImage(Image attributionImage) {
        this.attributionImage = attributionImage;
    }

    @Override
    public boolean isAttributionRequired() {
        return this.attributionRequired;
    }

    @Override
    public String getAttributionText(int zoom, Coordinate topLeft, Coordinate botRight) {
        return this.attributionText;
    }

    public void setAttributionText(String attributionText) {
        this.attributionText = attributionText;
    }

    @Override
    public String getAttributionLinkURL() {
        return this.attributionLinkURL;
    }

    public void setAttributionLinkURL(String attributionLinkURL) {
        this.attributionLinkURL = attributionLinkURL;
    }

    @Override
    public String getTermsOfUseURL() {
        return this.termsOfUserURL;
    }

    public void setTermsOfUserURL(String termsOfUserURL) {
        this.termsOfUserURL = termsOfUserURL;
    }

    @Override
    public double latToTileY(double lat, int zoom) {
        double l = lat / 180.0 * Math.PI;
        double pf = Math.log(Math.tan(l) + 1.0 / Math.cos(l));
        return Math.pow(2.0, zoom - 1) * (Math.PI - pf) / Math.PI;
    }

    @Override
    public double lonToTileX(double lon, int zoom) {
        return Math.pow(2.0, zoom - 3) * (lon + 180.0) / 45.0;
    }

    @Override
    public double tileYToLat(int y, int zoom) {
        return Math.atan(Math.sinh(Math.PI - Math.PI * (double)y / Math.pow(2.0, zoom - 1))) * 180.0 / Math.PI;
    }

    @Override
    public double tileXToLon(int x, int zoom) {
        return (double)x * 45.0 / Math.pow(2.0, zoom - 3) - 180.0;
    }

    protected final void setMinZoom(int minZoom) {
        this.minZoom = minZoom;
    }

    protected final void setMaxZoom(int maxZoom) {
        this.maxZoom = maxZoom;
    }

    public void setAttributionRequired(boolean required) {
        this.attributionRequired = required;
    }

    protected String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public void setTilePathBuilder(TilePathBuildable tilePathBuilder) {
        this.tilePathBuilder = tilePathBuilder;
    }
}

