/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.map.tile;

import jfxtras.labs.map.tile.AlternateOsmTileUrlBuilder;
import jfxtras.labs.map.tile.DefaultTileSource;
import jfxtras.labs.map.tile.OsmType;
import jfxtras.labs.map.tile.TileSource;
import jfxtras.labs.map.tile.TileSourceFactory;

public class OsmTileSourceFactory
implements TileSourceFactory<OsmType> {
    private static final int ZOOM = 18;

    @Override
    public TileSource create() {
        return this.create(OsmType.Mapnik);
    }

    @Override
    public TileSource create(OsmType type) {
        DefaultTileSource tileSource;
        switch (type) {
            case CycleMap: {
                tileSource = this.createExtended("OSM Cycle Map", "http://%s.tile.opencyclemap.org/cycle");
                break;
            }
            case Transport: {
                tileSource = this.createExtended("OSM Transport Map", "http://%s.tile2.opencyclemap.org/transport");
                break;
            }
            case Landscape: {
                tileSource = this.createExtended("OSM Landscape Map", "http://%s.tile3.opencyclemap.org/landscape");
                break;
            }
            default: {
                tileSource = new DefaultTileSource("Mapnik", "http://tile.openstreetmap.org");
            }
        }
        tileSource.setAttributionRequired(false);
        tileSource.setMaxZoom(18);
        return tileSource;
    }

    private DefaultTileSource createExtended(String name, String baseUrl) {
        DefaultTileSource osm = new DefaultTileSource(name, baseUrl);
        osm.setUrlBuilder(new AlternateOsmTileUrlBuilder());
        return osm;
    }
}

