/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.map.tile;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.image.Image;
import jfxtras.labs.map.tile.Tile;
import jfxtras.labs.map.tile.TileCacheable;
import jfxtras.labs.map.tile.TileInfo;
import jfxtras.labs.map.tile.TileSource;

public class TileRepository
implements TileCacheable {
    private TileSource tileSource;
    private Map<String, TileInfo> cache;
    private long expire;
    public static final long DEFAULT_EXPIRE = 3600000L;

    public TileRepository(TileSource source) {
        this.tileSource = source;
        this.cache = new ConcurrentHashMap<String, TileInfo>();
        this.expire = 3600000L;
    }

    @Override
    public Tile getTile(int tilex, int tiley, int zoom) {
        Tile tile = null;
        if (this.isValid(tilex, tiley, zoom)) {
            this.cleanupCache();
            String location = this.tileSource.getTileUrl(zoom, tilex, tiley);
            TileInfo info = this.cache.get(location);
            if (info != null) {
                tile = new Tile(location, info.getImage());
            } else {
                tile = new Tile(location);
                tile.imageLoadedProperty().addListener((ChangeListener)new ImageLoadedListener(location, tile));
                tile.loadImage();
            }
        }
        return tile;
    }

    private void cleanupCache() {
        Set<Map.Entry<String, TileInfo>> entries = this.cache.entrySet();
        for (Map.Entry<String, TileInfo> entry : entries) {
            TileInfo info = entry.getValue();
            long current = System.currentTimeMillis();
            if (current - info.getTimeStamp() <= this.expire) continue;
            this.cache.remove(entry.getKey());
        }
    }

    private boolean isValid(int tilex, int tiley, int zoom) {
        boolean valid = false;
        if (this.tileSource != null) {
            int max = 1 << zoom;
            valid = tilex >= 0 && tilex < max && tiley >= 0 && tiley < max;
        }
        return valid;
    }

    @Override
    public TileSource getTileSource() {
        return this.tileSource;
    }

    @Override
    public void setTileSource(TileSource tileSource) {
        this.tileSource = tileSource;
        this.cache.clear();
    }

    public void setExpire(long expire) {
        this.expire = expire;
    }

    private class ImageLoadedListener
    implements ChangeListener<Boolean> {
        private String location;
        private Tile tile;

        public ImageLoadedListener(String location, Tile tile) {
            this.location = location;
            this.tile = tile;
        }

        public void changed(ObservableValue<? extends Boolean> ov, Boolean oldVal, Boolean newVal) {
            if (newVal.booleanValue()) {
                this.addImage(this.location, this.tile.getImageView().getImage());
            }
        }

        private void addImage(String tileLocation, Image image) {
            long timeStamp = System.currentTimeMillis();
            TileInfo info = new TileInfo(timeStamp, image);
            TileRepository.this.cache.put(tileLocation, info);
        }
    }
}

