/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.map.tile.attribution;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jfxtras.labs.map.tile.attribution.Attribution;
import jfxtras.labs.map.tile.attribution.BingMetaDataHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class BingMapMetaDataHandler
extends BingMetaDataHandler {
    private static final String METADATA = "http://dev.virtualearth.net/REST/V1/Imagery/Copyright/en-us/Road/1/0/0/0/0?output=xml&dir=0";
    private static final String CR_PATTERN = "\\S\\s\\d+\\s\\w+";
    private static final String CR_TAG = "Copyright";
    private static final String STRING = "string";
    private String copyRight;
    private Pattern pattern = Pattern.compile("\\S\\s\\d+\\s\\w+");
    private boolean isCopyRight;

    public BingMapMetaDataHandler(String apiKey) {
        super(apiKey);
    }

    @Override
    public void startElement(String uri, String stripped, String tagName, Attributes attrs) throws SAXException {
        switch (tagName) {
            case "Copyright": {
                this.isCopyRight = true;
                break;
            }
            case "string": {
                this.attribution = this.createAttribution();
                break;
            }
        }
    }

    private Attribution createAttribution() {
        Attribution attr = new Attribution();
        attr.setMaxZoom(Integer.MAX_VALUE);
        return attr;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        super.characters(ch, start, length);
        if (this.isCopyRight) {
            this.copyRight = this.extractDefaultCopyRight(this.text);
        }
    }

    protected String extractDefaultCopyRight(String string) {
        String cr = "";
        Matcher matcher = this.pattern.matcher(this.text);
        while (matcher.find()) {
            cr = matcher.group();
        }
        return cr;
    }

    @Override
    public void endElement(String uri, String stripped, String tagName) throws SAXException {
        switch (tagName) {
            case "Copyright": {
                this.isCopyRight = false;
                break;
            }
            case "string": {
                this.attribution.setText(this.text);
                this.attributions.add(this.attribution);
                break;
            }
        }
    }

    @Override
    public void endDocument() throws SAXException {
        this.attribution = this.createAttribution();
        this.attribution.setText(this.copyRight + " Corporation");
        this.attributions.add(this.attribution);
    }

    @Override
    public String getMetaData(String key) {
        return METADATA + key;
    }
}

