/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.scene.control;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.lang.ref.WeakReference;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.FloatProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ListProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.MapProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.collections.ObservableSet;
import javafx.collections.SetChangeListener;
import javafx.scene.control.SelectionModel;
import javafx.util.StringConverter;

public class BeanPathAdapter<B> {
    public static final char PATH_SEPARATOR = '.';
    public static final char COLLECTION_ITEM_PATH_SEPARATOR = '#';
    public static final DateFormat SDF = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssz");
    private final ObjectProperty<DateFormat> dateFormatProperty = new SimpleObjectProperty((Object)SDF);
    private FieldBean<Void, B> root;
    private FieldPathValueProperty fieldPathValueProperty = new FieldPathValueProperty();

    public BeanPathAdapter(B bean) {
        this.setBean(bean);
    }

    public void bindBidirectional(String fieldPath, BooleanProperty property) {
        this.bindBidirectional(fieldPath, (Property)property, (Class)Boolean.class);
    }

    public void bindBidirectional(String fieldPath, StringProperty property) {
        this.bindBidirectional(fieldPath, (Property)property, (Class)String.class);
    }

    public void bindBidirectional(String fieldPath, Property<Number> property) {
        this.bindBidirectional(fieldPath, property, null);
    }

    public <E> void bindContentBidirectional(String fieldPath, String itemFieldPath, Class<?> itemFieldPathType, ObservableList<E> list, Class<E> listValueType, SelectionModel<E> selectionModel, String selectionModelItemMasterPath) {
        FieldProperty<?, ?, ?> itemMaster = null;
        if (selectionModelItemMasterPath != null && !selectionModelItemMasterPath.isEmpty()) {
            itemMaster = this.getRoot().performOperation(selectionModelItemMasterPath, list, listValueType, itemFieldPath, itemFieldPathType, null, null, FieldBeanOperation.CREATE_OR_FIND);
        }
        this.getRoot().performOperation(fieldPath, list, listValueType, itemFieldPath, itemFieldPathType, selectionModel, itemMaster, FieldBeanOperation.BIND);
    }

    public <E> void bindContentBidirectional(String fieldPath, String itemFieldPath, Class<?> itemFieldPathType, ObservableSet<E> set, Class<E> setValueType, SelectionModel<E> selectionModel, String selectionModelItemMasterPath) {
        FieldProperty<?, ?, ?> itemMaster = null;
        if (selectionModelItemMasterPath != null && !selectionModelItemMasterPath.isEmpty()) {
            itemMaster = this.getRoot().performOperation(selectionModelItemMasterPath, set, setValueType, itemFieldPath, itemFieldPathType, null, null, FieldBeanOperation.CREATE_OR_FIND);
        }
        this.getRoot().performOperation(fieldPath, set, setValueType, itemFieldPath, itemFieldPathType, selectionModel, itemMaster, FieldBeanOperation.BIND);
    }

    public <K, V> void bindContentBidirectional(String fieldPath, String itemFieldPath, Class<?> itemFieldPathType, ObservableMap<K, V> map, Class<V> mapValueType, SelectionModel<V> selectionModel, String selectionModelItemMasterPath) {
        FieldProperty<?, ?, ?> itemMaster = null;
        if (selectionModelItemMasterPath != null && !selectionModelItemMasterPath.isEmpty()) {
            itemMaster = this.getRoot().performOperation(selectionModelItemMasterPath, map, mapValueType, itemFieldPath, itemFieldPathType, null, null, FieldBeanOperation.CREATE_OR_FIND);
        }
        this.getRoot().performOperation(fieldPath, map, mapValueType, itemFieldPath, itemFieldPathType, selectionModel, itemMaster, FieldBeanOperation.BIND);
    }

    public <T> void bindBidirectional(String fieldPath, Property<T> property, Class<T> propertyType) {
        Class<Object> clazz;
        Class<T> clazz2 = clazz = propertyType != null ? propertyType : BeanPathAdapter.propertyValueClass(property);
        if (clazz == null && property.getValue() != null) {
            clazz = property.getValue().getClass();
        }
        if (clazz == null || clazz == Object.class) {
            throw new UnsupportedOperationException(String.format("Unable to determine property value class for %1$s and declared type %2$s", property, propertyType));
        }
        this.getRoot().performOperation(fieldPath, property, clazz, FieldBeanOperation.BIND);
    }

    public <T> void unBindBidirectional(String fieldPath, Property<T> property) {
        this.getRoot().performOperation(fieldPath, property, null, FieldBeanOperation.UNBIND);
    }

    public B getBean() {
        return this.getRoot().getBean();
    }

    public void setBean(B bean) {
        if (bean == null) {
            throw new NullPointerException();
        }
        if (this.getRoot() == null) {
            this.root = new FieldBean(null, bean, null, this.fieldPathValueProperty, this.dateFormatProperty());
        } else {
            this.getRoot().setBean(bean);
        }
        if (this.hasFieldPathValueTypes(FieldPathValueType.BEAN_CHANGE)) {
            this.fieldPathValueProperty.set(new FieldPathValue(null, this.getBean(), this.getBean(), FieldPathValueType.BEAN_CHANGE));
        }
    }

    protected final FieldBean<Void, B> getRoot() {
        return this.root;
    }

    public void setDateFormat(DateFormat df) {
        this.dateFormatProperty().set((Object)df);
    }

    public DateFormat getDateFormat() {
        return (DateFormat)this.dateFormatProperty().get();
    }

    public ObjectProperty<DateFormat> dateFormatProperty() {
        return this.dateFormatProperty;
    }

    public final ReadOnlyObjectProperty<FieldPathValue> fieldPathValueProperty() {
        return this.fieldPathValueProperty.getReadOnlyProperty();
    }

    protected static <T> Class<T> propertyValueClass(Property<T> property) {
        Class clazz = null;
        if (property != null) {
            clazz = StringProperty.class.isAssignableFrom(property.getClass()) ? String.class : (IntegerProperty.class.isAssignableFrom(property.getClass()) ? Integer.class : (BooleanProperty.class.isAssignableFrom(property.getClass()) ? Boolean.class : (DoubleProperty.class.isAssignableFrom(property.getClass()) ? Double.class : (FloatProperty.class.isAssignableFrom(property.getClass()) ? Float.class : (LongProperty.class.isAssignableFrom(property.getClass()) ? Long.class : (ListProperty.class.isAssignableFrom(property.getClass()) ? List.class : (MapProperty.class.isAssignableFrom(property.getClass()) ? Map.class : Object.class)))))));
        }
        return clazz;
    }

    public void addFieldPathValueTypes(FieldPathValueType ... types) {
        this.fieldPathValueProperty.addRemoveTypes(true, types);
    }

    public void removeFieldPathValueTypes(FieldPathValueType ... types) {
        this.fieldPathValueProperty.addRemoveTypes(false, types);
    }

    public boolean hasFieldPathValueTypes(FieldPathValueType ... types) {
        return this.fieldPathValueProperty.hasTypes(types);
    }

    protected static class FieldHandle<T, F> {
        private static final Map<Class<?>, Class<?>> PRIMS = new HashMap();
        private static final Map<Class<?>, Object> DFLTS;
        private final String fieldName;
        private MethodHandle accessor;
        private MethodHandle setter;
        private final Class<F> declaredFieldType;
        private T target;
        private boolean hasDefaultDerived;

        protected FieldHandle(T target, String fieldName, Class<F> declaredFieldType) {
            this.fieldName = fieldName;
            this.declaredFieldType = declaredFieldType;
            this.target = target;
            this.updateMethodHandles();
        }

        protected void updateMethodHandles() {
            this.accessor = FieldHandle.buildAccessorWithLikelyPrefixes(this.getTarget(), this.getFieldName());
            this.setter = FieldHandle.buildSetter(this.getAccessor(), this.getTarget(), this.getFieldName());
        }

        public static Class<?> getAccessorType(Object target, String fieldName) {
            return FieldHandle.buildAccessorWithLikelyPrefixes(target, fieldName).type().returnType();
        }

        protected static MethodHandle buildAccessorWithLikelyPrefixes(Object target, String fieldName) {
            MethodHandle mh = FieldHandle.buildAccessor(target, fieldName, "get", "is", "has", "use");
            if (mh == null) {
                throw new IllegalArgumentException(fieldName + " on " + target);
            }
            return mh;
        }

        protected static MethodHandle buildAccessor(Object target, String fieldName, String ... fieldNamePrefix) {
            String accessorName = FieldHandle.buildMethodName(fieldNamePrefix[0], fieldName);
            try {
                return MethodHandles.lookup().findVirtual(target.getClass(), accessorName, MethodType.methodType(target.getClass().getMethod(accessorName, new Class[0]).getReturnType())).bindTo(target);
            }
            catch (NoSuchMethodException e) {
                return fieldNamePrefix.length <= 1 ? null : FieldHandle.buildAccessor(target, fieldName, Arrays.copyOfRange(fieldNamePrefix, 1, fieldNamePrefix.length));
            }
            catch (Throwable t) {
                throw new IllegalArgumentException("Unable to resolve accessor " + accessorName, t);
            }
        }

        protected static MethodHandle buildSetter(MethodHandle accessor, Object target, String fieldName) {
            try {
                MethodHandle mh1 = MethodHandles.lookup().findVirtual(target.getClass(), FieldHandle.buildMethodName("set", fieldName), MethodType.methodType(Void.TYPE, accessor.type().returnType())).bindTo(target);
                return mh1;
            }
            catch (Throwable t) {
                throw new IllegalArgumentException("Unable to resolve setter " + fieldName, t);
            }
        }

        public F valueOf(String value) {
            return FieldHandle.valueOf(this.getDeclaredFieldType(), value);
        }

        public static <VT> VT valueOf(Class<VT> valueOfClass, Object value) {
            if (value != null && String.class.isAssignableFrom(valueOfClass)) {
                return (VT)value.toString();
            }
            Class<VT> clazz = PRIMS.containsKey(valueOfClass) ? PRIMS.get(valueOfClass) : valueOfClass;
            MethodHandle mh1 = null;
            try {
                mh1 = MethodHandles.lookup().findStatic(clazz, "valueOf", MethodType.methodType(clazz, String.class));
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (mh1 != null) {
                try {
                    return (VT)mh1.invoke(value);
                }
                catch (Throwable t) {
                    throw new IllegalArgumentException(String.format("Unable to invoke valueOf on %1$s using %2$s", value, valueOfClass), t);
                }
            }
            return null;
        }

        public static boolean hasDefault(Class<?> clazz) {
            return clazz == null ? false : DFLTS.containsKey(clazz);
        }

        public F defaultValue() {
            return FieldHandle.defaultValue(this.getDeclaredFieldType());
        }

        public static <VT> VT defaultValue(Class<VT> clazz) {
            return (VT)(DFLTS.containsKey(clazz) ? DFLTS.get(clazz) : null);
        }

        protected static String buildMethodName(String prefix, String fieldName) {
            return fieldName.startsWith(prefix) ? fieldName : prefix + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
        }

        public F setDerivedValueFromAccessor() {
            F derived = null;
            try {
                derived = this.deriveValueFromAccessor();
                this.getSetter().invoke(derived);
            }
            catch (Throwable t) {
                throw new RuntimeException(String.format("Unable to set %1$s on %2$s", derived, this.getTarget()), t);
            }
            return derived;
        }

        protected F deriveValueFromAccessor() {
            Cloneable targetValue = null;
            try {
                targetValue = this.getAccessor().invoke();
            }
            catch (Throwable t) {
                targetValue = null;
            }
            if (targetValue == null) {
                try {
                    if (DFLTS.containsKey(this.getFieldType())) {
                        targetValue = DFLTS.get(this.getFieldType());
                    } else {
                        TypeDescriptor.OfField clazz = this.getAccessor().type().returnType();
                        if (List.class.isAssignableFrom((Class<?>)clazz)) {
                            targetValue = new ArrayList();
                        } else if (Set.class.isAssignableFrom((Class<?>)clazz)) {
                            targetValue = new LinkedHashSet();
                        } else if (Map.class.isAssignableFrom((Class<?>)clazz)) {
                            targetValue = new HashMap();
                        } else if (!Calendar.class.isAssignableFrom(this.getFieldType()) && !String.class.isAssignableFrom(this.getFieldType())) {
                            targetValue = ((Class)clazz).newInstance();
                        }
                    }
                    this.hasDefaultDerived = true;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(String.format("Unable to get accessor return instance for %1$s using %2$s.", this.getAccessor(), this.getAccessor().type().returnType()));
                }
            } else {
                this.hasDefaultDerived = false;
            }
            return (F)targetValue;
        }

        public void setTarget(T target) {
            if (this.getTarget().equals(target)) {
                return;
            }
            this.target = target;
            this.updateMethodHandles();
        }

        public T getTarget() {
            return this.target;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        protected MethodHandle getAccessor() {
            return this.accessor;
        }

        protected MethodHandle getSetter() {
            return this.setter;
        }

        public Class<F> getDeclaredFieldType() {
            return this.declaredFieldType;
        }

        public Class<?> getFieldType() {
            return this.getAccessor().type().returnType();
        }

        public boolean hasDefaultDerived() {
            return this.hasDefaultDerived;
        }

        static {
            PRIMS.put(Boolean.TYPE, Boolean.class);
            PRIMS.put(Character.TYPE, Character.class);
            PRIMS.put(Double.TYPE, Double.class);
            PRIMS.put(Float.TYPE, Float.class);
            PRIMS.put(Long.TYPE, Long.class);
            PRIMS.put(Integer.TYPE, Integer.class);
            PRIMS.put(Short.TYPE, Short.class);
            PRIMS.put(Long.TYPE, Long.class);
            PRIMS.put(Byte.TYPE, Byte.class);
            DFLTS = new HashMap();
            DFLTS.put(Boolean.class, Boolean.FALSE);
            DFLTS.put(Boolean.TYPE, false);
            DFLTS.put(Byte.class, Byte.valueOf("0"));
            DFLTS.put(Byte.TYPE, (byte)Byte.valueOf("0"));
            DFLTS.put(Number.class, 0L);
            DFLTS.put(Short.class, Short.valueOf("0"));
            DFLTS.put(Short.TYPE, (short)Short.valueOf("0"));
            DFLTS.put(Character.class, Character.valueOf(' '));
            DFLTS.put(Character.TYPE, Character.valueOf(' '));
            DFLTS.put(Integer.class, 0);
            DFLTS.put(Integer.TYPE, 0);
            DFLTS.put(Long.class, 0L);
            DFLTS.put(Long.TYPE, 0L);
            DFLTS.put(Float.class, Float.valueOf(0.0f));
            DFLTS.put(Float.TYPE, Float.valueOf(0.0f));
            DFLTS.put(Double.class, 0.0);
            DFLTS.put(Double.TYPE, 0.0);
            DFLTS.put(BigInteger.class, BigInteger.valueOf(0L));
            DFLTS.put(BigDecimal.class, BigDecimal.valueOf(0.0));
        }
    }

    public static class FieldProperty<BT, T, PT>
    extends ObjectPropertyBase<PT>
    implements ListChangeListener<Object>,
    SetChangeListener<Object>,
    MapChangeListener<Object, Object>,
    ChangeListener<Object> {
        private final FieldPathValueProperty notifyProperty;
        private final ObjectProperty<DateFormat> dfp;
        private final String fullPath;
        private final FieldHandle<BT, T> fieldHandle;
        private boolean isDirty;
        private boolean isDirtyCollection;
        private boolean isCollectionListening;
        private final String collectionItemPath;
        private final WeakReference<Observable> collectionObservable;
        private final Class<?> collectionType;
        private final SelectionModel<Object> collectionSelectionModel;
        private final FieldProperty<?, ?, ?> itemMaster;

        protected FieldProperty(BT bean, String fullPath, String fieldName, FieldPathValueProperty notifyProperty, Class<T> declaredFieldType, String collectionItemPath, Observable collectionObservable, Class<?> collectionType, SelectionModel<?> collectionSelectionModel, FieldProperty<?, ?, ?> itemMaster, ObjectProperty<DateFormat> dfp) {
            this.dfp = dfp;
            this.fullPath = fullPath;
            this.notifyProperty = notifyProperty;
            this.fieldHandle = new FieldHandle<BT, BT>(bean, fieldName, declaredFieldType);
            this.itemMaster = itemMaster;
            this.collectionObservable = new WeakReference<Observable>(collectionObservable);
            this.collectionItemPath = collectionItemPath;
            this.collectionType = collectionType;
            this.collectionSelectionModel = collectionSelectionModel;
            if (this.collectionSelectionModel != null && this.itemMaster != null) {
                this.itemMaster.addListener(this);
            }
            this.setDerived();
        }

        public PT get() {
            try {
                Object dv = this.getDirty();
                if (dv != null && this.getDeclaredFieldType() != this.getFieldType()) {
                    return (PT)FieldStringConverter.coerceToString(dv, (DateFormat)this.dfp.get());
                }
                return (PT)dv;
            }
            catch (Throwable t) {
                throw new RuntimeException("Unable to get value", t);
            }
        }

        protected void setDerived() {
            T derived = this.fieldHandle.deriveValueFromAccessor();
            this.set(derived);
        }

        public void setDirty(Object v) {
            this.isDirty = true;
            this.set(v);
        }

        public void set(Object v) {
            try {
                Class<?> clazz;
                Object cv = this.fieldHandle.getAccessor().invoke();
                Class<?> clazz2 = clazz = cv != null ? cv.getClass() : this.fieldHandle.getFieldType();
                if (v != null && (Collection.class.isAssignableFrom(v.getClass()) || Map.class.isAssignableFrom(v.getClass()))) {
                    this.fieldHandle.getSetter().invoke(v);
                    this.postSet(cv);
                } else if (this.isDirty || cv != v) {
                    Object val = FieldStringConverter.coerce(v, clazz);
                    this.fieldHandle.getSetter().invoke(val);
                    this.postSet(cv);
                }
            }
            catch (Throwable t) {
                throw new IllegalArgumentException(String.format("Unable to set object value: %1$s on %2$s", v, this.fieldHandle.getFieldName()), t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void postSet(Object prevValue) throws Throwable {
            Boolean colChanged = this.populateObservableCollection();
            if (colChanged == null || colChanged.booleanValue()) {
                this.invalidated();
                this.fireValueChangedEvent();
            }
            try {
                Object cv;
                if (!this.isDirty && (this.fullPath.indexOf(35) < 0 || this.notifyProperty.hasTypes(FieldPathValueType.FIELD_CHANGE) && !this.hasFieldPathValueTypeAddOrRemove(true) && !this.hasFieldPathValueTypeAddOrRemove(false)) && ((cv = this.getDirty()) == null && prevValue != null || cv != null && !cv.equals(prevValue))) {
                    this.notifyProperty.set(new FieldPathValue(this.fullPath, this.getBean(), cv, FieldPathValueType.FIELD_CHANGE));
                }
            }
            finally {
                this.isDirty = false;
            }
        }

        private Boolean populateObservableCollection() throws Throwable {
            Observable oc = this.getCollectionObservable();
            Boolean changed = null;
            if (this.isList() || this.isSet()) {
                this.addRemoveCollectionListener(oc, false);
                LinkedHashSet items = (LinkedHashSet)this.getDirty();
                if (items == null) {
                    items = new LinkedHashSet();
                    this.fieldHandle.getSetter().invoke(items);
                }
                changed = this.syncCollectionValues(items, false, false, null, null, null);
            } else if (this.isMap()) {
                this.addRemoveCollectionListener(oc, false);
                HashMap items = (HashMap)this.getDirty();
                if (items == null) {
                    items = new HashMap();
                    this.fieldHandle.getSetter().invoke(items);
                }
                changed = this.syncCollectionValues(items, false, false, null, null, null);
            } else {
                return changed;
            }
            this.addRemoveCollectionListener(oc, true);
            return changed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean syncCollectionValues(Object values, boolean toField, boolean fromItemMasterChange, ListChangeListener.Change<?> listChange, SetChangeListener.Change<?> setChange, MapChangeListener.Change<?, ?> mapChange) {
            boolean changed = false;
            if (this.isDirtyCollection) {
                return changed;
            }
            if (this.collectionSelectionModel != null && this.itemMaster != null && this.itemMaster.isDirtyCollection && (listChange != null || setChange != null || mapChange != null)) {
                return changed;
            }
            try {
                Object oc;
                this.isDirtyCollection = true;
                if (this.collectionObservable.get() != null && Collection.class.isAssignableFrom(((Observable)this.collectionObservable.get()).getClass())) {
                    oc = (Collection)this.collectionObservable.get();
                    if (Collection.class.isAssignableFrom(values.getClass())) {
                        Collection col = (Collection)values;
                        if (toField) {
                            changed = this.syncCollectionValuesFromObservable((Collection<Object>)col, (Collection<Object>)oc);
                        } else {
                            boolean wasColEmpty = col.isEmpty();
                            if (this.collectionSelectionModel == null && (!wasColEmpty || this.isDirty)) {
                                oc.clear();
                                changed = true;
                            } else if (this.collectionSelectionModel == null) {
                                changed = this.syncCollectionValuesFromObservable((Collection<Object>)col, (Collection<Object>)oc);
                            }
                            if (!wasColEmpty) {
                                this.syncObservableFromCollectionValues((Collection<Object>)col, (Collection<Object>)oc);
                            }
                        }
                    } else if (Map.class.isAssignableFrom(values.getClass())) {
                        Map map = (Map)values;
                        if (toField) {
                            changed = this.syncCollectionValuesFromObservable((Map<Object, Object>)map, (Collection<Object>)oc);
                        } else {
                            boolean wasColEmpty = map.isEmpty();
                            if (this.collectionSelectionModel == null && (!wasColEmpty || this.isDirty)) {
                                oc.clear();
                                changed = true;
                            } else if (this.collectionSelectionModel == null) {
                                changed = this.syncCollectionValuesFromObservable((Map<Object, Object>)map, (Collection<Object>)oc);
                            }
                            if (!wasColEmpty) {
                                this.syncObservableFromCollectionValues((Map<Object, Object>)map, (Collection<Object>)oc);
                            }
                        }
                    }
                } else if (this.collectionObservable.get() instanceof ObservableMap) {
                    oc = (ObservableMap)this.collectionObservable.get();
                    if (Collection.class.isAssignableFrom(values.getClass())) {
                        Collection col = (Collection)values;
                        if (toField) {
                            changed = this.syncCollectionValuesFromObservable((Collection<Object>)col, (ObservableMap<Object, Object>)oc);
                        } else {
                            boolean wasColEmpty = col.isEmpty();
                            if (this.collectionSelectionModel == null && (!wasColEmpty || this.isDirty)) {
                                oc.clear();
                                changed = true;
                            } else if (this.collectionSelectionModel == null) {
                                changed = this.syncCollectionValuesFromObservable((Collection<Object>)col, (ObservableMap<Object, Object>)oc);
                            }
                            if (!wasColEmpty) {
                                this.syncObservableFromCollectionValues((Collection<Object>)col, (Map<Object, Object>)oc);
                            }
                        }
                    } else if (Map.class.isAssignableFrom(values.getClass())) {
                        Map map = (Map)values;
                        if (toField) {
                            changed = this.syncCollectionValuesFromObservable((Map<Object, Object>)map, (ObservableMap<Object, Object>)oc);
                        } else {
                            boolean wasColEmpty = map.isEmpty();
                            if (this.collectionSelectionModel == null && (!wasColEmpty || this.isDirty)) {
                                oc.clear();
                                changed = true;
                            } else if (this.collectionSelectionModel == null) {
                                changed = this.syncCollectionValuesFromObservable((Map<Object, Object>)map, (ObservableMap<Object, Object>)oc);
                            }
                            if (!wasColEmpty) {
                                this.syncObservableFromCollectionValues((Map<Object, Object>)map, (Map<Object, Object>)oc);
                            }
                        }
                    }
                }
                boolean bl = changed || listChange != null || setChange != null || mapChange != null;
                return bl;
            }
            finally {
                this.isDirtyCollection = false;
            }
        }

        private boolean syncObservableFromCollectionValues(Collection<Object> fromCol, Collection<Object> oc) {
            boolean changed = false;
            boolean missing = false;
            int i = -1;
            boolean isOcList = List.class.isAssignableFrom(oc.getClass());
            for (Object item : fromCol) {
                FieldProperty<?, ?, ?> fp = this.genFieldProperty(item, null);
                Object fpv = fp != null ? fp.getDirty() : item;
                missing = !oc.contains(fpv);
                boolean bl = changed = !changed ? missing : changed;
                if (this.collectionSelectionModel == null) {
                    if (isOcList) {
                        ((List)oc).add(++i, fpv);
                        continue;
                    }
                    oc.add(fpv);
                    continue;
                }
                this.selectCollectionValue(fpv);
            }
            return changed;
        }

        private boolean syncObservableFromCollectionValues(Collection<Object> fromCol, Map<Object, Object> oc) {
            boolean changed = false;
            boolean missing = false;
            int i = -1;
            for (Object item : fromCol) {
                FieldProperty<?, ?, ?> fp = this.genFieldProperty(item, null);
                Object fpv = fp != null ? fp.getDirty() : item;
                missing = !oc.containsValue(fpv);
                boolean bl = changed = !changed ? missing : changed;
                if (this.collectionSelectionModel == null) {
                    oc.put(++i, fpv);
                    continue;
                }
                this.selectCollectionValue(fpv);
            }
            return changed;
        }

        private boolean syncObservableFromCollectionValues(Map<Object, Object> fromMap, Collection<Object> oc) {
            boolean changed = false;
            boolean missing = false;
            int i = -1;
            boolean isOcList = List.class.isAssignableFrom(oc.getClass());
            for (Object item : fromMap.values()) {
                FieldProperty<?, ?, ?> fp = this.genFieldProperty(item, null);
                Object fpv = fp != null ? fp.getDirty() : item;
                missing = !oc.contains(fpv);
                boolean bl = changed = !changed ? missing : changed;
                if (this.collectionSelectionModel == null) {
                    if (isOcList) {
                        ((List)oc).add(++i, fpv);
                        continue;
                    }
                    oc.add(fpv);
                    continue;
                }
                this.selectCollectionValue(fpv);
            }
            return changed;
        }

        private boolean syncObservableFromCollectionValues(Map<Object, Object> fromMap, Map<Object, Object> oc) {
            boolean changed = false;
            boolean missing = false;
            int i = -1;
            for (Map.Entry<Object, Object> item : fromMap.entrySet()) {
                FieldProperty<?, ?, ?> fp = this.genFieldProperty(item.getValue(), null);
                Object fpv = fp != null ? fp.getDirty() : item.getValue();
                missing = !oc.containsValue(fpv);
                boolean bl = changed = !changed ? missing : changed;
                if (this.collectionSelectionModel == null) {
                    oc.put(++i, fpv);
                    continue;
                }
                this.selectCollectionValue(fpv);
            }
            return changed;
        }

        private void selectCollectionValue(Object value) {
            if (this.collectionSelectionModel == null) {
                return;
            }
            this.collectionSelectionModel.select(value);
        }

        private boolean syncCollectionValuesFromObservable(Collection<Object> toCol, Collection<Object> oc) {
            Object fpv;
            FieldProperty<?, ?, ?> fp;
            boolean changed = false;
            boolean missing = false;
            ArrayList<FieldPathValue> fvs = new ArrayList<FieldPathValue>();
            ArrayList<Object> nc = new ArrayList<Object>();
            for (Object item : oc) {
                if (item == null) continue;
                fp = this.genFieldProperty(null, item);
                fpv = fp == null ? item : fp.getBean();
                missing = !toCol.contains(fpv);
                changed = !changed ? missing : changed;
                nc.add(fpv);
                if (!missing || !this.hasFieldPathValueTypeAddOrRemove(true)) continue;
                fvs.add(this.newSyncCollectionFieldPathValue(fp, fpv, true));
            }
            if (this.hasFieldPathValueTypeAddOrRemove(false)) {
                for (Object item : toCol) {
                    if (nc.contains(item)) continue;
                    fp = this.genFieldProperty(item, null);
                    fpv = fp == null ? item : fp.getBean();
                    fvs.add(this.newSyncCollectionFieldPathValue(fp, fpv, false));
                }
            }
            toCol.clear();
            toCol.addAll(nc);
            this.setFieldPathValues(fvs);
            return changed;
        }

        private boolean syncCollectionValuesFromObservable(Map<Object, Object> toMap, Collection<Object> oc) {
            Object fpv;
            FieldProperty<?, ?, ?> fp;
            boolean changed = false;
            boolean missing = false;
            ArrayList<FieldPathValue> fvs = new ArrayList<FieldPathValue>();
            int i = -1;
            HashMap<Integer, Object> nc = new HashMap<Integer, Object>();
            for (Object item : oc) {
                if (item == null) continue;
                fp = this.genFieldProperty(null, item);
                fpv = fp == null ? item : fp.getBean();
                missing = !toMap.containsValue(fpv);
                changed = !changed ? missing : changed;
                nc.put(++i, fpv);
                if (!missing || !this.hasFieldPathValueTypeAddOrRemove(true)) continue;
                fvs.add(this.newSyncCollectionFieldPathValue(fp, fpv, true));
            }
            if (this.hasFieldPathValueTypeAddOrRemove(false)) {
                for (Object item : toMap.values()) {
                    if (nc.containsValue(item)) continue;
                    fp = this.genFieldProperty(item, null);
                    fpv = fp == null ? item : fp.getBean();
                    fvs.add(this.newSyncCollectionFieldPathValue(fp, fpv, false));
                }
            }
            toMap.clear();
            toMap.putAll(nc);
            this.setFieldPathValues(fvs);
            return changed;
        }

        private boolean syncCollectionValuesFromObservable(Collection<Object> toCol, ObservableMap<Object, Object> oc) {
            Object fpv;
            FieldProperty<?, ?, ?> fp;
            boolean changed = false;
            boolean missing = false;
            ArrayList<FieldPathValue> fvs = new ArrayList<FieldPathValue>();
            ArrayList nc = new ArrayList();
            for (Object item : oc.entrySet()) {
                if (item == null || item.getValue() == null) continue;
                fp = this.genFieldProperty(null, item.getValue());
                fpv = fp == null ? item.getValue() : fp.getBean();
                missing = !toCol.contains(fpv);
                changed = !changed ? missing : changed;
                nc.add(fpv);
                if (!missing || !this.hasFieldPathValueTypeAddOrRemove(true)) continue;
                fvs.add(this.newSyncCollectionFieldPathValue(fp, fpv, true));
            }
            if (this.hasFieldPathValueTypeAddOrRemove(false)) {
                for (Object item : toCol) {
                    if (nc.contains(item)) continue;
                    fp = this.genFieldProperty(item, null);
                    fpv = fp == null ? item : fp.getBean();
                    fvs.add(this.newSyncCollectionFieldPathValue(fp, fpv, false));
                }
            }
            toCol.clear();
            toCol.addAll(nc);
            this.setFieldPathValues(fvs);
            return changed;
        }

        private boolean syncCollectionValuesFromObservable(Map<Object, Object> toMap, ObservableMap<Object, Object> oc) {
            Object fpv;
            FieldProperty<?, ?, ?> fp;
            boolean changed = false;
            boolean missing = false;
            ArrayList<FieldPathValue> fvs = new ArrayList<FieldPathValue>();
            int i = -1;
            HashMap nc = new HashMap();
            for (Object item : oc.entrySet()) {
                if (item == null || item.getValue() == null) continue;
                fp = this.genFieldProperty(null, item.getValue());
                fpv = fp == null ? item.getValue() : fp.getBean();
                missing = !toMap.containsValue(fpv);
                changed = !changed ? missing : changed;
                nc.put(i, fpv);
                if (!missing || !this.hasFieldPathValueTypeAddOrRemove(true)) continue;
                fvs.add(this.newSyncCollectionFieldPathValue(fp, fpv, true));
            }
            if (this.hasFieldPathValueTypeAddOrRemove(false)) {
                for (Object item : toMap.values()) {
                    if (nc.containsValue(item)) continue;
                    fp = this.genFieldProperty(item, null);
                    fpv = fp == null ? item : fp.getBean();
                    fvs.add(this.newSyncCollectionFieldPathValue(fp, fpv, false));
                }
            }
            toMap.clear();
            toMap.putAll(nc);
            this.setFieldPathValues(fvs);
            return changed;
        }

        protected FieldPathValue newSyncCollectionFieldPathValue(FieldProperty<?, ?, ?> fp, Object fpv, boolean isAdd) {
            FieldPathValueType type;
            if (this.collectionSelectionModel != null) {
                type = isAdd ? FieldPathValueType.CONTENT_ITEM_ADD_SELECT : FieldPathValueType.CONTENT_ITEM_REMOVE_SELECT;
            } else {
                FieldPathValueType fieldPathValueType = type = isAdd ? FieldPathValueType.CONTENT_ITEM_ADD : FieldPathValueType.CONTENT_ITEM_REMOVE;
            }
            if (fp == null) {
                return new FieldPathValue(this.fullPath, this.getBean(), fpv, type);
            }
            return new FieldPathValue(fp.fullPath, fp.getBean(), fpv, type);
        }

        protected boolean hasFieldPathValueTypeAddOrRemove(boolean add) {
            return add && this.collectionSelectionModel != null && this.notifyProperty.hasTypes(FieldPathValueType.CONTENT_ITEM_ADD_SELECT) || add && this.collectionSelectionModel == null && this.notifyProperty.hasTypes(FieldPathValueType.CONTENT_ITEM_ADD) || !add && this.collectionSelectionModel != null && this.notifyProperty.hasTypes(FieldPathValueType.CONTENT_ITEM_REMOVE_SELECT) || !add && this.collectionSelectionModel == null && this.notifyProperty.hasTypes(FieldPathValueType.CONTENT_ITEM_REMOVE);
        }

        protected void setFieldPathValues(Collection<FieldPathValue> fieldPathValues) {
            if (this.notifyProperty != null) {
                for (FieldPathValue o : fieldPathValues) {
                    this.notifyProperty.set(o);
                }
            }
        }

        protected FieldProperty<?, ?, ?> genFieldProperty(Object itemBeanValue, Object itemBeanPropertyValue) {
            try {
                if (this.collectionItemPath == null || this.collectionItemPath.isEmpty()) {
                    return null;
                }
                if (itemBeanValue == null && itemBeanPropertyValue == null) {
                    throw new NullPointerException("Both itemBeanValue and itemBeanPropertyValue cannot be null");
                }
                Object value = itemBeanPropertyValue;
                Object bean = itemBeanValue == null ? this.collectionType.newInstance() : itemBeanValue;
                FieldProperty<?, ?, ?> fp = this.genCollectionFieldProperty(bean);
                if (value != null) {
                    fp.setDirty(value);
                } else {
                    value = fp.getDirty();
                }
                if (itemBeanPropertyValue != null) {
                    Object im;
                    Object object = im = this.itemMaster != null ? this.itemMaster.getDirty() : this.getDirty();
                    if (Collection.class.isAssignableFrom(im.getClass())) {
                        for (Object ib : (Collection)im) {
                            FieldProperty<?, ?, ?> imfp = this.genCollectionFieldProperty(ib);
                            if (imfp.getDirty() != value) continue;
                            return imfp;
                        }
                    } else if (Map.class.isAssignableFrom(im.getClass())) {
                        for (Map.Entry ib : ((Map)im).entrySet()) {
                            FieldProperty<?, ?, ?> imfp = this.genCollectionFieldProperty(ib.getValue());
                            if (imfp.getDirty() != value) continue;
                            return imfp;
                        }
                    }
                }
                return fp;
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new UnsupportedOperationException(String.format("Cannot create collection item bean using %1$s", this.collectionType), e);
            }
        }

        protected FieldProperty<?, ?, ?> genCollectionFieldProperty(Object bean) {
            FieldBean fb = new FieldBean(null, bean, null, this.notifyProperty, this.dfp);
            FieldProperty<?, ?, ?> fp = fb.performOperation(this.fullPath + '#' + this.collectionItemPath, this.collectionItemPath, Object.class, null, null, null, this.collectionSelectionModel, null, FieldBeanOperation.CREATE_OR_FIND);
            return fp;
        }

        protected Object updateCollectionItemProperty(Object itemBeanPropertyValue) {
            FieldProperty<?, ?, ?> fp = this.genFieldProperty(null, itemBeanPropertyValue);
            return fp == null ? itemBeanPropertyValue : fp.getBean();
        }

        protected void addRemoveCollectionListener(Observable observable, boolean add) {
            boolean isCol;
            boolean bl = isCol = this.getCollectionObservable() == observable;
            if (isCol && (this.isCollectionListening && add || this.isCollectionListening && !add)) {
                return;
            }
            Boolean change = null;
            if (observable instanceof ObservableList) {
                ObservableList ol = (ObservableList)observable;
                if (add) {
                    ol.addListener((ListChangeListener)this);
                    change = true;
                } else {
                    ol.removeListener((ListChangeListener)this);
                    change = false;
                }
            } else if (observable instanceof ObservableSet) {
                ObservableSet os = (ObservableSet)observable;
                if (add) {
                    os.addListener((SetChangeListener)this);
                    change = true;
                } else {
                    os.removeListener((SetChangeListener)this);
                    change = false;
                }
            } else if (observable instanceof ObservableMap) {
                ObservableMap om = (ObservableMap)observable;
                if (add) {
                    om.addListener((MapChangeListener)this);
                    change = true;
                } else {
                    om.removeListener((MapChangeListener)this);
                    change = false;
                }
            } else {
                if (observable == null) {
                    throw new IllegalStateException(String.format("Observable collection/map bound to %1$s (item path: %2$s) has been garbage collected", this.fieldHandle.getFieldName(), this.collectionItemPath, observable, this.getFieldType()));
                }
                throw new UnsupportedOperationException(String.format("%1$s (item path: %2$s) of type \"%4$s\" must be bound to a supported observable collection/map type... Found observable: %3$s", this.fieldHandle.getFieldName(), this.collectionItemPath, observable, this.getFieldType()));
            }
            if (isCol && change != null) {
                this.isCollectionListening = change;
            }
        }

        public void changed(ObservableValue<? extends Object> observable, Object oldValue, Object newValue) {
            this.syncCollectionValues(this.getDirty(), false, true, null, null, null);
        }

        public final void onChanged(ListChangeListener.Change<? extends Object> change) {
            this.syncCollectionValues(this.getDirty(), true, false, change, null, null);
        }

        public final void onChanged(SetChangeListener.Change<? extends Object> change) {
            this.syncCollectionValues(this.getDirty(), true, false, null, change, null);
        }

        public final void onChanged(MapChangeListener.Change<? extends Object, ? extends Object> change) {
            this.syncCollectionValues(this.getDirty(), true, false, null, null, change);
        }

        public Object getDirty() {
            try {
                return this.fieldHandle.getAccessor().invoke();
            }
            catch (Throwable t) {
                throw new RuntimeException("Unable to get dirty value", t);
            }
        }

        protected void setTarget(BT bean) {
            this.isDirty = true;
            this.fieldHandle.setTarget(bean);
            this.setDerived();
        }

        public BT getBean() {
            return this.fieldHandle.getTarget();
        }

        public String getName() {
            return this.fieldHandle.getFieldName();
        }

        public Class<T> getFieldType() {
            return this.fieldHandle.getFieldType();
        }

        public Class<?> getDeclaredFieldType() {
            return this.fieldHandle.getDeclaredFieldType();
        }

        protected boolean hasDefaultDerived() {
            return this.fieldHandle.hasDefaultDerived();
        }

        public boolean isList() {
            return List.class.isAssignableFrom(this.fieldHandle.getFieldType());
        }

        public boolean isSet() {
            return Set.class.isAssignableFrom(this.fieldHandle.getFieldType());
        }

        public boolean isMap() {
            return Map.class.isAssignableFrom(this.fieldHandle.getFieldType());
        }

        protected boolean isObservableList() {
            return FieldProperty.isObservableList(this.getCollectionObservable());
        }

        protected boolean isObservableSet() {
            return FieldProperty.isObservableSet(this.getCollectionObservable());
        }

        protected boolean isObservableMap() {
            return FieldProperty.isObservableMap(this.getCollectionObservable());
        }

        protected static boolean isObservableList(Observable observable) {
            return observable != null && ObservableList.class.isAssignableFrom(observable.getClass());
        }

        protected static boolean isObservableSet(Observable observable) {
            return observable != null && ObservableSet.class.isAssignableFrom(observable.getClass());
        }

        protected static boolean isObservableMap(Observable observable) {
            return observable != null && ObservableMap.class.isAssignableFrom(observable.getClass());
        }

        protected FieldProperty<Object, ?, ?> extractCollectionItemFieldProperty(FieldBean<Void, Object> fieldBean) {
            String[] cip = this.collectionItemPath.split("\\.");
            return fieldBean.getFieldProperty(cip[cip.length - 1]);
        }

        public boolean hasCollectionItemPath() {
            return this.collectionItemPath != null && !this.collectionItemPath.isEmpty();
        }

        public String getCollectionItemPath() {
            return this.collectionItemPath;
        }

        protected SelectionModel<Object> getCollectionSelectionModel() {
            return this.collectionSelectionModel;
        }

        protected Observable getCollectionObservable() {
            return (Observable)this.collectionObservable.get();
        }

        public boolean hasItemMaster() {
            return this.itemMaster != null;
        }
    }

    protected static class FieldStringConverter<T>
    extends StringConverter<T> {
        private final ObjectProperty<DateFormat> dfp;
        private final Class<T> targetClass;

        public FieldStringConverter(Class<T> targetClass, ObjectProperty<DateFormat> dfp) {
            this.dfp = dfp;
            this.targetClass = targetClass;
        }

        public T fromString(String string) {
            return FieldStringConverter.coerce(string, this.targetClass);
        }

        public String toString(T object) {
            return FieldStringConverter.coerceToString(object, (DateFormat)this.dfp.get());
        }

        public Class<T> getTargetClass() {
            return this.targetClass;
        }

        public static <VT> String coerceToString(VT v, DateFormat df) {
            String cv = null;
            if (v != null && SelectionModel.class.isAssignableFrom(v.getClass())) {
                cv = ((SelectionModel)v).getSelectedItem() != null ? ((SelectionModel)v).getSelectedItem().toString() : null;
            } else if (v != null && (Calendar.class.isAssignableFrom(v.getClass()) || Date.class.isAssignableFrom(v.getClass()))) {
                Date date = Date.class.isAssignableFrom(v.getClass()) ? (Date)v : ((Calendar)v).getTime();
                cv = df.format(date);
            } else if (v != null) {
                cv = v.toString();
            }
            return cv;
        }

        public static <VT> VT coerce(Object v, Class<VT> targetClass) {
            Object val;
            if (targetClass == Object.class) {
                return (VT)v;
            }
            boolean isStringType = targetClass.equals(String.class);
            if (v == null || !isStringType && v.toString() != null && v.toString().isEmpty()) {
                val = FieldHandle.defaultValue(targetClass);
            } else if (isStringType || v != null && targetClass.isAssignableFrom(v.getClass())) {
                val = targetClass.cast(v);
            } else if (v != null && Date.class.isAssignableFrom(targetClass)) {
                if (Calendar.class.isAssignableFrom(v.getClass())) {
                    val = ((Calendar)v).getTime();
                } else {
                    try {
                        val = SDF.parse(v.toString());
                    }
                    catch (Throwable t) {
                        throw new IllegalArgumentException(String.format("Unable to convert %1$s to %2$s", v, targetClass), t);
                    }
                }
            } else if (v != null && Calendar.class.isAssignableFrom(targetClass)) {
                Calendar cal = Calendar.getInstance();
                Date date = null;
                try {
                    date = Date.class.isAssignableFrom(v.getClass()) ? (Date)v : SDF.parse(v.toString());
                    cal.setTime(date);
                    val = cal;
                }
                catch (Throwable t) {
                    throw new IllegalArgumentException(String.format("Unable to convert %1$s to %2$s", v, targetClass), t);
                }
            } else {
                val = FieldHandle.valueOf(targetClass, v.toString());
            }
            return val;
        }
    }

    protected static class FieldBean<PT, BT>
    implements Serializable {
        private static final long serialVersionUID = 7397535724568852021L;
        private final FieldPathValueProperty notifyProperty;
        private final ObjectProperty<DateFormat> dfp;
        private final Map<String, FieldBean<BT, ?>> fieldBeans = new HashMap();
        private final Map<String, FieldProperty<BT, ?, ?>> fieldProperties = new HashMap();
        private final Map<String, FieldProperty<BT, ?, ?>> fieldSelectionProperties = new HashMap();
        private final Map<Class<?>, FieldStringConverter<?>> stringConverters = new HashMap();
        private FieldHandle<PT, BT> fieldHandle;
        private final FieldBean<?, PT> parent;
        private BT bean;

        protected FieldBean(FieldBean<?, PT> parent, FieldHandle<PT, BT> fieldHandle, FieldPathValueProperty notifyProperty, ObjectProperty<DateFormat> dfp) {
            this.parent = parent;
            this.fieldHandle = fieldHandle;
            this.bean = this.fieldHandle.setDerivedValueFromAccessor();
            this.notifyProperty = notifyProperty;
            this.dfp = dfp;
            if (this.getParent() != null) {
                this.getParent().addFieldBean(this);
            }
        }

        protected FieldBean(FieldBean<?, PT> parent, BT bean, String fieldName, FieldPathValueProperty notifyProperty, ObjectProperty<DateFormat> dfp) {
            if (bean == null) {
                throw new NullPointerException("Bean cannot be null");
            }
            this.parent = parent;
            this.bean = bean;
            this.notifyProperty = notifyProperty;
            this.dfp = dfp;
            FieldHandle<PT, BT> fieldHandle = this.fieldHandle = this.getParent() != null ? this.createFieldHandle(this.getParent().getBean(), bean, fieldName) : null;
            if (this.getParent() != null) {
                this.getParent().addFieldBean(this);
            }
        }

        protected FieldHandle<PT, BT> createFieldHandle(PT parentBean, BT bean, String fieldName) {
            return new FieldHandle(parentBean, fieldName, this.getBean().getClass());
        }

        public BT getBean() {
            return this.bean;
        }

        protected void addFieldBean(FieldBean<BT, ?> fieldBean) {
            if (!this.getFieldBeans().containsKey(fieldBean.getFieldName())) {
                this.getFieldBeans().put(fieldBean.getFieldName(), fieldBean);
            }
        }

        protected void addOrUpdateFieldProperty(FieldProperty<BT, ?, ?> fieldProperty) {
            String pkey = fieldProperty.getName();
            if (this.getFieldProperties().containsKey(pkey)) {
                this.getFieldProperties().get(pkey).setTarget(fieldProperty.getBean());
            } else if (this.getFieldSelectionProperties().containsKey(pkey)) {
                this.getFieldSelectionProperties().get(pkey).setTarget(fieldProperty.getBean());
            } else if (fieldProperty.hasItemMaster()) {
                this.getFieldSelectionProperties().put(pkey, fieldProperty);
            } else {
                this.getFieldProperties().put(pkey, fieldProperty);
            }
        }

        public void setBean(BT bean) {
            if (bean == null) {
                throw new NullPointerException("Bean cannot be null");
            }
            this.bean = bean;
            for (Map.Entry<String, FieldBean<BT, ?>> entry : this.getFieldBeans().entrySet()) {
                entry.getValue().setParentBean(this.getBean());
            }
            for (Map.Entry<String, Object> entry : this.getFieldSelectionProperties().entrySet()) {
                ((FieldProperty)((Object)entry.getValue())).setTarget(this.getBean());
            }
            for (Map.Entry<String, Object> entry : this.getFieldProperties().entrySet()) {
                ((FieldProperty)((Object)entry.getValue())).setTarget(this.getBean());
            }
        }

        public void setParentBean(PT bean) {
            if (bean == null) {
                throw new NullPointerException("Cannot bind to a null bean");
            }
            if (this.fieldHandle == null) {
                throw new IllegalStateException("Cannot bind to a root " + FieldBean.class.getSimpleName());
            }
            this.fieldHandle.setTarget(bean);
            this.setBean(this.fieldHandle.setDerivedValueFromAccessor());
        }

        public <T> FieldProperty<?, ?, ?> performOperation(String fieldPath, Property<T> property, Class<T> propertyValueClass, FieldBeanOperation operation) {
            return this.performOperation(fieldPath, fieldPath, propertyValueClass, null, (Observable)property, null, null, null, operation);
        }

        public <T> FieldProperty<?, ?, ?> performOperation(String fieldPath, ObservableList<T> observableList, Class<T> listValueClass, String collectionItemPath, Class<?> collectionItemPathType, SelectionModel<T> selectionModel, FieldProperty<?, ?, ?> itemMaster, FieldBeanOperation operation) {
            return this.performOperation(fieldPath, fieldPath, listValueClass, collectionItemPath, (Observable)observableList, collectionItemPathType, selectionModel, itemMaster, operation);
        }

        public <T> FieldProperty<?, ?, ?> performOperation(String fieldPath, ObservableSet<T> observableSet, Class<T> setValueClass, String collectionItemPath, Class<?> collectionItemPathType, SelectionModel<T> selectionModel, FieldProperty<?, ?, ?> itemMaster, FieldBeanOperation operation) {
            return this.performOperation(fieldPath, fieldPath, setValueClass, collectionItemPath, (Observable)observableSet, collectionItemPathType, selectionModel, itemMaster, operation);
        }

        public <K, V> FieldProperty<?, ?, ?> performOperation(String fieldPath, ObservableMap<K, V> observableMap, Class<V> mapValueClass, String collectionItemPath, Class<?> collectionItemPathType, SelectionModel<V> selectionModel, FieldProperty<?, ?, ?> itemMaster, FieldBeanOperation operation) {
            return this.performOperation(fieldPath, fieldPath, mapValueClass, collectionItemPath, (Observable)observableMap, collectionItemPathType, (SelectionModel)selectionModel, itemMaster, operation);
        }

        protected <T> FieldProperty<?, ?, ?> performOperation(String fullFieldPath, String fieldPath, Class<T> propertyValueClass, String collectionItemPath, Observable observable, Class<?> collectionItemType, SelectionModel<T> selectionModel, FieldProperty<?, ?, ?> itemMaster, FieldBeanOperation operation) {
            boolean isFieldSelProp;
            String[] fieldNames = fieldPath.split("\\.");
            boolean isField = fieldNames.length == 1;
            String pkey = isField ? fieldNames[0] : "";
            boolean isFieldProp = isField && this.getFieldProperties().containsKey(pkey);
            boolean bl = isFieldSelProp = isField && !isFieldProp && this.getFieldSelectionProperties().containsKey(pkey);
            if (isFieldProp || isFieldSelProp) {
                FieldProperty<BT, ?, ?> fp = isFieldSelProp ? this.getFieldSelectionProperties().get(pkey) : this.getFieldProperties().get(pkey);
                this.performOperation(fp, observable, propertyValueClass, operation);
                return fp;
            }
            if (!isField && this.getFieldBeans().containsKey(fieldNames[0])) {
                String nextFieldPath = fieldPath.replaceFirst(fieldNames[0] + '.', "");
                return this.getFieldBeans().get(fieldNames[0]).performOperation(fullFieldPath, nextFieldPath, propertyValueClass, collectionItemPath, observable, collectionItemType, selectionModel, itemMaster, operation);
            }
            if (operation != FieldBeanOperation.UNBIND) {
                if (isField) {
                    Class<?> fieldClass = FieldHandle.getAccessorType(this.getBean(), fieldNames[0]);
                    FieldProperty childProp = new FieldProperty(this.getBean(), fullFieldPath, fieldNames[0], this.notifyProperty, propertyValueClass == fieldClass ? fieldClass : Object.class, collectionItemPath, observable, collectionItemType, selectionModel, itemMaster, this.dfp);
                    this.addOrUpdateFieldProperty(childProp);
                    return this.performOperation(fullFieldPath, fieldNames[0], propertyValueClass, collectionItemPath, observable, collectionItemType, selectionModel, itemMaster, operation);
                }
                FieldHandle<BT, Object> pfh = new FieldHandle<BT, Object>(this.getBean(), fieldNames[0], Object.class);
                FieldBean<BT, Object> childBean = new FieldBean<BT, Object>(this, pfh, this.notifyProperty, this.dfp);
                String nextFieldPath = fieldPath.substring(fieldPath.indexOf(fieldNames[1]));
                return childBean.performOperation(fullFieldPath, nextFieldPath, propertyValueClass, collectionItemPath, observable, collectionItemType, selectionModel, itemMaster, operation);
            }
            return null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected <T> void performOperation(FieldProperty<BT, ?, ?> fp, Observable observable, Class<T> observableValueClass, FieldBeanOperation operation) {
            if (operation == FieldBeanOperation.CREATE_OR_FIND) {
                return;
            }
            Object val = fp.getDirty();
            if (Property.class.isAssignableFrom(observable.getClass())) {
                if (operation == FieldBeanOperation.UNBIND) {
                    Bindings.unbindBidirectional(fp, (Property)((Property)observable));
                } else if (operation == FieldBeanOperation.BIND) {
                    if (fp.getFieldType() == fp.getDeclaredFieldType()) {
                        Bindings.bindBidirectional(fp, (Property)((Property)observable));
                    } else {
                        Bindings.bindBidirectional(fp, (Property)((Property)observable), this.getFieldStringConverter(observableValueClass));
                    }
                }
            } else if (fp.getCollectionObservable() != null && observable != null && fp.getCollectionObservable() != observable) {
                if (operation == FieldBeanOperation.UNBIND) {
                    Bindings.unbindContentBidirectional((Object)fp.getCollectionObservable(), (Object)observable);
                } else if (operation == FieldBeanOperation.BIND) {
                    if (FieldProperty.isObservableList(observable) && fp.isObservableList()) {
                        Bindings.bindContentBidirectional((ObservableList)((ObservableList)observable), (ObservableList)((ObservableList)fp.getCollectionObservable()));
                    } else if (FieldProperty.isObservableSet(observable) && fp.isObservableSet()) {
                        Bindings.bindContentBidirectional((ObservableSet)((ObservableSet)observable), (ObservableSet)((ObservableSet)fp.getCollectionObservable()));
                    } else {
                        if (!FieldProperty.isObservableMap(observable) || !fp.isObservableMap()) throw new UnsupportedOperationException(String.format("Incompatible observable collection/map types cannot be bound %1$s and %2$s", fp.getCollectionObservable(), observable));
                        Bindings.bindContentBidirectional((ObservableMap)((ObservableMap)observable), (ObservableMap)((ObservableMap)fp.getCollectionObservable()));
                    }
                }
            } else if (operation == FieldBeanOperation.UNBIND) {
                fp.set(null);
            }
            Object currVal = fp.getDirty();
            if (val == null || val.toString() == null || val.toString().isEmpty() || val.equals(currVal) || fp.hasDefaultDerived()) return;
            fp.setDirty(val);
        }

        public String getFieldName() {
            return this.fieldHandle != null ? this.fieldHandle.getFieldName() : null;
        }

        public FieldBean<?, PT> getParent() {
            return this.parent;
        }

        protected Map<String, FieldBean<BT, ?>> getFieldBeans() {
            return this.fieldBeans;
        }

        protected Map<String, FieldProperty<BT, ?, ?>> getFieldProperties() {
            return this.fieldProperties;
        }

        protected Map<String, FieldProperty<BT, ?, ?>> getFieldSelectionProperties() {
            return this.fieldSelectionProperties;
        }

        public FieldProperty<BT, ?, ?> getFieldProperty(String proptertyName) {
            if (this.getFieldProperties().containsKey(proptertyName)) {
                return this.getFieldProperties().get(proptertyName);
            }
            if (this.getFieldSelectionProperties().containsKey(proptertyName)) {
                return this.getFieldSelectionProperties().get(proptertyName);
            }
            return null;
        }

        public <FCT, SMT> FieldStringConverter<FCT> getFieldStringConverter(Class<FCT> targetClass) {
            if (this.stringConverters.containsKey(targetClass)) {
                return this.stringConverters.get(targetClass);
            }
            FieldStringConverter<FCT> fsc = new FieldStringConverter<FCT>(targetClass, this.dfp);
            this.stringConverters.put(targetClass, fsc);
            return fsc;
        }
    }

    public static enum FieldBeanOperation {
        BIND,
        UNBIND,
        CREATE_OR_FIND;

    }

    public static enum FieldPathValueType {
        BEAN_CHANGE,
        FIELD_CHANGE,
        CONTENT_ITEM_ADD,
        CONTENT_ITEM_REMOVE,
        CONTENT_ITEM_ADD_SELECT,
        CONTENT_ITEM_REMOVE_SELECT;

    }

    public static class FieldPathValue {
        private final String path;
        private final Object bean;
        private final Object value;
        private final FieldPathValueType type;

        public FieldPathValue(String path, Object bean, Object value, FieldPathValueType type) {
            this.path = path;
            this.bean = bean;
            this.value = value;
            this.type = type;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.bean == null ? 0 : this.bean.hashCode());
            result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FieldPathValue other = (FieldPathValue)obj;
            if (this.bean == null ? other.bean != null : !this.bean.equals(other.bean)) {
                return false;
            }
            if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
                return false;
            }
            if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
                return false;
            }
            return this.type == other.type;
        }

        public String toString() {
            return FieldPathValue.class.getSimpleName() + " [path=" + this.path + ", value=" + this.value + ", type=" + (Object)((Object)this.type) + ", bean=" + this.bean + "]";
        }

        public String getPath() {
            return this.path;
        }

        public Object getBean() {
            return this.bean;
        }

        public Object getValue() {
            return this.value;
        }

        public FieldPathValueType getType() {
            return this.type;
        }
    }

    static class FieldPathValueProperty
    extends ReadOnlyObjectWrapper<FieldPathValue> {
        private final Set<FieldPathValueType> types = new HashSet<FieldPathValueType>();

        public FieldPathValueProperty() {
            this.addRemoveTypes(true, FieldPathValueType.values());
        }

        public void addRemoveTypes(boolean add, FieldPathValueType ... types) {
            if (types.length <= 0) {
                return;
            }
            if (add) {
                Collections.addAll(this.types, types);
            } else {
                for (FieldPathValueType t : types) {
                    this.types.remove((Object)t);
                }
            }
        }

        public boolean hasTypes(FieldPathValueType ... types) {
            if (types.length <= 0) {
                return false;
            }
            for (FieldPathValueType type : types) {
                if (this.types.contains((Object)type)) continue;
                return false;
            }
            return true;
        }
    }
}

