/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.scene.control;

import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.HashMap;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.util.Builder;
import jfxtras.labs.scene.control.BigDecimalField;

public class BigDecimalFieldBuilder<B extends BigDecimalFieldBuilder<B>>
implements Builder<BigDecimalField> {
    private static final String NUMBER = "number";
    private static final String NUMBER_FORMAT = "numberFormat";
    private static final String STEPWIDTH = "stepwidth";
    private static final String PROMPT_TEXT = "promptText";
    private static final String MIN_VALUE = "minValue";
    private static final String MAX_VALUE = "maxValue";
    private HashMap<String, Property> properties = new HashMap();

    protected BigDecimalFieldBuilder() {
    }

    public static final BigDecimalFieldBuilder create() {
        return new BigDecimalFieldBuilder();
    }

    public final BigDecimalFieldBuilder number(BigDecimal number) {
        this.properties.put(NUMBER, (Property)new SimpleObjectProperty((Object)number));
        return this;
    }

    public final BigDecimalFieldBuilder format(NumberFormat numberFormat) {
        this.properties.put(NUMBER_FORMAT, (Property)new SimpleObjectProperty((Object)numberFormat));
        return this;
    }

    public final BigDecimalFieldBuilder stepwidth(BigDecimal stepwidth) {
        this.properties.put(STEPWIDTH, (Property)new SimpleObjectProperty((Object)stepwidth));
        return this;
    }

    public final BigDecimalFieldBuilder promptText(String promptText) {
        this.properties.put(PROMPT_TEXT, (Property)new SimpleStringProperty(promptText));
        return this;
    }

    public final BigDecimalFieldBuilder minValue(BigDecimal minValue) {
        this.properties.put(MIN_VALUE, (Property)new SimpleObjectProperty((Object)minValue));
        return this;
    }

    public final BigDecimalFieldBuilder maxValue(BigDecimal maxValue) {
        this.properties.put(MAX_VALUE, (Property)new SimpleObjectProperty((Object)maxValue));
        return this;
    }

    public BigDecimalField build() {
        BigDecimalField CONTROL = new BigDecimalField();
        for (String key : this.properties.keySet()) {
            if (MAX_VALUE.equals(key)) {
                CONTROL.setMaxValue((BigDecimal)((SimpleObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if (MIN_VALUE.equals(key)) {
                CONTROL.setMinValue((BigDecimal)((SimpleObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if (NUMBER.equals(key)) {
                CONTROL.setNumber((BigDecimal)((SimpleObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if (NUMBER_FORMAT.equals(key)) {
                CONTROL.setFormat((NumberFormat)((SimpleObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if (PROMPT_TEXT.equals(key)) {
                CONTROL.setPromptText(((SimpleStringProperty)this.properties.get(key)).get());
                continue;
            }
            if (!STEPWIDTH.equals(key)) continue;
            CONTROL.setStepwidth((BigDecimal)((SimpleObjectProperty)this.properties.get(key)).get());
        }
        return CONTROL;
    }
}

