/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.scene.control;

import java.text.DateFormat;
import java.util.Calendar;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.Label;

public class CalendarLabel
extends Label {
    private final ObjectProperty<Calendar> value = new SimpleObjectProperty();
    private final ObjectProperty<DateFormat> format = new SimpleObjectProperty();

    public final Calendar getValue() {
        return (Calendar)this.value.get();
    }

    public final void setValue(Calendar value) {
        this.value.set((Object)value);
    }

    public ObjectProperty<Calendar> valueProperty() {
        return this.value;
    }

    public DateFormat getFormat() {
        return (DateFormat)this.format.getValue();
    }

    public final void setFormat(DateFormat value) {
        this.format.set((Object)value);
    }

    public ObjectProperty<DateFormat> formatProperty() {
        return this.format;
    }

    public CalendarLabel() {
        this(null);
    }

    public CalendarLabel(Calendar value) {
        this(value, DateFormat.getDateInstance());
    }

    public CalendarLabel(Calendar value, DateFormat df) {
        this.setFormat(df);
        this.initHandlers();
        this.setValue(value);
    }

    private void initHandlers() {
        this.valueProperty().addListener((ChangeListener)new ChangeListener<Calendar>(){

            public void changed(ObservableValue<? extends Calendar> observable, Calendar oldValue, Calendar newValue) {
                if (null != CalendarLabel.this.getValue()) {
                    CalendarLabel.this.setText(CalendarLabel.this.getFormat().format(CalendarLabel.this.getValue().getTime()));
                }
            }
        });
        this.formatProperty().addListener((ChangeListener)new ChangeListener<DateFormat>(){

            public void changed(ObservableValue<? extends DateFormat> observable, DateFormat olValue, DateFormat newValue) {
                if (null != CalendarLabel.this.getValue()) {
                    CalendarLabel.this.setText(CalendarLabel.this.getFormattedString());
                }
            }
        });
    }

    private String getFormattedString() {
        if (this.getValue() == null || this.getFormat() == null) {
            return null;
        }
        try {
            String formattedString = this.getFormat().format(this.getValue().getTime());
            return formattedString;
        }
        catch (Exception e) {
            this.setText("n/a");
            e.printStackTrace();
            return null;
        }
    }
}

