/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.scene.control;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.control.Control;
import jfxtras.labs.internal.scene.control.skin.CalendarTimePickerSkin;

public class CalendarTimePicker
extends Control {
    private final ObjectProperty<Calendar> calendarObjectProperty = new SimpleObjectProperty<Calendar>((Object)this, "calendar", Calendar.getInstance()){

        public void set(Calendar value) {
            value = CalendarTimePickerSkin.blockMinutesToStep(value, CalendarTimePicker.this.getMinuteStep());
            super.set((Object)value);
        }
    };
    private final SimpleObjectProperty<Integer> minuteStepProperty = new SimpleObjectProperty<Integer>((Object)this, "minuteStep", Integer.valueOf(1)){

        public void set(Integer value) {
            super.set((Object)value);
            CalendarTimePicker.this.setCalendar(CalendarTimePickerSkin.blockMinutesToStep(CalendarTimePicker.this.getCalendar(), CalendarTimePicker.this.getMinuteStep()));
        }
    };
    private final SimpleObjectProperty<Boolean> showLabelsProperty = new SimpleObjectProperty<Boolean>((Object)this, "showLabels", Boolean.valueOf(false)){

        public void set(Boolean value) {
            if (value == null) {
                throw new NullPointerException("showLabels cannot be null");
            }
            super.set((Object)value);
        }
    };

    public CalendarTimePicker() {
        this.construct();
    }

    private void construct() {
        this.getStyleClass().add((Object)((Object)((Object)this)).getClass().getSimpleName());
    }

    protected String getUserAgentStylesheet() {
        return ((Object)((Object)this)).getClass().getResource("/jfxtras/labs/internal/scene/control/" + ((Object)((Object)this)).getClass().getSimpleName() + ".css").toString();
    }

    public ObjectProperty<Calendar> calendarProperty() {
        return this.calendarObjectProperty;
    }

    public Calendar getCalendar() {
        return (Calendar)this.calendarObjectProperty.getValue();
    }

    public void setCalendar(Calendar value) {
        this.calendarObjectProperty.setValue((Object)value);
    }

    public CalendarTimePicker withCalendar(Calendar value) {
        this.setCalendar(value);
        return this;
    }

    public ObjectProperty<Integer> minuteStepProperty() {
        return this.minuteStepProperty;
    }

    public Integer getMinuteStep() {
        return (Integer)this.minuteStepProperty.getValue();
    }

    public void setMinuteStep(Integer value) {
        this.minuteStepProperty.setValue((Object)value);
    }

    public CalendarTimePicker withMinuteStep(Integer value) {
        this.setMinuteStep(value);
        return this;
    }

    public ObjectProperty<Boolean> showLabelsProperty() {
        return this.showLabelsProperty;
    }

    public Boolean getShowLabels() {
        return (Boolean)this.showLabelsProperty.getValue();
    }

    public void setShowLabels(Boolean value) {
        this.showLabelsProperty.setValue((Object)value);
    }

    public CalendarTimePicker withShowLabels(Boolean value) {
        this.setShowLabels(value);
        return this;
    }

    public static String quickFormatCalendar(Calendar value) {
        if (value == null) {
            return "null";
        }
        SimpleDateFormat lSimpleDateFormat = (SimpleDateFormat)SimpleDateFormat.getDateInstance(1);
        lSimpleDateFormat.applyPattern("yyyy-MM-dd HH:mm:ss");
        return value == null ? "null" : lSimpleDateFormat.format(value.getTime());
    }
}

