/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.scene.control;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.Control;
import javafx.util.Callback;

public class CalendarTimeTextField
extends Control {
    private final ObjectProperty<Calendar> valueObjectProperty = new SimpleObjectProperty((Object)this, "value", null);
    private final ObjectProperty<DateFormat> dateFormatObjectProperty = new SimpleObjectProperty<DateFormat>((Object)this, "dateFormat", (DateFormat)new SimpleDateFormat("HH:mm")){

        public void set(DateFormat value) {
            String lFormattedDate = value.format(DATE_WITH_TIME);
            if (lFormattedDate.contains("1")) {
                throw new IllegalArgumentException("The date format may only show time");
            }
            super.set((Object)value);
        }
    };
    private static final Date DATE_WITH_TIME = new GregorianCalendar(1111, 0, 1, 2, 2, 2).getTime();
    private final SimpleObjectProperty<Integer> minuteStepProperty = new SimpleObjectProperty((Object)this, "minuteStep", (Object)1);
    private final SimpleObjectProperty<Boolean> showLabelsProperty = new SimpleObjectProperty((Object)this, "showLabels", (Object)true);
    private final ObjectProperty<String> promptTextObjectProperty = new SimpleObjectProperty((Object)this, "promptText", null);
    private final ObjectProperty<Callback<Throwable, Void>> parseErrorCallbackObjectProperty = new SimpleObjectProperty((Object)this, "parseErrorCallback", null);
    ListProperty<DateFormat> dateFormatsProperty = new SimpleListProperty(FXCollections.observableList(new ArrayList()));

    public CalendarTimeTextField() {
        this.construct();
    }

    private void construct() {
        this.getStyleClass().add((Object)((Object)((Object)this)).getClass().getSimpleName());
        this.setFocusTraversable(false);
    }

    protected String getUserAgentStylesheet() {
        return ((Object)((Object)this)).getClass().getResource("/jfxtras/labs/internal/scene/control/" + ((Object)((Object)this)).getClass().getSimpleName() + ".css").toString();
    }

    public ObjectProperty<Calendar> valueProperty() {
        return this.valueObjectProperty;
    }

    public Calendar getValue() {
        return (Calendar)this.valueObjectProperty.getValue();
    }

    public void setValue(Calendar value) {
        this.valueObjectProperty.setValue((Object)value);
    }

    public CalendarTimeTextField withValue(Calendar value) {
        this.setValue(value);
        return this;
    }

    public ObjectProperty<DateFormat> dateFormatProperty() {
        return this.dateFormatObjectProperty;
    }

    public DateFormat getDateFormat() {
        return (DateFormat)this.dateFormatObjectProperty.getValue();
    }

    public void setDateFormat(DateFormat value) {
        this.dateFormatObjectProperty.setValue((Object)value);
    }

    public CalendarTimeTextField withDateFormat(DateFormat value) {
        this.setDateFormat(value);
        return this;
    }

    public ObjectProperty<Integer> minuteStepProperty() {
        return this.minuteStepProperty;
    }

    public Integer getMinuteStep() {
        return (Integer)this.minuteStepProperty.getValue();
    }

    public void setMinuteStep(Integer value) {
        this.minuteStepProperty.setValue((Object)value);
    }

    public CalendarTimeTextField withMinuteStep(Integer value) {
        this.setMinuteStep(value);
        return this;
    }

    public ObjectProperty<Boolean> showLabelsProperty() {
        return this.showLabelsProperty;
    }

    public Boolean getShowLabels() {
        return (Boolean)this.showLabelsProperty.getValue();
    }

    public void setShowLabels(Boolean value) {
        this.showLabelsProperty.setValue((Object)value);
    }

    public CalendarTimeTextField withShowLabels(Boolean value) {
        this.setShowLabels(value);
        return this;
    }

    public ObjectProperty<String> promptTextProperty() {
        return this.promptTextObjectProperty;
    }

    public String getPromptText() {
        return (String)this.promptTextObjectProperty.get();
    }

    public void setPromptText(String value) {
        this.promptTextObjectProperty.set((Object)value);
    }

    public CalendarTimeTextField withPromptText(String value) {
        this.setPromptText(value);
        return this;
    }

    public ObjectProperty<Callback<Throwable, Void>> parseErrorCallbackProperty() {
        return this.parseErrorCallbackObjectProperty;
    }

    public Callback<Throwable, Void> getParseErrorCallback() {
        return (Callback)this.parseErrorCallbackObjectProperty.getValue();
    }

    public void setParseErrorCallback(Callback<Throwable, Void> value) {
        this.parseErrorCallbackObjectProperty.setValue(value);
    }

    public CalendarTimeTextField withParseErrorCallback(Callback<Throwable, Void> value) {
        this.setParseErrorCallback(value);
        return this;
    }

    public ListProperty<DateFormat> dateFormatsProperty() {
        return this.dateFormatsProperty;
    }

    public ObservableList<DateFormat> getDateFormats() {
        return this.dateFormatsProperty.getValue();
    }

    public void setDateFormats(ObservableList<DateFormat> value) {
        this.dateFormatsProperty.setValue(value);
    }

    public CalendarTimeTextField withDateFormat(ObservableList<DateFormat> value) {
        this.setDateFormats(value);
        return this;
    }
}

