/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.scene.control;

import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContentDisplay;
import javafx.scene.image.ImageView;

public class MiniIconButton
extends Button {
    private ObjectProperty<ImageView> miniIcon;
    private ObjectProperty<AnimationType> animationType = new SimpleObjectProperty((Object)this, "animationType", (Object)AnimationType.NONE);
    private DoubleProperty animationDuration = new SimpleDoubleProperty((Object)this, "animationDuration", 500.0);
    private ObjectProperty<Pos> miniIconPosition = new SimpleObjectProperty((Object)this, "miniIconPosition", (Object)Pos.TOP_RIGHT);
    private DoubleProperty miniIconRatio = new SimpleDoubleProperty((Object)this, "miniIconRatio", 0.25);

    public MiniIconButton() {
        this.init();
    }

    public MiniIconButton(ImageView miniIcon) {
        this.setMiniIcon(miniIcon);
        this.init();
    }

    public MiniIconButton(String text, ImageView miniIcon) {
        super(text);
        this.setMiniIcon(miniIcon);
        this.init();
    }

    public MiniIconButton(Node graphic, ImageView miniIcon) {
        super(null, graphic);
        this.setMiniIcon(miniIcon);
        this.init();
    }

    public MiniIconButton(String text, Node graphic, ImageView miniIcon) {
        super(text, graphic);
        this.setMiniIcon(miniIcon);
        this.init();
    }

    public final ObjectProperty<ImageView> miniIconProperty() {
        if (this.miniIcon == null) {
            this.miniIcon = new ObjectPropertyBase<ImageView>(){

                public Object getBean() {
                    return MiniIconButton.this;
                }

                public String getName() {
                    return "miniIcon";
                }
            };
        }
        return this.miniIcon;
    }

    public void setMiniIcon(ImageView value) {
        this.miniIconProperty().setValue((Object)value);
    }

    public ImageView getMiniIcon() {
        return this.miniIcon == null ? null : (ImageView)this.miniIcon.getValue();
    }

    public final ObjectProperty<AnimationType> animationTypeProperty() {
        return this.animationType;
    }

    public AnimationType getAnimationType() {
        return (AnimationType)((Object)this.animationType.getValue());
    }

    public void setAnimationType(AnimationType value) {
        this.animationType.setValue((Object)value);
    }

    public final ObjectProperty<Pos> miniIconPositionProperty() {
        return this.miniIconPosition;
    }

    public final void setMiniIconPosition(Pos value) {
        this.miniIconPosition.set((Object)value);
    }

    public final Pos getMiniIconPosition() {
        return (Pos)this.miniIconPosition.getValue();
    }

    public final DoubleProperty miniIconRatioProperty() {
        return this.miniIconRatio;
    }

    public final void setMiniIconRatio(double value) {
        this.miniIconRatio.set(value);
    }

    public final double getMiniIconRatio() {
        return this.miniIconRatio.getValue();
    }

    public final DoubleProperty animationDurationProperty() {
        return this.animationDuration;
    }

    public final void setAnimationDuration(double value) {
        this.animationDuration.set(value);
    }

    public final double getAnimationDuration() {
        return this.animationDuration.getValue();
    }

    protected String getUserAgentStylesheet() {
        return ((Object)((Object)this)).getClass().getResource("/jfxtras/labs/internal/scene/control/" + ((Object)((Object)this)).getClass().getSimpleName() + ".css").toString();
    }

    private void init() {
        this.setStyle(null);
        this.getStyleClass().add((Object)"mini-icon-button");
        this.setContentDisplay(ContentDisplay.TOP);
        this.setMiniIconRatioRange();
    }

    private void setMiniIconRatioRange() {
        this.miniIconRatio.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observableValue, Number oldValue, Number newValue) {
                if (newValue.doubleValue() > 1.0) {
                    MiniIconButton.this.miniIconRatio.set(1.0);
                } else if (newValue.doubleValue() < 0.01) {
                    MiniIconButton.this.miniIconRatio.set(0.01);
                }
            }
        });
    }

    public static enum AnimationType {
        NONE,
        JUMP,
        BLINK;

    }
}

