/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.scene.control;

import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.WritableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.Control;
import javafx.scene.paint.Color;
import javafx.scene.paint.LinearGradientBuilder;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.util.Duration;

public class SlideLock
extends Control {
    private static final String DEFAULT_STYLE_CLASS = "slide-lock";
    public static final double START_XCOORD = 33.0;
    public static final double END_XCOORD = 375.0;
    public static final double BUTTON_YCOORD = 49.0;
    public static final double PREFERRED_WIDTH = 523.28571;
    public static final double PREFERRED_HEIGHT = 188.0;
    private BooleanProperty backgroundVisible;
    private BooleanProperty buttonGlareVisible;
    private BooleanProperty locked;
    private StringProperty text;
    private DoubleProperty startX;
    private DoubleProperty endX;
    private DoubleProperty textOpacity;
    private Timeline snapButtonBackAnim;
    private Timeline unlockAnimation;
    private ObjectProperty<Paint> buttonArrowBackgroundColor;
    private ObjectProperty<Paint> buttonColor;

    public SlideLock() {
        this("slide to unlock");
    }

    public SlideLock(String displayText) {
        this.getStyleClass().setAll((Object[])new String[]{DEFAULT_STYLE_CLASS});
        this.backgroundVisible = new SimpleBooleanProperty(false);
        this.buttonGlareVisible = new SimpleBooleanProperty(true);
        this.buttonGlareVisible = new SimpleBooleanProperty(true);
        this.locked = new SimpleBooleanProperty(true);
        this.text = new SimpleStringProperty(displayText);
        this.startX = new SimpleDoubleProperty(33.0);
        this.endX = new SimpleDoubleProperty(33.0);
        this.textOpacity = new SimpleDoubleProperty(1.0);
        this.snapButtonBackAnim = new Timeline();
        this.unlockAnimation = new Timeline();
        this.buttonArrowBackgroundColor = new SimpleObjectProperty();
        this.buttonColor = new SimpleObjectProperty();
        this.init();
    }

    private void init() {
        KeyValue BUTTON_X_START = new KeyValue((WritableValue)this.endX, (Object)33.0);
        KeyFrame LOCK_KEY_FRAME = new KeyFrame(Duration.millis((double)150.0), new KeyValue[]{BUTTON_X_START});
        KeyValue TEXT_OPACITY_LOCK_KV = new KeyValue((WritableValue)this.textOpacity, (Object)1);
        KeyFrame TEXT_OPACITY_LOCK_KF = new KeyFrame(Duration.millis((double)150.0), new KeyValue[]{TEXT_OPACITY_LOCK_KV});
        this.snapButtonBackAnim.getKeyFrames().addAll((Object[])new KeyFrame[]{LOCK_KEY_FRAME, TEXT_OPACITY_LOCK_KF});
        KeyValue BUTTON_X_END = new KeyValue((WritableValue)this.endX, (Object)375.0);
        KeyFrame UNLOCK_KEY_FRAME = new KeyFrame(Duration.millis((double)1000.0), new KeyValue[]{BUTTON_X_END});
        KeyValue TEXT_OPACITY_UNLOCK_KV = new KeyValue((WritableValue)this.textOpacity, (Object)0);
        KeyFrame TEXT_OPACITY_UNLOCK_KF = new KeyFrame(Duration.millis((double)1000.0), new KeyValue[]{TEXT_OPACITY_UNLOCK_KV});
        this.unlockAnimation.getKeyFrames().addAll((Object[])new KeyFrame[]{UNLOCK_KEY_FRAME, TEXT_OPACITY_UNLOCK_KF});
        this.unlockAnimation.setOnFinished((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent EVENT) {
                SlideLock.this.setLocked(false);
            }
        });
        this.buttonArrowBackgroundColor.set((Object)LinearGradientBuilder.create().proportional(true).startX(0.0).startY(1.0).endX(0.0).endY(0.0).stops(new Stop[]{new Stop(0.0, Color.web((String)"747474")), new Stop(1.0, Color.web((String)"e8e8e8"))}).build());
        this.buttonColor.set((Object)LinearGradientBuilder.create().proportional(true).startX(0.0).startY(1.0).endX(0.0).endY(0.0).stops(new Stop[]{new Stop(0.0, Color.web((String)"c5c5c5")), new Stop(1.0, Color.web((String)"f0f0f0"))}).build());
    }

    protected String getUserAgentStylesheet() {
        return ((Object)((Object)this)).getClass().getResource("/jfxtras/labs/scene/control/slidelock.css").toExternalForm();
    }

    public final boolean isBackgroundVisible() {
        return this.backgroundVisible.get();
    }

    public final void setBackgroundVisible(boolean backgroundVisible) {
        this.backgroundVisible.set(backgroundVisible);
    }

    public final BooleanProperty backgroundVisibleProperty() {
        return this.backgroundVisible;
    }

    public final boolean isButtonGlareVisible() {
        return this.buttonGlareVisible.get();
    }

    public final void setButtonGlareVisible(boolean backgroundVisible) {
        this.buttonGlareVisible.set(backgroundVisible);
    }

    public final BooleanProperty buttonGlareVisibleProperty() {
        return this.buttonGlareVisible;
    }

    public final boolean isLocked() {
        return this.locked.get();
    }

    public final void setLocked(boolean locked) {
        this.locked.set(locked);
    }

    public final BooleanProperty lockedProperty() {
        return this.locked;
    }

    public final void autoUnlock() {
        this.unlockAnimation.play();
    }

    public final String getText() {
        return (String)this.text.get();
    }

    public final void setText(String text) {
        this.text.set((Object)text);
    }

    public final StringProperty textProperty() {
        return this.text;
    }

    public final double getStartX() {
        return this.startX.get();
    }

    public final void setStartX(double startX) {
        this.startX.set(startX);
    }

    public final DoubleProperty startXProperty() {
        return this.startX;
    }

    public final double getEndX() {
        return this.endX.get();
    }

    public final void setEndX(double endX) {
        this.endX.set(endX);
    }

    public final DoubleProperty endXProperty() {
        return this.endX;
    }

    public final double getTextOpacity() {
        return this.textOpacity.get();
    }

    public final void setTextOpacity(double opacity) {
        this.textOpacity.set(opacity);
    }

    public final DoubleProperty textOpacityProperty() {
        return this.textOpacity;
    }

    public final Paint getButtonArrowBackgroundColor() {
        return (Paint)this.buttonArrowBackgroundColor.get();
    }

    public final void setButtonArrowBackgroundColor(Paint color) {
        this.buttonArrowBackgroundColor.set((Object)color);
    }

    public final ObjectProperty<Paint> buttonArrowBackgroundColorProperty() {
        return this.buttonArrowBackgroundColor;
    }

    public final Paint getButtonColor() {
        return (Paint)this.buttonColor.get();
    }

    public final void setButtonColor(Paint color) {
        this.buttonColor.set((Object)color);
    }

    public final ObjectProperty<Paint> buttonColorProperty() {
        return this.buttonColor;
    }

    public Timeline getSnapButtonBackAnim() {
        return this.snapButtonBackAnim;
    }
}

