/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.scene.control.gauge;

import java.util.Calendar;
import java.util.Date;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.control.Control;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class Clock
extends Control {
    private static final String DEFAULT_STYLE_CLASS = "clock";
    private StringProperty timeZone = new SimpleStringProperty(Calendar.getInstance().getTimeZone().getDisplayName());
    private BooleanProperty running = new SimpleBooleanProperty(false);
    private BooleanProperty secondPointerVisible = new SimpleBooleanProperty(true);
    private BooleanProperty autoDimEnabled = new SimpleBooleanProperty(false);
    private BooleanProperty daylightSavingTime = new SimpleBooleanProperty(Calendar.getInstance().getTimeZone().inDaylightTime(new Date()));
    private ObjectProperty<Theme> theme = new SimpleObjectProperty((Object)Theme.BRIGHT);
    private ObjectProperty<ClockStyle> clockStyle = new SimpleObjectProperty((Object)ClockStyle.DB);
    private ObjectProperty<Paint> brightBackgroundPaint = new SimpleObjectProperty((Object)Color.WHITE);
    private ObjectProperty<Paint> darkBackgroundPaint = new SimpleObjectProperty((Object)Color.BLACK);
    private ObjectProperty<Paint> brightTickMarkPaint;
    private ObjectProperty<Paint> darkTickMarkPaint;
    private ObjectProperty<Paint> brightPointerPaint = new SimpleObjectProperty((Object)Color.BLACK);
    private ObjectProperty<Paint> darkPointerPaint = new SimpleObjectProperty((Object)Color.WHITE);
    private ObjectProperty<Paint> secondPointerPaint;
    private IntegerProperty hour;
    private IntegerProperty minute;
    private IntegerProperty second;
    private StringProperty title;

    public Clock() {
        this.brightTickMarkPaint = new SimpleObjectProperty((Object)Color.BLACK);
        this.darkTickMarkPaint = new SimpleObjectProperty((Object)Color.WHITE);
        this.secondPointerPaint = new SimpleObjectProperty((Object)Color.rgb((int)237, (int)0, (int)58));
        this.title = new SimpleStringProperty("");
        this.hour = new SimpleIntegerProperty(0);
        this.minute = new SimpleIntegerProperty(0);
        this.second = new SimpleIntegerProperty(0);
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
    }

    public void setPrefSize(double WIDTH, double HEIGHT) {
        double SIZE = WIDTH <= HEIGHT ? WIDTH : HEIGHT;
        super.setPrefSize(SIZE, SIZE);
    }

    public final String getTimeZone() {
        return (String)this.timeZone.get();
    }

    public final void setTimeZone(String TIME_ZONE) {
        this.timeZone.set((Object)TIME_ZONE);
    }

    public final StringProperty timeZoneProperty() {
        return this.timeZone;
    }

    public final boolean isRunning() {
        return this.running.get();
    }

    public final void setRunning(boolean RUNNING) {
        this.running.set(RUNNING);
    }

    public final BooleanProperty runningProperty() {
        return this.running;
    }

    public final boolean isSecondPointerVisible() {
        return this.secondPointerVisible.get();
    }

    public final void setSecondPointerVisible(boolean SECOND_POINTER_VISIBLE) {
        this.secondPointerVisible.set(SECOND_POINTER_VISIBLE);
    }

    public final BooleanProperty secondPointerVisibleProperty() {
        return this.secondPointerVisible;
    }

    public final boolean isAutoDimEnabled() {
        return this.autoDimEnabled.get();
    }

    public final void setAutoDimEnabled(boolean AUTO_DIM_ENABLED) {
        this.autoDimEnabled.set(AUTO_DIM_ENABLED);
    }

    public final BooleanProperty autoDimEnabledProperty() {
        return this.autoDimEnabled;
    }

    public final boolean isDaylightSavingTime() {
        return this.daylightSavingTime.get();
    }

    public final void setDaylightSavingTime(boolean DAYLIGHT_SAVING_TIME) {
        this.daylightSavingTime.set(DAYLIGHT_SAVING_TIME);
    }

    public final BooleanProperty daylightSavingTimeProperty() {
        return this.daylightSavingTime;
    }

    public final Theme getTheme() {
        return (Theme)((Object)this.theme.get());
    }

    public final void setTheme(Theme Theme2) {
        this.theme.set((Object)Theme2);
    }

    public final ObjectProperty<Theme> themeProperty() {
        return this.theme;
    }

    public final ClockStyle getClockStyle() {
        return (ClockStyle)((Object)this.clockStyle.get());
    }

    public final void setClockStyle(ClockStyle CLOCK_STYLE) {
        this.clockStyle.set((Object)CLOCK_STYLE);
    }

    public final ObjectProperty<ClockStyle> clockStyleProperty() {
        return this.clockStyle;
    }

    public final Paint getBrightBackgroundPaint() {
        return (Paint)this.brightBackgroundPaint.get();
    }

    public final void setBrightBackgroundPaint(Paint BRIGHT_BACKGROUND_PAINT) {
        this.brightBackgroundPaint.set((Object)BRIGHT_BACKGROUND_PAINT);
    }

    public final ObjectProperty<Paint> brightBackgroundPaintProperty() {
        return this.brightBackgroundPaint;
    }

    public final Paint getDarkBackgroundPaint() {
        return (Paint)this.darkBackgroundPaint.get();
    }

    public final void setDarkBackgroundPaint(Paint DARK_BACKGROUND_PAINT) {
        this.darkBackgroundPaint.set((Object)DARK_BACKGROUND_PAINT);
    }

    public final ObjectProperty<Paint> darkBackgroundPaintProperty() {
        return this.darkBackgroundPaint;
    }

    public final Paint getBrightTickMarkPaint() {
        return (Paint)this.brightTickMarkPaint.get();
    }

    public final void setBrightTickMarkPaint(Paint BRIGHT_TICK_MARK_PAINT) {
        this.brightTickMarkPaint.set((Object)BRIGHT_TICK_MARK_PAINT);
    }

    public final ObjectProperty<Paint> brightTickMarkPaintProperty() {
        return this.brightTickMarkPaint;
    }

    public final Paint getDarkTickMarkPaint() {
        return (Paint)this.darkTickMarkPaint.get();
    }

    public final void setDarkTickMarkPaint(Paint DARK_TICK_MARK_PAINT) {
        this.darkTickMarkPaint.set((Object)DARK_TICK_MARK_PAINT);
    }

    public final ObjectProperty<Paint> darkTickMarkPaintProperty() {
        return this.darkTickMarkPaint;
    }

    public final Paint getBrightPointerPaint() {
        return (Paint)this.brightPointerPaint.get();
    }

    public final void setBrightPointerPaint(Paint BRIGHT_POINTER_PAINT) {
        this.brightPointerPaint.set((Object)BRIGHT_POINTER_PAINT);
    }

    public final ObjectProperty<Paint> brightPointerPaintProperty() {
        return this.brightPointerPaint;
    }

    public final Paint getDarkPointerPaint() {
        return (Paint)this.darkPointerPaint.get();
    }

    public final void setDarkPointerPaint(Paint DARK_POINTER_PAINT) {
        this.darkPointerPaint.set((Object)DARK_POINTER_PAINT);
    }

    public final ObjectProperty<Paint> darkPointerPaintProperty() {
        return this.darkPointerPaint;
    }

    public final Paint getSecondPointerPaint() {
        return (Paint)this.secondPointerPaint.get();
    }

    public final void setSecondPointerPaint(Paint SECOND_POINTER_PAINT) {
        this.secondPointerPaint.set((Object)SECOND_POINTER_PAINT);
    }

    public final ObjectProperty<Paint> secondPointerPaintProperty() {
        return this.secondPointerPaint;
    }

    public final String getTitle() {
        return (String)this.title.get();
    }

    public final void setTitle(String TITLE) {
        this.title.set((Object)TITLE);
    }

    public final StringProperty titleProperty() {
        return this.title;
    }

    public final int getHour() {
        return this.hour.get();
    }

    public final void setHour(int HOUR) {
        this.hour.set(this.clamp(0, 23, HOUR));
    }

    public final ReadOnlyIntegerProperty hourProperty() {
        return this.hour;
    }

    public final int getMinute() {
        return this.minute.get();
    }

    public final void setMinute(int MINUTE) {
        this.minute.set(this.clamp(0, 59, MINUTE));
    }

    public final ReadOnlyIntegerProperty minuteProperty() {
        return this.minute;
    }

    public final int getSecond() {
        return this.second.get();
    }

    public final void setSecond(int SECOND) {
        this.second.set(this.clamp(0, 59, SECOND));
    }

    public final ReadOnlyIntegerProperty secondProperty() {
        return this.second;
    }

    private int clamp(int MIN, int MAX, int VALUE) {
        return VALUE < MIN ? MIN : (VALUE > MAX ? MAX : VALUE);
    }

    protected String getUserAgentStylesheet() {
        return ((Object)((Object)this)).getClass().getResource("extras.css").toExternalForm();
    }

    public static enum ClockStyle {
        DB,
        IOS6,
        STANDARD;

    }

    public static enum Theme {
        BRIGHT,
        DARK;

    }
}

