/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.scene.control.gauge;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Point2D;
import javafx.scene.control.Control;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;
import jfxtras.labs.scene.control.gauge.ColorDef;
import jfxtras.labs.scene.control.gauge.GaugeModel;
import jfxtras.labs.scene.control.gauge.LcdDesign;
import jfxtras.labs.scene.control.gauge.LedColor;
import jfxtras.labs.scene.control.gauge.Marker;
import jfxtras.labs.scene.control.gauge.Radial;
import jfxtras.labs.scene.control.gauge.Section;
import jfxtras.labs.scene.control.gauge.StyleModel;

public abstract class Gauge
extends Control {
    private ObjectProperty<GaugeModel> gaugeModelProperty;
    private ObjectProperty<StyleModel> styleModelProperty;
    private GaugeModel gaugeModel;
    private StyleModel styleModel;
    private ObjectProperty<RadialRange> radialRange;
    private DoubleProperty angleStep;
    private final ObjectProperty<EventHandler<GaugeModel.GaugeModelEvent>> onGaugeModelEvent = new SimpleObjectProperty();
    private final ObjectProperty<EventHandler<StyleModel.StyleModelEvent>> onStyleModelEvent = new SimpleObjectProperty();

    protected Gauge() {
        this(new GaugeModel(), new StyleModel());
    }

    protected Gauge(GaugeModel GAUGE_MODEL) {
        this(GAUGE_MODEL, new StyleModel());
    }

    protected Gauge(StyleModel STYLE_MODEL) {
        this(new GaugeModel(), STYLE_MODEL);
    }

    protected Gauge(GaugeModel GAUGE_MODEL, StyleModel STYLE_MODEL) {
        this.gaugeModelProperty = new SimpleObjectProperty((Object)GAUGE_MODEL);
        this.styleModelProperty = new SimpleObjectProperty((Object)STYLE_MODEL);
        this.gaugeModel = (GaugeModel)this.gaugeModelProperty.get();
        this.styleModel = (StyleModel)this.styleModelProperty.get();
        this.radialRange = new SimpleObjectProperty((Object)RadialRange.RADIAL_300);
        this.angleStep = new SimpleDoubleProperty(((RadialRange)((Object)this.radialRange.get())).ANGLE_RANGE / this.gaugeModel.getRange());
        this.ledBlinkingProperty().bind((ObservableValue)this.thresholdExceededProperty());
        this.addGaugeModelListener();
        this.addStyleModelListener();
    }

    private final void addGaugeModelListener() {
        this.gaugeModel.setOnGaugeModelEvent(new EventHandler<GaugeModel.GaugeModelEvent>(){

            public void handle(GaugeModel.GaugeModelEvent EVENT) {
                Gauge.this.forwardModelEvent(EVENT);
            }
        });
    }

    public final ObjectProperty<EventHandler<GaugeModel.GaugeModelEvent>> onGaugeModelEventProperty() {
        return this.onGaugeModelEvent;
    }

    public final void setOnGaugeModelEvent(EventHandler<GaugeModel.GaugeModelEvent> HANDLER) {
        this.onGaugeModelEventProperty().set(HANDLER);
    }

    public final EventHandler<GaugeModel.GaugeModelEvent> getOnGaugeModelEvent() {
        return (EventHandler)this.onGaugeModelEventProperty().get();
    }

    public void forwardModelEvent(GaugeModel.GaugeModelEvent EVENT) {
        EventHandler<GaugeModel.GaugeModelEvent> MODEL_EVENT_HANDLER = this.getOnGaugeModelEvent();
        if (MODEL_EVENT_HANDLER != null) {
            MODEL_EVENT_HANDLER.handle((Event)EVENT);
        }
    }

    private final void addStyleModelListener() {
        this.styleModel.setOnStyleModelEvent(new EventHandler<StyleModel.StyleModelEvent>(){

            public void handle(StyleModel.StyleModelEvent EVENT) {
                Gauge.this.forwardStyleModelEvent(EVENT);
            }
        });
    }

    public final ObjectProperty<EventHandler<StyleModel.StyleModelEvent>> onStyleModelEventProperty() {
        return this.onStyleModelEvent;
    }

    public final void setOnStyleModelEvent(EventHandler<StyleModel.StyleModelEvent> HANDLER) {
        this.onStyleModelEventProperty().set(HANDLER);
    }

    public final EventHandler<StyleModel.StyleModelEvent> getOnStyleModelEvent() {
        return (EventHandler)this.onStyleModelEventProperty().get();
    }

    public void forwardStyleModelEvent(StyleModel.StyleModelEvent EVENT) {
        EventHandler<StyleModel.StyleModelEvent> STYLE_MODEL_EVENT_HANDLER = this.getOnStyleModelEvent();
        if (STYLE_MODEL_EVENT_HANDLER != null) {
            STYLE_MODEL_EVENT_HANDLER.handle((Event)EVENT);
        }
    }

    public String getUserAgentStylesheet() {
        return ((Object)((Object)this)).getClass().getResource("steelseries.css").toExternalForm();
    }

    public final StyleModel getStyleModel() {
        return (StyleModel)this.styleModelProperty.get();
    }

    public final void setStyleModel(StyleModel STYLE_MODEL) {
        this.styleModelProperty.set((Object)STYLE_MODEL);
        this.styleModel = (StyleModel)this.styleModelProperty().get();
        this.addStyleModelListener();
    }

    public final ReadOnlyObjectProperty<StyleModel> styleModelProperty() {
        return this.styleModelProperty;
    }

    public final GaugeModel getGaugeModel() {
        return (GaugeModel)this.gaugeModelProperty.get();
    }

    public final void setGaugeModel(GaugeModel GAUGE_MODEL) {
        this.gaugeModelProperty.set((Object)GAUGE_MODEL);
        this.gaugeModel = (GaugeModel)this.gaugeModelProperty.get();
        this.addGaugeModelListener();
    }

    public final ReadOnlyObjectProperty<GaugeModel> gaugeModelProperty() {
        return this.gaugeModelProperty;
    }

    public RadialRange getRadialRange() {
        return (RadialRange)((Object)this.radialRange.get());
    }

    public void setRadialRange(RadialRange RADIAL_RANGE) {
        this.radialRange.set((Object)RADIAL_RANGE);
        this.gaugeModel.calcRange();
        this.angleStep.set(((RadialRange)((Object)this.radialRange.get())).ANGLE_RANGE / this.gaugeModel.getRange());
        if (RADIAL_RANGE == RadialRange.RADIAL_360) {
            this.setKnobsVisible(false);
            this.setEndlessMode(true);
        } else {
            this.setEndlessMode(false);
        }
    }

    public final ObjectProperty<RadialRange> radialRangeProperty() {
        return this.radialRange;
    }

    public final double getAngleStep() {
        return this.angleStep.get();
    }

    public final void recalcRange() {
        if (this.getMinValue() < this.getMaxValue()) {
            this.gaugeModel.calcRange();
        }
        this.angleStep.set(((RadialRange)((Object)this.radialRange.get())).ANGLE_RANGE / this.gaugeModel.getRange());
    }

    public final ReadOnlyDoubleProperty angleStepProperty() {
        return this.angleStep;
    }

    public final Point2D getLedPosition() {
        return ((RadialRange)((Object)this.radialRange.get())).LED_POSITION;
    }

    public final Point2D getUserLedPosition() {
        return ((RadialRange)((Object)this.radialRange.get())).USER_LED_POSITION;
    }

    public final double getValue() {
        return this.gaugeModel.getValue();
    }

    public final void setValue(double VALUE) {
        this.gaugeModel.setValue(VALUE);
    }

    public final DoubleProperty valueProperty() {
        return this.gaugeModel.valueProperty();
    }

    public final double getRealValue() {
        return this.gaugeModel.getRealValue();
    }

    public final ReadOnlyDoubleProperty realValueProperty() {
        return this.gaugeModel.realValueProperty();
    }

    public final double getFormerValue() {
        return this.gaugeModel.getFormerValue();
    }

    public final ReadOnlyDoubleProperty formerValueProperty() {
        return this.gaugeModel.formerValueProperty();
    }

    public final boolean isValueAnimationEnabled() {
        return this.gaugeModel.isValueAnimationEnabled();
    }

    public final void setValueAnimationEnabled(boolean VALUE_ANIMATION_ENABLED) {
        this.gaugeModel.setValueAnimationEnabled(VALUE_ANIMATION_ENABLED);
    }

    public final BooleanProperty valueAnimationEnabledProperty() {
        return this.gaugeModel.valueAnimationEnabledProperty();
    }

    public final double getAnimationDuration() {
        return this.gaugeModel.getAnimationDuration();
    }

    public final void setAnimationDuration(double ANIMATION_DURATION) {
        this.gaugeModel.setAnimationDuration(ANIMATION_DURATION);
    }

    public final DoubleProperty animationDurationProperty() {
        return this.gaugeModel.animationDurationProperty();
    }

    public final double getRedrawTolerance() {
        return this.gaugeModel.getRedrawTolerance();
    }

    public final void setRedrawTolerance(double REDRAW_TOLERANCE) {
        this.gaugeModel.setRedrawTolerance(REDRAW_TOLERANCE);
    }

    public final DoubleProperty redrawToleranceProperty() {
        return this.gaugeModel.redrawToleranceProperty();
    }

    public final double getRedrawToleranceValue() {
        return this.gaugeModel.getRedrawToleranceValue();
    }

    public final double getMinValue() {
        return this.gaugeModel.getMinValue();
    }

    public final void setMinValue(double MIN_VALUE) {
        this.gaugeModel.setMinValue(MIN_VALUE);
        this.gaugeModel.calcRange();
        this.angleStep.set(((RadialRange)((Object)this.radialRange.get())).ANGLE_RANGE / this.gaugeModel.getRange());
    }

    public final ReadOnlyDoubleProperty minValueProperty() {
        return this.gaugeModel.minValueProperty();
    }

    public final double getUncorrectedMinValue() {
        return this.gaugeModel.getUncorrectedMinValue();
    }

    public final double getMaxValue() {
        return this.gaugeModel.getMaxValue();
    }

    public final void setMaxValue(double MAX_VALUE) {
        this.gaugeModel.setMaxValue(MAX_VALUE);
        this.gaugeModel.calcRange();
        this.angleStep.set(((RadialRange)((Object)this.radialRange.get())).ANGLE_RANGE / this.gaugeModel.getRange());
    }

    public final ReadOnlyDoubleProperty maxValueProperty() {
        return this.gaugeModel.maxValueProperty();
    }

    public final double getUncorrectedMaxValue() {
        return this.gaugeModel.getUncorrectedMaxValue();
    }

    public final double getRange() {
        return this.gaugeModel.getRange();
    }

    public final ReadOnlyDoubleProperty rangeProperty() {
        return this.gaugeModel.rangeProperty();
    }

    public final double getMinMeasuredValue() {
        return this.gaugeModel.getMinMeasuredValue();
    }

    public final void setMinMeasuredValue(double MIN_MEASURED_VALUE) {
        this.gaugeModel.setMinMeasuredValue(MIN_MEASURED_VALUE);
    }

    public final DoubleProperty minMeasuredValueProperty() {
        return this.gaugeModel.minMeasuredValueProperty();
    }

    public final boolean isBargraph() {
        return this.styleModel.isBargraph();
    }

    public final void setBargraph(boolean BARGRAPH) {
        this.styleModel.setBargraph(BARGRAPH);
    }

    public final BooleanProperty bargraphProperty() {
        return this.styleModel.bargraphProperty();
    }

    public final boolean isMinMeasuredValueVisible() {
        return this.styleModel.isMinMeasuredValueVisible();
    }

    public final void setMinMeasuredValueVisible(boolean MIN_MEASURED_VALUE_VISIBLE) {
        this.styleModel.setMinMeasuredValueVisible(MIN_MEASURED_VALUE_VISIBLE);
    }

    public final BooleanProperty minMeasuredValueVisibleProperty() {
        return this.styleModel.minMeasuredValueVisibleProperty();
    }

    public final void resetMinMeasuredValue() {
        this.gaugeModel.resetMinMeasuredValue();
    }

    public final double getMaxMeasuredValue() {
        return this.gaugeModel.getMaxMeasuredValue();
    }

    public final void setMaxMeasuredValue(double MAX_MEASURED_VALUE) {
        this.gaugeModel.setMaxMeasuredValue(MAX_MEASURED_VALUE);
    }

    public final DoubleProperty maxMeasuredValueProperty() {
        return this.gaugeModel.maxMeasuredValueProperty();
    }

    public final boolean isMaxMeasuredValueVisible() {
        return this.styleModel.isMaxMeasuredValueVisible();
    }

    public final void setMaxMeasuredValueVisible(boolean MAX_MEASURED_VALUE_VISIBLE) {
        this.styleModel.setMaxMeasuredValueVisible(MAX_MEASURED_VALUE_VISIBLE);
    }

    public final BooleanProperty maxMeasuredValueVisibleProperty() {
        return this.styleModel.maxMeasuredValueVisibleProperty();
    }

    public final void resetMaxMeasuredValue() {
        this.gaugeModel.resetMaxMeasuredValue();
    }

    public final void resetMinMaxMeasuredValue() {
        this.gaugeModel.resetMinMaxMeasuredValue();
    }

    public final double getThreshold() {
        return this.gaugeModel.getThreshold();
    }

    public final void setThreshold(double THRESHOLD) {
        this.gaugeModel.setThreshold(THRESHOLD);
    }

    public final DoubleProperty thresholdProperty() {
        return this.gaugeModel.thresholdProperty();
    }

    public final boolean isThresholdBehaviorInverted() {
        return this.gaugeModel.isThresholdBehaviorInverted();
    }

    public final void setThresholdBehaviorInverted(boolean THRESHOLD_BEHAVIOR_INVERTED) {
        this.gaugeModel.setThresholdBehaviorInverted(THRESHOLD_BEHAVIOR_INVERTED);
    }

    public final BooleanProperty thresholdBehaviorInvertedProperty() {
        return this.gaugeModel.thresholdBehaviorInvertedProperty();
    }

    public final boolean isThresholdExceeded() {
        return this.gaugeModel.isThresholdExceeded();
    }

    public final void setThresholdExceeded(boolean THRESHOLD_EXCEEDED) {
        this.gaugeModel.setThresholdExceeded(THRESHOLD_EXCEEDED);
    }

    public final BooleanProperty thresholdExceededProperty() {
        return this.gaugeModel.thresholdExceededProperty();
    }

    public final boolean isThresholdVisible() {
        return this.styleModel.isThresholdVisible();
    }

    public final void setThresholdVisible(boolean THRESHOLD_VISIBLE) {
        this.styleModel.setThresholdVisible(THRESHOLD_VISIBLE);
    }

    public final BooleanProperty thresholdVisibleProperty() {
        return this.styleModel.thresholdVisibleProperty();
    }

    public final ThresholdColor getThresholdColor() {
        return this.styleModel.getThresholdColor();
    }

    public final void setThresholdColor(ThresholdColor THRESHOLD_COLOR) {
        this.styleModel.setThresholdColor(THRESHOLD_COLOR);
    }

    public final ObjectProperty<ThresholdColor> thresholdColorProperty() {
        return this.styleModel.thresholdColorProperty();
    }

    public final String getTitle() {
        return this.gaugeModel.getTitle();
    }

    public final void setTitle(String TITLE) {
        this.gaugeModel.setTitle(TITLE);
    }

    public final StringProperty titleProperty() {
        return this.gaugeModel.titleProperty();
    }

    public final String getUnit() {
        return this.gaugeModel.getUnit();
    }

    public final void setUnit(String UNIT) {
        this.gaugeModel.setUnit(UNIT);
    }

    public final StringProperty unitProperty() {
        return this.gaugeModel.unitProperty();
    }

    public final FrameDesign getFrameDesign() {
        return this.styleModel.getFrameDesign();
    }

    public final void setFrameDesign(FrameDesign FRAME_DESIGN) {
        this.styleModel.setFrameDesign(FRAME_DESIGN);
    }

    public final ObjectProperty<FrameDesign> frameDesignProperty() {
        return this.styleModel.frameDesignProperty();
    }

    public final Color getFrameBaseColor() {
        return this.styleModel.getFrameBaseColor();
    }

    public final void setFrameBaseColor(Color FRAME_BASE_COLOR) {
        this.styleModel.setFrameBaseColor(FRAME_BASE_COLOR);
    }

    public final ObjectProperty<Color> frameBaseColorProperty() {
        return this.styleModel.frameBaseColorProperty();
    }

    public final boolean isFrameVisible() {
        return this.styleModel.isFrameVisible();
    }

    public final void setFrameVisible(boolean FRAME_VISIBLE) {
        this.styleModel.setFrameVisible(FRAME_VISIBLE);
    }

    public final BooleanProperty frameVisibleProperty() {
        return this.styleModel.frameVisibleProperty();
    }

    public final BackgroundDesign getBackgroundDesign() {
        return this.styleModel.getBackgroundDesign();
    }

    public final void setBackgroundDesign(BackgroundDesign BACKGROUND_DESIGN) {
        this.styleModel.setBackgroundDesign(BACKGROUND_DESIGN);
    }

    public final ObjectProperty<BackgroundDesign> backgroundDesignProperty() {
        return this.styleModel.backgroundDesignProperty();
    }

    public final boolean isBackgroundVisible() {
        return this.styleModel.isBackgroundVisible();
    }

    public final void setBackgroundVisible(boolean BACKGROUND_VISIBLE) {
        this.styleModel.setBackgroundVisible(BACKGROUND_VISIBLE);
    }

    public final BooleanProperty backgroundVisibleProperty() {
        return this.styleModel.backgroundVisibleProperty();
    }

    public final KnobDesign getKnobDesign() {
        return this.styleModel.getKnobDesign();
    }

    public final void setKnobDesign(KnobDesign KNOB_DESIGN) {
        this.styleModel.setKnobDesign(KNOB_DESIGN);
    }

    public final ObjectProperty<KnobDesign> knobDesignProperty() {
        return this.styleModel.knobDesignProperty();
    }

    public final KnobColor getKnobColor() {
        return this.styleModel.getKnobColor();
    }

    public final void setKnobColor(KnobColor KNOB_COLOR) {
        this.styleModel.setKnobColor(KNOB_COLOR);
    }

    public final ObjectProperty<KnobColor> knobColorProperty() {
        return this.styleModel.knobColorProperty();
    }

    public final boolean isKnobsVisible() {
        return this.styleModel.getKnobsVisible();
    }

    public final void setKnobsVisible(boolean POSTS_VISIBLE) {
        this.styleModel.setKnobsVisible(POSTS_VISIBLE);
    }

    public final BooleanProperty knobsVisibleProperty() {
        return this.styleModel.knobsVisibleProperty();
    }

    public final PointerType getPointerType() {
        return this.styleModel.getPointerType();
    }

    public final void setPointerType(PointerType POINTER_TYPE) {
        this.styleModel.setPointerType(POINTER_TYPE);
    }

    public final ObjectProperty<PointerType> pointerTypeProperty() {
        return this.styleModel.pointerTypeProperty();
    }

    public final ColorDef getValueColor() {
        return this.styleModel.getValueColor();
    }

    public final void setValueColor(ColorDef VALUE_COLOR) {
        this.styleModel.setValueColor(VALUE_COLOR);
    }

    public final ObjectProperty<ColorDef> valueColorProperty() {
        return this.styleModel.valueColorProperty();
    }

    public final boolean isPointerGlowEnabled() {
        return this.styleModel.isPointerGlowEnabled();
    }

    public final void setPointerGlowEnabled(boolean POINTER_GLOW_ENABLED) {
        this.styleModel.setPointerGlowEnabled(POINTER_GLOW_ENABLED);
    }

    public final BooleanProperty pointerGlowEnabledProperty() {
        return this.styleModel.pointerGlowEnabledProperty();
    }

    public final boolean isPointerShadowEnabled() {
        return this.styleModel.isPointerShadowEnabled();
    }

    public final void setPointerShadowEnabled(boolean POINTER_SHADOW_ENABLED) {
        this.styleModel.setPointerShadowEnabled(POINTER_SHADOW_ENABLED);
    }

    public final BooleanProperty pointerShadowEnabledProperty() {
        return this.styleModel.pointerShadowEnabledProperty();
    }

    public final boolean isLedVisible() {
        return this.styleModel.isLedVisible();
    }

    public final void setLedVisible(boolean LED_VISIBLE) {
        this.styleModel.setLedVisible(LED_VISIBLE);
    }

    public final BooleanProperty ledVisibleProperty() {
        return this.styleModel.ledVisibleProperty();
    }

    public final LedColor getLedColor() {
        return this.styleModel.getLedColor();
    }

    public final void setLedColor(LedColor LED_COLOR) {
        this.styleModel.setLedColor(LED_COLOR);
    }

    public final ObjectProperty<LedColor> ledColorProperty() {
        return this.styleModel.ledColorProperty();
    }

    public final boolean isLedBlinking() {
        return this.styleModel.isLedBlinking();
    }

    public final void setLedBlinking(boolean LED_BLINKING) {
        this.styleModel.setLedBlinking(LED_BLINKING);
    }

    public final BooleanProperty ledBlinkingProperty() {
        return this.styleModel.ledBlinkingProperty();
    }

    public final boolean isUserLedVisible() {
        return this.styleModel.isUserLedVisible();
    }

    public final void setUserLedVisible(boolean USER_LED_VISIBLE) {
        this.styleModel.setUserLedVisible(USER_LED_VISIBLE);
    }

    public final BooleanProperty userLedVisibleProperty() {
        return this.styleModel.userLedVisibleProperty();
    }

    public final LedColor getUserLedColor() {
        return this.styleModel.getUserLedColor();
    }

    public final void setUserLedColor(LedColor USER_LED_COLOR) {
        this.styleModel.setUserLedColor(USER_LED_COLOR);
    }

    public final ObjectProperty<LedColor> userLedColorProperty() {
        return this.styleModel.userLedColorProperty();
    }

    public final boolean isUserLedOn() {
        return this.styleModel.isUserLedOn();
    }

    public final void setUserLedOn(boolean USER_LED_ON) {
        this.styleModel.setUserLedOn(USER_LED_ON);
    }

    public final BooleanProperty userLedOnProperty() {
        return this.styleModel.userLedOnProperty();
    }

    public final boolean isUserLedBlinking() {
        return this.styleModel.isUserLedBlinking();
    }

    public final void setUserLedBlinking(boolean USER_LED_BLINKING) {
        this.styleModel.setUserLedBlinking(USER_LED_BLINKING);
    }

    public final BooleanProperty userLedBlinkingProperty() {
        return this.styleModel.userLedBlinkingProperty();
    }

    public final String getTitleFont() {
        return this.styleModel.getTitleFont();
    }

    public final void setTitleFont(String TITLE_FONT) {
        this.styleModel.setTitleFont(TITLE_FONT);
    }

    public final StringProperty titleFontProperty() {
        return this.styleModel.titleFontProperty();
    }

    public final String getUnitFont() {
        return this.styleModel.getUnitFont();
    }

    public final void setUnitFont(String UNIT_FONT) {
        this.styleModel.setUnitFont(UNIT_FONT);
    }

    public final StringProperty unitFontProperty() {
        return this.styleModel.unitFontProperty();
    }

    public final Radial.ForegroundType getForegroundType() {
        return this.styleModel.getForegroundType();
    }

    public final void setForegroundType(Radial.ForegroundType FOREGROUND_TYPE) {
        this.styleModel.setForegroundType(FOREGROUND_TYPE);
    }

    public final ObjectProperty<Radial.ForegroundType> foregroundTypeProperty() {
        return this.styleModel.foregroundTypeProperty();
    }

    public final boolean isForegroundVisible() {
        return this.styleModel.isForegroundVisible();
    }

    public final void setForegroundVisible(boolean FOREGROUND_VISIBLE) {
        this.styleModel.setForegroundVisible(FOREGROUND_VISIBLE);
    }

    public final BooleanProperty foregroundVisibleProperty() {
        return this.styleModel.foregroundVisibleProperty();
    }

    public final double getLcdValue() {
        return this.gaugeModel.getLcdValue();
    }

    public final void setLcdValue(double LCD_VALUE) {
        this.gaugeModel.setLcdValue(LCD_VALUE);
    }

    public final DoubleProperty lcdValueProperty() {
        return this.gaugeModel.lcdValueProperty();
    }

    public final boolean isLcdValueCoupled() {
        return this.gaugeModel.isLcdValueCoupled();
    }

    public final void setLcdValueCoupled(boolean LCD_VALUE_COUPLED) {
        this.gaugeModel.setLcdValueCoupled(LCD_VALUE_COUPLED);
    }

    public final BooleanProperty lcdValueCoupledProperty() {
        return this.gaugeModel.lcdValueCoupledProperty();
    }

    public final double getLcdThreshold() {
        return this.gaugeModel.getLcdThreshold();
    }

    public final void setLcdThreshold(double LCD_THRESHOLD) {
        this.gaugeModel.setLcdThreshold(LCD_THRESHOLD);
    }

    public final DoubleProperty lcdThresholdProperty() {
        return this.gaugeModel.lcdThresholdProperty();
    }

    public final boolean isLcdThresholdBehaviorInverted() {
        return this.gaugeModel.isLcdThresholdBehaviorInverted();
    }

    public final void setLcdThresholdBehaviorInverted(boolean LCD_THRESHOLD_BEHAVIOR_INVERTED) {
        this.gaugeModel.setLcdThresholdBehaviorInverted(LCD_THRESHOLD_BEHAVIOR_INVERTED);
    }

    public final BooleanProperty lcdThresholdBehaviorInvertedProperty() {
        return this.gaugeModel.lcdThresholdBehaviorInvertedProperty();
    }

    public final boolean isLcdThresholdVisible() {
        return this.styleModel.isLcdThresholdVisible();
    }

    public final void setLcdThresholdVisible(boolean LCD_THRESHOLD_VISIBLE) {
        this.styleModel.setLcdThresholdVisible(LCD_THRESHOLD_VISIBLE);
    }

    public final BooleanProperty lcdThresholdVisibleProperty() {
        return this.styleModel.lcdThresholdVisibleProperty();
    }

    public final LcdDesign getLcdDesign() {
        return this.styleModel.getLcdDesign();
    }

    public final void setLcdDesign(LcdDesign LCD_Design) {
        this.styleModel.setLcdDesign(LCD_Design);
    }

    public final ObjectProperty lcdDesignProperty() {
        return this.styleModel.lcdDesignProperty();
    }

    public final boolean isLcdVisible() {
        return this.styleModel.isLcdVisible();
    }

    public final void setLcdVisible(boolean LCD_VISIBLE) {
        this.styleModel.setLcdVisible(LCD_VISIBLE);
    }

    public final BooleanProperty lcdVisibleProperty() {
        return this.styleModel.lcdVisibleProperty();
    }

    public final String getLcdUnit() {
        return this.gaugeModel.getLcdUnit();
    }

    public final void setLcdUnit(String LCD_UNIT) {
        this.gaugeModel.setLcdUnit(LCD_UNIT);
    }

    public final StringProperty lcdUnitProperty() {
        return this.gaugeModel.lcdUnitProperty();
    }

    public final boolean isLcdUnitVisible() {
        return this.styleModel.getLcdUnitVisible();
    }

    public final void setLcdUnitVisible(boolean LCD_UNIT_VISIBLE) {
        this.styleModel.setLcdUnitVisible(LCD_UNIT_VISIBLE);
    }

    public final BooleanProperty lcdUnitVisibleProperty() {
        return this.styleModel.lcdUnitVisibleProperty();
    }

    public final String getLcdUnitFont() {
        return this.styleModel.getLcdUnitFont();
    }

    public final void setLcdUnitFont(String LCD_UNIT_FONT) {
        this.styleModel.setLcdUnitFont(LCD_UNIT_FONT);
    }

    public final StringProperty lcdUnitFontProperty() {
        return this.styleModel.lcdUnitFontProperty();
    }

    public final String getLcdTitleFont() {
        return this.styleModel.getLcdTitleFont();
    }

    public final void setLcdTitleFont(String LCD_TITLE_FONT) {
        this.styleModel.setLcdTitleFont(LCD_TITLE_FONT);
    }

    public final StringProperty lcdTitleFontProperty() {
        return this.styleModel.lcdTitleFontProperty();
    }

    public final LcdFont getLcdValueFont() {
        return this.styleModel.getLcdValueFont();
    }

    public final void setLcdValueFont(LcdFont VALUE_FONT) {
        this.styleModel.setLcdValueFont(VALUE_FONT);
    }

    public final ObjectProperty<LcdFont> lcdValueFontProperty() {
        return this.styleModel.lcdValueFontProperty();
    }

    public final NumberSystem getLcdNumberSystem() {
        return this.gaugeModel.getLcdNumberSystem();
    }

    public final void setLcdNumberSystem(NumberSystem LCD_NUMBER_SYSTEM) {
        this.gaugeModel.setLcdNumberSystem(LCD_NUMBER_SYSTEM);
    }

    public final ObjectProperty lcdNumberSystemProperty() {
        return this.gaugeModel.lcdNumberSystemProperty();
    }

    public final boolean isLcdNumberSystemVisible() {
        return this.styleModel.isLcdNumberSystemVisible();
    }

    public final void setLcdNumberSystemVisible(boolean LCD_NUMBER_SYSTEM_VISIBLE) {
        this.styleModel.setLcdNumberSystemVisible(LCD_NUMBER_SYSTEM_VISIBLE);
    }

    public final BooleanProperty lcdNumberSystemVisibleProperty() {
        return this.styleModel.lcdNumberSystemVisibleProperty();
    }

    public final int getLcdDecimals() {
        return this.styleModel.getLcdDecimals();
    }

    public final void setLcdDecimals(int LCD_DECIMALS) {
        this.styleModel.setLcdDecimals(LCD_DECIMALS);
    }

    public final IntegerProperty lcdDecimalsProperty() {
        return this.styleModel.lcdDecimalsProperty();
    }

    public final boolean isLcdBlinking() {
        return this.styleModel.isLcdBlinking();
    }

    public final void setLcdBlinking(boolean LCD_BLINKING) {
        this.styleModel.setLcdBlinking(LCD_BLINKING);
    }

    public final BooleanProperty lcdBlinkingProperty() {
        return this.styleModel.lcdBlinkingProperty();
    }

    public final boolean isLcdBackgroundVisible() {
        return this.styleModel.isLcdBackgroundVisible();
    }

    public final void setLcdBackgroundVisible(boolean LCD_BACKGROUND_VISIBLE) {
        this.styleModel.setLcdBackgroundVisible(LCD_BACKGROUND_VISIBLE);
    }

    public final BooleanProperty lcdBackgroundVisibleProperty() {
        return this.styleModel.lcdBackgroundVisibleProperty();
    }

    public final boolean isGlowVisible() {
        return this.styleModel.isGlowVisible();
    }

    public final void setGlowVisible(boolean GLOW_VISIBLE) {
        this.styleModel.setGlowVisible(GLOW_VISIBLE);
    }

    public final BooleanProperty glowVisibleProperty() {
        return this.styleModel.glowVisibleProperty();
    }

    public final boolean isGlowOn() {
        return this.styleModel.isGlowOn();
    }

    public final void setGlowOn(boolean GLOW_ON) {
        this.styleModel.setGlowOn(GLOW_ON);
    }

    public final BooleanProperty glowOnProperty() {
        return this.styleModel.glowOnProperty();
    }

    public final boolean isPulsatingGlow() {
        return this.styleModel.isPulsatingGlow();
    }

    public final void setPulsatingGlow(boolean PULSATING_GLOW) {
        this.styleModel.setPulsatingGlow(PULSATING_GLOW);
    }

    public final BooleanProperty pulsatingGlowProperty() {
        return this.styleModel.pulsatingGlowProperty();
    }

    public final Color getGlowColor() {
        return this.styleModel.getGlowColor();
    }

    public final void setGlowColor(Color GLOW_COLOR) {
        this.styleModel.setGlowColor(GLOW_COLOR);
    }

    public final ObjectProperty<Color> glowColorProperty() {
        return this.styleModel.glowColorProperty();
    }

    public final boolean isTickmarksVisible() {
        return this.styleModel.isTickmarksVisible();
    }

    public final void setTickmarksVisible(boolean TICKMARKS_VISIBLE) {
        this.styleModel.setTickmarksVisible(TICKMARKS_VISIBLE);
    }

    public final BooleanProperty tickmarksVisibleProperty() {
        return this.styleModel.tickmarksVisibleProperty();
    }

    public final boolean isMajorTicksVisible() {
        return this.styleModel.isMajorTicksVisible();
    }

    public final void setMajorTicksVisible(boolean MAJOR_TICKS_VISIBLE) {
        this.styleModel.setMajorTicksVisible(MAJOR_TICKS_VISIBLE);
    }

    public final BooleanProperty majorTicksVisibleProperty() {
        return this.styleModel.majorTicksVisibleProperty();
    }

    public final TickmarkType getMajorTickmarkType() {
        return this.styleModel.getMajorTickmarkType();
    }

    public final void setMajorTickmarkType(TickmarkType TICKMARK_TYPE) {
        this.styleModel.setMajorTickmarkType(TICKMARK_TYPE);
    }

    public final ObjectProperty<TickmarkType> majorTickmarkTypeProperty() {
        return this.styleModel.majorTickmarkTypeProperty();
    }

    public final Color getMajorTickmarkColor() {
        return this.styleModel.getMajorTickmarkColor();
    }

    public final void setMajorTickmarkColor(Color MAJOR_TICKMARK_COLOR) {
        this.styleModel.setMajorTickmarkColor(MAJOR_TICKMARK_COLOR);
    }

    public final ObjectProperty<Color> majorTickmarkColorProperty() {
        return this.styleModel.majorTickmarkColorProperty();
    }

    public final boolean isMajorTickmarkColorEnabled() {
        return this.styleModel.isMajorTickmarkColorEnabled();
    }

    public final void setMajorTickmarkColorEnabled(boolean MAJOR_TICKMARK_COLOR_ENABLED) {
        this.styleModel.setMajorTickmarkColorEnabled(MAJOR_TICKMARK_COLOR_ENABLED);
    }

    public final BooleanProperty majorTickmarkColorEnabledProperty() {
        return this.styleModel.majorTickmarkColorEnabledProperty();
    }

    public final boolean isMinorTicksVisible() {
        return this.styleModel.isMinorTicksVisible();
    }

    public final void setMinorTicksVisible(boolean MINOR_TICKS_VISIBLE) {
        this.styleModel.setMinorTicksVisible(MINOR_TICKS_VISIBLE);
    }

    public final BooleanProperty minorTicksVisibleProperty() {
        return this.styleModel.minorTicksVisibleProperty();
    }

    public final Color getMinorTickmarkColor() {
        return this.styleModel.getMinorTickmarkColor();
    }

    public final void setMinorTickmarkColor(Color MINOR_TICKMARK_COLOR) {
        this.styleModel.setMinorTickmarkColor(MINOR_TICKMARK_COLOR);
    }

    public final ObjectProperty<Color> minorTickmarkColorProperty() {
        return this.styleModel.minorTickmarkColorProperty();
    }

    public final boolean isMinorTickmarkColorEnabled() {
        return this.styleModel.isMinorTickmarkColorEnabled();
    }

    public final void setMinorTickmarkColorEnabled(boolean MINOR_TICKMARK_COLOR_ENABLED) {
        this.styleModel.setMinorTickmarkColorEnabled(MINOR_TICKMARK_COLOR_ENABLED);
    }

    public final BooleanProperty minorTickmarkColorEnabledProperty() {
        return this.styleModel.minorTickmarkColorEnabledProperty();
    }

    public final boolean isTickLabelsVisible() {
        return this.styleModel.isTickLabelsVisible();
    }

    public final void setTickLabelsVisible(boolean TICKLABELS_VISIBLE) {
        this.styleModel.setTickLabelsVisible(TICKLABELS_VISIBLE);
    }

    public final BooleanProperty ticklabelsVisibleProperty() {
        return this.styleModel.ticklabelsVisibleProperty();
    }

    public final TicklabelOrientation getTickLabelOrientation() {
        return this.styleModel.getTickLabelOrientation();
    }

    public final void setTickLabelOrientation(TicklabelOrientation TICKLABEL_ORIENTATION) {
        this.styleModel.setTickLabelOrientation(TICKLABEL_ORIENTATION);
    }

    public final ObjectProperty<TicklabelOrientation> tickLabelOrientationProperty() {
        return this.styleModel.tickLabelOrientationProperty();
    }

    public final NumberFormat getTickLabelNumberFormat() {
        return this.styleModel.getTickLabelNumberFormat();
    }

    public final void setTickLabelNumberFormat(NumberFormat TICKLABEL_NUMBER_FORMAT) {
        this.styleModel.setTickLabelNumberFormat(TICKLABEL_NUMBER_FORMAT);
    }

    public final ObjectProperty<NumberFormat> tickLabelNumberFormatProperty() {
        return this.styleModel.tickLabelNumberFormatProperty();
    }

    public final Point2D getTickmarksOffset() {
        return this.styleModel.getTickmarksOffset();
    }

    public final void setTickmarksOffset(Point2D TICKMARKS_OFFSET) {
        this.styleModel.setTickmarksOffset(TICKMARKS_OFFSET);
    }

    public final ObjectProperty<Point2D> tickmarksOffsetProperty() {
        return this.styleModel.tickmarksOffsetProperty();
    }

    public final boolean isTickmarkGlowEnabled() {
        return this.styleModel.isTickmarkGlowEnabled();
    }

    public final void setTickmarkGlowEnabled(boolean TICKMARK_GLOW_ENABLED) {
        this.styleModel.setTickmarkGlowEnabled(TICKMARK_GLOW_ENABLED);
    }

    public final BooleanProperty tickmarkGlowEnabledProperty() {
        return this.styleModel.tickmarkGlowEnabledProperty();
    }

    public final Color getTickmarkGlowColor() {
        return this.styleModel.getTickmarkGlowColor();
    }

    public final void setTickmarkGlowColor(Color TICKMARK_GLOW_COLOR) {
        this.styleModel.setTickmarkGlowColor(TICKMARK_GLOW_COLOR);
    }

    public final ObjectProperty<Color> tickmarkGlowProperty() {
        return this.styleModel.tickmarkGlowColorProperty();
    }

    public final int getMaxNoOfMajorTicks() {
        return this.gaugeModel.getMaxNoOfMajorTicks();
    }

    public final void setMaxNoOfMajorTicks(int MAX_NO_OF_MAJOR_TICKS) {
        this.gaugeModel.setMaxNoOfMajorTicks(MAX_NO_OF_MAJOR_TICKS);
    }

    public final IntegerProperty maxNoOfMajorTicksProperty() {
        return this.gaugeModel.maxNoOfMajorTicksProperty();
    }

    public final int getMaxNoOfMinorTicks() {
        return this.gaugeModel.getMaxNoOfMinorTicks();
    }

    public final void setMaxNoOfMinorTicks(int MAX_NO_OF_MINOR_TICKS) {
        this.gaugeModel.setMaxNoOfMinorTicks(MAX_NO_OF_MINOR_TICKS);
    }

    public final IntegerProperty maxNoOfMinorTicksProperty() {
        return this.gaugeModel.maxNoOfMinorTicksProperty();
    }

    public final double getMajorTickSpacing() {
        return this.gaugeModel.getMajorTickSpacing();
    }

    public final void setMajorTickSpacing(double MAJOR_TICK_SPACING) {
        this.gaugeModel.setMajorTickSpacing(MAJOR_TICK_SPACING);
    }

    public final DoubleProperty majorTickSpacingProperty() {
        return this.gaugeModel.majorTickSpacingProperty();
    }

    public final double getMinorTickSpacing() {
        return this.gaugeModel.getMinorTickSpacing();
    }

    public final void setMinorTickSpacing(double MINOR_TICK_SPACING) {
        this.gaugeModel.setMinorTickSpacing(MINOR_TICK_SPACING);
    }

    public final DoubleProperty minorTickSpacingProperty() {
        return this.gaugeModel.minorTickSpacingProperty();
    }

    public final boolean isNiceScaling() {
        return this.gaugeModel.isNiceScaling();
    }

    public final void setNiceScaling(boolean NICE_SCALING) {
        this.gaugeModel.setNiceScaling(NICE_SCALING);
        this.recalcRange();
    }

    public final BooleanProperty niceScalingProperty() {
        return this.gaugeModel.niceScalingProperty();
    }

    public final boolean isTightScale() {
        return this.gaugeModel.isTightScale();
    }

    public final void setTightScale(boolean TIGHT_SCALE) {
        this.gaugeModel.setTightScale(TIGHT_SCALE);
    }

    public final BooleanProperty tightScaleProperty() {
        return this.gaugeModel.tightScaleProperty();
    }

    public final double getTightScaleOffset() {
        return this.gaugeModel.getTightScaleOffset();
    }

    public final boolean isLargeNumberScale() {
        return this.gaugeModel.isLargeNumberScale();
    }

    public final void setLargeNumberScale(boolean LARGE_NUMBER_SCALE) {
        this.gaugeModel.setLargeNumberScale(LARGE_NUMBER_SCALE);
    }

    public final BooleanProperty largeNumberScaleProperty() {
        return this.gaugeModel.largeNumberScaleProperty();
    }

    public final boolean isLastLabelVisible() {
        return this.gaugeModel.isLastLabelVisible();
    }

    public final void setLastLabelVisible(boolean LAST_LABEL_VISIBLE) {
        this.gaugeModel.setLastLabelVisible(LAST_LABEL_VISIBLE);
    }

    public final BooleanProperty lastLabelVisibleProperty() {
        return this.gaugeModel.lastLabelVisibleProperty();
    }

    public final ObservableList<Section> getSections() {
        return this.gaugeModel.getSections();
    }

    public final void addSection(Section SECTION) {
        this.gaugeModel.addSection(SECTION);
    }

    public final void addAllSections(Section ... SECTIONS) {
        for (Section section : SECTIONS) {
            this.gaugeModel.addSection(section);
        }
    }

    public final void addAllSections(List<Section> SECTIONS) {
        for (Section section : SECTIONS) {
            this.gaugeModel.addSection(section);
        }
    }

    public final void removeSection(Section SECTION) {
        this.gaugeModel.removeSection(SECTION);
    }

    public final void resetSections() {
        this.gaugeModel.resetSections();
    }

    public final boolean isSectionsVisible() {
        return this.styleModel.isSectionsVisible();
    }

    public final void setSectionsVisible(boolean SECTIONS_VISIBLE) {
        this.styleModel.setSectionsVisible(SECTIONS_VISIBLE);
    }

    public final BooleanProperty sectionsVisibleProperty() {
        return this.styleModel.sectionsVisibleProperty();
    }

    public final boolean isExpandedSections() {
        return this.styleModel.isExpandedSections();
    }

    public final void setExpandedSections(boolean EXPANDED_SECTIONS) {
        this.styleModel.setExpandedSections(EXPANDED_SECTIONS);
    }

    public final BooleanProperty expandedSectionsProperty() {
        return this.styleModel.expandedSectionsProperty();
    }

    public final boolean isSectionsHighlighting() {
        return this.styleModel.isSectionsHighlighting();
    }

    public final void setSectionsHighlighting(boolean SECTIONS_HIGHLIGHTING) {
        this.styleModel.setSectionsHighlighting(SECTIONS_HIGHLIGHTING);
    }

    public final BooleanProperty sectionsHighlightingProperty() {
        return this.styleModel.sectionsHighlightingProperty();
    }

    public final boolean isShowSectionTickmarksOnly() {
        return this.styleModel.isShowSectionTickmarksOnly();
    }

    public final void setShowSectionTickmarksOnly(boolean SHOW_SECTION_TICKMARKS_ONLY) {
        this.styleModel.setShowSectionTickmarksOnly(SHOW_SECTION_TICKMARKS_ONLY);
    }

    public final BooleanProperty showSectionTickmarksOnlyProperty() {
        return this.styleModel.showSectionTickmarksOnlyProperty();
    }

    public final ObservableList<Section> getAreas() {
        return this.gaugeModel.getAreas();
    }

    public final void addArea(Section AREA) {
        this.gaugeModel.addArea(AREA);
    }

    public final void addAllAreas(Section ... AREAS) {
        for (Section area : AREAS) {
            this.gaugeModel.addArea(area);
        }
    }

    public final void addAllAreas(List<Section> AREAS) {
        for (Section area : AREAS) {
            this.gaugeModel.addArea(area);
        }
    }

    public final void removeArea(Section AREA) {
        this.gaugeModel.removeArea(AREA);
    }

    public final void resetAreas() {
        this.gaugeModel.resetAreas();
    }

    public final boolean isAreasVisible() {
        return this.styleModel.isAreasVisible();
    }

    public final void setAreasVisible(boolean AREAS_VISIBLE) {
        this.styleModel.setAreasVisible(AREAS_VISIBLE);
    }

    public final BooleanProperty areasVisibleProperty() {
        return this.styleModel.areasVisibleProperty();
    }

    public final boolean isAreasHighlighting() {
        return this.styleModel.isAreasHighlighting();
    }

    public final void setAreasHighlighting(boolean AREAS_HIGHLIGHTING) {
        this.styleModel.setAreasHighlighting(AREAS_HIGHLIGHTING);
    }

    public final BooleanProperty areasHighlightingProperty() {
        return this.styleModel.areasHighlightingProperty();
    }

    public final ObservableList<Section> getTickMarkSections() {
        return this.gaugeModel.getTickMarkSections();
    }

    public final void addTickMarkSection(Section TICK_MARK_SECTION) {
        this.gaugeModel.addTickMarkSection(TICK_MARK_SECTION);
    }

    public final void removeTickMarkSection(Section TICK_MARK_SECTION) {
        this.gaugeModel.removeTickMarkSection(TICK_MARK_SECTION);
    }

    public final void resetTickMarkSections() {
        this.gaugeModel.resetTickMarkSections();
    }

    public final ObservableList<Marker> getMarkers() {
        return this.gaugeModel.getMarkers();
    }

    public final void addMarker(Marker MARKER) {
        this.gaugeModel.addMarker(MARKER);
    }

    public final void removeMarker(Marker MARKER) {
        this.gaugeModel.removeMarker(MARKER);
    }

    public final void resetMarkers() {
        this.gaugeModel.resetMarkers();
    }

    public final boolean isMarkersVisible() {
        return this.styleModel.isMarkersVisible();
    }

    public final void setMarkersVisible(boolean INDICATORS_VISIBLE) {
        this.styleModel.setMarkersVisible(INDICATORS_VISIBLE);
    }

    public final BooleanProperty markersVisibleProperty() {
        return this.styleModel.markersVisibleProperty();
    }

    public final boolean isEndlessMode() {
        return this.gaugeModel.isEndlessMode();
    }

    public final void setEndlessMode(boolean ENDLESS_MODE) {
        if (this.getRadialRange() == RadialRange.RADIAL_360) {
            this.gaugeModel.setEndlessMode(ENDLESS_MODE);
        }
    }

    public final Color getTextureColor() {
        return this.styleModel.getTextureColor();
    }

    public final String getTextureColorString() {
        return this.styleModel.getTextureColorString();
    }

    public final void setTextureColor(Color TEXTURE_COLOR) {
        this.styleModel.setTextureColor(TEXTURE_COLOR);
    }

    public final ObjectProperty<Color> textureColorProperty() {
        return this.styleModel.textureColorProperty();
    }

    public final Color getSimpleGradientBaseColor() {
        return this.styleModel.getSimpleGradientBaseColor();
    }

    public final String getSimpleGradientBaseColorString() {
        return this.styleModel.getSimpleGradientBaseColorString();
    }

    public final void setSimpleGradientBaseColor(Color SIMPLE_GRADIENT_BASE_COLOR) {
        this.styleModel.setSimpleGradientBaseColor(SIMPLE_GRADIENT_BASE_COLOR);
    }

    public final ObjectProperty<Color> simpleGradientBaseColorProperty() {
        return this.styleModel.simpleGradientBaseColorProperty();
    }

    public final boolean isTitleVisible() {
        return this.styleModel.isTitleVisible();
    }

    public final void setTitleVisible(boolean TITLE_VISIBLE) {
        this.styleModel.setTitleVisible(TITLE_VISIBLE);
    }

    public final BooleanProperty titleVisibleProperty() {
        return this.styleModel.titleVisibleProperty();
    }

    public final boolean isUnitVisible() {
        return this.styleModel.isUnitVisible();
    }

    public final void setUnitVisible(boolean UNIT_VISIBLE) {
        this.styleModel.setUnitVisible(UNIT_VISIBLE);
    }

    public final BooleanProperty unitVisibleProperty() {
        return this.styleModel.unitVisibleProperty();
    }

    public final Trend getTrend() {
        return this.gaugeModel.getTrend();
    }

    public final void setTrend(Trend TREND) {
        this.gaugeModel.setTrend(TREND);
    }

    public final ObjectProperty<Trend> trendProperty() {
        return this.gaugeModel.trendProperty();
    }

    public final boolean isTrendVisible() {
        return this.styleModel.isTrendVisible();
    }

    public final void setTrendVisible(boolean TREND_VISIBLE) {
        this.styleModel.setTrendVisible(TREND_VISIBLE);
    }

    public final BooleanProperty trendVisibleProperty() {
        return this.styleModel.trendVisibleProperty();
    }

    public final Color getTrendUpColor() {
        return this.styleModel.getTrendUpColor();
    }

    public final void setTrendUpColor(Color TREND_UP_COLOR) {
        this.styleModel.setTrendUpColor(TREND_UP_COLOR);
    }

    public final ObjectProperty<Color> trendUpColorProperty() {
        return this.styleModel.trendUpColorProperty();
    }

    public final Color getTrendRisingColor() {
        return this.styleModel.getTrendRisingColor();
    }

    public final void setTrendRisingColor(Color TREND_RISING_COLOR) {
        this.styleModel.setTrendRisingColor(TREND_RISING_COLOR);
    }

    public final ObjectProperty<Color> trendRisingColorProperty() {
        return this.styleModel.trendRisingColorProperty();
    }

    public final Color getTrendSteadyColor() {
        return this.styleModel.getTrendSteadyColor();
    }

    public final void setTrendSteadyColor(Color TREND_STEADY_COLOR) {
        this.styleModel.setTrendSteadyColor(TREND_STEADY_COLOR);
    }

    public final ObjectProperty<Color> trendSteadyColorProperty() {
        return this.styleModel.trendSteadyColorProperty();
    }

    public final Color getTrendFallingColor() {
        return this.styleModel.getTrendFallingColor();
    }

    public final void setTrendFallingColor(Color TREND_FALLING_COLOR) {
        this.styleModel.setTrendFallingColor(TREND_FALLING_COLOR);
    }

    public final ObjectProperty<Color> trendFallingColorProperty() {
        return this.styleModel.trendFallingColorProperty();
    }

    public final Color getTrendDownColor() {
        return this.styleModel.getTrendDownColor();
    }

    public final void setTrendDownColor(Color TREND_DOWN_COLOR) {
        this.styleModel.setTrendDownColor(TREND_DOWN_COLOR);
    }

    public final ObjectProperty<Color> trendDownColorProperty() {
        return this.styleModel.trendDownColorProperty();
    }

    public static enum Trend {
        UP,
        RISING,
        STEADY,
        FALLING,
        DOWN,
        UNKNOWN;

    }

    public static enum TicklabelOrientation {
        NORMAL,
        HORIZONTAL,
        TANGENT;

    }

    public static enum TickmarkType {
        LINE,
        TRIANGLE;

    }

    public static enum ThresholdColor {
        RED("-fx-red;", Color.rgb((int)213, (int)0, (int)0)),
        GREEN("-fx-green;", Color.rgb((int)0, (int)148, (int)0)),
        BLUE("-fx-blue;", Color.rgb((int)0, (int)120, (int)220)),
        ORANGE("-fx-orange;", Color.rgb((int)248, (int)142, (int)0)),
        YELLOW("-fx-yellow;", Color.rgb((int)210, (int)204, (int)0)),
        CYAN("-fx-cyan;", Color.rgb((int)0, (int)159, (int)215)),
        MAGENTA("-fx-magenta;", Color.rgb((int)223, (int)42, (int)125)),
        LILA("-fx-lila", Color.rgb((int)71, (int)0, (int)255)),
        WHITE("-fx-white;", Color.rgb((int)245, (int)245, (int)245)),
        GRAY("-fx-gray;", Color.rgb((int)102, (int)102, (int)102)),
        BLACK("-fx-black;", Color.rgb((int)15, (int)15, (int)15)),
        RAITH("-fx-raith;", Color.rgb((int)65, (int)143, (int)193)),
        GREEN_LCD("-fx-green-lcd;", Color.rgb((int)24, (int)220, (int)183)),
        JUG_GREEN("-fx-jug-green;", Color.rgb((int)90, (int)183, (int)0)),
        CUSTOM("-fx-custom;", Color.rgb((int)0, (int)195, (int)97));

        public final String CSS;
        public final Color COLOR;

        private ThresholdColor(String CSS_COLOR, Color COLOR) {
            this.CSS = "-fx-threshold: " + CSS_COLOR;
            this.COLOR = COLOR;
        }
    }

    public static enum RadialRange {
        RADIAL_360(360.0, 0.0, 0.0, new Rectangle(0.4, 0.56, 0.4, 0.12), 0.0, new Point2D(0.6, 0.4), new Point2D(0.3, 0.4), 1.0, 0.38),
        RADIAL_300(300.0, -150.0, 240.0, new Rectangle(0.4, 0.56, 0.4, 0.12), 150.0, new Point2D(0.6, 0.4), new Point2D(0.3, 0.4), 1.0, 0.38),
        RADIAL_280(280.0, -140.0, 280.0, new Rectangle(0.4, 0.56, 0.4, 0.12), 150.0, new Point2D(0.6, 0.4), new Point2D(0.3, 0.4), 1.0, 0.38),
        RADIAL_270(270.0, -180.0, 270.0, new Rectangle(0.4, 0.56, 0.4, 0.12), 180.0, new Point2D(0.6, 0.4), new Point2D(0.3, 0.4), 1.0, 0.38),
        RADIAL_180(180.0, -90.0, 180.0, new Rectangle(0.55, 0.56, 0.55, 0.12), 90.0, new Point2D(0.6, 0.4), new Point2D(0.3, 0.4), 1.0, 0.38),
        RADIAL_180N(180.0, -90.0, 180.0, new Rectangle(0.55, 0.56, 0.55, 0.12), 90.0, new Point2D(0.6, 0.35), new Point2D(0.3, 0.35), 1.0, 0.38),
        RADIAL_180S(180.0, -90.0, 180.0, new Rectangle(0.55, 0.56, 0.55, 0.12), 0.0, new Point2D(0.6, 0.2), new Point2D(0.3, 0.2), -1.0, 0.38),
        RADIAL_90(90.0, -90.0, 180.0, new Rectangle(0.55, 0.56, 0.55, 0.12), 91.0, new Point2D(0.6, 0.4), new Point2D(0.3, 0.4), 1.0, 0.38),
        RADIAL_90N(90.0, 315.0, 225.0, new Rectangle(0.55, 0.52, 0.55, 0.12), 45.0, new Point2D(0.6, 0.4), new Point2D(0.3, 0.4), 1.0, 0.5),
        RADIAL_90W(90.0, 225.0, 45.0, new Rectangle(0.2, 0.58, 0.45, 0.12), 135.0, new Point2D(0.12, 0.35), new Point2D(0.12, 0.55), 1.0, 0.5),
        RADIAL_90S(90.0, -135.0, 45.0, new Rectangle(0.55, 0.36, 0.55, 0.12), 225.0, new Point2D(0.6, 0.5), new Point2D(0.3, 0.5), -1.0, 0.5),
        RADIAL_90E(90.0, 135.0, 225.0, new Rectangle(0.2, 0.58, 0.45, 0.12), -315.0, new Point2D(0.78, 0.35), new Point2D(0.78, 0.55), -1.0, 0.5);

        public final double ANGLE_RANGE;
        public final double ROTATION_OFFSET;
        public final double SECTIONS_OFFSET;
        public final Rectangle LCD_FACTORS;
        public final double TICKLABEL_ORIENATION_CHANGE_ANGLE;
        public final Point2D LED_POSITION;
        public final Point2D USER_LED_POSITION;
        public final double ANGLE_STEP_SIGN;
        public final double RADIUS_FACTOR;

        private RadialRange(double ANGLE_RANGE, double ROTATION_OFFSET, double SECTIONS_OFFSET, Rectangle LCD_FACTORS, double TICKLABEL_ORIENATION_CHANGE_ANGLE, Point2D LED_POSITION, Point2D USER_LED_POSITION, double ANGLE_STEP_SIGN, double RADIUS_FACTOR) {
            this.ANGLE_RANGE = ANGLE_RANGE;
            this.ROTATION_OFFSET = ROTATION_OFFSET;
            this.SECTIONS_OFFSET = SECTIONS_OFFSET;
            this.LCD_FACTORS = LCD_FACTORS;
            this.TICKLABEL_ORIENATION_CHANGE_ANGLE = TICKLABEL_ORIENATION_CHANGE_ANGLE;
            this.LED_POSITION = LED_POSITION;
            this.USER_LED_POSITION = USER_LED_POSITION;
            this.ANGLE_STEP_SIGN = ANGLE_STEP_SIGN;
            this.RADIUS_FACTOR = RADIUS_FACTOR;
        }
    }

    public static enum PointerType {
        TYPE1,
        TYPE2,
        TYPE3,
        TYPE4,
        TYPE5,
        TYPE6,
        TYPE7,
        TYPE8,
        TYPE9,
        TYPE10,
        TYPE11,
        TYPE12,
        TYPE13,
        TYPE14,
        TYPE15,
        TYPE16;

    }

    public static enum NumberSystem {
        DECIMAL("dec"),
        HEXADECIMAL("hex"),
        OCTAL("oct");

        private String text;

        private NumberSystem(String TEXT) {
            this.text = TEXT;
        }

        public String toString() {
            return this.text;
        }
    }

    public static enum NumberFormat {
        AUTO("0"),
        STANDARD("0"),
        FRACTIONAL("0.0#"),
        SCIENTIFIC("0.##E0"),
        PERCENTAGE("##0.0%");

        private final DecimalFormat DF;

        private NumberFormat(String FORMAT_STRING) {
            this.DF = new DecimalFormat(FORMAT_STRING, new DecimalFormatSymbols(Locale.US));
        }

        public String format(Number NUMBER) {
            return this.DF.format(NUMBER);
        }
    }

    public static enum LcdFont {
        STANDARD,
        LCD,
        BUS,
        PIXEL,
        PHONE_LCD;

    }

    public static enum KnobDesign {
        STANDARD,
        PLAIN,
        METAL,
        BIG;

    }

    public static enum KnobColor {
        BLACK,
        BRASS,
        SILVER;

    }

    public static enum FrameDesign {
        BLACK_METAL("frame-design-blackmetal"),
        SHINY_METAL("frame-design-shinymetal"),
        CHROME("frame-design-chrome"),
        METAL("frame-design-metal"),
        GLOSSY_METAL("frame-design-glossymetal"),
        DARK_GLOSSY("frame-design-darkglossy"),
        BRASS("frame-design-brass"),
        STEEL("frame-design-steel"),
        GOLD("frame-design-gold"),
        ANTHRACITE("frame-design-anthracite"),
        TILTED_GRAY("frame-design-tiltedgray"),
        TILTED_BLACK("frame-design-tiltedblack"),
        CUSTOM("frame-design-custom");

        public final String CSS;

        private FrameDesign(String CSS) {
            this.CSS = CSS;
        }
    }

    public static enum BackgroundDesign {
        DARK_GRAY("background-design-darkgray"),
        SATIN_GRAY("background-design-satingray"),
        LIGHT_GRAY("background-design-lightgray"),
        WHITE("background-design-white"),
        BLACK("background-design-black"),
        BEIGE("background-design-beige"),
        BROWN("background-design-brown"),
        RED("background-design-red"),
        GREEN("background-design-green"),
        BLUE("background-design-blue"),
        ANTHRACITE("background-design-anthracite"),
        MUD("background-design-mud"),
        CARBON("background-design-carbon"),
        STAINLESS("background-design-stainless"),
        BRUSHED_METAL("background-design-brushedmetal"),
        PUNCHED_SHEET("background-design-punchedsheet"),
        NOISY_PLASTIC("backgroundd-design-noisyplastic"),
        SIMPLE_GRADIENT("background-design-simplegradient"),
        TRANSPARENT("background-design-transparent"),
        CUSTOM("background-design-custom");

        public final String CSS_BACKGROUND;
        public final String CSS_TEXT;

        private BackgroundDesign(String CSS_BACKGROUND) {
            this.CSS_BACKGROUND = CSS_BACKGROUND;
            this.CSS_TEXT = CSS_BACKGROUND + "-text";
        }
    }
}

