/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.scene.control.gauge;

import java.util.List;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.event.EventType;
import jfxtras.labs.scene.control.gauge.Gauge;
import jfxtras.labs.scene.control.gauge.LinearScale;
import jfxtras.labs.scene.control.gauge.Marker;
import jfxtras.labs.scene.control.gauge.Section;

public class GaugeModel {
    private DoubleProperty value;
    private DoubleProperty realValue;
    private DoubleProperty formerValue;
    private BooleanProperty valueAnimationEnabled;
    private DoubleProperty animationDuration;
    private DoubleProperty redrawTolerance;
    private DoubleProperty minMeasuredValue;
    private DoubleProperty maxMeasuredValue;
    private DoubleProperty threshold;
    private BooleanProperty thresholdBehaviorInverted;
    private BooleanProperty thresholdExceeded;
    private StringProperty title;
    private StringProperty unit;
    private DoubleProperty lcdValue;
    private BooleanProperty lcdValueCoupled;
    private DoubleProperty lcdThreshold;
    private BooleanProperty lcdThresholdBehaviorInverted;
    private StringProperty lcdUnit;
    private ObjectProperty<Gauge.NumberSystem> lcdNumberSystem;
    private ObjectProperty<LinearScale> scale;
    private ObjectProperty<Gauge.Trend> trend;
    private ObservableList<Section> sections;
    private ObservableList<Section> areas;
    private ObservableList<Section> tickMarkSections;
    private ObservableList<Marker> markers;
    private BooleanProperty endlessMode;
    private ObjectProperty<EventHandler<GaugeModelEvent>> onGaugeModelEvent = new SimpleObjectProperty();

    public GaugeModel() {
        this.value = new SimpleDoubleProperty(0.0);
        this.realValue = new SimpleDoubleProperty(0.0);
        this.formerValue = new SimpleDoubleProperty(0.0);
        this.valueAnimationEnabled = new SimpleBooleanProperty(true);
        this.animationDuration = new SimpleDoubleProperty(800.0);
        this.redrawTolerance = new SimpleDoubleProperty(0.0);
        this.minMeasuredValue = new SimpleDoubleProperty(100.0);
        this.maxMeasuredValue = new SimpleDoubleProperty(0.0);
        this.threshold = new SimpleDoubleProperty(50.0);
        this.thresholdBehaviorInverted = new SimpleBooleanProperty(false);
        this.thresholdExceeded = new SimpleBooleanProperty(false);
        this.title = new SimpleStringProperty("");
        this.unit = new SimpleStringProperty("");
        this.lcdValue = new SimpleDoubleProperty(0.0);
        this.lcdValueCoupled = new SimpleBooleanProperty(true);
        this.lcdThreshold = new SimpleDoubleProperty(50.0);
        this.lcdThresholdBehaviorInverted = new SimpleBooleanProperty(false);
        this.lcdUnit = new SimpleStringProperty("");
        this.lcdNumberSystem = new SimpleObjectProperty((Object)Gauge.NumberSystem.DECIMAL);
        this.scale = new SimpleObjectProperty((Object)new LinearScale(0.0, 100.0));
        this.trend = new SimpleObjectProperty((Object)Gauge.Trend.UNKNOWN);
        this.sections = FXCollections.observableArrayList();
        this.areas = FXCollections.observableArrayList();
        this.tickMarkSections = FXCollections.observableArrayList();
        this.markers = FXCollections.observableArrayList();
        this.endlessMode = new SimpleBooleanProperty(false);
        this.sections.addListener(new InvalidationListener(){

            public void invalidated(Observable ov) {
                GaugeModel.this.fireGaugeModelEvent();
            }
        });
        this.areas.addListener(new InvalidationListener(){

            public void invalidated(Observable ov) {
                GaugeModel.this.fireGaugeModelEvent();
            }
        });
        this.tickMarkSections.addListener(new InvalidationListener(){

            public void invalidated(Observable ov) {
                GaugeModel.this.fireGaugeModelEvent();
            }
        });
        this.markers.addListener(new InvalidationListener(){

            public void invalidated(Observable ov) {
                GaugeModel.this.fireGaugeModelEvent();
            }
        });
    }

    public final ObjectProperty<EventHandler<GaugeModelEvent>> onGaugeModelEventProperty() {
        return this.onGaugeModelEvent;
    }

    public final void setOnGaugeModelEvent(EventHandler<GaugeModelEvent> HANDLER) {
        this.onGaugeModelEventProperty().set(HANDLER);
    }

    public final EventHandler<GaugeModelEvent> getOnGaugeModelEvent() {
        return (EventHandler)this.onGaugeModelEventProperty().get();
    }

    public void fireGaugeModelEvent() {
        EventHandler<GaugeModelEvent> MODEL_EVENT_HANDLER = this.getOnGaugeModelEvent();
        if (MODEL_EVENT_HANDLER != null) {
            GaugeModelEvent GAUGE_MODEL_EVENT = new GaugeModelEvent();
            MODEL_EVENT_HANDLER.handle((Event)GAUGE_MODEL_EVENT);
        }
    }

    public final double getValue() {
        return this.value.get();
    }

    public final void setValue(double VALUE) {
        this.formerValue.set(this.value.get());
        if (this.isEndlessMode()) {
            this.value.set(VALUE % this.getRange());
            this.realValue.set(VALUE);
        } else {
            this.value.set(this.clamp(((LinearScale)this.scale.get()).getNiceMinValue(), ((LinearScale)this.scale.get()).getNiceMaxValue(), VALUE));
            this.realValue.set(this.value.get());
        }
        this.fireGaugeModelEvent();
    }

    public final DoubleProperty valueProperty() {
        return this.value;
    }

    public final double getRealValue() {
        return this.realValue.get();
    }

    public final ReadOnlyDoubleProperty realValueProperty() {
        return this.realValue;
    }

    public final double getFormerValue() {
        return this.formerValue.get();
    }

    public final ReadOnlyDoubleProperty formerValueProperty() {
        return this.formerValue;
    }

    public final boolean isValueAnimationEnabled() {
        return this.valueAnimationEnabled.get();
    }

    public final void setValueAnimationEnabled(boolean VALUE_ANIMATION_ENABLED) {
        this.valueAnimationEnabled.set(VALUE_ANIMATION_ENABLED);
        this.fireGaugeModelEvent();
    }

    public final BooleanProperty valueAnimationEnabledProperty() {
        return this.valueAnimationEnabled;
    }

    public final double getAnimationDuration() {
        return this.animationDuration.get();
    }

    public final void setAnimationDuration(double ANIMATION_DURATION) {
        this.animationDuration.set(ANIMATION_DURATION);
        this.fireGaugeModelEvent();
    }

    public final DoubleProperty animationDurationProperty() {
        return this.animationDuration;
    }

    public final double getRedrawTolerance() {
        return this.redrawTolerance.get();
    }

    public final void setRedrawTolerance(double REDRAW_TOLERANCE) {
        this.redrawTolerance.set(this.clamp(0.0, 1.0, REDRAW_TOLERANCE));
    }

    public final DoubleProperty redrawToleranceProperty() {
        return this.redrawTolerance;
    }

    public final double getRedrawToleranceValue() {
        return this.redrawToleranceProperty().multiply((ObservableNumberValue)this.rangeProperty()).doubleValue();
    }

    public final double getMinValue() {
        return ((LinearScale)this.scale.get()).getMinValue();
    }

    public final void setMinValue(double MIN_VALUE) {
        ((LinearScale)this.scale.get()).setMinValue(MIN_VALUE);
        ((LinearScale)this.scale.get()).setUncorrectedMinValue(MIN_VALUE);
        this.fireGaugeModelEvent();
    }

    public final ReadOnlyDoubleProperty minValueProperty() {
        return ((LinearScale)this.scale.get()).minValueProperty();
    }

    public final double getUncorrectedMinValue() {
        return ((LinearScale)this.scale.get()).getUncorrectedMinValue();
    }

    public final double getMaxValue() {
        return ((LinearScale)this.scale.get()).getMaxValue();
    }

    public final void setMaxValue(double MAX_VALUE) {
        ((LinearScale)this.scale.get()).setMaxValue(MAX_VALUE);
        ((LinearScale)this.scale.get()).setUncorrectedMaxValue(MAX_VALUE);
        this.fireGaugeModelEvent();
    }

    public final ReadOnlyDoubleProperty maxValueProperty() {
        return ((LinearScale)this.scale.get()).maxValueProperty();
    }

    public final double getUncorrectedMaxValue() {
        return ((LinearScale)this.scale.get()).getUncorrectedMaxValue();
    }

    public final double getRange() {
        return ((LinearScale)this.scale.get()).getRange();
    }

    public final ReadOnlyDoubleProperty rangeProperty() {
        return ((LinearScale)this.scale.get()).rangeProperty();
    }

    public final double getMinMeasuredValue() {
        return this.minMeasuredValue.get();
    }

    public final void setMinMeasuredValue(double MIN_MEASURED_VALUE) {
        this.minMeasuredValue.set(MIN_MEASURED_VALUE);
        this.fireGaugeModelEvent();
    }

    public final DoubleProperty minMeasuredValueProperty() {
        return this.minMeasuredValue;
    }

    public final void resetMinMeasuredValue() {
        this.setMinMeasuredValue(this.getValue());
    }

    public final double getMaxMeasuredValue() {
        return this.maxMeasuredValue.get();
    }

    public final void setMaxMeasuredValue(double MAX_MEASURED_VALUE) {
        this.maxMeasuredValue.set(MAX_MEASURED_VALUE);
        this.fireGaugeModelEvent();
    }

    public final DoubleProperty maxMeasuredValueProperty() {
        return this.maxMeasuredValue;
    }

    public final void resetMaxMeasuredValue() {
        this.setMaxMeasuredValue(this.getValue());
    }

    public final void resetMinMaxMeasuredValue() {
        this.setMinMeasuredValue(this.getValue());
        this.setMaxMeasuredValue(this.getValue());
    }

    public final double getThreshold() {
        return this.threshold.get();
    }

    public final void setThreshold(double THRESHOLD) {
        this.threshold.set(Double.compare(THRESHOLD, ((LinearScale)this.scale.get()).getNiceMinValue()) < 0 ? ((LinearScale)this.scale.get()).getNiceMinValue() : (Double.compare(THRESHOLD, ((LinearScale)this.scale.get()).getNiceMaxValue()) > 0 ? ((LinearScale)this.scale.get()).getNiceMaxValue() : THRESHOLD));
        this.fireGaugeModelEvent();
    }

    public final DoubleProperty thresholdProperty() {
        return this.threshold;
    }

    public final boolean isThresholdBehaviorInverted() {
        return this.thresholdBehaviorInverted.get();
    }

    public final void setThresholdBehaviorInverted(boolean THRESHOLD_BEHAVIOR_INVERTED) {
        this.thresholdBehaviorInverted.set(THRESHOLD_BEHAVIOR_INVERTED);
        this.fireGaugeModelEvent();
    }

    public final BooleanProperty thresholdBehaviorInvertedProperty() {
        return this.thresholdBehaviorInverted;
    }

    public final boolean isThresholdExceeded() {
        return this.thresholdExceeded.get();
    }

    public final void setThresholdExceeded(boolean THRESHOLD_EXCEEDED) {
        this.thresholdExceeded.set(THRESHOLD_EXCEEDED);
        this.fireGaugeModelEvent();
    }

    public final BooleanProperty thresholdExceededProperty() {
        return this.thresholdExceeded;
    }

    public final String getTitle() {
        return (String)this.title.get();
    }

    public final void setTitle(String TITLE) {
        this.title.set((Object)TITLE);
        this.fireGaugeModelEvent();
    }

    public final StringProperty titleProperty() {
        return this.title;
    }

    public final String getUnit() {
        return (String)this.unit.get();
    }

    public final void setUnit(String UNIT) {
        this.unit.set((Object)UNIT);
        this.fireGaugeModelEvent();
    }

    public final StringProperty unitProperty() {
        return this.unit;
    }

    public final double getLcdValue() {
        return this.lcdValue.get();
    }

    public final void setLcdValue(double LCD_VALUE) {
        this.lcdValue.set(LCD_VALUE);
        this.fireGaugeModelEvent();
    }

    public final DoubleProperty lcdValueProperty() {
        return this.lcdValue;
    }

    public final boolean isLcdValueCoupled() {
        return this.lcdValueCoupled.get();
    }

    public final void setLcdValueCoupled(boolean LCD_VALUE_COUPLED) {
        this.lcdValueCoupled.set(LCD_VALUE_COUPLED);
        this.fireGaugeModelEvent();
    }

    public final BooleanProperty lcdValueCoupledProperty() {
        return this.lcdValueCoupled;
    }

    public final double getLcdThreshold() {
        return this.lcdThreshold.get();
    }

    public final void setLcdThreshold(double LCD_THRESHOLD) {
        this.lcdThreshold.set(LCD_THRESHOLD);
        this.fireGaugeModelEvent();
    }

    public final DoubleProperty lcdThresholdProperty() {
        return this.lcdThreshold;
    }

    public final boolean isLcdThresholdBehaviorInverted() {
        return this.lcdThresholdBehaviorInverted.get();
    }

    public final void setLcdThresholdBehaviorInverted(boolean LCD_THRESHOLD_BEHAVIOR_INVERTED) {
        this.lcdThresholdBehaviorInverted.set(LCD_THRESHOLD_BEHAVIOR_INVERTED);
        this.fireGaugeModelEvent();
    }

    public final BooleanProperty lcdThresholdBehaviorInvertedProperty() {
        return this.lcdThresholdBehaviorInverted;
    }

    public final String getLcdUnit() {
        return (String)this.lcdUnit.get();
    }

    public final void setLcdUnit(String LCD_UNIT_STRING) {
        this.lcdUnit.set((Object)LCD_UNIT_STRING);
        this.fireGaugeModelEvent();
    }

    public final StringProperty lcdUnitProperty() {
        return this.lcdUnit;
    }

    public final Gauge.NumberSystem getLcdNumberSystem() {
        return (Gauge.NumberSystem)((Object)this.lcdNumberSystem.get());
    }

    public final void setLcdNumberSystem(Gauge.NumberSystem LCD_NUMBER_SYSTEM) {
        this.lcdNumberSystem.set((Object)LCD_NUMBER_SYSTEM);
        this.fireGaugeModelEvent();
    }

    public final ObjectProperty lcdNumberSystemProperty() {
        return this.lcdNumberSystem;
    }

    public final int getMaxNoOfMajorTicks() {
        return ((LinearScale)this.scale.get()).getMaxNoOfMajorTicks();
    }

    public final void setMaxNoOfMajorTicks(int MAX_NO_OF_MAJOR_TICKS) {
        ((LinearScale)this.scale.get()).setMaxNoOfMajorTicks(MAX_NO_OF_MAJOR_TICKS);
        this.fireGaugeModelEvent();
    }

    public final IntegerProperty maxNoOfMajorTicksProperty() {
        return ((LinearScale)this.scale.get()).maxNoOfMajorTicksProperty();
    }

    public final int getMaxNoOfMinorTicks() {
        return ((LinearScale)this.scale.get()).getMaxNoOfMinorTicks();
    }

    public final void setMaxNoOfMinorTicks(int MAX_NO_OF_MINOR_TICKS) {
        ((LinearScale)this.scale.get()).setMaxNoOfMinorTicks(MAX_NO_OF_MINOR_TICKS);
        this.fireGaugeModelEvent();
    }

    public final IntegerProperty maxNoOfMinorTicksProperty() {
        return ((LinearScale)this.scale.get()).maxNoOfMinorTicksProperty();
    }

    public final double getMajorTickSpacing() {
        return ((LinearScale)this.scale.get()).getMajorTickSpacing();
    }

    public final void setMajorTickSpacing(double MAJOR_TICK_SPACING) {
        ((LinearScale)this.scale.get()).setMajorTickSpacing(MAJOR_TICK_SPACING);
    }

    public final DoubleProperty majorTickSpacingProperty() {
        return ((LinearScale)this.scale.get()).majorTickSpacingProperty();
    }

    public final double getMinorTickSpacing() {
        return ((LinearScale)this.scale.get()).getMinorTickSpacing();
    }

    public final void setMinorTickSpacing(double MINOR_TICK_SPACING) {
        ((LinearScale)this.scale.get()).setMinorTickSpacing(MINOR_TICK_SPACING);
    }

    public final DoubleProperty minorTickSpacingProperty() {
        return ((LinearScale)this.scale.get()).minorTickSpacingProperty();
    }

    public final Gauge.Trend getTrend() {
        return (Gauge.Trend)((Object)this.trend.get());
    }

    public final void setTrend(Gauge.Trend TREND) {
        this.trend.set((Object)TREND);
        this.fireGaugeModelEvent();
    }

    public final ObjectProperty<Gauge.Trend> trendProperty() {
        return this.trend;
    }

    public final boolean isNiceScaling() {
        return ((LinearScale)this.scale.get()).isNiceScaling();
    }

    public final void setNiceScaling(boolean NICE_SCALING) {
        ((LinearScale)this.scale.get()).setNiceScaling(NICE_SCALING);
        this.fireGaugeModelEvent();
    }

    public final BooleanProperty niceScalingProperty() {
        return ((LinearScale)this.scale.get()).niceScalingProperty();
    }

    public final boolean isTightScale() {
        return ((LinearScale)this.scale.get()).isTightScale();
    }

    public final void setTightScale(boolean TIGHT_SCALE) {
        ((LinearScale)this.scale.get()).setTightScale(TIGHT_SCALE);
    }

    public final BooleanProperty tightScaleProperty() {
        return ((LinearScale)this.scale.get()).tightScaleProperty();
    }

    public final double getTightScaleOffset() {
        return ((LinearScale)this.scale.get()).getTightScaleOffset();
    }

    public final boolean isLargeNumberScale() {
        return ((LinearScale)this.scale.get()).isLargeNumberScale();
    }

    public final void setLargeNumberScale(boolean LARGE_NUMBER_SCALE) {
        ((LinearScale)this.scale.get()).setLargeNumberScale(LARGE_NUMBER_SCALE);
    }

    public final BooleanProperty largeNumberScaleProperty() {
        return ((LinearScale)this.scale.get()).largeNumberScaleProperty();
    }

    public final boolean isLastLabelVisible() {
        return ((LinearScale)this.scale.get()).isLastLabelVisible();
    }

    public final void setLastLabelVisible(boolean LAST_LABEL_VISIBLE) {
        ((LinearScale)this.scale.get()).setLastLabelVisible(LAST_LABEL_VISIBLE);
    }

    public final BooleanProperty lastLabelVisibleProperty() {
        return ((LinearScale)this.scale.get()).lastLabelVisibleProperty();
    }

    public final ObservableList<Section> getSections() {
        return this.sections;
    }

    public final void setSections(Section ... SECTION_ARRAY) {
        this.sections.setAll((Object[])SECTION_ARRAY);
        this.fireGaugeModelEvent();
    }

    public final void setSections(List<Section> SECTIONS) {
        this.sections.setAll(SECTIONS);
        this.fireGaugeModelEvent();
    }

    public final void addSection(Section SECTION) {
        this.sections.add((Object)new Section(SECTION.getStart(), SECTION.getStop(), SECTION.getColor(), SECTION.getText()));
        this.fireGaugeModelEvent();
    }

    public final void removeSection(Section SECTION) {
        for (Section section : this.sections) {
            if (!section.equals(SECTION)) continue;
            this.sections.remove((Object)section);
            break;
        }
        this.fireGaugeModelEvent();
    }

    public final void resetSections() {
        this.sections.clear();
        this.fireGaugeModelEvent();
    }

    public final ObservableList<Section> getAreas() {
        return this.areas;
    }

    public final void setAreas(Section ... AREA_ARRAY) {
        this.areas.setAll((Object[])AREA_ARRAY);
        this.fireGaugeModelEvent();
    }

    public final void setAreas(List<Section> AREAS) {
        this.areas.setAll(AREAS);
        this.fireGaugeModelEvent();
    }

    public final void addArea(Section AREA) {
        this.areas.add((Object)new Section(AREA.getStart(), AREA.getStop(), AREA.getColor(), AREA.getText()));
        this.fireGaugeModelEvent();
    }

    public final void removeArea(Section AREA) {
        for (Section area : this.areas) {
            if (!area.equals(AREA)) continue;
            this.areas.remove((Object)area);
            break;
        }
        this.fireGaugeModelEvent();
    }

    public final void resetAreas() {
        this.areas.clear();
        this.fireGaugeModelEvent();
    }

    public final ObservableList<Section> getTickMarkSections() {
        return this.tickMarkSections;
    }

    public final void setTickMarkSections(Section ... SECTIONS_ARRAY) {
        this.tickMarkSections.setAll((Object[])SECTIONS_ARRAY);
        this.fireGaugeModelEvent();
    }

    public final void setTickMarkSections(List<Section> SECTIONS) {
        this.tickMarkSections.setAll(SECTIONS);
        this.fireGaugeModelEvent();
    }

    public final void addTickMarkSection(Section SECTION) {
        this.tickMarkSections.add((Object)new Section(SECTION.getStart(), SECTION.getStop(), SECTION.getColor(), SECTION.getText()));
        this.fireGaugeModelEvent();
    }

    public final void removeTickMarkSection(Section SECTION) {
        for (Section section : this.tickMarkSections) {
            if (!section.equals(SECTION)) continue;
            this.tickMarkSections.remove((Object)section);
            break;
        }
        this.fireGaugeModelEvent();
    }

    public final void resetTickMarkSections() {
        this.tickMarkSections.clear();
        this.fireGaugeModelEvent();
    }

    public final ObservableList<Marker> getMarkers() {
        return this.markers;
    }

    public final void setMarkers(Marker ... MARKER_ARRAY) {
        this.markers.setAll((Object[])MARKER_ARRAY);
        this.fireGaugeModelEvent();
    }

    public final void setMarkers(List<Marker> MARKERS) {
        this.markers.setAll(MARKERS);
        this.fireGaugeModelEvent();
    }

    public final void addMarker(Marker MARKER) {
        this.markers.add((Object)new Marker(MARKER.getValue(), MARKER.getColor(), MARKER.getText(), MARKER.isVisible()));
        this.fireGaugeModelEvent();
    }

    public final void removeMarker(Marker MARKER) {
        for (Marker marker : this.markers) {
            if (!marker.equals(MARKER)) continue;
            this.markers.remove((Object)marker);
            break;
        }
        this.fireGaugeModelEvent();
    }

    public final void resetMarkers() {
        this.markers.clear();
        this.fireGaugeModelEvent();
    }

    public final boolean isEndlessMode() {
        return this.endlessMode.get();
    }

    public final void setEndlessMode(boolean ENDLESS_MODE) {
        this.endlessMode.set(ENDLESS_MODE);
    }

    public final BooleanProperty endlessModeProperty() {
        return this.endlessMode;
    }

    private double clamp(double MIN, double MAX, double VALUE) {
        return VALUE < MIN ? MIN : (VALUE > MAX ? MAX : VALUE);
    }

    protected void calcRange() {
        if (this.getMinValue() < this.getMaxValue()) {
            if (((LinearScale)this.scale.get()).isTightScale()) {
                ((LinearScale)this.scale.get()).calculateTight();
            } else {
                ((LinearScale)this.scale.get()).calculateLoose();
            }
        }
    }

    public class GaugeModelEvent
    extends Event {
        public GaugeModelEvent() {
            super(new EventType());
        }

        public GaugeModelEvent(Object source, EventTarget target) {
            super(source, target, new EventType());
        }
    }
}

