/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.scene.control.gauge;

import java.util.LinkedList;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Orientation;
import javafx.scene.control.Control;
import javafx.scene.paint.Color;
import jfxtras.labs.scene.control.gauge.Led;

public class LedBargraph
extends Control {
    private static final String DEFAULT_STYLE_CLASS = "bargraph";
    private ObjectProperty<Led.Type> ledType = new SimpleObjectProperty((Object)Led.Type.ROUND);
    private BooleanProperty frameVisible = new SimpleBooleanProperty(true);
    private DoubleProperty ledSize = new SimpleDoubleProperty(16.0);
    private ObjectProperty<Orientation> orientation = new SimpleObjectProperty((Object)Orientation.HORIZONTAL);
    private IntegerProperty noOfLeds = new SimpleIntegerProperty(16);
    private ObjectProperty<LinkedList<Color>> ledColors = new SimpleObjectProperty(new LinkedList());
    private BooleanProperty peakValueVisible = new SimpleBooleanProperty(false);
    private DoubleProperty value = new SimpleDoubleProperty(0.0);

    public LedBargraph() {
        for (int i = 0; i < this.noOfLeds.get(); ++i) {
            if (i < 11) {
                ((LinkedList)this.ledColors.get()).add(Color.LIME);
                continue;
            }
            if (i > 10 && i < 13) {
                ((LinkedList)this.ledColors.get()).add(Color.YELLOW);
                continue;
            }
            ((LinkedList)this.ledColors.get()).add(Color.RED);
        }
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
    }

    public final Led.Type getLedType() {
        return (Led.Type)((Object)this.ledType.get());
    }

    public final void setLedType(Led.Type LED_TYPE) {
        this.ledType.set((Object)LED_TYPE);
    }

    public final ObjectProperty<Led.Type> ledTypeProperty() {
        return this.ledType;
    }

    public final boolean isFrameVisible() {
        return this.frameVisible.get();
    }

    public final void setFrameVisible(boolean FRAME_VISIBLE) {
        this.frameVisible.set(FRAME_VISIBLE);
    }

    public final BooleanProperty frameVisibleProperty() {
        return this.frameVisible;
    }

    public final double getLedSize() {
        return this.ledSize.get();
    }

    public final void setLedSize(double LED_SIZE) {
        double size = LED_SIZE < 10.0 ? 10.0 : (LED_SIZE > 50.0 ? 50.0 : LED_SIZE);
        this.ledSize.set(size);
    }

    public final DoubleProperty ledSizeProperty() {
        return this.ledSize;
    }

    public final Orientation getOrientation() {
        return (Orientation)this.orientation.get();
    }

    public final void setOrientation(Orientation ORIENTATION) {
        this.orientation.set((Object)ORIENTATION);
    }

    public final ObjectProperty<Orientation> orientationProperty() {
        return this.orientation;
    }

    public final int getNoOfLeds() {
        return this.noOfLeds.get();
    }

    public final void setNoOfLeds(int NO_OF_LEDS) {
        int amount;
        int n = amount = NO_OF_LEDS < 5 ? 5 : NO_OF_LEDS;
        if (amount > this.noOfLeds.get()) {
            for (int i = 0; i < amount - this.noOfLeds.get(); ++i) {
                ((LinkedList)this.ledColors.get()).add(Color.RED);
            }
        }
        this.noOfLeds.set(amount);
    }

    public final IntegerProperty noOfLedsProperty() {
        return this.noOfLeds;
    }

    public final LinkedList<Color> getLedColors() {
        return (LinkedList)this.ledColors.get();
    }

    public final void setLedColors(LinkedList<Color> LED_COLORS) {
        this.ledColors.set(LED_COLORS);
    }

    public final ObjectProperty<LinkedList<Color>> ledColorsProperty() {
        return this.ledColors;
    }

    public final Color getLedColor(int INDEX) {
        Color ledColor = INDEX < 0 ? (Color)((LinkedList)this.ledColors.get()).get(0) : (INDEX > this.noOfLeds.get() - 1 ? (Color)((LinkedList)this.ledColors.get()).get(this.noOfLeds.get() - 1) : (Color)((LinkedList)this.ledColors.get()).get(INDEX));
        return ledColor;
    }

    public final void setLedColor(int INDEX, Color COLOR) {
        int realIndex = INDEX - 1;
        if (realIndex < 0) {
            ((LinkedList)this.ledColors.get()).set(0, COLOR);
        } else if (realIndex > this.noOfLeds.get() - 1) {
            ((LinkedList)this.ledColors.get()).set(this.noOfLeds.get() - 1, COLOR);
        } else {
            ((LinkedList)this.ledColors.get()).set(realIndex, COLOR);
        }
    }

    public final boolean isPeakValueVisible() {
        return this.peakValueVisible.get();
    }

    public final void setPeakValueVisible(boolean PEAK_VALUE_VISIBLE) {
        this.peakValueVisible.set(PEAK_VALUE_VISIBLE);
    }

    public final BooleanProperty peakValueVisibleProperty() {
        return this.peakValueVisible;
    }

    public final double getValue() {
        return this.value.get();
    }

    public final void setValue(double VALUE) {
        double val = VALUE < 0.0 ? 0.0 : (VALUE > 1.0 ? 1.0 : VALUE);
        this.value.set(val);
    }

    public final DoubleProperty valueProperty() {
        return this.value;
    }

    public String getUserAgentStylesheet() {
        return ((Object)((Object)this)).getClass().getResource("extras.css").toExternalForm();
    }
}

