/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.scene.control.gauge;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import jfxtras.labs.scene.control.gauge.Scale;

public class LinearScale
extends Scale {
    private BooleanProperty tightScale;
    private BooleanProperty niceScaling;
    private DoubleProperty niceMinValue;
    private DoubleProperty niceMaxValue;
    private DoubleProperty majorTickSpacing;
    private DoubleProperty minorTickSpacing;
    private IntegerProperty maxNoOfMajorTicks;
    private IntegerProperty maxNoOfMinorTicks;
    private DoubleProperty niceRange;
    private BooleanProperty largeNumberScale;
    private double tightScaleOffset;

    public LinearScale() {
        super(0.0, 100.0);
        this.init();
    }

    public LinearScale(double MIN_VALUE, double MAX_VALUE) {
        super(MIN_VALUE, MAX_VALUE);
        this.init();
    }

    private void init() {
        this.tightScale = new SimpleBooleanProperty(false);
        this.niceScaling = new SimpleBooleanProperty(true);
        this.niceMinValue = new SimpleDoubleProperty(this.getMinValue());
        this.niceMaxValue = new SimpleDoubleProperty(this.getMaxValue());
        this.niceRange = new SimpleDoubleProperty(this.getRange());
        this.largeNumberScale = new SimpleBooleanProperty(false);
        this.maxNoOfMajorTicks = new SimpleIntegerProperty(10);
        this.maxNoOfMinorTicks = new SimpleIntegerProperty(10);
        this.majorTickSpacing = new SimpleDoubleProperty(10.0);
        this.minorTickSpacing = new SimpleDoubleProperty(1.0);
        this.tightScaleOffset = 0.0;
    }

    public final boolean isTightScale() {
        return this.tightScale.get();
    }

    public final void setTightScale(boolean TIGHT_SCALE) {
        this.tightScale.set(TIGHT_SCALE);
    }

    public final BooleanProperty tightScaleProperty() {
        return this.tightScale;
    }

    public final boolean isNiceScaling() {
        return this.niceScaling.get();
    }

    public final void setNiceScaling(boolean NICE_SCALING) {
        this.niceScaling.set(NICE_SCALING);
    }

    public final BooleanProperty niceScalingProperty() {
        return this.niceScaling;
    }

    public final double getNiceMinValue() {
        return this.niceMinValue.get();
    }

    public final ReadOnlyDoubleProperty niceMinValueProperty() {
        return this.niceMinValue;
    }

    public final double getNiceMaxValue() {
        return this.niceMaxValue.get();
    }

    public final ReadOnlyDoubleProperty niceMaxValueProperty() {
        return this.niceMaxValue;
    }

    public final int getMaxNoOfMajorTicks() {
        return this.maxNoOfMajorTicks.get();
    }

    public final void setMaxNoOfMajorTicks(int MAX_NO_OF_MAJOR_TICKS) {
        this.maxNoOfMajorTicks.set(MAX_NO_OF_MAJOR_TICKS);
    }

    public final IntegerProperty maxNoOfMajorTicksProperty() {
        return this.maxNoOfMajorTicks;
    }

    public final int getMaxNoOfMinorTicks() {
        return this.maxNoOfMinorTicks.get();
    }

    public final void setMaxNoOfMinorTicks(int MAX_NO_OF_MINOR_TICKS) {
        this.maxNoOfMinorTicks.set(MAX_NO_OF_MINOR_TICKS);
    }

    public final IntegerProperty maxNoOfMinorTicksProperty() {
        return this.maxNoOfMinorTicks;
    }

    public final double getNiceRange() {
        return this.niceRange.get();
    }

    public final ReadOnlyDoubleProperty niceRangeProperty() {
        return this.niceRange;
    }

    public final boolean isLargeNumberScale() {
        return this.largeNumberScale.get();
    }

    public final void setLargeNumberScale(boolean LARGE_NUMBER_SCALE) {
        this.largeNumberScale.set(LARGE_NUMBER_SCALE);
    }

    public final BooleanProperty largeNumberScaleProperty() {
        return this.largeNumberScale;
    }

    public final double getMajorTickSpacing() {
        return this.majorTickSpacing.get();
    }

    public final void setMajorTickSpacing(double MAJOR_TICKSPACING) {
        this.majorTickSpacing.set(MAJOR_TICKSPACING);
    }

    public final DoubleProperty majorTickSpacingProperty() {
        return this.majorTickSpacing;
    }

    public final double getMinorTickSpacing() {
        return this.minorTickSpacing.get();
    }

    public final void setMinorTickSpacing(double MINOR_TICK_SPACING) {
        this.minorTickSpacing.set(MINOR_TICK_SPACING);
    }

    public final DoubleProperty minorTickSpacingProperty() {
        return this.minorTickSpacing;
    }

    public final double getTightScaleOffset() {
        return this.tightScaleOffset;
    }

    protected void calculateLoose() {
        if (this.isNiceScaling()) {
            this.niceRange.set(this.calcNiceNumber(this.getRange(), false));
            this.majorTickSpacing.set(this.calcNiceNumber(this.niceRange.doubleValue() / (this.maxNoOfMajorTicks.doubleValue() - 1.0), true));
            this.niceMinValue.set(Math.floor(this.getMinValue() / this.majorTickSpacing.doubleValue()) * this.majorTickSpacing.doubleValue());
            this.niceMaxValue.set(Math.ceil(this.getUncorrectedMaxValue() / this.majorTickSpacing.doubleValue()) * this.majorTickSpacing.doubleValue());
            this.minorTickSpacing.set(this.calcNiceNumber(this.majorTickSpacing.doubleValue() / (double)(this.maxNoOfMinorTicks.intValue() - 1), true));
            this.niceRange.set(this.niceMaxValue.doubleValue() - this.niceMinValue.doubleValue());
            this.setMinValue(this.niceMinValue.get());
            this.setMaxValue(this.niceMaxValue.get());
        } else {
            this.niceRange.set(this.getRange());
            this.niceMinValue.set(this.getMinValue());
            this.niceMaxValue.set(this.getMaxValue());
        }
    }

    protected void calculateTight() {
        if (this.isNiceScaling()) {
            this.niceRange.set(this.getUncorrectedMaxValue() - this.getUncorrectedMinValue());
            this.majorTickSpacing.set(this.calcNiceNumber(this.niceRange.doubleValue() / (this.maxNoOfMajorTicks.doubleValue() - 1.0), true));
            this.niceMinValue.set(Math.floor(this.getUncorrectedMinValue() / this.majorTickSpacing.doubleValue()) * this.majorTickSpacing.doubleValue());
            this.niceMaxValue.set(Math.ceil(this.getUncorrectedMaxValue() / this.majorTickSpacing.doubleValue()) * this.majorTickSpacing.doubleValue());
            this.minorTickSpacing.set(this.calcNiceNumber(this.majorTickSpacing.doubleValue() / (this.maxNoOfMinorTicks.doubleValue() - 1.0), true));
            this.tightScaleOffset = (int)((this.getUncorrectedMinValue() - this.niceMinValue.doubleValue() + 1.0) / this.minorTickSpacing.doubleValue());
            this.niceMinValue.set(this.getUncorrectedMinValue());
            this.niceMaxValue.set(this.getUncorrectedMaxValue());
        } else {
            this.niceRange.set(this.getRange());
            this.niceMinValue.set(this.getMinValue());
            this.niceMaxValue.set(this.getMaxValue());
        }
    }

    private double calcNiceNumber(double RANGE, boolean ROUND) {
        double niceFraction;
        double EXPONENT = Math.floor(Math.log10(RANGE));
        double FRACTION = RANGE / Math.pow(10.0, EXPONENT);
        double MOD = FRACTION % 0.5;
        if (this.isLargeNumberScale()) {
            if (MOD != 0.0) {
                niceFraction = FRACTION - MOD;
                niceFraction += 0.5;
            } else {
                niceFraction = FRACTION;
            }
        } else {
            niceFraction = ROUND ? (FRACTION < 1.5 ? 1.0 : (FRACTION < 3.0 ? 2.0 : (FRACTION < 7.0 ? 5.0 : 10.0))) : (Double.compare(FRACTION, 1.0) <= 0 ? 1.0 : (Double.compare(FRACTION, 2.0) <= 0 ? 2.0 : (Double.compare(FRACTION, 5.0) <= 0 ? 5.0 : 10.0)));
        }
        return niceFraction * Math.pow(10.0, EXPONENT);
    }
}

