/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.scene.control.gauge;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.paint.Color;
import jfxtras.labs.scene.control.gauge.MarkerEvent;

public class Marker {
    private DoubleProperty value = new SimpleDoubleProperty();
    private ObjectProperty<Color> color = new SimpleObjectProperty((Object)Color.TRANSPARENT);
    private StringProperty text = new SimpleStringProperty("");
    private BooleanProperty visible = new SimpleBooleanProperty();
    private ObjectProperty<EventHandler<MarkerEvent>> onMarkerEvent = new SimpleObjectProperty();

    public Marker() {
    }

    public Marker(double VALUE, Color COLOR) {
        this(VALUE, COLOR, Double.toString(VALUE));
    }

    public Marker(double VALUE, Color COLOR, String TEXT) {
        this(VALUE, COLOR, TEXT, true);
    }

    public Marker(double VALUE, Color COLOR, String TEXT, boolean VISIBLE) {
        this.setValue(VALUE);
        this.setColor(COLOR);
        this.setText(TEXT);
        this.setVisible(VISIBLE);
    }

    public final ObjectProperty<EventHandler<MarkerEvent>> onMarkerEventProperty() {
        return this.onMarkerEvent;
    }

    public final void setOnMarkerEvent(EventHandler<MarkerEvent> HANDLER) {
        this.onMarkerEventProperty().set(HANDLER);
    }

    public final EventHandler<MarkerEvent> getOnMarkerEvent() {
        return (EventHandler)this.onMarkerEventProperty().get();
    }

    public void fireMarkerEvent(MarkerEvent MARKER_EVENT) {
        EventHandler<MarkerEvent> MARKER_EVENT_HANDLER = this.getOnMarkerEvent();
        if (MARKER_EVENT_HANDLER != null) {
            MARKER_EVENT_HANDLER.handle((Event)MARKER_EVENT);
        }
    }

    public final double getValue() {
        return this.value.get();
    }

    public final void setValue(double VALUE) {
        this.value.set(VALUE);
    }

    public final DoubleProperty valueProperty() {
        return this.value;
    }

    public final Color getColor() {
        return (Color)this.color.get();
    }

    public final void setColor(Color COLOR) {
        this.color.set((Object)COLOR);
    }

    public final ObjectProperty<Color> colorProperty() {
        return this.color;
    }

    public final String getText() {
        return (String)this.text.get();
    }

    public final void setText(String TEXT) {
        this.text.set((Object)TEXT);
    }

    public final StringProperty textProperty() {
        return this.text;
    }

    public final boolean isVisible() {
        return this.visible.get();
    }

    public final void setVisible(boolean VISIBLE) {
        this.visible.set(VISIBLE);
    }

    public final BooleanProperty visibleProperty() {
        return this.visible;
    }

    public final boolean equals(Marker MARKER) {
        return Double.compare(MARKER.getValue(), this.getValue()) == 0 && MARKER.getColor().equals((Object)this.getColor()) && MARKER.getText().equals(this.getText());
    }
}

