/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.scene.control.gauge;

import javafx.animation.AnimationTimer;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.control.Control;
import javafx.scene.paint.Color;

public class Odometer
extends Control {
    private static final String DEFAULT_STYLE_CLASS = "odometer";
    private ObjectProperty<Color> color = new SimpleObjectProperty((Object)Color.rgb((int)240, (int)240, (int)240));
    private ObjectProperty<Color> decimalColor = new SimpleObjectProperty((Object)Color.rgb((int)220, (int)0, (int)0));
    private ObjectProperty<Color> numberColor = new SimpleObjectProperty((Object)Color.BLACK);
    private ObjectProperty<Color> numberDecimalColor = new SimpleObjectProperty((Object)Color.WHITE);
    private LongProperty interval;
    private IntegerProperty rotations;
    private IntegerProperty rotationPreset;
    private BooleanProperty countdownMode;
    private IntegerProperty noOfDigits;
    private IntegerProperty noOfDecimals;
    private long lastTimerCall;
    private AnimationTimer timer;

    public Odometer() {
        this(6);
    }

    public Odometer(int NO_OF_DIGITS) {
        this.noOfDigits = new SimpleIntegerProperty(NO_OF_DIGITS < 0 ? 1 : NO_OF_DIGITS);
        this.noOfDecimals = new SimpleIntegerProperty(0);
        this.interval = new SimpleLongProperty(1000L);
        this.rotations = new SimpleIntegerProperty(0);
        this.rotationPreset = new SimpleIntegerProperty(0);
        this.countdownMode = new SimpleBooleanProperty(false);
        this.lastTimerCall = System.nanoTime();
        this.timer = new AnimationTimer(){

            public void handle(long l) {
                long currentNanoTime = System.nanoTime();
                if (currentNanoTime > Odometer.this.lastTimerCall + Odometer.this.interval.get() * 1000000L) {
                    Odometer.this.increment();
                    Odometer.this.lastTimerCall = currentNanoTime;
                }
            }
        };
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
    }

    public final Color getColor() {
        return (Color)this.color.get();
    }

    public final void setColor(Color COLOR) {
        this.color.set((Object)COLOR);
    }

    public final ObjectProperty<Color> colorProperty() {
        return this.color;
    }

    public final Color getDecimalColor() {
        return (Color)this.decimalColor.get();
    }

    public final void setDecimalColor(Color DECIMAL_COLOR) {
        this.decimalColor.set((Object)DECIMAL_COLOR);
    }

    public final ObjectProperty<Color> decimalColorProperty() {
        return this.decimalColor;
    }

    public final Color getNumberColor() {
        return (Color)this.numberColor.get();
    }

    public final void setNumberColor(Color COLOR) {
        this.numberColor.set((Object)COLOR);
    }

    public final ObjectProperty<Color> numberColorProperty() {
        return this.numberColor;
    }

    public final Color getNumberDecimalColor() {
        return (Color)this.numberDecimalColor.get();
    }

    public final void setNumberDecimalColor(Color NUMBER_DECIMAL_COLOR) {
        this.numberDecimalColor.set((Object)NUMBER_DECIMAL_COLOR);
    }

    public final ObjectProperty<Color> numberDecimalColorProperty() {
        return this.numberDecimalColor;
    }

    public final long getInterval() {
        return this.interval.get();
    }

    public final void setInterval(long INTERVAL) {
        this.interval.set(INTERVAL < 100L ? 100L : (INTERVAL > 5000L ? 5000L : INTERVAL));
    }

    public final LongProperty intervalProperty() {
        return this.interval;
    }

    public final int getRotations() {
        return this.rotations.get();
    }

    public final ReadOnlyIntegerProperty rotationsProperty() {
        return this.rotations;
    }

    public final int getRotationPreset() {
        return this.rotationPreset.get();
    }

    public final void setRotationPreset(int ROTATION_PRESET) {
        this.rotationPreset.set(ROTATION_PRESET);
    }

    public final IntegerProperty rotationPresetProperty() {
        return this.rotationPreset;
    }

    public final void start() {
        this.timer.start();
    }

    public final void stop() {
        this.timer.stop();
    }

    public final void reset() {
        this.timer.stop();
        this.rotations.set(0);
    }

    public final boolean isCountdownMode() {
        return this.countdownMode.get();
    }

    public final void setCountdownMode(boolean COUNTDOWN_MODE) {
        this.countdownMode.set(COUNTDOWN_MODE);
    }

    public final BooleanProperty countdownModeProperty() {
        return this.countdownMode;
    }

    public final int getNoOfDigits() {
        return this.noOfDigits.get();
    }

    public final void setNoOfDigits(int NO_OF_DIGITS) {
        this.noOfDigits.set(NO_OF_DIGITS);
    }

    public final IntegerProperty noOfDigitsProperty() {
        return this.noOfDigits;
    }

    public final int getNoOfDecimals() {
        return this.noOfDecimals.get();
    }

    public final void setNoOfDecimals(int NO_OF_DECIMALS) {
        this.noOfDecimals.set(NO_OF_DECIMALS);
    }

    public final IntegerProperty noOfDecimalsProperty() {
        return this.noOfDecimals;
    }

    public final void increment() {
        this.rotations.set(this.rotations.get() + 1);
        if ((double)this.rotations.get() >= Math.pow(10.0, this.noOfDigits.get() + this.noOfDecimals.get())) {
            this.rotations.set(0);
        }
    }

    public final int getDialPosition(int dial) {
        double pow = Math.pow(10.0, dial);
        return (int)Math.floor((double)this.rotations.get() % pow / (pow / 10.0));
    }

    public void setPrefSize(double WIDTH, double HEIGHT) {
        double prefHeight = WIDTH / (double)(this.getNoOfDigits() + this.getNoOfDecimals()) * 1.6875 < HEIGHT * 0.5925925925925926 ? WIDTH / (double)(this.getNoOfDigits() + this.getNoOfDecimals()) * 1.6875 : HEIGHT;
        double prefWidth = prefHeight * 0.5925925925925926 * (double)(this.getNoOfDigits() + this.getNoOfDecimals());
        super.setPrefSize(prefWidth, prefHeight);
    }

    protected String getUserAgentStylesheet() {
        return ((Object)((Object)this)).getClass().getResource("extras.css").toExternalForm();
    }
}

