/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.scene.control.gauge;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.paint.Color;
import jfxtras.labs.scene.control.gauge.Gauge;
import jfxtras.labs.scene.control.gauge.GaugeModel;
import jfxtras.labs.scene.control.gauge.StyleModel;

public final class Radial
extends Gauge {
    private static final String DEFAULT_STYLE_CLASS = "radial";
    private BooleanProperty histogramVisible;
    private ObjectProperty<Color> histogramColor;
    private DoubleProperty histogramLineWidth;
    private BooleanProperty histogramCreationEnabled;
    private IntegerProperty histogramDataPeriodInMinutes;

    public Radial() {
        this(new GaugeModel(), new StyleModel());
    }

    public Radial(GaugeModel GAUGE_MODEL) {
        this(GAUGE_MODEL, new StyleModel());
    }

    public Radial(StyleModel STYLE_MODEL) {
        this(new GaugeModel(), STYLE_MODEL);
    }

    public Radial(GaugeModel GAUGE_MODEL, StyleModel STYLE_MODEL) {
        super(GAUGE_MODEL, STYLE_MODEL);
        this.getStyleClass().setAll((Object[])new String[]{DEFAULT_STYLE_CLASS});
        this.histogramVisible = new SimpleBooleanProperty(false);
        this.histogramColor = new SimpleObjectProperty((Object)Color.AQUAMARINE);
        this.histogramLineWidth = new SimpleDoubleProperty(1.0);
        this.histogramCreationEnabled = new SimpleBooleanProperty(false);
        this.histogramDataPeriodInMinutes = new SimpleIntegerProperty(5);
    }

    public void setPrefSize(double WIDTH, double HEIGHT) {
        double SIZE = WIDTH <= HEIGHT ? WIDTH : HEIGHT;
        super.setPrefSize(SIZE, SIZE);
    }

    public void setMinSize(double WIDTH, double HEIGHT) {
        double SIZE = WIDTH <= HEIGHT ? WIDTH : HEIGHT;
        super.setMinSize(SIZE, SIZE);
    }

    public void setMaxSize(double WIDTH, double HEIGHT) {
        double SIZE = WIDTH <= HEIGHT ? WIDTH : HEIGHT;
        super.setMaxSize(SIZE, SIZE);
    }

    public final boolean isHistogramVisible() {
        return this.histogramVisible.get();
    }

    public final void setHistogramVisible(boolean HISTOGRAM_VISIBLE) {
        this.histogramVisible.set(HISTOGRAM_VISIBLE);
    }

    public final BooleanProperty histogramVisibleProperty() {
        return this.histogramVisible;
    }

    public final Color getHistogramColor() {
        return (Color)this.histogramColor.get();
    }

    public final void setHistogramColor(Color HISTOGRAM_COLOR) {
        this.histogramColor.set((Object)HISTOGRAM_COLOR);
    }

    public final ObjectProperty<Color> histogramColorProperty() {
        return this.histogramColor;
    }

    public final double getHistogramLineWidth() {
        return this.histogramLineWidth.get();
    }

    public final void setHistogramLineWidth(double HISTOGRAM_LINE_WIDTH) {
        double lineWidth = HISTOGRAM_LINE_WIDTH < 0.5 ? 0.5 : (HISTOGRAM_LINE_WIDTH > 3.0 ? 3.0 : HISTOGRAM_LINE_WIDTH);
        this.histogramLineWidth.set(lineWidth);
    }

    public final DoubleProperty histogramLineWidthProperty() {
        return this.histogramLineWidth;
    }

    public final boolean isHistogramCreationEnabled() {
        return this.histogramCreationEnabled.get();
    }

    public final void setHistogramCreationEnabled(boolean HISTOGRAM_CREATION_ENABLED) {
        this.histogramCreationEnabled.set(HISTOGRAM_CREATION_ENABLED);
    }

    public final BooleanProperty histogramCreationEnabledProperty() {
        return this.histogramCreationEnabled;
    }

    public final int getHistogramDataPeriodInMinutes() {
        return this.histogramDataPeriodInMinutes.get();
    }

    public final void setHistogramDataPeriodInMinutes(int HISTOGRAM_DATA_PERIOD_IN_MINUTES) {
        this.histogramDataPeriodInMinutes.set(HISTOGRAM_DATA_PERIOD_IN_MINUTES);
    }

    public final IntegerProperty histogramDataPeriodInMinutesProperty() {
        return this.histogramDataPeriodInMinutes;
    }

    public static enum ForegroundType {
        TYPE1,
        TYPE2,
        TYPE3,
        TYPE4,
        TYPE5;

    }
}

