/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.scene.control.gauge;

import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Arc;
import javafx.scene.shape.Shape;
import jfxtras.labs.util.Util;

public class Section {
    private DoubleProperty start;
    private DoubleProperty stop;
    private ObjectProperty<Color> color;
    private StringProperty cssColor;
    private ObjectProperty<Color> transparentColor;
    private ObjectProperty<Color> highlightColor;
    private ObjectProperty<Color> transparentHighlightColor;
    private ObjectProperty<Paint> paint;
    private ObjectProperty<Shape> sectionArea;
    private ObjectProperty<Shape> filledArea;
    private StringProperty text;

    public Section() {
        this(-1.0, -1.0, Color.RED, "");
    }

    public Section(double START, double STOP, Color COLOR) {
        this(START, STOP, COLOR, "");
    }

    public Section(double START, double STOP, Color COLOR, String TEXT) {
        this(START, STOP, COLOR, COLOR.brighter().brighter(), null, null, TEXT);
    }

    public Section(double START, double STOP, Color COLOR, Color HIGHLIGHT_COLOR) {
        this(START, STOP, COLOR, HIGHLIGHT_COLOR, null, null, "");
    }

    public Section(double START, double STOP, Color COLOR, Color HIGHLIGHT_COLOR, String TEXT) {
        this(START, STOP, COLOR, HIGHLIGHT_COLOR, null, null, TEXT);
    }

    public Section(double START, double STOP, Color COLOR, Arc FILLED_AREA) {
        this(START, STOP, COLOR, null, FILLED_AREA);
    }

    public Section(double START, double STOP, Color COLOR, Shape SECTION_AREA, Arc FILLED_AREA) {
        this(START, STOP, COLOR, COLOR.brighter().brighter(), SECTION_AREA, (Shape)FILLED_AREA, "");
    }

    public Section(double START, double STOP, Color COLOR, Color HIGHLIGHT_COLOR, Shape SECTION_AREA, Shape FILLED_AREA, String TEXT) {
        this.start = new SimpleDoubleProperty(START);
        this.stop = new SimpleDoubleProperty(STOP);
        this.color = new SimpleObjectProperty((Object)COLOR);
        this.transparentColor = new SimpleObjectProperty((Object)Color.color((double)COLOR.getRed(), (double)COLOR.getGreen(), (double)COLOR.getBlue(), (double)0.3));
        this.highlightColor = new SimpleObjectProperty((Object)HIGHLIGHT_COLOR);
        this.transparentHighlightColor = new SimpleObjectProperty((Object)Color.color((double)COLOR.getRed(), (double)COLOR.getGreen(), (double)COLOR.getBlue(), (double)0.5));
        this.sectionArea = new SimpleObjectProperty((Object)SECTION_AREA);
        this.filledArea = new SimpleObjectProperty((Object)FILLED_AREA);
        this.paint = new SimpleObjectProperty((Object)COLOR);
        this.text = new SimpleStringProperty(TEXT);
        this.cssColor = new SimpleStringProperty(Util.colorToCssColor(COLOR));
    }

    public final double getStart() {
        return this.start.get();
    }

    public final void setStart(double START) {
        this.start.set(START);
    }

    public final DoubleProperty startProperty() {
        return this.start;
    }

    public final double getStop() {
        return this.stop.get();
    }

    public final void setStop(double STOP) {
        this.stop.set(STOP);
    }

    public final DoubleProperty stopProperty() {
        return this.stop;
    }

    public final Color getColor() {
        return (Color)this.color.get();
    }

    public final void setColor(Color COLOR) {
        this.color.set((Object)COLOR);
        this.transparentColor.set((Object)Color.color((double)COLOR.getRed(), (double)COLOR.getGreen(), (double)COLOR.getBlue(), (double)0.25));
        this.cssColor.set((Object)Util.colorToCssColor(COLOR));
    }

    public final ObjectProperty<Color> colorProperty() {
        return this.color;
    }

    public final Color getTransparentColor() {
        return (Color)this.transparentColor.get();
    }

    public final ObjectProperty<Color> transparentColorProperty() {
        return this.transparentColor;
    }

    public final Color getHighlightColor() {
        return (Color)this.highlightColor.get();
    }

    public final void setHighlightColor(Color COLOR) {
        this.highlightColor.set((Object)COLOR);
        this.transparentHighlightColor.set((Object)Color.color((double)COLOR.getRed(), (double)COLOR.getGreen(), (double)COLOR.getBlue(), (double)0.5));
    }

    public final ObjectProperty<Color> highlightColorProperty() {
        return this.highlightColor;
    }

    public final Color getTransparentHighlightColor() {
        return (Color)this.transparentHighlightColor.get();
    }

    public final ObjectProperty<Color> transparentHighlightColorProperty() {
        return this.transparentHighlightColor;
    }

    public final String getCssColor() {
        return (String)this.cssColor.get();
    }

    public final StringProperty cssColorProperty() {
        return this.cssColor;
    }

    public final Shape getSectionArea() {
        return (Shape)this.sectionArea.get();
    }

    public final void setSectionArea(Shape SECTION_AREA) {
        this.sectionArea.set((Object)SECTION_AREA);
    }

    public final ObjectProperty<Shape> sectionAreaProperty() {
        return this.sectionArea;
    }

    public final Shape getFilledArea() {
        return (Shape)this.filledArea.get();
    }

    public final void setFilledArea(Shape FILLED_AREA) {
        this.filledArea.set((Object)FILLED_AREA);
    }

    public final ObjectProperty<Shape> filledAreaProperty() {
        return this.filledArea;
    }

    public final String getText() {
        return (String)this.text.get();
    }

    public final void setText(String TEXT) {
        this.text.set((Object)TEXT);
    }

    public final StringProperty textProperty() {
        return this.text;
    }

    public final Paint getPaint() {
        return (Paint)this.paint.get();
    }

    public final void setPaint(Paint PAINT) {
        this.paint.set((Object)PAINT);
    }

    public final ObjectProperty<Paint> paintProperty() {
        return this.paint;
    }

    public boolean contains(double VALUE) {
        return Double.compare(VALUE, this.start.get()) >= 0 && Double.compare(VALUE, this.stop.get()) <= 0;
    }

    public boolean equals(Section SECTION) {
        return Double.compare(SECTION.getStart(), this.getStart()) == 0 && Double.compare(SECTION.getStop(), this.getStop()) == 0 && SECTION.getColor().equals((Object)this.getColor()) && SECTION.getText().equals(this.getText());
    }

    public String toString() {
        StringBuilder NAME = new StringBuilder();
        NAME.append("Section: ").append("\n");
        NAME.append("startValue: ").append(this.start.get()).append("\n");
        NAME.append("stopValue : ").append(this.stop.get()).append("\n");
        NAME.append("color     : ").append(this.color.toString());
        return NAME.toString();
    }
}

