/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.scene.control.gauge;

import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.paint.Color;
import jfxtras.labs.scene.control.gauge.Gauge;
import jfxtras.labs.scene.control.gauge.GaugeModel;
import jfxtras.labs.scene.control.gauge.Section;
import jfxtras.labs.scene.control.gauge.StyleModel;

public class SmallRadial
extends Gauge {
    private static final String DEFAULT_STYLE_CLASS = "small-radial";
    private ObjectProperty<Color> valueLabelColor;
    private BooleanProperty valueLabelVisible;
    private IntegerProperty noOfDecimals;
    private DoubleProperty timeToValueInMs;
    private ObjectProperty<Color> frameColor;
    private ObjectProperty<Color> backgroundColor;
    private ObjectProperty<Color> tickMarkColor;
    private ObjectProperty<Color> pointerColor;
    private ObjectProperty<Color> centerKnobColor;
    private ObjectProperty<Color> thresholdLedColor;
    private BooleanProperty pointerShadowVisible;

    public SmallRadial() {
        this(new GaugeModel(), new StyleModel());
    }

    public SmallRadial(GaugeModel GAUGE_MODEL) {
        this(GAUGE_MODEL, new StyleModel());
    }

    public SmallRadial(GaugeModel GAUGE_MODEL, StyleModel STYLE_MODEL) {
        super(GAUGE_MODEL, STYLE_MODEL);
        this.setRadialRange(Gauge.RadialRange.RADIAL_280);
        this.valueLabelColor = new SimpleObjectProperty((Object)Color.BLACK);
        this.valueLabelVisible = new SimpleBooleanProperty(true);
        this.noOfDecimals = new SimpleIntegerProperty(2);
        this.frameColor = new SimpleObjectProperty((Object)Color.rgb((int)110, (int)110, (int)110));
        this.backgroundColor = new SimpleObjectProperty((Object)Color.rgb((int)220, (int)220, (int)220));
        this.tickMarkColor = new SimpleObjectProperty((Object)Color.BLACK);
        this.pointerColor = new SimpleObjectProperty((Object)Color.RED);
        this.centerKnobColor = new SimpleObjectProperty((Object)Color.rgb((int)110, (int)110, (int)110));
        this.thresholdLedColor = new SimpleObjectProperty((Object)Color.RED);
        this.pointerShadowVisible = new SimpleBooleanProperty(false);
        this.timeToValueInMs = new SimpleDoubleProperty(1500.0);
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
    }

    @Override
    public final Gauge.RadialRange getRadialRange() {
        return Gauge.RadialRange.RADIAL_280;
    }

    public final Color getValueLabelColor() {
        return (Color)this.valueLabelColor.get();
    }

    public final void setValueLabelColor(Color LABEL_COLOR) {
        this.valueLabelColor.set((Object)LABEL_COLOR);
    }

    public final ObjectProperty<Color> labelColorProperty() {
        return this.valueLabelColor;
    }

    public final boolean isValueLabelVisible() {
        return this.valueLabelVisible.get();
    }

    public final void setValueLabelVisible(boolean VALUE_LABEL_VISIBLE) {
        this.valueLabelVisible.set(VALUE_LABEL_VISIBLE);
    }

    public final BooleanProperty valueLabelVisibleProperty() {
        return this.valueLabelVisible;
    }

    public final int getNoOfDecimals() {
        return this.noOfDecimals.get();
    }

    public final void setNoOfDecimals(int NO_OF_DECIMALS) {
        int number = NO_OF_DECIMALS < 0 ? 0 : (NO_OF_DECIMALS > 5 ? 5 : NO_OF_DECIMALS);
        this.noOfDecimals.set(number);
    }

    public final ReadOnlyIntegerProperty noOfDecimalsProperty() {
        return this.noOfDecimals;
    }

    public final void setSections(Section ... SECTION_ARRAY) {
        this.getGaugeModel().setSections(SECTION_ARRAY);
    }

    public final void setSections(List<Section> SECTIONS) {
        this.getGaugeModel().setSections(SECTIONS);
    }

    public final Color getFrameColor() {
        return (Color)this.frameColor.get();
    }

    public final void setFrameColor(Color FRAME_COLOR) {
        this.frameColor.set((Object)FRAME_COLOR);
    }

    public final ObjectProperty<Color> frameColorProperty() {
        return this.frameColor;
    }

    public final Color getBackgroundColor() {
        return (Color)this.backgroundColor.get();
    }

    public final void setBackgroundColor(Color BACKGROUND_COLOR) {
        this.backgroundColor.set((Object)BACKGROUND_COLOR);
    }

    public final ObjectProperty<Color> backgroundColorProperty() {
        return this.backgroundColor;
    }

    public final Color getTickMarkColor() {
        return (Color)this.tickMarkColor.get();
    }

    public final void setTickMarkColor(Color TICK_MARK_COLOR) {
        this.tickMarkColor.set((Object)TICK_MARK_COLOR);
    }

    public final ObjectProperty<Color> tickMarkColorProperty() {
        return this.tickMarkColor;
    }

    public final Color getPointerColor() {
        return (Color)this.pointerColor.get();
    }

    public final void setPointerColor(Color POINTER_COLOR) {
        this.pointerColor.set((Object)POINTER_COLOR);
    }

    public final ObjectProperty<Color> pointerColorProperty() {
        return this.pointerColor;
    }

    public final Color getCenterKnobColor() {
        return (Color)this.centerKnobColor.get();
    }

    public final void setCenterKnobColor(Color CENTER_KNOB_COLOR) {
        this.centerKnobColor.set((Object)CENTER_KNOB_COLOR);
    }

    public final ObjectProperty<Color> centerKnobColorProperty() {
        return this.centerKnobColor;
    }

    public final Color getThresholdLedColor() {
        return (Color)this.thresholdLedColor.get();
    }

    public final void setThresholdLedColor(Color THRESHOLD_LED_COLOR) {
        this.thresholdLedColor.set((Object)THRESHOLD_LED_COLOR);
    }

    public final ObjectProperty<Color> thresholdLedColorProperty() {
        return this.thresholdLedColor;
    }

    public final boolean isPointerShadowVisible() {
        return this.pointerShadowVisible.get();
    }

    public final void setPointerShadowVisible(boolean POINTER_SHADOW_VISIBLE) {
        this.pointerShadowVisible.set(POINTER_SHADOW_VISIBLE);
    }

    public final BooleanProperty pointerShadowVisibleProperty() {
        return this.pointerShadowVisible;
    }

    public final double getTimeToValueInMs() {
        return this.timeToValueInMs.get();
    }

    public final void setTimeToValueInMs(double TIME_TO_VALUE_IN_MS) {
        double value = TIME_TO_VALUE_IN_MS < 10.0 ? 10.0 : (TIME_TO_VALUE_IN_MS > 5000.0 ? 5000.0 : TIME_TO_VALUE_IN_MS);
        this.timeToValueInMs.set(value);
    }

    public final DoubleProperty timeToValueInMsProperty() {
        return this.timeToValueInMs;
    }

    public void setPrefSize(double WIDTH, double HEIGHT) {
        double SIZE = WIDTH < HEIGHT * 1.0 ? WIDTH * 1.0 : HEIGHT;
        super.setPrefSize(SIZE, SIZE);
    }

    public void setMinSize(double WIDTH, double HEIGHT) {
        double size = WIDTH < HEIGHT * 1.0 ? WIDTH * 1.0 : HEIGHT;
        size = size < 30.0 ? 30.0 : size;
        super.setPrefSize(size, size);
    }

    public void setMaxSize(double WIDTH, double HEIGHT) {
        double size = WIDTH < HEIGHT * 1.0 ? WIDTH * 1.0 : HEIGHT;
        size = size > 500.0 ? 500.0 : size;
        super.setPrefSize(size, size);
    }
}

