/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.scene.control.gauge;

import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.scene.control.Control;
import javafx.scene.paint.Color;

public class StepIndicator
extends Control {
    private static final String DEFAULT_STYLE_CLASS = "step-indicator";
    private ObjectProperty<EventHandler<StepEvent>> onStepEvent = new SimpleObjectProperty();
    private ObjectProperty<Color> color;
    private IntegerProperty noOfSteps;
    private IntegerProperty currentStep;
    private int selectedStep;

    public StepIndicator() {
        this(Color.rgb((int)138, (int)205, (int)250));
    }

    public StepIndicator(Color COLOR) {
        this.color = new SimpleObjectProperty((Object)COLOR);
        this.noOfSteps = new SimpleIntegerProperty(5);
        this.currentStep = new SimpleIntegerProperty(0);
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
    }

    public final Color getColor() {
        return (Color)this.color.get();
    }

    public final void setColor(Color COLOR) {
        this.color.set((Object)COLOR);
    }

    public final ObjectProperty<Color> colorProperty() {
        return this.color;
    }

    public final int getNoOfSteps() {
        return this.noOfSteps.get();
    }

    public final void setNoOfSteps(int NO_OF_STEPS) {
        this.noOfSteps.set(NO_OF_STEPS < 1 ? 1 : (NO_OF_STEPS > 20 ? 20 : NO_OF_STEPS));
    }

    public final IntegerProperty noOfStepsProperty() {
        return this.noOfSteps;
    }

    public final int getCurrentStep() {
        return this.currentStep.get();
    }

    public final void setCurrentStep(int CURRENT_STEP) {
        this.currentStep.set(CURRENT_STEP < 0 ? 0 : (CURRENT_STEP > this.noOfSteps.get() ? this.noOfSteps.get() : CURRENT_STEP));
    }

    public final IntegerProperty currentStepProperty() {
        return this.currentStep;
    }

    public final void next() {
        if (this.currentStep.get() < this.noOfSteps.get()) {
            this.currentStep.set(this.currentStep.get() + 1);
        }
    }

    public final void back() {
        if (this.currentStep.get() > 0) {
            this.currentStep.set(this.currentStep.get() - 1);
        }
    }

    public final void setSelectedStep(int SELECTED_STEP) {
        this.selectedStep = SELECTED_STEP;
    }

    public void setPrefSize(double WIDTH, double HEIGHT) {
        double SIZE = WIDTH < HEIGHT ? WIDTH : HEIGHT;
        super.setPrefSize((double)this.noOfSteps.get() * SIZE, SIZE);
    }

    public final ObjectProperty<EventHandler<StepEvent>> onStepEventProperty() {
        return this.onStepEvent;
    }

    public final void setOnStepEvent(EventHandler<StepEvent> HANDLER) {
        this.onStepEventProperty().set(HANDLER);
    }

    public final EventHandler<StepEvent> getOnStepEvent() {
        return (EventHandler)this.onStepEventProperty().get();
    }

    public void fireStepEvent() {
        EventHandler<StepEvent> MODEL_EVENT_HANDLER;
        if (this.selectedStep > 0 && (MODEL_EVENT_HANDLER = this.getOnStepEvent()) != null) {
            StepEvent Step_EVENT = new StepEvent(this.selectedStep);
            MODEL_EVENT_HANDLER.handle((Event)Step_EVENT);
        }
    }

    protected String getUserAgentStylesheet() {
        return ((Object)((Object)this)).getClass().getResource("extras.css").toExternalForm();
    }

    public class StepEvent
    extends Event {
        private final int INDEX;

        public StepEvent(int INDEX) {
            super(new EventType());
            this.INDEX = INDEX;
        }

        public StepEvent(Object source, EventTarget target, int INDEX) {
            super(source, target, new EventType());
            this.INDEX = INDEX;
        }

        public final int getIndex() {
            return this.INDEX;
        }
    }
}

