/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.scene.control.gauge;

import java.util.HashMap;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.control.ControlBuilder;
import javafx.scene.paint.Color;
import javafx.util.Builder;
import jfxtras.labs.scene.control.gauge.StepIndicator;

public class StepIndicatorBuilder<B extends StepIndicatorBuilder<B>>
extends ControlBuilder<B>
implements Builder<StepIndicator> {
    private HashMap<String, Property> properties = new HashMap();

    protected StepIndicatorBuilder() {
    }

    public static final StepIndicatorBuilder create() {
        return new StepIndicatorBuilder();
    }

    public final StepIndicatorBuilder noOfSteps(int NO_OF_STEPS) {
        this.properties.put("noOfSteps", (Property)new SimpleIntegerProperty(NO_OF_STEPS));
        return this;
    }

    public final StepIndicatorBuilder color(Color COLOR) {
        this.properties.put("color", (Property)new SimpleObjectProperty((Object)COLOR));
        return this;
    }

    public final StepIndicatorBuilder currentStep(int CURRENT_STEP) {
        this.properties.put("currentStep", (Property)new SimpleIntegerProperty(CURRENT_STEP));
        return this;
    }

    public final B prefWidth(double PREF_WIDTH) {
        this.properties.put("prefWidth", (Property)new SimpleDoubleProperty(PREF_WIDTH));
        return (B)((Object)this);
    }

    public final B prefHeight(double PREF_HEIGHT) {
        this.properties.put("prefHeight", (Property)new SimpleDoubleProperty(PREF_HEIGHT));
        return (B)((Object)this);
    }

    public final B layoutX(double LAYOUT_X) {
        this.properties.put("layoutX", (Property)new SimpleDoubleProperty(LAYOUT_X));
        return (B)((Object)this);
    }

    public final B layoutY(double LAYOUT_Y) {
        this.properties.put("layoutY", (Property)new SimpleDoubleProperty(LAYOUT_Y));
        return (B)((Object)this);
    }

    public final StepIndicator build() {
        StepIndicator CONTROL = new StepIndicator();
        for (String key : this.properties.keySet()) {
            if ("noOfSteps".equals(key)) {
                CONTROL.setNoOfSteps(((IntegerProperty)this.properties.get(key)).get());
                continue;
            }
            if ("color".equals(key)) {
                CONTROL.setColor((Color)((ObjectProperty)this.properties.get(key)).get());
                continue;
            }
            if ("currentStep".equals(key)) {
                CONTROL.setCurrentStep(((IntegerProperty)this.properties.get(key)).get());
                continue;
            }
            if ("prefWidth".equals(key)) {
                CONTROL.setPrefWidth(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("prefHeight".equals(key)) {
                CONTROL.setPrefHeight(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if ("layoutX".equals(key)) {
                CONTROL.setLayoutX(((DoubleProperty)this.properties.get(key)).get());
                continue;
            }
            if (!"layoutY".equals(key)) continue;
            CONTROL.setLayoutY(((DoubleProperty)this.properties.get(key)).get());
        }
        return CONTROL;
    }
}

