/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.scene.control.gauge;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.MissingResourceException;

public class UtilHex {
    private byte[] rawData = null;

    public static byte[] toBytes(String hexString) {
        String[] bytes = hexString.split("\\s");
        return UtilHex.toBytes(bytes);
    }

    public static byte[] toBytes(String[] bytes) {
        ArrayList<Byte> list = new ArrayList<Byte>();
        for (String bStr : bytes) {
            int n = 0;
            if (!bStr.equals("0") && !bStr.equals("00")) {
                n = Byte.parseByte(bStr.substring(0, 1), 16);
                n = 16 * n + Byte.parseByte(bStr.substring(1), 16);
            }
            list.add(new Byte((byte)n));
        }
        byte[] result = new byte[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            result[i] = (Byte)list.get(i);
        }
        return result;
    }

    public static String long2Dword(long l, boolean bLastSB) {
        String s1 = Long.toHexString(l);
        String ss1 = "00000000".substring(0, 8 - s1.length()).concat(s1);
        if (bLastSB) {
            return ss1.substring(6, 8).concat(" ").concat(ss1.substring(4, 6)).concat(" ").concat(ss1.substring(2, 4)).concat(" ").concat(ss1.substring(0, 2));
        }
        return ss1.substring(0, 2).concat(" ").concat(ss1.substring(2, 4)).concat(" ").concat(ss1.substring(4, 6)).concat(" ").concat(ss1.substring(6, 8));
    }

    public static String long2Word(long l, boolean bLastSB) {
        String s1 = Long.toHexString(l);
        String ss1 = "0000".substring(0, 4 - s1.length()).concat(s1);
        if (bLastSB) {
            return ss1.substring(2, 4).concat(" ").concat(ss1.substring(0, 2));
        }
        return ss1.substring(0, 2).concat(" ").concat(ss1.substring(2, 4));
    }

    public static String dec2hexStr(byte b) {
        return Integer.toString((b & 0xFF) + 256, 16).substring(1).toUpperCase();
    }

    public static String dec2hexStr(int b) {
        return Integer.toString((b & 0xFF) + 256, 16).substring(1).toUpperCase();
    }

    public static String bin2Hex(String s) {
        return Integer.toHexString(Integer.parseInt(s, 2));
    }

    public static String bytes2String(byte[] theBytes) {
        String out = "";
        for (int i = 0; i < theBytes.length; ++i) {
            out = out.concat(UtilHex.dec2hexStr(theBytes[i]));
            if (i >= theBytes.length - 1) continue;
            out = out.concat(" ");
        }
        return out;
    }

    public static int word2Int(String s1, String s2) {
        String ss1 = "00".substring(0, 2 - s1.length()).concat(s1);
        String ss2 = ss1.concat("00".substring(0, 2 - s2.length()).concat(s2));
        return Integer.parseInt(ss2, 16);
    }

    public static long dword2Long(String s1, String s2, String s3, String s4) {
        String ss1 = "00".substring(0, 2 - s1.length()).concat(s1);
        String ss2 = ss1.concat("00".substring(0, 2 - s2.length()).concat(s2));
        String ss3 = ss2.concat("00".substring(0, 2 - s3.length()).concat(s3));
        String ss4 = ss3.concat("00".substring(0, 2 - s4.length()).concat(s4));
        return Long.parseLong(ss4, 16);
    }

    public static int hex2Decimal(String s) {
        int decimal = Integer.parseInt(s, 16);
        return decimal;
    }

    public static String String2Binary(String s) {
        return Integer.toBinaryString(UtilHex.hex2Decimal(s));
    }

    public static String hex2bin(String s) {
        String s1 = UtilHex.String2Binary(s);
        String ss1 = "00000000".substring(0, 8 - s1.length()).concat(s1);
        return ss1;
    }

    public boolean convertsBmp(String pathBmp, int minLevel, int maxLevel, boolean colorR, boolean colorG, boolean colorB) {
        if (maxLevel > 255) {
            maxLevel = 255;
        }
        if (minLevel > maxLevel) {
            minLevel = maxLevel;
        }
        if (minLevel < 0) {
            minLevel = 0;
        }
        int[] tonos = new int[]{minLevel, (maxLevel + minLevel) / 2, maxLevel};
        int[] colores = new int[]{colorR ? 1 : 0, colorG ? 1 : 0, colorB ? 1 : 0};
        String fullpathBmp = pathBmp.endsWith(".bmp") ? pathBmp : pathBmp.concat(".bmp");
        InputStream bmpStream = null;
        try {
            bmpStream = this.getClass().getResourceAsStream(fullpathBmp);
        }
        catch (MissingResourceException mre) {
            // empty catch block
        }
        jBMP2Panel bmp = new jBMP2Panel(fullpathBmp, colores, tonos);
        try {
            boolean bFound = false;
            bFound = bmpStream != null ? bmp.getBMPImageFromStream(bmpStream) : bmp.getBMPImage();
            if (bFound) {
                String mem = bmp.BMP2MemoriaGrafica();
                this.rawData = UtilHex.toBytes(mem);
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public String getRawData() {
        if (this.rawData == null) {
            return null;
        }
        return UtilHex.bytes2String(this.rawData);
    }

    private class jBMP2Panel {
        private InputStream is;
        private int curPos = 0;
        private int bitmapOffset;
        private int width;
        private int height;
        private int levels = 3;
        private int[] tonos;
        private int colorMask = 1;
        private int numColors = 1;
        private short bitsPerPixel;
        private int compression;
        private int actualSizeOfBitmap;
        private int scanLineSize;
        private int actualColorsUsed;
        private byte[] r;
        private byte[] g;
        private byte[] b;
        private int noOfEntries;
        private byte[] byteData;
        private int[] intData;
        private byte[] m_RawData = null;
        private String m_sFullPath = null;

        public jBMP2Panel(String fullPath, int[] colores, int[] tonos) {
            this.m_sFullPath = fullPath;
            this.tonos = tonos;
            this.levels = tonos.length;
            this.colorMask = colores[0] + 2 * colores[1] + 4 * colores[2];
            this.numColors = 3;
        }

        public boolean getBMPImage() throws Exception {
            File file = new File(this.m_sFullPath);
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(file);
            }
            catch (FileNotFoundException ex) {
                System.out.println("File " + this.m_sFullPath + " not found");
                return false;
            }
            try {
                this.read(fis);
            }
            catch (IOException ex) {
                System.out.append("Error reading bmp file");
                return false;
            }
            return true;
        }

        public boolean getBMPImageFromStream(InputStream stream) throws Exception {
            try {
                this.read(stream);
            }
            catch (IOException ex) {
                System.out.append("Error reading bmp file");
                return false;
            }
            return true;
        }

        protected void getFileHeader() throws IOException, Exception {
            int fileType = 19778;
            short reserved1 = 0;
            short reserved2 = 0;
            fileType = this.readShort();
            if (fileType != 19778) {
                throw new Exception("Not a BMP file");
            }
            int fileSize = this.readInt();
            reserved1 = this.readShort();
            reserved2 = this.readShort();
            this.bitmapOffset = this.readInt();
        }

        protected void getBitmapHeader() throws IOException {
            int size = this.readInt();
            this.width = this.readInt();
            this.height = this.readInt();
            short planes = this.readShort();
            this.bitsPerPixel = this.readShort();
            this.compression = this.readInt();
            int sizeOfBitmap = this.readInt();
            int horzResolution = this.readInt();
            int vertResolution = this.readInt();
            int colorsUsed = this.readInt();
            int colorsImportant = this.readInt();
            boolean topDown = this.height < 0;
            int noOfPixels = this.width * this.height;
            this.scanLineSize = (this.width * this.bitsPerPixel + 31) / 32 * 4;
            this.actualSizeOfBitmap = sizeOfBitmap != 0 ? sizeOfBitmap : this.scanLineSize * this.height;
            this.actualColorsUsed = colorsUsed != 0 ? colorsUsed : (this.bitsPerPixel < 16 ? 1 << this.bitsPerPixel : 0);
        }

        protected void getPalette() throws IOException {
            this.noOfEntries = this.actualColorsUsed;
            if (this.noOfEntries > 0) {
                this.r = new byte[this.noOfEntries];
                this.g = new byte[this.noOfEntries];
                this.b = new byte[this.noOfEntries];
                for (int i = 0; i < this.noOfEntries; ++i) {
                    this.b[i] = (byte)this.is.read();
                    this.g[i] = (byte)this.is.read();
                    this.r[i] = (byte)this.is.read();
                    int reserved = this.is.read();
                    this.curPos += 4;
                }
            }
        }

        protected void unpack(byte[] rawData, int rawOffset, int[] intData, int intOffset, int w) {
            int j = intOffset;
            int k = rawOffset;
            int mask = 255;
            for (int i = 0; i < w; ++i) {
                int b0 = rawData[k++] & mask;
                int b1 = (rawData[k++] & mask) << 8;
                int b2 = (rawData[k++] & mask) << 16;
                intData[j] = 0xFF000000 | b0 | b1 | b2;
                ++j;
            }
        }

        protected void unpack(byte[] rawData, int rawOffset, int bpp, byte[] byteData, int byteOffset, int w) throws Exception {
            int pixPerByte;
            int mask;
            int j = byteOffset;
            int k = rawOffset;
            switch (bpp) {
                case 1: {
                    mask = 1;
                    pixPerByte = 8;
                    break;
                }
                case 4: {
                    mask = 15;
                    pixPerByte = 2;
                    break;
                }
                case 8: {
                    mask = -1;
                    pixPerByte = 1;
                    break;
                }
                default: {
                    throw new Exception("Unsupported bits-per-pixel value");
                }
            }
            int i = 0;
            while (true) {
                int shift = 8 - bpp;
                for (int ii = 0; ii < pixPerByte; ++ii) {
                    byte br = rawData[k];
                    br = (byte)(br >> shift);
                    byteData[j] = (byte)(br & mask);
                    ++j;
                    if (++i == w) {
                        return;
                    }
                    shift -= bpp;
                }
                ++k;
            }
        }

        protected int readScanLine(byte[] b, int off, int len) throws IOException {
            int bytesRead = 0;
            int l = len;
            int r = 0;
            while (len > 0) {
                bytesRead = this.is.read(b, off, len);
                if (bytesRead == -1) {
                    return r == 0 ? -1 : r;
                }
                if (bytesRead == len) {
                    return l;
                }
                len -= bytesRead;
                off += bytesRead;
                r += bytesRead;
            }
            return l;
        }

        protected void getPixelData() throws IOException, Exception {
            long skip = this.bitmapOffset - this.curPos;
            if (skip > 0L) {
                this.is.skip(skip);
                this.curPos = (int)((long)this.curPos + skip);
            }
            int len = this.scanLineSize;
            if (this.bitsPerPixel > 8) {
                this.intData = new int[this.width * this.height];
            } else {
                this.byteData = new byte[this.width * this.height];
            }
            this.m_RawData = new byte[this.actualSizeOfBitmap];
            int rawOffset = 0;
            int offset = (this.height - 1) * this.width;
            for (int i = this.height - 1; i >= 0; --i) {
                int n = this.readScanLine(this.m_RawData, rawOffset, len);
                if (n < len) {
                    throw new Exception("Scan line ended prematurely after " + n + " bytes");
                }
                if (this.bitsPerPixel > 8) {
                    this.unpack(this.m_RawData, rawOffset, this.intData, offset, this.width);
                } else {
                    this.unpack(this.m_RawData, rawOffset, this.bitsPerPixel, this.byteData, offset, this.width);
                }
                rawOffset += len;
                offset -= this.width;
            }
        }

        public String BMP2MemoriaGrafica() {
            int colSize = (this.width / 8 + (this.width % 8 > 0 ? 1 : 0)) * 8;
            int lineSize = (this.width / 16 + (this.width % 16 > 0 ? 1 : 0)) * 16;
            long tam = 32L + (long)(this.levels * lineSize * this.height * this.numColors / 8);
            String mem = "04 DF FF FF FF FF ";
            mem = mem.concat(UtilHex.long2Word(colSize, false)).concat(" ").concat(UtilHex.long2Word(this.height, false)).concat(" ");
            mem = mem.concat(UtilHex.dec2hexStr(this.colorMask)).concat(" ").concat(UtilHex.dec2hexStr(this.levels)).concat(" ");
            mem = mem.concat("00 00 00 00 00 00 01 00 ").concat(UtilHex.long2Dword(tam - 32L, false)).concat(" ");
            mem = mem.concat(UtilHex.long2Dword(tam, false)).concat(" 00 00 00 00");
            for (int k = 0; k < this.levels; ++k) {
                String[][] planos = this.getPanelRawData(this.tonos[k]);
                for (int i = 0; i < this.numColors; ++i) {
                    for (int j = 0; j < planos[i].length; ++j) {
                        mem = mem.concat(" ").concat(planos[i][j]);
                    }
                }
            }
            return mem;
        }

        public String[] getMemoriaGrafica(int tonoMax) {
            String[] mem = new String[3];
            String[][] planos = this.getPanelRawData(tonoMax);
            for (int i = 0; i < 3; ++i) {
                mem[i] = "";
                for (int j = 0; j < planos[i].length; ++j) {
                    mem[i] = mem[i].concat(planos[i][j]);
                    if (j > 0 && (j + 1) % 8 == 0) {
                        mem[i] = mem[i].concat("#");
                        continue;
                    }
                    if (j >= planos[i].length - 1) continue;
                    mem[i] = mem[i].concat(" ");
                }
            }
            return mem;
        }

        private String[][] getPanelRawData(int tonoMax) {
            int coloresPorPixel = 3;
            int tam = this.scanLineSize;
            int colSize = (this.width / 8 + (this.width % 8 > 0 ? 1 : 0)) * 8;
            int lineSize = (this.width / 16 + (this.width % 16 > 0 ? 1 : 0)) * 16;
            String[][] panelData = new String[coloresPorPixel][this.height * lineSize / 8];
            int[] swapBMP = new int[]{2, 1, 0};
            for (int k = 0; k < coloresPorPixel; ++k) {
                int iPlano = swapBMP[k];
                int pos = 0;
                String lastBit = "";
                for (int j = this.height - 1; j >= 0; --j) {
                    for (int i = k; i < lineSize * coloresPorPixel + k; i += coloresPorPixel * 8) {
                        String bits = "";
                        for (int m = 0; m < 8; ++m) {
                            if (i + m * coloresPorPixel < tam) {
                                if ((this.m_RawData[i + m * coloresPorPixel + j * tam] & 0xFF) >= tonoMax) {
                                    bits = bits.concat("1");
                                    lastBit = "1";
                                    continue;
                                }
                                bits = bits.concat("0");
                                lastBit = "0";
                                continue;
                            }
                            if (i + m * coloresPorPixel < colSize * coloresPorPixel) {
                                bits = bits.concat("0");
                                continue;
                            }
                            if (i + m * coloresPorPixel >= lineSize * coloresPorPixel) continue;
                            bits = bits.concat("0");
                        }
                        if (pos >= lineSize * this.height / 8) continue;
                        String s1 = UtilHex.bin2Hex(bits);
                        String ss1 = "00".substring(0, 2 - s1.length()).concat(s1);
                        panelData[iPlano][pos++] = ss1;
                    }
                }
            }
            return panelData;
        }

        public void read(InputStream is) throws IOException, Exception {
            this.is = is;
            this.getFileHeader();
            this.getBitmapHeader();
            if (this.compression != 0) {
                throw new Exception("BMP Compression not supported");
            }
            this.getPalette();
            this.getPixelData();
        }

        protected int readInt() throws IOException {
            int b1 = this.is.read();
            int b2 = this.is.read();
            int b3 = this.is.read();
            int b4 = this.is.read();
            this.curPos += 4;
            return (b4 << 24) + (b3 << 16) + (b2 << 8) + (b1 << 0);
        }

        protected short readShort() throws IOException {
            int b1 = this.is.read();
            int b2 = this.is.read();
            this.curPos += 4;
            return (short)((b2 << 8) + b1);
        }
    }
}

