/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.scene.control.gauge;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.geometry.Point2D;
import javafx.scene.control.Control;
import javafx.scene.paint.Color;

public class XYControl
extends Control {
    private static final String DEFAULT_STYLE_CLASS = "xy-control";
    private DoubleProperty xValue = new SimpleDoubleProperty(0.0);
    private DoubleProperty yValue = new SimpleDoubleProperty(0.0);
    private StringProperty xAxisLabel = new SimpleStringProperty("x");
    private StringProperty yAxisLabel = new SimpleStringProperty("y");
    private BooleanProperty xAxisLabelVisible = new SimpleBooleanProperty(false);
    private BooleanProperty yAxisLabelVisible = new SimpleBooleanProperty(false);
    private ObjectProperty<Sensitivity> sensitivity = new SimpleObjectProperty((Object)Sensitivity.COARSE);
    private ObjectProperty<Point2D> position = new SimpleObjectProperty((Object)new Point2D(this.xValue.get(), this.yValue.get()));

    public XYControl() {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
    }

    public void setPrefSize(double WIDTH, double HEIGHT) {
        double SIZE = WIDTH < HEIGHT ? WIDTH : HEIGHT;
        super.setPrefSize(SIZE, SIZE);
    }

    public final double getXValue() {
        return this.xValue.get();
    }

    public final void setXValue(double X_VALUE) {
        this.validateValue(X_VALUE, this.xValue);
    }

    public final DoubleProperty xValueProperty() {
        return this.xValue;
    }

    public final double getYValue() {
        return this.yValue.get();
    }

    public final void setYValue(double Y_VALUE) {
        this.validateValue(Y_VALUE, this.yValue);
    }

    public final DoubleProperty yValueProperty() {
        return this.yValue;
    }

    public final String getXAxisLabel() {
        return (String)this.xAxisLabel.get();
    }

    public final void setXAxisLabel(String X_AXIS_LABEL) {
        this.xAxisLabel.set((Object)X_AXIS_LABEL);
    }

    public final StringProperty xAxisLabelProperty() {
        return this.xAxisLabel;
    }

    public final String getYAxisLabel() {
        return (String)this.yAxisLabel.get();
    }

    public final void setYAxisLabel(String Y_AXIS_LABEL) {
        this.yAxisLabel.set((Object)Y_AXIS_LABEL);
    }

    public final StringProperty yAxisLabelProperty() {
        return this.yAxisLabel;
    }

    public final boolean isXAxisLabelVisible() {
        return this.xAxisLabelVisible.get();
    }

    public final void setXAxisLabelVisible(boolean X_AXIS_LABEL_VISIBLE) {
        this.xAxisLabelVisible.set(X_AXIS_LABEL_VISIBLE);
    }

    public final BooleanProperty xAxisLabelVisibleProperty() {
        return this.xAxisLabelVisible;
    }

    public final boolean isYAxisLabelVisible() {
        return this.yAxisLabelVisible.get();
    }

    public final void setYAxisLabelVisible(boolean Y_AXIS_LABEL_VISIBLE) {
        this.yAxisLabelVisible.set(Y_AXIS_LABEL_VISIBLE);
    }

    public final BooleanProperty yAxisLabelVisibleProperty() {
        return this.yAxisLabelVisible;
    }

    public final Sensitivity getSensitivity() {
        return (Sensitivity)((Object)this.sensitivity.get());
    }

    public final void setSensitivity(Sensitivity SENSITIVITY) {
        this.sensitivity.set((Object)SENSITIVITY);
    }

    public final ObjectProperty<Sensitivity> sensitivityProperty() {
        return this.sensitivity;
    }

    public final Point2D getPosition() {
        return (Point2D)this.position.get();
    }

    public final void setPosition(double X_VALUE, double Y_VALUE) {
        this.setXValue(X_VALUE);
        this.setYValue(Y_VALUE);
    }

    public final void setPosition(Point2D POSITION) {
        this.setXValue(POSITION.getX());
        this.setYValue(POSITION.getY());
        this.position.set((Object)POSITION);
    }

    public final ObjectProperty<Point2D> positionProperty() {
        return this.position;
    }

    public final void incrementX() {
        this.setXValue(this.getXValue() + ((Sensitivity)((Object)this.sensitivity.get())).STEP_SIZE);
    }

    public final void decrementX() {
        this.setXValue(this.getXValue() - ((Sensitivity)((Object)this.sensitivity.get())).STEP_SIZE);
    }

    public final void incrementY() {
        this.setYValue(this.getYValue() + ((Sensitivity)((Object)this.sensitivity.get())).STEP_SIZE);
    }

    public final void decrementY() {
        this.setYValue(this.getYValue() - ((Sensitivity)((Object)this.sensitivity.get())).STEP_SIZE);
    }

    public final void reset() {
        this.setXValue(0.0);
        this.setYValue(0.0);
    }

    private void validateValue(double VALUE, DoubleProperty TARGET) {
        double value = VALUE < -1.0 ? -1.0 : (VALUE > 1.0 ? 1.0 : VALUE);
        TARGET.set(value);
    }

    protected String getUserAgentStylesheet() {
        return ((Object)((Object)this)).getClass().getResource("extras.css").toExternalForm();
    }

    public static enum Sensitivity {
        COARSE(0.1, Color.RED),
        MEDIUM(0.025, Color.rgb((int)255, (int)191, (int)0)),
        FINE(0.005, Color.LIME);

        public final double STEP_SIZE;
        public final Color COLOR;

        private Sensitivity(double STEP_SIZE, Color COLOR) {
            this.STEP_SIZE = STEP_SIZE;
            this.COLOR = COLOR;
        }
    }
}

