/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.scene.control.grid.cell;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.media.Media;
import javafx.scene.media.MediaPlayer;
import javafx.scene.media.MediaPlayerBuilder;
import javafx.scene.media.MediaView;
import javafx.scene.media.MediaViewBuilder;
import jfxtras.labs.scene.control.grid.GridCell;

public class MediaImageCell
extends GridCell<Media> {
    private MediaPlayer mediaPlayer;

    public MediaImageCell() {
        this.getStyleClass().add((Object)"media-grid-cell");
        this.itemProperty().addListener((ChangeListener)new ChangeListener<Media>(){

            public void changed(ObservableValue<? extends Media> arg0, Media arg1, Media arg2) {
                MediaImageCell.this.getChildren().clear();
                if (MediaImageCell.this.mediaPlayer != null) {
                    MediaImageCell.this.mediaPlayer.stop();
                }
                MediaImageCell.this.mediaPlayer = MediaPlayerBuilder.create().media(arg2).build();
                MediaView mediaView = MediaViewBuilder.create().mediaPlayer(MediaImageCell.this.mediaPlayer).build();
                mediaView.fitHeightProperty().bind((ObservableValue)MediaImageCell.this.heightProperty());
                mediaView.fitWidthProperty().bind((ObservableValue)MediaImageCell.this.widthProperty());
                MediaImageCell.this.setGraphic((Node)mediaView);
            }
        });
    }

    public void pause() {
        if (this.mediaPlayer != null) {
            this.mediaPlayer.pause();
        }
    }

    public void play() {
        if (this.mediaPlayer != null) {
            this.mediaPlayer.play();
        }
    }

    public void stop() {
        if (this.mediaPlayer != null) {
            this.mediaPlayer.stop();
        }
    }
}

