/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.scene.control.radialmenu;

import java.util.ArrayList;
import java.util.List;
import javafx.animation.FadeTransition;
import javafx.animation.FadeTransitionBuilder;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.ParallelTransition;
import javafx.animation.ParallelTransitionBuilder;
import javafx.animation.Timeline;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Group;
import javafx.scene.GroupBuilder;
import javafx.scene.Node;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.CircleBuilder;
import javafx.util.Duration;
import jfxtras.labs.scene.control.radialmenu.RadialMenuItem;

public class RadialMenu
extends Group
implements EventHandler<MouseEvent>,
ChangeListener<Object> {
    protected List<RadialMenuItem> items = new ArrayList<RadialMenuItem>();
    protected DoubleProperty innerRadius;
    protected DoubleProperty radius;
    protected DoubleProperty offset;
    protected DoubleProperty initialAngle;
    protected ObjectProperty<Paint> backgroundFill;
    protected ObjectProperty<Paint> backgroundMouseOnFill;
    protected ObjectProperty<Paint> strokeMouseOnFill;
    protected ObjectProperty<Paint> strokeFill;
    protected BooleanProperty clockwise;
    protected BooleanProperty backgroundVisible;
    protected BooleanProperty strokeVisible;
    protected ObjectProperty<CenterVisibility> centerVisibility;
    protected ObjectProperty<Node> centerGraphic;
    protected Circle centerStrokeShape;
    protected Group centerGroup;
    protected Group itemGroup;
    private boolean mouseOn = false;
    private double lastInitialAngleValue;
    private double lastOffsetValue;

    public Paint getBackgroundFill() {
        return (Paint)this.backgroundFill.get();
    }

    public void setBackgroundFill(Paint backgroundFill) {
        this.backgroundFill.set((Object)backgroundFill);
    }

    public ObjectProperty<Paint> backgroundFillProperty() {
        return this.backgroundFill;
    }

    public Paint getBackgroundMouseOnFill() {
        return (Paint)this.backgroundMouseOnFill.get();
    }

    public void setBackgroundMouseOnFill(Paint backgroundMouseOnFill) {
        this.backgroundMouseOnFill.set((Object)backgroundMouseOnFill);
    }

    public ObjectProperty<Paint> backgroundMouseOnFillProperty() {
        return this.backgroundMouseOnFill;
    }

    public Paint getStrokeMouseOnFill() {
        return (Paint)this.strokeMouseOnFill.get();
    }

    public void setStrokeMouseOnFill(Paint backgroundMouseOnFill) {
        this.strokeMouseOnFill.set((Object)backgroundMouseOnFill);
    }

    public ObjectProperty<Paint> strokeMouseOnFillProperty() {
        return this.strokeMouseOnFill;
    }

    public Paint getStrokeFill() {
        return (Paint)this.strokeFill.get();
    }

    public void setStrokeFill(Paint strokeFill) {
        this.strokeFill.set((Object)strokeFill);
    }

    public ObjectProperty<Paint> strokeFillProperty() {
        return this.strokeFill;
    }

    public Node getCenterGraphic() {
        return (Node)this.centerGraphic.get();
    }

    public void setCenterGraphic(Node graphic) {
        if (this.centerGraphic.get() != null) {
            this.centerGroup.getChildren().remove(this.centerGraphic.get());
        }
        if (graphic != null) {
            this.centerGroup.getChildren().add((Object)graphic);
        }
        this.centerGraphic.set((Object)graphic);
    }

    public ObjectProperty<Node> centerGraphicProperty() {
        return this.centerGraphic;
    }

    public double getInitialAngle() {
        return this.initialAngle.get();
    }

    public DoubleProperty initialAngleProperty() {
        return this.initialAngle;
    }

    public double getInnerRadius() {
        return this.innerRadius.get();
    }

    public DoubleProperty innerRadiusProperty() {
        return this.innerRadius;
    }

    public double getRadius() {
        return this.radius.get();
    }

    public DoubleProperty radiusProperty() {
        return this.radius;
    }

    public double getOffset() {
        return this.offset.get();
    }

    public DoubleProperty offsetProperty() {
        return this.offset;
    }

    public boolean isClockwise() {
        return this.clockwise.get();
    }

    public BooleanProperty clockwiseProperty() {
        return this.clockwise;
    }

    public boolean isBackgroundVisible() {
        return this.backgroundVisible.get();
    }

    public BooleanProperty backgroundVisibleProperty() {
        return this.backgroundVisible;
    }

    public BooleanProperty strokeVisibleProperty() {
        return this.strokeVisible;
    }

    public boolean isStrokeVisible() {
        return this.strokeVisible.get();
    }

    public ObjectProperty<CenterVisibility> centerVisibilityProperty() {
        return this.centerVisibility;
    }

    public CenterVisibility getCenterVisibility() {
        return (CenterVisibility)((Object)this.centerVisibility.get());
    }

    public void setCenterVisibility(CenterVisibility visibility) {
        this.centerVisibility.set((Object)visibility);
    }

    public RadialMenu() {
    }

    public RadialMenu(double initialAngle, double innerRadius, double radius, double offset, Paint bgFill, Paint bgMouseOnFill, Paint strokeFill, Paint strokeMouseOnFill, boolean clockwise, CenterVisibility centerVisibility, Node centerGraphic) {
        this.itemGroup = GroupBuilder.create().build();
        this.getChildren().add((Object)this.itemGroup);
        this.initialAngle = new SimpleDoubleProperty(initialAngle);
        this.initialAngle.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> paramObservableValue, Number paramT1, Number paramT2) {
                RadialMenu.this.setInitialAngle(((Number)paramObservableValue.getValue()).doubleValue());
            }
        });
        this.innerRadius = new SimpleDoubleProperty(innerRadius);
        this.strokeFill = new SimpleObjectProperty((Object)strokeFill);
        this.strokeFill.addListener((ChangeListener)this);
        this.radius = new SimpleDoubleProperty(radius);
        this.offset = new SimpleDoubleProperty(offset);
        this.clockwise = new SimpleBooleanProperty(clockwise);
        this.backgroundFill = new SimpleObjectProperty((Object)bgFill);
        this.backgroundFill.addListener((ChangeListener)this);
        this.backgroundMouseOnFill = new SimpleObjectProperty((Object)bgMouseOnFill);
        this.backgroundMouseOnFill.addListener((ChangeListener)this);
        this.strokeMouseOnFill = new SimpleObjectProperty((Object)strokeMouseOnFill);
        this.strokeMouseOnFill.addListener((ChangeListener)this);
        this.strokeVisible = new SimpleBooleanProperty(true);
        this.backgroundVisible = new SimpleBooleanProperty(true);
        this.centerVisibility = new SimpleObjectProperty((Object)centerVisibility);
        this.centerStrokeShape = ((CircleBuilder)((CircleBuilder)CircleBuilder.create().radius(innerRadius).stroke(strokeFill)).fill(bgFill)).build();
        this.centerStrokeShape.radiusProperty().bind((ObservableValue)this.innerRadiusProperty());
        this.centerVisibility.addListener((ChangeListener)this);
        this.strokeVisible.addListener((ChangeListener)this);
        this.backgroundVisible.addListener((ChangeListener)this);
        this.centerGroup = ((GroupBuilder)((GroupBuilder)((GroupBuilder)GroupBuilder.create().onMouseEntered((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                RadialMenu.this.mouseOn = true;
                RadialMenu.this.redraw();
            }
        })).onMouseExited((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                RadialMenu.this.mouseOn = false;
                RadialMenu.this.redraw();
            }
        })).onMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                boolean visible = RadialMenu.this.itemGroup.isVisible();
                if (visible) {
                    RadialMenu.this.hideRadialMenu();
                } else {
                    RadialMenu.this.showRadialMenu();
                }
                event.consume();
            }
        })).build();
        this.centerGroup.getChildren().add((Object)this.centerStrokeShape);
        this.getChildren().add((Object)this.centerGroup);
        this.centerGraphic = new SimpleObjectProperty((Object)centerGraphic);
        this.setCenterGraphic(centerGraphic);
        this.saveStateBeforeAnimation();
    }

    public void setOnMenuItemMouseClicked(EventHandler<? super MouseEvent> paramEventHandler) {
        for (RadialMenuItem item : this.items) {
            item.setOnMouseClicked(paramEventHandler);
        }
    }

    public void setInitialAngle(double angle) {
        this.initialAngle.set(angle);
        double angleOffset = this.initialAngle.get();
        for (RadialMenuItem item : this.items) {
            item.setStartAngle(angleOffset);
            angleOffset += item.getMenuSize();
        }
    }

    public void setInnerRadius(double radius) {
        this.innerRadius.set(radius);
    }

    public void setRadius(double radius) {
        this.radius.set(radius);
    }

    public void setOffset(double offset) {
        this.offset.set(offset);
    }

    public void setBackgroundVisible(boolean visible) {
        this.backgroundVisible.set(visible);
    }

    public void setStrokeVisible(boolean visible) {
        this.strokeVisible.set(visible);
    }

    public void setBackgroundColor(Paint color) {
        this.backgroundFill.set((Object)color);
    }

    public void setBackgroundMouseOnColor(Paint color) {
        this.backgroundMouseOnFill.set((Object)color);
    }

    public void setStrokeMouseOnColor(Paint color) {
        this.strokeMouseOnFill.set((Object)color);
    }

    public void setStrokeColor(Paint color) {
        this.strokeFill.set((Object)color);
    }

    public void setClockwise(boolean clockwise) {
        this.clockwise.set(clockwise);
    }

    public void addMenuItem(RadialMenuItem item) {
        item.visibleProperty().bind((ObservableValue)this.visibleProperty());
        item.backgroundColorProperty().bind(this.backgroundFill);
        item.backgroundMouseOnColorProperty().bind(this.backgroundMouseOnFill);
        item.strokeMouseOnColorProperty().bind(this.strokeMouseOnFill);
        item.innerRadiusProperty().bind((ObservableValue)this.innerRadius);
        item.radiusProperty().bind((ObservableValue)this.radius);
        item.offsetProperty().bind((ObservableValue)this.offset);
        item.strokeColorProperty().bind(this.strokeFill);
        item.clockwiseProperty().bind((ObservableValue)this.clockwise);
        item.backgroundVisibleProperty().bind((ObservableValue)this.backgroundVisible);
        item.strokeVisibleProperty().bind((ObservableValue)this.strokeVisible);
        this.items.add(item);
        this.itemGroup.getChildren().add(this.itemGroup.getChildren().size(), (Object)item);
        double angleOffset = this.initialAngle.get();
        for (RadialMenuItem it : this.items) {
            it.setStartAngle(angleOffset);
            angleOffset += item.getMenuSize();
        }
        item.setOnMouseClicked(this);
    }

    public void removeMenuItem(RadialMenuItem item) {
        this.items.remove((Object)item);
        this.itemGroup.getChildren().remove((Object)item);
        item.visibleProperty().unbind();
        item.backgroundColorProperty().unbind();
        item.backgroundMouseOnColorProperty().unbind();
        item.innerRadiusProperty().unbind();
        item.radiusProperty().unbind();
        item.offsetProperty().unbind();
        item.strokeColorProperty().unbind();
        item.clockwiseProperty().unbind();
        item.backgroundVisibleProperty().unbind();
        item.strokeVisibleProperty().unbind();
        item.removeEventHandler(MouseEvent.MOUSE_CLICKED, this);
    }

    public void removeMenuItem(int itemIndex) {
        RadialMenuItem item = this.items.get(itemIndex);
        this.removeMenuItem(item);
    }

    public void handle(MouseEvent event) {
        if (event.getButton() == MouseButton.PRIMARY) {
            RadialMenuItem item;
            item.setSelected(!(item = (RadialMenuItem)((Object)event.getSource())).isSelected());
            for (RadialMenuItem it : this.items) {
                if (it == item) continue;
                it.setSelected(false);
            }
            if (!item.isSelected()) {
                this.hideRadialMenu();
            }
            event.consume();
        }
    }

    public void hideRadialMenu() {
        this.saveStateBeforeAnimation();
        ArrayList<FadeTransition> anim = new ArrayList<FadeTransition>();
        FadeTransition fadeItemGroup = ((FadeTransitionBuilder)FadeTransitionBuilder.create().node((Node)this.itemGroup).fromValue(1.0).toValue(0.0).duration(Duration.millis((double)300.0)).onFinished((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent arg0) {
                RadialMenu.this.itemGroup.setVisible(false);
            }
        })).build();
        anim.add(fadeItemGroup);
        if (this.centerVisibility.get() == CenterVisibility.WITH_MENU) {
            FadeTransition fadeCenter = ((FadeTransitionBuilder)FadeTransitionBuilder.create().node((Node)this.centerGroup).fromValue(1.0).toValue(0.0).duration(Duration.millis((double)300.0)).onFinished((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent arg0) {
                    RadialMenu.this.centerGroup.setVisible(false);
                }
            })).build();
            anim.add(fadeCenter);
        }
        ParallelTransition transition = ParallelTransitionBuilder.create().children(anim).build();
        transition.play();
    }

    public void showRadialMenu() {
        ArrayList<Object> anim = new ArrayList<Object>();
        FadeTransition fade = FadeTransitionBuilder.create().node((Node)this.itemGroup).duration(Duration.millis((double)400.0)).fromValue(0.0).toValue(1.0).build();
        anim.add(fade);
        Timeline offset = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)this.offsetProperty(), (Object)0)}), new KeyFrame(Duration.millis((double)300.0), new KeyValue[]{new KeyValue((WritableValue)this.offsetProperty(), (Object)this.lastOffsetValue)})});
        anim.add(offset);
        Timeline angle = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)this.initialAngleProperty(), (Object)(this.lastInitialAngleValue + 20.0))}), new KeyFrame(Duration.millis((double)300.0), new KeyValue[]{new KeyValue((WritableValue)this.initialAngleProperty(), (Object)this.lastInitialAngleValue)})});
        anim.add(angle);
        if (this.centerVisibility.get() == CenterVisibility.WITH_MENU) {
            FadeTransition fadeCenter = FadeTransitionBuilder.create().node((Node)this.centerGroup).fromValue(0.0).toValue(1.0).duration(Duration.millis((double)300.0)).build();
            anim.add(fadeCenter);
            this.centerGroup.setVisible(true);
        }
        ParallelTransition transition = ParallelTransitionBuilder.create().children(anim).build();
        this.itemGroup.setVisible(true);
        transition.play();
    }

    private void saveStateBeforeAnimation() {
        this.lastInitialAngleValue = this.initialAngle.get();
        this.lastOffsetValue = this.offset.get();
    }

    public void changed(ObservableValue<? extends Object> arg0, Object arg1, Object arg2) {
        this.redraw();
    }

    private void redraw() {
        if (this.centerVisibility.get() == CenterVisibility.NEVER) {
            this.centerGroup.visibleProperty().set(false);
        } else if (this.centerVisibility.get() == CenterVisibility.ALWAYS) {
            this.centerGroup.visibleProperty().set(true);
        } else {
            this.centerGroup.visibleProperty().set(this.itemGroup.isVisible());
        }
        this.centerStrokeShape.setFill((Paint)(this.backgroundVisible.get() ? (this.mouseOn && this.backgroundMouseOnFill.get() != null ? (Paint)this.backgroundMouseOnFill.get() : (Paint)this.backgroundFill.get()) : Color.TRANSPARENT));
        this.centerStrokeShape.setStroke((Paint)(this.strokeVisible.get() ? (this.mouseOn && this.strokeMouseOnFill.get() != null ? (Paint)this.strokeMouseOnFill.get() : (Paint)this.strokeFill.get()) : Color.TRANSPARENT));
    }

    public static enum CenterVisibility {
        ALWAYS,
        WITH_MENU,
        NEVER;

    }
}

