/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.scene.control.radialmenu;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.ArcTo;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;

public class RadialMenuItem
extends Group
implements ChangeListener<Object> {
    protected DoubleProperty startAngle = new SimpleDoubleProperty();
    protected double menuSize = 45.0;
    protected DoubleProperty innerRadius = new SimpleDoubleProperty();
    protected DoubleProperty radius = new SimpleDoubleProperty();
    protected DoubleProperty offset = new SimpleDoubleProperty();
    protected ObjectProperty<Paint> backgroundMouseOnColor = new SimpleObjectProperty();
    protected ObjectProperty<Paint> backgroundColor = new SimpleObjectProperty();
    protected BooleanProperty backgroundVisible = new SimpleBooleanProperty(true);
    protected BooleanProperty strokeVisible = new SimpleBooleanProperty(true);
    protected BooleanProperty clockwise = new SimpleBooleanProperty();
    protected ObjectProperty<Paint> strokeColor = new SimpleObjectProperty();
    protected ObjectProperty<Paint> strokeMouseOnColor = new SimpleObjectProperty();
    protected MoveTo moveTo;
    protected ArcTo arcToInner;
    protected ArcTo arcTo;
    protected LineTo lineTo;
    protected LineTo lineTo2;
    protected double innerStartX;
    protected double innerStartY;
    protected double innerEndX;
    protected double innerEndY;
    protected boolean innerSweep;
    protected double startX;
    protected double startY;
    protected double endX;
    protected double endY;
    protected boolean sweep;
    protected double graphicX;
    protected double graphicY;
    protected double translateX;
    protected double translateY;
    protected boolean mouseOn = false;
    protected Path path;
    protected Node graphic;
    protected String text;

    public RadialMenuItem() {
        this.innerRadius.addListener((ChangeListener)this);
        this.radius.addListener((ChangeListener)this);
        this.offset.addListener((ChangeListener)this);
        this.backgroundVisible.addListener((ChangeListener)this);
        this.strokeVisible.addListener((ChangeListener)this);
        this.clockwise.addListener((ChangeListener)this);
        this.backgroundColor.addListener((ChangeListener)this);
        this.strokeColor.addListener((ChangeListener)this);
        this.backgroundMouseOnColor.addListener((ChangeListener)this);
        this.strokeMouseOnColor.addListener((ChangeListener)this);
        this.startAngle.addListener((ChangeListener)this);
        this.path = new Path();
        this.moveTo = new MoveTo();
        this.arcToInner = new ArcTo();
        this.arcTo = new ArcTo();
        this.lineTo = new LineTo();
        this.lineTo2 = new LineTo();
        this.path.getElements().add((Object)this.moveTo);
        this.path.getElements().add((Object)this.arcToInner);
        this.path.getElements().add((Object)this.lineTo);
        this.path.getElements().add((Object)this.arcTo);
        this.path.getElements().add((Object)this.lineTo2);
        this.getChildren().add((Object)this.path);
        this.setOnMouseEntered((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent arg0) {
                RadialMenuItem.this.mouseOn = true;
                RadialMenuItem.this.redraw();
            }
        });
        this.setOnMouseExited((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent arg0) {
                RadialMenuItem.this.mouseOn = false;
                RadialMenuItem.this.redraw();
            }
        });
    }

    public RadialMenuItem(double menuSize, Node graphic) {
        this();
        this.menuSize = menuSize;
        this.graphic = graphic;
        if (this.graphic != null) {
            this.getChildren().add((Object)this.graphic);
        }
        this.redraw();
    }

    public RadialMenuItem(double menuSize, Node graphic, final EventHandler<ActionEvent> actionHandler) {
        this(menuSize, graphic);
        this.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent paramT) {
                actionHandler.handle((Event)new ActionEvent(paramT.getSource(), paramT.getTarget()));
            }
        });
        this.redraw();
    }

    public RadialMenuItem(double menuSize, String text, Node graphic) {
        this(menuSize, graphic);
        this.text = text;
        this.redraw();
    }

    public RadialMenuItem(double menuSize, String text, Node graphic, EventHandler<ActionEvent> actionHandler) {
        this(menuSize, graphic, actionHandler);
        this.text = text;
        this.redraw();
    }

    DoubleProperty innerRadiusProperty() {
        return this.innerRadius;
    }

    DoubleProperty radiusProperty() {
        return this.radius;
    }

    DoubleProperty offsetProperty() {
        return this.offset;
    }

    ObjectProperty<Paint> backgroundMouseOnColorProperty() {
        return this.backgroundMouseOnColor;
    }

    ObjectProperty<Paint> strokeMouseOnColorProperty() {
        return this.strokeMouseOnColor;
    }

    ObjectProperty<Paint> backgroundColorProperty() {
        return this.backgroundColor;
    }

    public BooleanProperty clockwiseProperty() {
        return this.clockwise;
    }

    ObjectProperty<Paint> strokeColorProperty() {
        return this.strokeColor;
    }

    public BooleanProperty strokeVisibleProperty() {
        return this.strokeVisible;
    }

    public BooleanProperty backgroundVisibleProperty() {
        return this.backgroundVisible;
    }

    public Node getGraphic() {
        return this.graphic;
    }

    public void setStartAngle(double angle) {
        this.startAngle.set(angle);
    }

    public DoubleProperty startAngleProperty() {
        return this.startAngle;
    }

    public void setGraphic(Node graphic) {
        if (this.graphic != null) {
            this.getChildren().remove((Object)this.graphic);
        }
        this.graphic = graphic;
        if (this.graphic != null) {
            this.getChildren().add((Object)graphic);
        }
        this.redraw();
    }

    public void setText(String text) {
        this.text = text;
        this.redraw();
    }

    public String getText() {
        return this.text;
    }

    protected void redraw() {
        this.path.setFill((Paint)(this.backgroundVisible.get() ? (this.mouseOn && this.backgroundMouseOnColor.get() != null ? (Paint)this.backgroundMouseOnColor.get() : (Paint)this.backgroundColor.get()) : Color.TRANSPARENT));
        this.path.setStroke((Paint)(this.strokeVisible.get() ? (this.mouseOn && this.strokeMouseOnColor.get() != null ? (Paint)this.strokeMouseOnColor.get() : (Paint)this.strokeColor.get()) : Color.TRANSPARENT));
        this.path.setFillRule(FillRule.EVEN_ODD);
        this.computeCoordinates();
        this.update();
    }

    protected void update() {
        double innerRadiusValue = this.innerRadius.get();
        double radiusValue = this.radius.get();
        this.moveTo.setX(this.innerStartX + this.translateX);
        this.moveTo.setY(this.innerStartY + this.translateY);
        this.arcToInner.setX(this.innerEndX + this.translateX);
        this.arcToInner.setY(this.innerEndY + this.translateY);
        this.arcToInner.setSweepFlag(this.innerSweep);
        this.arcToInner.setRadiusX(innerRadiusValue);
        this.arcToInner.setRadiusY(innerRadiusValue);
        this.lineTo.setX(this.startX + this.translateX);
        this.lineTo.setY(this.startY + this.translateY);
        this.arcTo.setX(this.endX + this.translateX);
        this.arcTo.setY(this.endY + this.translateY);
        this.arcTo.setSweepFlag(this.sweep);
        this.arcTo.setRadiusX(radiusValue);
        this.arcTo.setRadiusY(radiusValue);
        this.lineTo2.setX(this.innerStartX + this.translateX);
        this.lineTo2.setY(this.innerStartY + this.translateY);
        if (this.graphic != null) {
            this.graphic.setTranslateX(this.graphicX + this.translateX);
            this.graphic.setTranslateY(this.graphicY + this.translateY);
        }
    }

    protected void computeCoordinates() {
        double innerRadiusValue = this.innerRadius.get();
        double startAngleValue = this.startAngle.get();
        double graphicAngle = startAngleValue + this.menuSize / 2.0;
        double radiusValue = this.radius.get();
        double graphicRadius = innerRadiusValue + (radiusValue - innerRadiusValue) / 2.0;
        double offsetValue = this.offset.get();
        if (!this.clockwise.get()) {
            this.innerStartX = innerRadiusValue * Math.cos(Math.toRadians(startAngleValue));
            this.innerStartY = -innerRadiusValue * Math.sin(Math.toRadians(startAngleValue));
            this.innerEndX = innerRadiusValue * Math.cos(Math.toRadians(startAngleValue + this.menuSize));
            this.innerEndY = -innerRadiusValue * Math.sin(Math.toRadians(startAngleValue + this.menuSize));
            this.innerSweep = false;
            this.startX = radiusValue * Math.cos(Math.toRadians(startAngleValue + this.menuSize));
            this.startY = -radiusValue * Math.sin(Math.toRadians(startAngleValue + this.menuSize));
            this.endX = radiusValue * Math.cos(Math.toRadians(startAngleValue));
            this.endY = -radiusValue * Math.sin(Math.toRadians(startAngleValue));
            this.sweep = true;
            if (this.graphic != null) {
                this.graphicX = graphicRadius * Math.cos(Math.toRadians(graphicAngle)) - this.graphic.getBoundsInParent().getWidth() / 2.0;
                this.graphicY = -graphicRadius * Math.sin(Math.toRadians(graphicAngle)) - this.graphic.getBoundsInParent().getHeight() / 2.0;
            }
            this.translateX = offsetValue * Math.cos(Math.toRadians(startAngleValue + this.menuSize / 2.0));
            this.translateY = -offsetValue * Math.sin(Math.toRadians(startAngleValue + this.menuSize / 2.0));
        } else if (this.clockwise.get()) {
            this.innerStartX = innerRadiusValue * Math.cos(Math.toRadians(startAngleValue));
            this.innerStartY = innerRadiusValue * Math.sin(Math.toRadians(startAngleValue));
            this.innerEndX = innerRadiusValue * Math.cos(Math.toRadians(startAngleValue + this.menuSize));
            this.innerEndY = innerRadiusValue * Math.sin(Math.toRadians(startAngleValue + this.menuSize));
            this.innerSweep = true;
            this.startX = radiusValue * Math.cos(Math.toRadians(startAngleValue + this.menuSize));
            this.startY = radiusValue * Math.sin(Math.toRadians(startAngleValue + this.menuSize));
            this.endX = radiusValue * Math.cos(Math.toRadians(startAngleValue));
            this.endY = radiusValue * Math.sin(Math.toRadians(startAngleValue));
            this.sweep = false;
            if (this.graphic != null) {
                this.graphicX = graphicRadius * Math.cos(Math.toRadians(graphicAngle)) - this.graphic.getBoundsInParent().getWidth() / 2.0;
                this.graphicY = graphicRadius * Math.sin(Math.toRadians(graphicAngle)) - this.graphic.getBoundsInParent().getHeight() / 2.0;
            }
            this.translateX = offsetValue * Math.cos(Math.toRadians(startAngleValue + this.menuSize / 2.0));
            this.translateY = offsetValue * Math.sin(Math.toRadians(startAngleValue + this.menuSize / 2.0));
        }
    }

    public double getMenuSize() {
        return this.menuSize;
    }

    public void changed(ObservableValue<? extends Object> arg0, Object arg1, Object arg2) {
        this.redraw();
    }

    void setSelected(boolean selected) {
    }

    boolean isSelected() {
        return false;
    }
}

