/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.scene.control.window;

import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import jfxtras.labs.scene.control.window.SelectableNode;
import jfxtras.labs.scene.control.window.Window;
import jfxtras.labs.scene.control.window.WindowIcon;
import jfxtras.labs.util.WindowUtil;

public class MinimizeIcon
extends WindowIcon {
    public static final String DEFAULT_STYLE_CLASS = "window-minimize-icon";
    private Window w;

    public MinimizeIcon(final Window w) {
        this.w = w;
        this.getStyleClass().setAll((Object[])new String[]{DEFAULT_STYLE_CLASS});
        this.setOnAction(new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                w.setMinimized(!w.isMinimized());
                if (w.isSelected()) {
                    MinimizeIcon.this.minimizeSelectedWindows();
                }
            }
        });
    }

    private void minimizeSelectedWindows() {
        for (SelectableNode sN : WindowUtil.getDefaultClipboard().getSelectedItems()) {
            if (sN == this.w || !(sN instanceof Window)) continue;
            Window selectedWindow = (Window)sN;
            if (!this.w.getParent().equals(selectedWindow.getParent())) continue;
            selectedWindow.setMinimized(!selectedWindow.isMinimized());
        }
    }
}

