/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.scene.control.window;

import javafx.animation.Animation;
import javafx.animation.ScaleTransition;
import javafx.animation.Transition;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.util.Duration;
import jfxtras.labs.scene.control.window.SelectableNode;
import jfxtras.labs.scene.control.window.WindowIcon;
import jfxtras.labs.util.NodeUtil;

public class Window
extends Control
implements SelectableNode {
    public static final String DEFAULT_STYLE = "/jfxtras/labs/scene/control/window/default.css";
    public static final String DEFAULT_STYLE_CLASS = "window";
    private boolean moveToFront = true;
    private StringProperty titleProperty = new SimpleStringProperty("Title");
    private BooleanProperty minimizeProperty = new SimpleBooleanProperty();
    private BooleanProperty resizableProperty = new SimpleBooleanProperty(true);
    private BooleanProperty movableProperty = new SimpleBooleanProperty(true);
    private Property<Pane> contentPaneProperty = new SimpleObjectProperty();
    private ObservableList<WindowIcon> leftIcons = FXCollections.observableArrayList();
    private ObservableList<WindowIcon> rightIcons = FXCollections.observableArrayList();
    private DoubleProperty resizableBorderWidthProperty = new SimpleDoubleProperty(5.0);
    private StringProperty titleBarStyleClassProperty = new SimpleStringProperty("window-titlebar");
    private ObjectProperty<EventHandler<ActionEvent>> onCloseActionProperty = new SimpleObjectProperty();
    private ObjectProperty<EventHandler<ActionEvent>> onClosedActionProperty = new SimpleObjectProperty();
    private ObjectProperty<Transition> closeTransitionProperty = new SimpleObjectProperty();
    private BooleanProperty selectedProperty = new SimpleBooleanProperty(false);
    private BooleanProperty selectableProperty = new SimpleBooleanProperty(true);

    public Window() {
        this.init();
    }

    public Window(String title) {
        this.setTitle(title);
        this.init();
    }

    private void init() {
        this.getStyleClass().setAll((Object[])new String[]{DEFAULT_STYLE_CLASS});
        this.setContentPane((Pane)new StackPane());
        this.boundsInParentProperty().addListener((ChangeListener)new ChangeListener<Bounds>(){

            public void changed(ObservableValue<? extends Bounds> ov, Bounds t, Bounds t1) {
                if (Window.this.getParent() != null) {
                    if (t1.equals(t)) {
                        return;
                    }
                    Window.this.getParent().requestLayout();
                    double x = Math.max(0.0, Window.this.getLayoutX());
                    double y = Math.max(0.0, Window.this.getLayoutY());
                    Window.this.setLayoutX(x);
                    Window.this.setLayoutY(y);
                }
            }
        });
        this.closeTransitionProperty.addListener((ChangeListener)new ChangeListener<Transition>(){

            public void changed(ObservableValue<? extends Transition> ov, Transition t, Transition t1) {
                t1.statusProperty().addListener((ChangeListener)new ChangeListener<Animation.Status>(){

                    public void changed(ObservableValue<? extends Animation.Status> observableValue, Animation.Status oldValue, Animation.Status newValue) {
                        if (newValue == Animation.Status.STOPPED) {
                            if (Window.this.getParent() == null) {
                                return;
                            }
                            if (Window.this.getOnCloseAction() != null) {
                                Window.this.getOnCloseAction().handle((Event)new ActionEvent((Object)this, (EventTarget)Window.this));
                            }
                            if (Window.this.getParent() != null) {
                                NodeUtil.removeFromParent((Node)Window.this);
                            }
                            if (Window.this.getOnClosedAction() != null) {
                                Window.this.getOnClosedAction().handle((Event)new ActionEvent((Object)this, (EventTarget)Window.this));
                            }
                        }
                    }
                });
            }
        });
        ScaleTransition st = new ScaleTransition();
        st.setNode((Node)this);
        st.setFromX(1.0);
        st.setFromY(1.0);
        st.setToX(0.0);
        st.setToY(0.0);
        st.setDuration(Duration.seconds((double)0.2));
        this.setCloseTransition((Transition)st);
    }

    protected String getUserAgentStylesheet() {
        return DEFAULT_STYLE;
    }

    public Pane getContentPane() {
        return (Pane)this.contentPaneProperty.getValue();
    }

    public void setContentPane(Pane contentPane) {
        this.contentPaneProperty.setValue((Object)contentPane);
    }

    public Property<Pane> contentPaneProperty() {
        return this.contentPaneProperty;
    }

    public void setMoveToFront(boolean moveToFront) {
        this.moveToFront = moveToFront;
    }

    public boolean isMoveToFront() {
        return this.moveToFront;
    }

    public final String getTitle() {
        return (String)this.titleProperty.get();
    }

    public final void setTitle(String title) {
        this.titleProperty.set((Object)title);
    }

    public final StringProperty titleProperty() {
        return this.titleProperty;
    }

    public ObservableList<WindowIcon> getLeftIcons() {
        return this.leftIcons;
    }

    public ObservableList<WindowIcon> getRightIcons() {
        return this.rightIcons;
    }

    public void setMinimized(boolean v) {
        this.minimizeProperty.set(v);
    }

    public boolean isMinimized() {
        return this.minimizeProperty.get();
    }

    public BooleanProperty minimizedProperty() {
        return this.minimizeProperty;
    }

    public void setResizableWindow(boolean v) {
        this.resizableProperty.set(v);
    }

    public boolean isResizableWindow() {
        return this.resizableProperty.get();
    }

    public BooleanProperty resizeableWindowProperty() {
        return this.resizableProperty;
    }

    public void setMovable(boolean v) {
        this.movableProperty.set(v);
    }

    public boolean isMovable() {
        return this.movableProperty.get();
    }

    public BooleanProperty movableProperty() {
        return this.movableProperty;
    }

    public StringProperty titleBarStyleClassProperty() {
        return this.titleBarStyleClassProperty;
    }

    public void setTitleBarStyleClass(String name) {
        this.titleBarStyleClassProperty.set((Object)name);
    }

    public String getTitleBarStyleClass() {
        return (String)this.titleBarStyleClassProperty.get();
    }

    public DoubleProperty resizableBorderWidthProperty() {
        return this.resizableBorderWidthProperty;
    }

    public void setResizableBorderWidth(double v) {
        this.resizableBorderWidthProperty.set(v);
    }

    public double getResizableBorderWidth() {
        return this.resizableBorderWidthProperty.get();
    }

    public void close() {
        if (this.getParent() == null) {
            return;
        }
        if (this.getCloseTransition() != null) {
            this.getCloseTransition().play();
        } else {
            if (this.getOnCloseAction() != null) {
                this.getOnCloseAction().handle((Event)new ActionEvent((Object)this, (EventTarget)this));
            }
            NodeUtil.removeFromParent((Node)this);
            if (this.getOnClosedAction() != null) {
                this.getOnClosedAction().handle((Event)new ActionEvent((Object)this, (EventTarget)this));
            }
        }
    }

    public ObjectProperty<EventHandler<ActionEvent>> onClosedActionProperty() {
        return this.onClosedActionProperty;
    }

    public void setOnClosedAction(EventHandler<ActionEvent> onClosedAction) {
        this.onClosedActionProperty.set(onClosedAction);
    }

    public EventHandler<ActionEvent> getOnClosedAction() {
        return (EventHandler)this.onClosedActionProperty.get();
    }

    public ObjectProperty<EventHandler<ActionEvent>> onCloseActionProperty() {
        return this.onCloseActionProperty;
    }

    public void setOnCloseAction(EventHandler<ActionEvent> onClosedAction) {
        this.onCloseActionProperty.set(onClosedAction);
    }

    public EventHandler<ActionEvent> getOnCloseAction() {
        return (EventHandler)this.onCloseActionProperty.get();
    }

    public ObjectProperty<Transition> closeTransitionProperty() {
        return this.closeTransitionProperty;
    }

    public void setCloseTransition(Transition t) {
        this.closeTransitionProperty.set((Object)t);
    }

    public Transition getCloseTransition() {
        return (Transition)this.closeTransitionProperty.get();
    }

    @Override
    public boolean requestSelection(boolean select) {
        if (!select) {
            this.selectedProperty.set(false);
        }
        if (this.isSelectable()) {
            this.selectedProperty.set(select);
            return true;
        }
        return false;
    }

    public BooleanProperty selectableProperty() {
        return this.selectableProperty;
    }

    public void setSelectable(Boolean selectable) {
        this.selectableProperty.set(selectable.booleanValue());
    }

    public boolean isSelectable() {
        return this.selectableProperty.get();
    }

    public ReadOnlyBooleanProperty selectedProperty() {
        return this.selectedProperty;
    }

    public boolean isSelected() {
        return this.selectedProperty.get();
    }
}

