/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.scene.layout;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.geometry.Bounds;
import javafx.scene.transform.Transform;
import jfxtras.labs.scene.layout.OptimizableContentPane;
import jfxtras.labs.scene.layout.OptimizationRule;

public class DefaultOptimizationRule
implements OptimizationRule {
    private final DoubleProperty minSceneArea = new SimpleDoubleProperty(2000.0);
    private final DoubleProperty minSceneDimension = new SimpleDoubleProperty(50.0);
    private final BooleanProperty attachNodesProperty = new SimpleBooleanProperty();

    @Override
    public boolean visible(OptimizableContentPane p, Transform t) {
        boolean visible;
        Bounds bounds = p.getBoundsInLocal();
        bounds = p.localToScene(bounds);
        boolean bl = visible = this.getMinSceneArea() <= bounds.getWidth() * bounds.getHeight();
        if (visible) {
            visible = Math.min(bounds.getWidth(), bounds.getHeight()) > this.getMinSceneDimension();
        }
        return visible;
    }

    @Override
    public boolean attached(OptimizableContentPane p, Transform t) {
        if (this.isAttachNodes()) {
            return this.visible(p, t);
        }
        return true;
    }

    public DoubleProperty minSceneAreaProperty() {
        return this.minSceneArea;
    }

    public void setMinSceneArea(double s) {
        this.minSceneArea.set(s);
    }

    public double getMinSceneArea() {
        return this.minSceneArea.get();
    }

    public DoubleProperty minSceneDimensionProperty() {
        return this.minSceneDimension;
    }

    public void setMinSceneDimension(double d) {
        this.minSceneDimension.set(d);
    }

    public double getMinSceneDimension() {
        return this.minSceneDimension.get();
    }

    public BooleanProperty attachNodesProperty() {
        return this.attachNodesProperty;
    }

    public void setAttachNodes(boolean attach) {
        this.attachNodesProperty().set(attach);
    }

    public boolean isAttachNodes() {
        return this.attachNodesProperty().get();
    }
}

