/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.scene.layout;

import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Control;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ToggleButton;

class GenericLayoutConstraints {
    static final double UNKNOWN = -1234.0;

    GenericLayoutConstraints() {
    }

    public static void overrideMaxWidth(Node node, C c) {
        if (node == null) {
            return;
        }
        if (node instanceof Button || node instanceof ToggleButton || node instanceof CheckBox || node instanceof RadioButton || node instanceof ChoiceBox) {
            Control lControl = (Control)node;
            lControl.setMaxWidth(c.maxWidth >= 0.0 ? c.maxWidth : Double.MAX_VALUE);
        }
    }

    public static void overrideMaxHeight(Node node, C c) {
        if (node == null) {
            return;
        }
        if (node instanceof Button || node instanceof ToggleButton) {
            Control lControl = (Control)node;
            lControl.setMaxHeight(c.maxHeight >= 0.0 ? c.maxHeight : Double.MAX_VALUE);
        }
    }

    public static class C<T> {
        double minWidth = -1.0;
        double minWidthReset = -1234.0;
        double prefWidth = -1.0;
        double prefWidthReset = -1234.0;
        double maxWidth = -1.0;
        double maxWidthReset = -1234.0;
        double minHeight = -1.0;
        double minHeightReset = -1234.0;
        double prefHeight = -1.0;
        double prefHeightReset = -1234.0;
        double maxHeight = -1.0;
        double maxHeightReset = -1234.0;

        public T minWidth(double value) {
            this.minWidth = value;
            return (T)this;
        }

        public T prefWidth(double value) {
            this.prefWidth = value;
            return (T)this;
        }

        public T maxWidth(double value) {
            this.maxWidth = value;
            return (T)this;
        }

        public T minHeight(double value) {
            this.minHeight = value;
            return (T)this;
        }

        public T prefHeight(double value) {
            this.prefHeight = value;
            return (T)this;
        }

        public T maxHeight(double value) {
            this.maxHeight = value;
            return (T)this;
        }

        protected void rememberResetValues(Node node) {
            if (node instanceof Control) {
                Control lControl = (Control)node;
                if (this.minWidthReset == -1234.0) {
                    this.minWidthReset = lControl.getMinWidth();
                }
                if (this.prefWidthReset == -1234.0) {
                    this.prefWidthReset = lControl.getPrefWidth();
                }
                if (this.maxWidthReset == -1234.0) {
                    this.maxWidthReset = lControl.getMaxWidth();
                }
                if (this.minHeightReset == -1234.0) {
                    this.minHeightReset = lControl.getMinHeight();
                }
                if (this.prefHeightReset == -1234.0) {
                    this.prefHeightReset = lControl.getPrefHeight();
                }
                if (this.maxHeightReset == -1234.0) {
                    this.maxHeightReset = lControl.getMaxHeight();
                }
            }
        }

        protected void apply(Node node) {
            if (node instanceof Control) {
                Control lControl = (Control)node;
                this.rememberResetValues((Node)lControl);
                lControl.setMinWidth(this.minWidth >= 0.0 ? this.minWidth : this.minWidthReset);
                lControl.setPrefWidth(this.prefWidth >= 0.0 ? this.prefWidth : this.prefWidthReset);
                lControl.setMaxWidth(this.maxWidth >= 0.0 ? this.maxWidth : this.maxWidthReset);
                lControl.setMinHeight(this.minHeight >= 0.0 ? this.minHeight : this.minHeightReset);
                lControl.setPrefHeight(this.prefHeight >= 0.0 ? this.prefHeight : this.prefHeightReset);
                lControl.setMaxHeight(this.maxHeight >= 0.0 ? this.maxHeight : this.maxHeightReset);
            }
        }
    }
}

