/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.scene.layout;

import java.util.ArrayList;
import java.util.Collection;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.layout.StackPane;
import javafx.scene.transform.Transform;
import jfxtras.labs.scene.layout.DefaultOptimizationRule;
import jfxtras.labs.scene.layout.OptimizationRule;

public class OptimizableContentPane
extends StackPane {
    private OptimizationRule optimizationRule;
    private Transform transform;
    private boolean optimizing = false;
    private boolean visibility = true;
    private boolean attached = true;
    private Collection<Node> detatched = new ArrayList<Node>();

    public OptimizableContentPane() {
        this.optimizationRule = new DefaultOptimizationRule();
        this.localToSceneTransformProperty().addListener((ChangeListener)new ChangeListener<Transform>(){

            public void changed(ObservableValue<? extends Transform> ov, Transform oldVal, Transform newVal) {
                OptimizableContentPane.this.transform = newVal;
                OptimizableContentPane.this.updateOptimizationRule();
            }
        });
        this.boundsInLocalProperty().addListener((ChangeListener)new ChangeListener<Bounds>(){

            public void changed(ObservableValue<? extends Bounds> ov, Bounds t, Bounds t1) {
                OptimizableContentPane.this.updateOptimizationRule();
            }
        });
        this.visibleProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> ov, Boolean oldValue, Boolean newValue) {
                if (!OptimizableContentPane.this.optimizing) {
                    OptimizableContentPane.this.visibility = newValue;
                }
            }
        });
    }

    private void updateOptimizationRule() {
        boolean attachedReq;
        if (!this.visibility) {
            return;
        }
        if (this.optimizing) {
            return;
        }
        this.optimizing = true;
        if (this.transform == null) {
            this.transform = (Transform)this.localToSceneTransformProperty().get();
        }
        boolean visible = this.optimizationRule.visible(this, this.transform);
        if (this.isVisible() != visible) {
            this.setVisible(visible);
        }
        if (this.attached != (attachedReq = this.optimizationRule.attached(this, this.transform))) {
            if (attachedReq) {
                this.getChildren().addAll(this.detatched);
                this.detatched.clear();
            } else {
                this.detatched.addAll((Collection<Node>)this.getChildren());
                this.getChildren().removeAll(this.detatched);
            }
            this.attached = attachedReq;
        }
        this.optimizing = false;
    }

    public OptimizationRule getOptimizationRule() {
        return this.optimizationRule;
    }

    public void setOptimizationRule(OptimizationRule optimizationRule) {
        this.optimizationRule = optimizationRule;
    }
}

