/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.scene.layout;

import java.util.WeakHashMap;
import javafx.collections.ListChangeListener;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.layout.Priority;
import jfxtras.labs.scene.layout.GenericLayoutConstraints;

public class VBox
extends javafx.scene.layout.VBox {
    private WeakHashMap<Node, C> cMap = new WeakHashMap();

    public VBox() {
        this.construct();
    }

    public VBox(double spacing) {
        super(spacing);
        this.construct();
    }

    private void construct() {
        this.getChildren().addListener((ListChangeListener)new ListChangeListener<Node>(){

            public void onChanged(ListChangeListener.Change<? extends Node> changes) {
                while (changes.next()) {
                    for (Node lNode : changes.getAddedSubList()) {
                        C lC = (C)VBox.this.cMap.get(lNode);
                        if (lC == null) continue;
                        lC.apply(lNode);
                    }
                }
            }
        });
    }

    public VBox withSpacing(double value) {
        super.setSpacing(value);
        return this;
    }

    public void add(Node node) {
        this.getChildren().add((Object)node);
    }

    public void add(Node node, C c) {
        this.cMap.put(node, c);
        c.rememberResetValues(node);
        this.getChildren().add((Object)node);
    }

    public void remove(Node node) {
        this.getChildren().remove((Object)node);
        this.cMap.remove(node);
    }

    public void setConstraint(Node node, C c) {
        this.cMap.put(node, c);
        c.rememberResetValues(node);
    }

    public void removeConstraintsFor(Node node) {
        this.cMap.remove(node);
    }

    public void removeNode(Node node) {
        this.getChildren().remove((Object)node);
    }

    public static class C
    extends GenericLayoutConstraints.C<C> {
        private Priority vgrow = null;
        private Priority vgrowReset = null;
        Insets margin = null;
        Insets marginReset = null;

        public C vgrow(Priority value) {
            this.vgrow = value;
            return this;
        }

        public C margin(Insets value) {
            this.margin = value;
            return this;
        }

        @Override
        protected void rememberResetValues(Node node) {
            super.rememberResetValues(node);
            this.vgrowReset = javafx.scene.layout.VBox.getVgrow((Node)node);
            this.marginReset = javafx.scene.layout.VBox.getMargin((Node)node);
        }

        @Override
        protected void apply(Node node) {
            super.apply(node);
            if (this.vgrow != null) {
                GenericLayoutConstraints.overrideMaxWidth(node, this);
            }
            javafx.scene.layout.VBox.setVgrow((Node)node, (Priority)(this.vgrow != null ? this.vgrow : this.vgrowReset));
            javafx.scene.layout.VBox.setMargin((Node)node, (Insets)(this.margin != null ? this.margin : this.marginReset));
        }
    }
}

