/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.util;

import javafx.animation.Interpolator;
import javafx.scene.image.Image;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;
import javafx.scene.paint.ImagePattern;
import javafx.scene.shape.Shape;

public class BiLinearGradient {
    private final Color COLOR_00;
    private final Color COLOR_10;
    private final Color COLOR_01;
    private final Color COLOR_11;

    public BiLinearGradient(Color COLOR_00, Color COLOR_10, Color COLOR_01, Color COLOR_11) {
        this.COLOR_00 = COLOR_00;
        this.COLOR_10 = COLOR_10;
        this.COLOR_01 = COLOR_01;
        this.COLOR_11 = COLOR_11;
    }

    private Color biLinearInterpolateColor(Color COL_00, Color COL_10, Color COL_01, Color COL_11, double FRAC_X, double FRAC_Y) {
        Color INTERPOLATED_COLOR_X1 = (Color)Interpolator.LINEAR.interpolate((Object)COL_00, (Object)COL_10, FRAC_X);
        Color INTERPOLATED_COLOR_X2 = (Color)Interpolator.LINEAR.interpolate((Object)COL_01, (Object)COL_11, FRAC_X);
        return (Color)Interpolator.LINEAR.interpolate((Object)INTERPOLATED_COLOR_X1, (Object)INTERPOLATED_COLOR_X2, FRAC_Y);
    }

    public Image getImage(double WIDTH, double HEIGHT) {
        int width = (int)WIDTH <= 0 ? 100 : (int)WIDTH;
        int height = (int)HEIGHT <= 0 ? 100 : (int)HEIGHT;
        WritableImage RASTER = new WritableImage(width, height);
        PixelWriter PIXEL_WRITER = RASTER.getPixelWriter();
        double FRACTION_STEP_X = 1.0 / (WIDTH - 1.0);
        double FRACTION_STEP_Y = 1.0 / (HEIGHT - 1.0);
        double fractionX = 0.0;
        double fractionY = 0.0;
        int y = 0;
        while ((double)y < HEIGHT) {
            int x = 0;
            while ((double)x < WIDTH) {
                PIXEL_WRITER.setColor(x, y, this.biLinearInterpolateColor(this.COLOR_00, this.COLOR_10, this.COLOR_01, this.COLOR_11, fractionX, fractionY));
                fractionX = fractionX > 1.0 ? 1.0 : (fractionX += FRACTION_STEP_X);
                ++x;
            }
            fractionY = (fractionY += FRACTION_STEP_Y) > 1.0 ? 1.0 : fractionY;
            fractionX = 0.0;
            ++y;
        }
        return RASTER;
    }

    public ImagePattern apply(Shape SHAPE) {
        double x = SHAPE.getLayoutBounds().getMinX();
        double y = SHAPE.getLayoutBounds().getMinY();
        double width = SHAPE.getLayoutBounds().getWidth();
        double height = SHAPE.getLayoutBounds().getHeight();
        return new ImagePattern(this.getImage(width, height), x, y, width, height, false);
    }
}

