/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.labs.util;

import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.scene.shape.Arc;
import javafx.scene.shape.ArcTo;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.Circle;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.CubicCurve;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.Ellipse;
import javafx.scene.shape.HLineTo;
import javafx.scene.shape.Line;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.Polyline;
import javafx.scene.shape.QuadCurve;
import javafx.scene.shape.QuadCurveTo;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.SVGPath;
import javafx.scene.shape.SVGPathBuilder;
import javafx.scene.shape.Shape;
import javafx.scene.shape.VLineTo;
import javafx.scene.text.Text;

public class ShapeConverter {
    private static final double KAPPA = 0.5522847498307935;

    public static String shapeToSvgString(Shape SHAPE) {
        StringBuilder fxPath = new StringBuilder();
        if (Line.class.equals(SHAPE.getClass())) {
            fxPath.append(ShapeConverter.convertLine((Line)SHAPE));
        } else if (Arc.class.equals(SHAPE.getClass())) {
            fxPath.append(ShapeConverter.convertArc((Arc)SHAPE));
        } else if (QuadCurve.class.equals(SHAPE.getClass())) {
            fxPath.append(ShapeConverter.convertQuadCurve((QuadCurve)SHAPE));
        } else if (CubicCurve.class.equals(SHAPE.getClass())) {
            fxPath.append(ShapeConverter.convertCubicCurve((CubicCurve)SHAPE));
        } else if (Rectangle.class.equals(SHAPE.getClass())) {
            fxPath.append(ShapeConverter.convertRectangle((Rectangle)SHAPE));
        } else if (Circle.class.equals(SHAPE.getClass())) {
            fxPath.append(ShapeConverter.convertCircle((Circle)SHAPE));
        } else if (Ellipse.class.equals(SHAPE.getClass())) {
            fxPath.append(ShapeConverter.convertEllipse((Ellipse)SHAPE));
        } else if (Text.class.equals(SHAPE.getClass())) {
            Path path = (Path)Shape.subtract((Shape)SHAPE, (Shape)new Rectangle(0.0, 0.0));
            fxPath.append(ShapeConverter.convertPath(path));
        } else if (Path.class.equals(SHAPE.getClass())) {
            fxPath.append(ShapeConverter.convertPath((Path)SHAPE));
        } else if (Polygon.class.equals(SHAPE.getClass())) {
            fxPath.append(ShapeConverter.convertPolygon((Polygon)SHAPE));
        } else if (Polyline.class.equals(SHAPE.getClass())) {
            fxPath.append(ShapeConverter.convertPolyline((Polyline)SHAPE));
        } else if (SVGPath.class.equals(SHAPE.getClass())) {
            fxPath.append(((SVGPath)SHAPE).getContent());
        }
        return fxPath.toString();
    }

    public static SVGPath shapeToSvgPath(Shape SHAPE) {
        return SVGPathBuilder.create().content(ShapeConverter.shapeToSvgString(SHAPE)).build();
    }

    public static String convertLine(Line LINE) {
        StringBuilder fxPath = new StringBuilder();
        fxPath.append("M ").append(LINE.getStartX()).append(" ").append(LINE.getStartY()).append(" ").append("L ").append(LINE.getEndX()).append(" ").append(LINE.getEndY());
        return fxPath.toString();
    }

    public static String convertArc(Arc ARC) {
        StringBuilder fxPath = new StringBuilder();
        double centerX = ARC.getCenterX();
        double centerY = ARC.getCenterY();
        double radiusX = ARC.getRadiusX();
        double radiusY = ARC.getRadiusY();
        double startAngle = ARC.getStartAngle();
        double length = ARC.getLength();
        double alpha = ARC.getLength() + startAngle;
        startAngle = Math.toRadians(startAngle);
        alpha = Math.toRadians(alpha);
        double phiOffset = Math.toRadians(-90.0);
        double startX = centerX + Math.cos(phiOffset) * radiusX * Math.cos(startAngle) + Math.sin(-phiOffset) * radiusY * Math.sin(startAngle);
        double startY = centerY + Math.sin(phiOffset) * radiusX * Math.cos(startAngle) + Math.cos(phiOffset) * radiusY * Math.sin(startAngle);
        double endX = centerX + Math.cos(phiOffset) * radiusX * Math.cos(alpha) + Math.sin(-phiOffset) * radiusY * Math.sin(alpha);
        double endY = centerY + Math.sin(phiOffset) * radiusX * Math.cos(alpha) + Math.cos(phiOffset) * radiusY * Math.sin(alpha);
        int xAxisRot = 0;
        int largeArc = length > 180.0 ? 1 : 0;
        int sweep = length > 0.0 ? 1 : 0;
        fxPath.append("M ").append(centerX).append(" ").append(centerY).append(" ");
        if (ArcType.ROUND == ARC.getType()) {
            fxPath.append("h ").append(startX - centerX).append(" v ").append(startY - centerY);
        }
        fxPath.append("A ").append(radiusX).append(" ").append(radiusY).append(" ").append(xAxisRot).append(" ").append(largeArc).append(" ").append(sweep).append(" ").append(endX).append(" ").append(endY).append(" ");
        if (ArcType.CHORD == ARC.getType() || ArcType.ROUND == ARC.getType()) {
            fxPath.append("Z");
        }
        return fxPath.toString();
    }

    public static String convertQuadCurve(QuadCurve QUAD_CURVE) {
        StringBuilder fxPath = new StringBuilder();
        fxPath.append("M ").append(QUAD_CURVE.getStartX()).append(" ").append(QUAD_CURVE.getStartY()).append(" ").append("Q ").append(QUAD_CURVE.getControlX()).append(" ").append(QUAD_CURVE.getControlY()).append(QUAD_CURVE.getEndX()).append(" ").append(QUAD_CURVE.getEndY());
        return fxPath.toString();
    }

    public static String convertCubicCurve(CubicCurve CUBIC_CURVE) {
        StringBuilder fxPath = new StringBuilder();
        fxPath.append("M ").append(CUBIC_CURVE.getStartX()).append(" ").append(CUBIC_CURVE.getStartY()).append(" ").append("C ").append(CUBIC_CURVE.getControlX1()).append(" ").append(CUBIC_CURVE.getControlY1()).append(" ").append(CUBIC_CURVE.getControlX2()).append(" ").append(CUBIC_CURVE.getControlY2()).append(" ").append(CUBIC_CURVE.getEndX()).append(" ").append(CUBIC_CURVE.getEndY());
        return fxPath.toString();
    }

    public static String convertRectangle(Rectangle RECTANGLE) {
        StringBuilder fxPath = new StringBuilder();
        Bounds bounds = RECTANGLE.getBoundsInLocal();
        if (Double.compare(RECTANGLE.getArcWidth(), 0.0) == 0 && Double.compare(RECTANGLE.getArcHeight(), 0.0) == 0) {
            fxPath.append("M ").append(bounds.getMinX()).append(" ").append(bounds.getMinY()).append(" ").append("H ").append(bounds.getMaxX()).append(" ").append("V ").append(bounds.getMaxY()).append(" ").append("H ").append(bounds.getMinX()).append(" ").append("V ").append(bounds.getMinY()).append(" ").append("Z");
        } else {
            double x = bounds.getMinX();
            double y = bounds.getMinY();
            double width = bounds.getWidth();
            double height = bounds.getHeight();
            double arcWidth = RECTANGLE.getArcWidth();
            double arcHeight = RECTANGLE.getArcHeight();
            double r = x + width;
            double b = y + height;
            fxPath.append("M ").append(x + arcWidth).append(" ").append(y).append(" ").append("L ").append(r - arcWidth).append(" ").append(y).append(" ").append("Q ").append(r).append(" ").append(y).append(" ").append(r).append(" ").append(y + arcHeight).append(" ").append("L ").append(r).append(" ").append(y + height - arcHeight).append(" ").append("Q ").append(r).append(" ").append(b).append(" ").append(r - arcWidth).append(" ").append(b).append(" ").append("L ").append(x + arcWidth).append(" ").append(b).append(" ").append("Q ").append(x).append(" ").append(b).append(" ").append(x).append(" ").append(b - arcHeight).append(" ").append("L ").append(x).append(" ").append(y + arcHeight).append(" ").append("Q ").append(x).append(" ").append(y).append(" ").append(x + arcWidth).append(" ").append(y).append(" ").append("Z");
        }
        return fxPath.toString();
    }

    public static String convertCircle(Circle CIRCLE) {
        StringBuilder fxPath = new StringBuilder();
        double CENTER_X = CIRCLE.getCenterX() == 0.0 ? CIRCLE.getRadius() : CIRCLE.getCenterX();
        double CENTER_Y = CIRCLE.getCenterY() == 0.0 ? CIRCLE.getRadius() : CIRCLE.getCenterY();
        double RADIUS = CIRCLE.getRadius();
        double CONTROL_DISTANCE = RADIUS * 0.5522847498307935;
        fxPath.append("M ").append(CENTER_X).append(" ").append(CENTER_Y - RADIUS).append(" ");
        fxPath.append("C ").append(CENTER_X + CONTROL_DISTANCE).append(" ").append(CENTER_Y - RADIUS).append(" ").append(CENTER_X + RADIUS).append(" ").append(CENTER_Y - CONTROL_DISTANCE).append(" ").append(CENTER_X + RADIUS).append(" ").append(CENTER_Y).append(" ");
        fxPath.append("C ").append(CENTER_X + RADIUS).append(" ").append(CENTER_Y + CONTROL_DISTANCE).append(" ").append(CENTER_X + CONTROL_DISTANCE).append(" ").append(CENTER_Y + RADIUS).append(" ").append(CENTER_X).append(" ").append(CENTER_Y + RADIUS).append(" ");
        fxPath.append("C ").append(CENTER_X - CONTROL_DISTANCE).append(" ").append(CENTER_Y + RADIUS).append(" ").append(CENTER_X - RADIUS).append(" ").append(CENTER_Y + CONTROL_DISTANCE).append(" ").append(CENTER_X - RADIUS).append(" ").append(CENTER_Y).append(" ");
        fxPath.append("C ").append(CENTER_X - RADIUS).append(" ").append(CENTER_Y - CONTROL_DISTANCE).append(" ").append(CENTER_X - CONTROL_DISTANCE).append(" ").append(CENTER_Y - RADIUS).append(" ").append(CENTER_X).append(" ").append(CENTER_Y - RADIUS).append(" ");
        fxPath.append("Z");
        return fxPath.toString();
    }

    public static String convertEllipse(Ellipse ELLIPSE) {
        StringBuilder fxPath = new StringBuilder();
        double CENTER_X = ELLIPSE.getCenterX() == 0.0 ? ELLIPSE.getRadiusX() : ELLIPSE.getCenterX();
        double CENTER_Y = ELLIPSE.getCenterY() == 0.0 ? ELLIPSE.getRadiusY() : ELLIPSE.getCenterY();
        double RADIUS_X = ELLIPSE.getRadiusX();
        double RADIUS_Y = ELLIPSE.getRadiusY();
        double CONTROL_DISTANCE_X = RADIUS_X * 0.5522847498307935;
        double CONTROL_DISTANCE_Y = RADIUS_Y * 0.5522847498307935;
        fxPath.append("M ").append(CENTER_X).append(" ").append(CENTER_Y - RADIUS_Y).append(" ");
        fxPath.append("C ").append(CENTER_X + CONTROL_DISTANCE_X).append(" ").append(CENTER_Y - RADIUS_Y).append(" ").append(CENTER_X + RADIUS_X).append(" ").append(CENTER_Y - CONTROL_DISTANCE_Y).append(" ").append(CENTER_X + RADIUS_X).append(" ").append(CENTER_Y).append(" ");
        fxPath.append("C ").append(CENTER_X + RADIUS_X).append(" ").append(CENTER_Y + CONTROL_DISTANCE_Y).append(" ").append(CENTER_X + CONTROL_DISTANCE_X).append(" ").append(CENTER_Y + RADIUS_Y).append(" ").append(CENTER_X).append(" ").append(CENTER_Y + RADIUS_Y).append(" ");
        fxPath.append("C ").append(CENTER_X - CONTROL_DISTANCE_X).append(" ").append(CENTER_Y + RADIUS_Y).append(" ").append(CENTER_X - RADIUS_X).append(" ").append(CENTER_Y + CONTROL_DISTANCE_Y).append(" ").append(CENTER_X - RADIUS_X).append(" ").append(CENTER_Y).append(" ");
        fxPath.append("C ").append(CENTER_X - RADIUS_X).append(" ").append(CENTER_Y - CONTROL_DISTANCE_Y).append(" ").append(CENTER_X - CONTROL_DISTANCE_X).append(" ").append(CENTER_Y - RADIUS_Y).append(" ").append(CENTER_X).append(" ").append(CENTER_Y - RADIUS_Y).append(" ");
        fxPath.append("Z");
        return fxPath.toString();
    }

    public static String convertPath(Path PATH) {
        StringBuilder fxPath = new StringBuilder();
        for (PathElement element : PATH.getElements()) {
            if (MoveTo.class.equals(element.getClass())) {
                fxPath.append("M ").append(((MoveTo)element).getX()).append(" ").append(((MoveTo)element).getY()).append(" ");
                continue;
            }
            if (LineTo.class.equals(element.getClass())) {
                fxPath.append("L ").append(((LineTo)element).getX()).append(" ").append(((LineTo)element).getY()).append(" ");
                continue;
            }
            if (CubicCurveTo.class.equals(element.getClass())) {
                fxPath.append("C ").append(((CubicCurveTo)element).getControlX1()).append(" ").append(((CubicCurveTo)element).getControlY1()).append(" ").append(((CubicCurveTo)element).getControlX2()).append(" ").append(((CubicCurveTo)element).getControlY2()).append(" ").append(((CubicCurveTo)element).getX()).append(" ").append(((CubicCurveTo)element).getY()).append(" ");
                continue;
            }
            if (QuadCurveTo.class.equals(element.getClass())) {
                fxPath.append("Q ").append(((QuadCurveTo)element).getControlX()).append(" ").append(((QuadCurveTo)element).getControlY()).append(" ").append(((QuadCurveTo)element).getX()).append(" ").append(((QuadCurveTo)element).getY()).append(" ");
                continue;
            }
            if (ArcTo.class.equals(element.getClass())) {
                fxPath.append("A ").append(((ArcTo)element).getX()).append(" ").append(((ArcTo)element).getY()).append(" ").append(((ArcTo)element).getRadiusX()).append(" ").append(((ArcTo)element).getRadiusY()).append(" ");
                continue;
            }
            if (HLineTo.class.equals(element.getClass())) {
                fxPath.append("H ").append(((HLineTo)element).getX()).append(" ");
                continue;
            }
            if (VLineTo.class.equals(element.getClass())) {
                fxPath.append("V ").append(((VLineTo)element).getY()).append(" ");
                continue;
            }
            if (!ClosePath.class.equals(element.getClass())) continue;
            fxPath.append("Z");
        }
        return fxPath.toString();
    }

    public static String convertPolygon(Polygon POLYGON) {
        StringBuilder fxPath = new StringBuilder();
        int size = POLYGON.getPoints().size();
        if (size % 2 == 0) {
            ObservableList coordinates = POLYGON.getPoints();
            for (int i = 0; i < size; i += 2) {
                fxPath.append(i == 0 ? "M " : "L ").append(coordinates.get(i)).append(" ").append(coordinates.get(i + 1)).append(" ");
            }
            fxPath.append("Z");
        }
        return fxPath.toString();
    }

    public static String convertPolyline(Polyline POLYLINE) {
        StringBuilder fxPath = new StringBuilder();
        int size = POLYLINE.getPoints().size();
        if (size % 2 == 0) {
            ObservableList coordinates = POLYLINE.getPoints();
            for (int i = 0; i < size; i += 2) {
                fxPath.append(i == 0 ? "M " : "L ").append(coordinates.get(i)).append(" ").append(coordinates.get(i + 1)).append(" ");
            }
        }
        return fxPath.toString();
    }
}

