/*
 * Decompiled with CFR 0.152.
 */
package anywheresoftware.b4a;

import anywheresoftware.b4a.BA;
import java.util.Iterator;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

@BA.Hide
public class B4AThreadPool {
    private final WeakHashMap<Object, ConcurrentHashMap<Integer, Future<?>>> futures = new WeakHashMap();
    private final ConcurrentLinkedQueue<QueuedTask> queueOfTasks = new ConcurrentLinkedQueue();
    private ThreadPoolExecutor pool = new ThreadPoolExecutor(0, 300, 60L, TimeUnit.SECONDS, new SynchronousQueue()){

        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            int i = 0;
            while (i < 1) {
                QueuedTask qt = (QueuedTask)B4AThreadPool.this.queueOfTasks.poll();
                if (qt != null) {
                    BA.firstInstance.postRunnable(qt);
                }
                ++i;
            }
        }
    };
    private static final int THREADS_SPARE = 5;

    public B4AThreadPool() {
        this.pool.setThreadFactory(new MyThreadFactory());
    }

    public void submit(Runnable task, Object container, int taskId) {
        if (this.pool.getActiveCount() > this.pool.getMaximumPoolSize() - 5) {
            this.queueOfTasks.add(new QueuedTask(task, container, taskId));
        } else {
            this.submitToPool(task, container, taskId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submitToPool(Runnable task, Object container, int taskId) {
        ConcurrentHashMap<Integer, Future<Object>> map;
        Future<?> f;
        try {
            f = this.pool.submit(task);
        }
        catch (RejectedExecutionException ree) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.submitToPool(task, container, taskId);
            return;
        }
        WeakHashMap<Object, ConcurrentHashMap<Integer, Future<?>>> e = this.futures;
        synchronized (e) {
            map = this.futures.get(container);
            if (map == null) {
                map = new ConcurrentHashMap();
                this.futures.put(container, map);
            }
        }
        Iterator<Future<Object>> it = map.values().iterator();
        while (it.hasNext()) {
            Future<Object> fit = it.next();
            if (!fit.isDone()) continue;
            it.remove();
        }
        map.put(taskId, f);
    }

    public boolean isRunning(Object container, int taskId) {
        ConcurrentHashMap<Integer, Future<?>> map = this.futures.get(container);
        if (map == null) {
            return false;
        }
        Future<?> f = map.get(taskId);
        if (f == null) {
            return false;
        }
        return !f.isDone();
    }

    public void markTaskAsFinished(Object container, int taskId) {
        ConcurrentHashMap<Integer, Future<?>> map = this.futures.get(container);
        if (map == null) {
            return;
        }
        map.remove(taskId);
    }

    private static class MyThreadFactory
    implements ThreadFactory {
        private final ThreadFactory defaultFactory = Executors.defaultThreadFactory();

        private MyThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = this.defaultFactory.newThread(r);
            t.setDaemon(true);
            return t;
        }
    }

    class QueuedTask
    implements Runnable {
        final Runnable task;
        final Object container;
        final int taskId;

        public QueuedTask(Runnable task, Object container, int taskId) {
            this.task = task;
            this.container = container;
            this.taskId = taskId;
        }

        @Override
        public void run() {
            if (B4AThreadPool.this.pool.getActiveCount() > B4AThreadPool.this.pool.getMaximumPoolSize() - 5) {
                BA.firstInstance.postRunnable(this);
            } else {
                B4AThreadPool.this.submitToPool(this.task, this.container, this.taskId);
            }
        }
    }
}

